

CREATE TABLE `ceba_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ceba_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2023-10-12 12:29:08","2023-10-12 12:29:08","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `ceba_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `ceba_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO ceba_options VALUES("1","siteurl","https://freeingo.ceba.co.tz","yes");
INSERT INTO ceba_options VALUES("2","home","https://freeingo.ceba.co.tz","yes");
INSERT INTO ceba_options VALUES("3","blogname","Freeingo","yes");
INSERT INTO ceba_options VALUES("4","blogdescription","","yes");
INSERT INTO ceba_options VALUES("5","users_can_register","0","yes");
INSERT INTO ceba_options VALUES("6","admin_email","mambojambotz@gmail.com","yes");
INSERT INTO ceba_options VALUES("7","start_of_week","1","yes");
INSERT INTO ceba_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO ceba_options VALUES("9","use_smilies","1","yes");
INSERT INTO ceba_options VALUES("10","require_name_email","1","yes");
INSERT INTO ceba_options VALUES("11","comments_notify","1","yes");
INSERT INTO ceba_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO ceba_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO ceba_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO ceba_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO ceba_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO ceba_options VALUES("17","mailserver_port","110","yes");
INSERT INTO ceba_options VALUES("18","default_category","1","yes");
INSERT INTO ceba_options VALUES("19","default_comment_status","open","yes");
INSERT INTO ceba_options VALUES("20","default_ping_status","closed","yes");
INSERT INTO ceba_options VALUES("21","default_pingback_flag","","yes");
INSERT INTO ceba_options VALUES("22","posts_per_page","10","yes");
INSERT INTO ceba_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO ceba_options VALUES("24","time_format","g:i a","yes");
INSERT INTO ceba_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO ceba_options VALUES("26","comment_moderation","0","yes");
INSERT INTO ceba_options VALUES("27","moderation_notify","1","yes");
INSERT INTO ceba_options VALUES("28","permalink_structure","/index.php/%year%/%monthnum%/%day%/%postname%/","yes");
INSERT INTO ceba_options VALUES("29","rewrite_rules","a:282:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:22:\"index.php/portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:52:\"index.php/portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:47:\"index.php/portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:39:\"index.php/portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:52:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:45:\"index.php/e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:53:\"index.php/e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:60:\"index.php/e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:41:\"index.php/e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"index.php/sellkit-discount/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"index.php/sellkit-discount/([^/]+)/embed/?$\";s:49:\"index.php?sellkit-discount=$matches[1]&embed=true\";s:47:\"index.php/sellkit-discount/([^/]+)/trackback/?$\";s:43:\"index.php?sellkit-discount=$matches[1]&tb=1\";s:55:\"index.php/sellkit-discount/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?sellkit-discount=$matches[1]&paged=$matches[2]\";s:62:\"index.php/sellkit-discount/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?sellkit-discount=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/sellkit-discount/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?sellkit-discount=$matches[1]&page=$matches[2]\";s:43:\"index.php/sellkit-discount/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"index.php/sellkit-discount/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"index.php/sellkit-discount/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/sellkit-discount/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/sellkit-discount/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/sellkit-discount/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/sellkit-coupon/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/sellkit-coupon/([^/]+)/embed/?$\";s:47:\"index.php?sellkit-coupon=$matches[1]&embed=true\";s:45:\"index.php/sellkit-coupon/([^/]+)/trackback/?$\";s:41:\"index.php?sellkit-coupon=$matches[1]&tb=1\";s:53:\"index.php/sellkit-coupon/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?sellkit-coupon=$matches[1]&paged=$matches[2]\";s:60:\"index.php/sellkit-coupon/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?sellkit-coupon=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/sellkit-coupon/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?sellkit-coupon=$matches[1]&page=$matches[2]\";s:41:\"index.php/sellkit-coupon/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/sellkit-coupon/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/sellkit-coupon/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/sellkit-coupon/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/sellkit-coupon/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/sellkit-coupon/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:61:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:81:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:76:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:76:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:57:\"index.php/sellkit-alert/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"index.php/sellkit-alert/([^/]+)/embed/?$\";s:46:\"index.php?sellkit-alert=$matches[1]&embed=true\";s:44:\"index.php/sellkit-alert/([^/]+)/trackback/?$\";s:40:\"index.php?sellkit-alert=$matches[1]&tb=1\";s:52:\"index.php/sellkit-alert/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?sellkit-alert=$matches[1]&paged=$matches[2]\";s:59:\"index.php/sellkit-alert/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?sellkit-alert=$matches[1]&cpage=$matches[2]\";s:48:\"index.php/sellkit-alert/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?sellkit-alert=$matches[1]&page=$matches[2]\";s:40:\"index.php/sellkit-alert/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"index.php/sellkit-alert/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"index.php/sellkit-alert/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"index.php/sellkit-alert/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"index.php/sellkit-alert/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"index.php/sellkit-alert/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"index.php/sellkit_step/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"index.php/sellkit_step/([^/]+)/embed/?$\";s:45:\"index.php?sellkit_step=$matches[1]&embed=true\";s:43:\"index.php/sellkit_step/([^/]+)/trackback/?$\";s:39:\"index.php?sellkit_step=$matches[1]&tb=1\";s:51:\"index.php/sellkit_step/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?sellkit_step=$matches[1]&paged=$matches[2]\";s:58:\"index.php/sellkit_step/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?sellkit_step=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/sellkit_step/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?sellkit_step=$matches[1]&page=$matches[2]\";s:39:\"index.php/sellkit_step/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"index.php/sellkit_step/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"index.php/sellkit_step/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/sellkit_step/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/sellkit_step/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"index.php/sellkit_step/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:63:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:83:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:78:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:78:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:59:\"index.php/sellkit-funnels/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"index.php/sellkit-funnels/([^/]+)/embed/?$\";s:48:\"index.php?sellkit-funnels=$matches[1]&embed=true\";s:46:\"index.php/sellkit-funnels/([^/]+)/trackback/?$\";s:42:\"index.php?sellkit-funnels=$matches[1]&tb=1\";s:54:\"index.php/sellkit-funnels/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?sellkit-funnels=$matches[1]&paged=$matches[2]\";s:61:\"index.php/sellkit-funnels/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?sellkit-funnels=$matches[1]&cpage=$matches[2]\";s:50:\"index.php/sellkit-funnels/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?sellkit-funnels=$matches[1]&page=$matches[2]\";s:42:\"index.php/sellkit-funnels/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"index.php/sellkit-funnels/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"index.php/sellkit-funnels/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/sellkit-funnels/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/sellkit-funnels/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"index.php/sellkit-funnels/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"index.php/portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"index.php/portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"index.php/portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"index.php/portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"index.php/portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"index.php/portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"index.php/portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:40:\"index.php/portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:60:\"index.php/portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:55:\"index.php/portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:48:\"index.php/portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:55:\"index.php/portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:44:\"index.php/portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:36:\"index.php/portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"index.php/portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"index.php/portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"index.php/portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"index.php/portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"index.php/portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:69:\"index.php/portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:64:\"index.php/portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:45:\"index.php/portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:57:\"index.php/portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:39:\"index.php/portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:64:\"index.php/portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:59:\"index.php/portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:40:\"index.php/portfolio-tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:52:\"index.php/portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:34:\"index.php/portfolio-tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:52:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-codes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-codes/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-codes=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-codes/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-codes=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-codes/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-codes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-codes/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-codes=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-codes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-codes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-codes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-codes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-codes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-codes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-fonts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-fonts/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-fonts=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-fonts/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-fonts=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-fonts/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-fonts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-fonts/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-fonts=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-fonts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/jupiterx-icons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/jupiterx-icons/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-icons=$matches[1]&embed=true\";s:45:\"index.php/jupiterx-icons/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-icons=$matches[1]&tb=1\";s:53:\"index.php/jupiterx-icons/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&paged=$matches[2]\";s:60:\"index.php/jupiterx-icons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/jupiterx-icons/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-icons=$matches[1]&page=$matches[2]\";s:41:\"index.php/jupiterx-icons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/jupiterx-icons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/jupiterx-icons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-icons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/jupiterx-icons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/jupiterx-icons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO ceba_options VALUES("30","hack_file","0","yes");
INSERT INTO ceba_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO ceba_options VALUES("32","moderation_keys","","no");
INSERT INTO ceba_options VALUES("33","active_plugins","a:6:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:35:\"google-site-kit/google-site-kit.php\";i:3;s:31:\"jupiterx-core/jupiterx-core.php\";i:4;s:27:\"sellkit-pro/sellkit-pro.php\";i:5;s:19:\"sellkit/sellkit.php\";}","yes");
INSERT INTO ceba_options VALUES("34","category_base","","yes");
INSERT INTO ceba_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO ceba_options VALUES("36","comment_max_links","2","yes");
INSERT INTO ceba_options VALUES("37","gmt_offset","0","yes");
INSERT INTO ceba_options VALUES("38","default_email_category","1","yes");
INSERT INTO ceba_options VALUES("39","recently_edited","","no");
INSERT INTO ceba_options VALUES("40","template","jupiterx","yes");
INSERT INTO ceba_options VALUES("41","stylesheet","jupiterx","yes");
INSERT INTO ceba_options VALUES("42","comment_registration","0","yes");
INSERT INTO ceba_options VALUES("43","html_type","text/html","yes");
INSERT INTO ceba_options VALUES("44","use_trackback","0","yes");
INSERT INTO ceba_options VALUES("45","default_role","subscriber","yes");
INSERT INTO ceba_options VALUES("46","db_version","55853","yes");
INSERT INTO ceba_options VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO ceba_options VALUES("48","upload_path","","yes");
INSERT INTO ceba_options VALUES("49","blog_public","1","yes");
INSERT INTO ceba_options VALUES("50","default_link_category","2","yes");
INSERT INTO ceba_options VALUES("51","show_on_front","posts","yes");
INSERT INTO ceba_options VALUES("52","tag_base","","yes");
INSERT INTO ceba_options VALUES("53","show_avatars","1","yes");
INSERT INTO ceba_options VALUES("54","avatar_rating","G","yes");
INSERT INTO ceba_options VALUES("55","upload_url_path","","yes");
INSERT INTO ceba_options VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO ceba_options VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO ceba_options VALUES("58","thumbnail_crop","1","yes");
INSERT INTO ceba_options VALUES("59","medium_size_w","300","yes");
INSERT INTO ceba_options VALUES("60","medium_size_h","300","yes");
INSERT INTO ceba_options VALUES("61","avatar_default","mystery","yes");
INSERT INTO ceba_options VALUES("62","large_size_w","1024","yes");
INSERT INTO ceba_options VALUES("63","large_size_h","1024","yes");
INSERT INTO ceba_options VALUES("64","image_default_link_type","none","yes");
INSERT INTO ceba_options VALUES("65","image_default_size","","yes");
INSERT INTO ceba_options VALUES("66","image_default_align","","yes");
INSERT INTO ceba_options VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO ceba_options VALUES("68","close_comments_days_old","14","yes");
INSERT INTO ceba_options VALUES("69","thread_comments","1","yes");
INSERT INTO ceba_options VALUES("70","thread_comments_depth","5","yes");
INSERT INTO ceba_options VALUES("71","page_comments","0","yes");
INSERT INTO ceba_options VALUES("72","comments_per_page","50","yes");
INSERT INTO ceba_options VALUES("73","default_comments_page","newest","yes");
INSERT INTO ceba_options VALUES("74","comment_order","asc","yes");
INSERT INTO ceba_options VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO ceba_options VALUES("76","widget_categories","a:0:{}","yes");
INSERT INTO ceba_options VALUES("77","widget_text","a:0:{}","yes");
INSERT INTO ceba_options VALUES("78","widget_rss","a:0:{}","yes");
INSERT INTO ceba_options VALUES("79","uninstall_plugins","a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","no");
INSERT INTO ceba_options VALUES("80","timezone_string","","yes");
INSERT INTO ceba_options VALUES("81","page_for_posts","0","yes");
INSERT INTO ceba_options VALUES("82","page_on_front","0","yes");
INSERT INTO ceba_options VALUES("83","default_post_format","0","yes");
INSERT INTO ceba_options VALUES("84","link_manager_enabled","0","yes");
INSERT INTO ceba_options VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO ceba_options VALUES("86","site_icon","0","yes");
INSERT INTO ceba_options VALUES("87","medium_large_size_w","768","yes");
INSERT INTO ceba_options VALUES("88","medium_large_size_h","0","yes");
INSERT INTO ceba_options VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO ceba_options VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO ceba_options VALUES("91","admin_email_lifespan","1712665747","yes");
INSERT INTO ceba_options VALUES("92","disallowed_keys","","no");
INSERT INTO ceba_options VALUES("93","comment_previously_approved","1","yes");
INSERT INTO ceba_options VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO ceba_options VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO ceba_options VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO ceba_options VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO ceba_options VALUES("98","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO ceba_options VALUES("99","initial_db_version","55853","yes");
INSERT INTO ceba_options VALUES("100","ceba_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO ceba_options VALUES("101","fresh_site","1","yes");
INSERT INTO ceba_options VALUES("102","user_count","1","no");
INSERT INTO ceba_options VALUES("103","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("104","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO ceba_options VALUES("105","cron","a:9:{i:1697167750;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1697200150;a:5:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697200808;a:1:{s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697201313;a:4:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697201771;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1697201772;a:1:{s:24:\"sellkit_update_rfm_score\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697286561;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1697719190;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO ceba_options VALUES("106","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("107","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("108","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("109","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("110","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("111","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("112","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("113","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("114","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("115","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("116","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("117","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("118","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("119","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("120","_transient_wp_core_block_css_files","a:496:{i:0;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/editor-rtl.css\";i:1;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/editor-rtl.min.css\";i:2;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/editor.css\";i:3;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/editor.min.css\";i:4;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/style-rtl.css\";i:5;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/style-rtl.min.css\";i:6;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/style.css\";i:7;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/archives/style.min.css\";i:8;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/editor-rtl.css\";i:9;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/editor-rtl.min.css\";i:10;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/editor.css\";i:11;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/editor.min.css\";i:12;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/style-rtl.css\";i:13;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/style-rtl.min.css\";i:14;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/style.css\";i:15;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/style.min.css\";i:16;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/theme-rtl.css\";i:17;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/theme-rtl.min.css\";i:18;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/theme.css\";i:19;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/audio/theme.min.css\";i:20;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/editor-rtl.css\";i:21;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/editor-rtl.min.css\";i:22;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/editor.css\";i:23;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/editor.min.css\";i:24;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/style-rtl.css\";i:25;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/style-rtl.min.css\";i:26;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/style.css\";i:27;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/avatar/style.min.css\";i:28;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/block/editor-rtl.css\";i:29;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/block/editor-rtl.min.css\";i:30;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/block/editor.css\";i:31;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/block/editor.min.css\";i:32;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/editor-rtl.css\";i:33;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/editor-rtl.min.css\";i:34;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/editor.css\";i:35;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/editor.min.css\";i:36;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/style-rtl.css\";i:37;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/style-rtl.min.css\";i:38;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/style.css\";i:39;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/button/style.min.css\";i:40;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/editor-rtl.css\";i:41;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/editor-rtl.min.css\";i:42;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/editor.css\";i:43;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/editor.min.css\";i:44;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/style-rtl.css\";i:45;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/style-rtl.min.css\";i:46;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/style.css\";i:47;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/buttons/style.min.css\";i:48;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/calendar/style-rtl.css\";i:49;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/calendar/style-rtl.min.css\";i:50;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/calendar/style.css\";i:51;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/calendar/style.min.css\";i:52;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/editor-rtl.css\";i:53;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/editor-rtl.min.css\";i:54;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/editor.css\";i:55;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/editor.min.css\";i:56;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/style-rtl.css\";i:57;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/style-rtl.min.css\";i:58;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/style.css\";i:59;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/categories/style.min.css\";i:60;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/editor-rtl.css\";i:61;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/editor-rtl.min.css\";i:62;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/editor.css\";i:63;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/editor.min.css\";i:64;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/style-rtl.css\";i:65;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/style-rtl.min.css\";i:66;s:68:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/style.css\";i:67;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/style.min.css\";i:68;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/theme-rtl.css\";i:69;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/theme-rtl.min.css\";i:70;s:68:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/theme.css\";i:71;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/code/theme.min.css\";i:72;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/editor-rtl.css\";i:73;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/editor-rtl.min.css\";i:74;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/editor.css\";i:75;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/editor.min.css\";i:76;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/style-rtl.css\";i:77;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/style-rtl.min.css\";i:78;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/style.css\";i:79;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/columns/style.min.css\";i:80;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-content/style-rtl.css\";i:81;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-content/style-rtl.min.css\";i:82;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-content/style.css\";i:83;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-content/style.min.css\";i:84;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-template/style-rtl.css\";i:85;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-template/style-rtl.min.css\";i:86;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-template/style.css\";i:87;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comment-template/style.min.css\";i:88;s:96:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination-numbers/editor-rtl.css\";i:89;s:100:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination-numbers/editor-rtl.min.css\";i:90;s:92:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination-numbers/editor.css\";i:91;s:96:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination-numbers/editor.min.css\";i:92;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/editor-rtl.css\";i:93;s:92:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/editor-rtl.min.css\";i:94;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/editor.css\";i:95;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/editor.min.css\";i:96;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/style-rtl.css\";i:97;s:91:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/style-rtl.min.css\";i:98;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/style.css\";i:99;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-pagination/style.min.css\";i:100;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-title/editor-rtl.css\";i:101;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-title/editor-rtl.min.css\";i:102;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-title/editor.css\";i:103;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments-title/editor.min.css\";i:104;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/editor-rtl.css\";i:105;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/editor-rtl.min.css\";i:106;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/editor.css\";i:107;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/editor.min.css\";i:108;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/style-rtl.css\";i:109;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/style-rtl.min.css\";i:110;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/style.css\";i:111;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/comments/style.min.css\";i:112;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/editor-rtl.css\";i:113;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/editor-rtl.min.css\";i:114;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/editor.css\";i:115;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/editor.min.css\";i:116;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/style-rtl.css\";i:117;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/style-rtl.min.css\";i:118;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/style.css\";i:119;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/cover/style.min.css\";i:120;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/editor-rtl.css\";i:121;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/editor-rtl.min.css\";i:122;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/editor.css\";i:123;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/editor.min.css\";i:124;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/style-rtl.css\";i:125;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/style-rtl.min.css\";i:126;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/style.css\";i:127;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/details/style.min.css\";i:128;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/editor-rtl.css\";i:129;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/editor-rtl.min.css\";i:130;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/editor.css\";i:131;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/editor.min.css\";i:132;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/style-rtl.css\";i:133;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/style-rtl.min.css\";i:134;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/style.css\";i:135;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/style.min.css\";i:136;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/theme-rtl.css\";i:137;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/theme-rtl.min.css\";i:138;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/theme.css\";i:139;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/embed/theme.min.css\";i:140;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/editor-rtl.css\";i:141;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/editor-rtl.min.css\";i:142;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/editor.css\";i:143;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/editor.min.css\";i:144;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/style-rtl.css\";i:145;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/style-rtl.min.css\";i:146;s:68:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/style.css\";i:147;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/file/style.min.css\";i:148;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/footnotes/style-rtl.css\";i:149;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/footnotes/style-rtl.min.css\";i:150;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/footnotes/style.css\";i:151;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/footnotes/style.min.css\";i:152;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/freeform/editor-rtl.css\";i:153;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/freeform/editor-rtl.min.css\";i:154;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/freeform/editor.css\";i:155;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/freeform/editor.min.css\";i:156;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/editor-rtl.css\";i:157;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/editor-rtl.min.css\";i:158;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/editor.css\";i:159;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/editor.min.css\";i:160;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/style-rtl.css\";i:161;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/style-rtl.min.css\";i:162;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/style.css\";i:163;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/style.min.css\";i:164;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/theme-rtl.css\";i:165;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/theme-rtl.min.css\";i:166;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/theme.css\";i:167;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/gallery/theme.min.css\";i:168;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/editor-rtl.css\";i:169;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/editor-rtl.min.css\";i:170;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/editor.css\";i:171;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/editor.min.css\";i:172;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/style-rtl.css\";i:173;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/style-rtl.min.css\";i:174;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/style.css\";i:175;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/style.min.css\";i:176;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/theme-rtl.css\";i:177;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/theme-rtl.min.css\";i:178;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/theme.css\";i:179;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/group/theme.min.css\";i:180;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/heading/style-rtl.css\";i:181;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/heading/style-rtl.min.css\";i:182;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/heading/style.css\";i:183;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/heading/style.min.css\";i:184;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/html/editor-rtl.css\";i:185;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/html/editor-rtl.min.css\";i:186;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/html/editor.css\";i:187;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/html/editor.min.css\";i:188;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/editor-rtl.css\";i:189;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/editor-rtl.min.css\";i:190;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/editor.css\";i:191;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/editor.min.css\";i:192;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/style-rtl.css\";i:193;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/style-rtl.min.css\";i:194;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/style.css\";i:195;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/style.min.css\";i:196;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/theme-rtl.css\";i:197;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/theme-rtl.min.css\";i:198;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/theme.css\";i:199;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/image/theme.min.css\";i:200;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-comments/style-rtl.css\";i:201;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-comments/style-rtl.min.css\";i:202;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-comments/style.css\";i:203;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-comments/style.min.css\";i:204;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/editor-rtl.css\";i:205;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/editor-rtl.min.css\";i:206;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/editor.css\";i:207;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/editor.min.css\";i:208;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/style-rtl.css\";i:209;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/style-rtl.min.css\";i:210;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/style.css\";i:211;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/latest-posts/style.min.css\";i:212;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/list/style-rtl.css\";i:213;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/list/style-rtl.min.css\";i:214;s:68:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/list/style.css\";i:215;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/list/style.min.css\";i:216;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/editor-rtl.css\";i:217;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/editor-rtl.min.css\";i:218;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/editor.css\";i:219;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/editor.min.css\";i:220;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/style-rtl.css\";i:221;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/style-rtl.min.css\";i:222;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/style.css\";i:223;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/media-text/style.min.css\";i:224;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/more/editor-rtl.css\";i:225;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/more/editor-rtl.min.css\";i:226;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/more/editor.css\";i:227;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/more/editor.min.css\";i:228;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/editor-rtl.css\";i:229;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/editor-rtl.min.css\";i:230;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/editor.css\";i:231;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/editor.min.css\";i:232;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/style-rtl.css\";i:233;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/style-rtl.min.css\";i:234;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/style.css\";i:235;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-link/style.min.css\";i:236;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-submenu/editor-rtl.css\";i:237;s:91:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-submenu/editor-rtl.min.css\";i:238;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-submenu/editor.css\";i:239;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation-submenu/editor.min.css\";i:240;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/editor-rtl.css\";i:241;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/editor-rtl.min.css\";i:242;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/editor.css\";i:243;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/editor.min.css\";i:244;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/style-rtl.css\";i:245;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/style-rtl.min.css\";i:246;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/style.css\";i:247;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/navigation/style.min.css\";i:248;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/nextpage/editor-rtl.css\";i:249;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/nextpage/editor-rtl.min.css\";i:250;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/nextpage/editor.css\";i:251;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/nextpage/editor.min.css\";i:252;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/editor-rtl.css\";i:253;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/editor-rtl.min.css\";i:254;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/editor.css\";i:255;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/editor.min.css\";i:256;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/style-rtl.css\";i:257;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/style-rtl.min.css\";i:258;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/style.css\";i:259;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/page-list/style.min.css\";i:260;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/editor-rtl.css\";i:261;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/editor-rtl.min.css\";i:262;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/editor.css\";i:263;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/editor.min.css\";i:264;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/style-rtl.css\";i:265;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/style-rtl.min.css\";i:266;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/style.css\";i:267;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/paragraph/style.min.css\";i:268;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-author/style-rtl.css\";i:269;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-author/style-rtl.min.css\";i:270;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-author/style.css\";i:271;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-author/style.min.css\";i:272;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/editor-rtl.css\";i:273;s:91:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/editor-rtl.min.css\";i:274;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/editor.css\";i:275;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/editor.min.css\";i:276;s:86:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/style-rtl.css\";i:277;s:90:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/style-rtl.min.css\";i:278;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/style.css\";i:279;s:86:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-comments-form/style.min.css\";i:280;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-date/style-rtl.css\";i:281;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-date/style-rtl.min.css\";i:282;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-date/style.css\";i:283;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-date/style.min.css\";i:284;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/editor-rtl.css\";i:285;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/editor-rtl.min.css\";i:286;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/editor.css\";i:287;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/editor.min.css\";i:288;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/style-rtl.css\";i:289;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/style-rtl.min.css\";i:290;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/style.css\";i:291;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-excerpt/style.min.css\";i:292;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/editor-rtl.css\";i:293;s:92:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/editor-rtl.min.css\";i:294;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/editor.css\";i:295;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/editor.min.css\";i:296;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/style-rtl.css\";i:297;s:91:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/style-rtl.min.css\";i:298;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/style.css\";i:299;s:87:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-featured-image/style.min.css\";i:300;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-navigation-link/style-rtl.css\";i:301;s:92:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-navigation-link/style-rtl.min.css\";i:302;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-navigation-link/style.css\";i:303;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-navigation-link/style.min.css\";i:304;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/editor-rtl.css\";i:305;s:86:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/editor-rtl.min.css\";i:306;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/editor.css\";i:307;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/editor.min.css\";i:308;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/style-rtl.css\";i:309;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/style-rtl.min.css\";i:310;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/style.css\";i:311;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-template/style.min.css\";i:312;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-terms/style-rtl.css\";i:313;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-terms/style-rtl.min.css\";i:314;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-terms/style.css\";i:315;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-terms/style.min.css\";i:316;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-title/style-rtl.css\";i:317;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-title/style-rtl.min.css\";i:318;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-title/style.css\";i:319;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/post-title/style.min.css\";i:320;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/preformatted/style-rtl.css\";i:321;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/preformatted/style-rtl.min.css\";i:322;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/preformatted/style.css\";i:323;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/preformatted/style.min.css\";i:324;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/editor-rtl.css\";i:325;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/editor-rtl.min.css\";i:326;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/editor.css\";i:327;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/editor.min.css\";i:328;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/style-rtl.css\";i:329;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/style-rtl.min.css\";i:330;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/style.css\";i:331;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/style.min.css\";i:332;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/theme-rtl.css\";i:333;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/theme-rtl.min.css\";i:334;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/theme.css\";i:335;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/pullquote/theme.min.css\";i:336;s:93:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination-numbers/editor-rtl.css\";i:337;s:97:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination-numbers/editor-rtl.min.css\";i:338;s:89:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination-numbers/editor.css\";i:339;s:93:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination-numbers/editor.min.css\";i:340;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/editor-rtl.css\";i:341;s:89:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/editor-rtl.min.css\";i:342;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/editor.css\";i:343;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/editor.min.css\";i:344;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/style-rtl.css\";i:345;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/style-rtl.min.css\";i:346;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/style.css\";i:347;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-pagination/style.min.css\";i:348;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-title/style-rtl.css\";i:349;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-title/style-rtl.min.css\";i:350;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-title/style.css\";i:351;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query-title/style.min.css\";i:352;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query/editor-rtl.css\";i:353;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query/editor-rtl.min.css\";i:354;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query/editor.css\";i:355;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/query/editor.min.css\";i:356;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/style-rtl.css\";i:357;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/style-rtl.min.css\";i:358;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/style.css\";i:359;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/style.min.css\";i:360;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/theme-rtl.css\";i:361;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/theme-rtl.min.css\";i:362;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/theme.css\";i:363;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/quote/theme.min.css\";i:364;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/read-more/style-rtl.css\";i:365;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/read-more/style-rtl.min.css\";i:366;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/read-more/style.css\";i:367;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/read-more/style.min.css\";i:368;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/editor-rtl.css\";i:369;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/editor-rtl.min.css\";i:370;s:68:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/editor.css\";i:371;s:72:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/editor.min.css\";i:372;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/style-rtl.css\";i:373;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/style-rtl.min.css\";i:374;s:67:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/style.css\";i:375;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/rss/style.min.css\";i:376;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/editor-rtl.css\";i:377;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/editor-rtl.min.css\";i:378;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/editor.css\";i:379;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/editor.min.css\";i:380;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/style-rtl.css\";i:381;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/style-rtl.min.css\";i:382;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/style.css\";i:383;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/style.min.css\";i:384;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/theme-rtl.css\";i:385;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/theme-rtl.min.css\";i:386;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/theme.css\";i:387;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/search/theme.min.css\";i:388;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/editor-rtl.css\";i:389;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/editor-rtl.min.css\";i:390;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/editor.css\";i:391;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/editor.min.css\";i:392;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/style-rtl.css\";i:393;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/style-rtl.min.css\";i:394;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/style.css\";i:395;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/style.min.css\";i:396;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/theme-rtl.css\";i:397;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/theme-rtl.min.css\";i:398;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/theme.css\";i:399;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/separator/theme.min.css\";i:400;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/shortcode/editor-rtl.css\";i:401;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/shortcode/editor-rtl.min.css\";i:402;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/shortcode/editor.css\";i:403;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/shortcode/editor.min.css\";i:404;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/editor-rtl.css\";i:405;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/editor-rtl.min.css\";i:406;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/editor.css\";i:407;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/editor.min.css\";i:408;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/style-rtl.css\";i:409;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/style-rtl.min.css\";i:410;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/style.css\";i:411;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-logo/style.min.css\";i:412;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-tagline/editor-rtl.css\";i:413;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-tagline/editor-rtl.min.css\";i:414;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-tagline/editor.css\";i:415;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-tagline/editor.min.css\";i:416;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/editor-rtl.css\";i:417;s:83:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/editor-rtl.min.css\";i:418;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/editor.css\";i:419;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/editor.min.css\";i:420;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/style-rtl.css\";i:421;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/style-rtl.min.css\";i:422;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/style.css\";i:423;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/site-title/style.min.css\";i:424;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-link/editor-rtl.css\";i:425;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-link/editor-rtl.min.css\";i:426;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-link/editor.css\";i:427;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-link/editor.min.css\";i:428;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/editor-rtl.css\";i:429;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/editor-rtl.min.css\";i:430;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/editor.css\";i:431;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/editor.min.css\";i:432;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/style-rtl.css\";i:433;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/style-rtl.min.css\";i:434;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/style.css\";i:435;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/social-links/style.min.css\";i:436;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/editor-rtl.css\";i:437;s:79:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/editor-rtl.min.css\";i:438;s:71:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/editor.css\";i:439;s:75:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/editor.min.css\";i:440;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/style-rtl.css\";i:441;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/style-rtl.min.css\";i:442;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/style.css\";i:443;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/spacer/style.min.css\";i:444;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/editor-rtl.css\";i:445;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/editor-rtl.min.css\";i:446;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/editor.css\";i:447;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/editor.min.css\";i:448;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/style-rtl.css\";i:449;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/style-rtl.min.css\";i:450;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/style.css\";i:451;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/style.min.css\";i:452;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/theme-rtl.css\";i:453;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/theme-rtl.min.css\";i:454;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/theme.css\";i:455;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/table/theme.min.css\";i:456;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/tag-cloud/style-rtl.css\";i:457;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/tag-cloud/style-rtl.min.css\";i:458;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/tag-cloud/style.css\";i:459;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/tag-cloud/style.min.css\";i:460;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/editor-rtl.css\";i:461;s:86:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/editor-rtl.min.css\";i:462;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/editor.css\";i:463;s:82:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/editor.min.css\";i:464;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/theme-rtl.css\";i:465;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/theme-rtl.min.css\";i:466;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/theme.css\";i:467;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/template-part/theme.min.css\";i:468;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/term-description/style-rtl.css\";i:469;s:88:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/term-description/style-rtl.min.css\";i:470;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/term-description/style.css\";i:471;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/term-description/style.min.css\";i:472;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/editor-rtl.css\";i:473;s:85:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/editor-rtl.min.css\";i:474;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/editor.css\";i:475;s:81:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/editor.min.css\";i:476;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/style-rtl.css\";i:477;s:84:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/style-rtl.min.css\";i:478;s:76:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/style.css\";i:479;s:80:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/text-columns/style.min.css\";i:480;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/verse/style-rtl.css\";i:481;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/verse/style-rtl.min.css\";i:482;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/verse/style.css\";i:483;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/verse/style.min.css\";i:484;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/editor-rtl.css\";i:485;s:78:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/editor-rtl.min.css\";i:486;s:70:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/editor.css\";i:487;s:74:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/editor.min.css\";i:488;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/style-rtl.css\";i:489;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/style-rtl.min.css\";i:490;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/style.css\";i:491;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/style.min.css\";i:492;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/theme-rtl.css\";i:493;s:77:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/theme-rtl.min.css\";i:494;s:69:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/theme.css\";i:495;s:73:\"/home/cebaco5/public_html/freeingo/wp-includes/blocks/video/theme.min.css\";}","yes");
INSERT INTO ceba_options VALUES("121","nonce_key","R45EIgBX*[56Yu3$XL[r.b[;=3S%<?n#U@6nVwdD5W!{N{4_8CRJ<Fp2?j#e=2E|","no");
INSERT INTO ceba_options VALUES("122","nonce_salt","m=R98>)eXqvDnw8s`qf@5ws5k1Td9Bi#gna=hKI8azW]8RGLs;6b{A#)vSSAHQNu","no");
INSERT INTO ceba_options VALUES("124","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1697115096;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes");
INSERT INTO ceba_options VALUES("125","recovery_keys","a:0:{}","yes");
INSERT INTO ceba_options VALUES("126","https_detection_errors","a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:24:\"SSL verification failed.\";}}","yes");
INSERT INTO ceba_options VALUES("127","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.2-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.3.2-partial-1.zip\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.2\";s:7:\"version\";s:5:\"6.3.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:5:\"6.3.1\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.2-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.3.2-partial-1.zip\";s:8:\"rollback\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.2-rollback-1.zip\";}s:7:\"current\";s:5:\"6.3.2\";s:7:\"version\";s:5:\"6.3.2\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:5:\"6.3.1\";s:9:\"new_files\";s:0:\"\";}}s:12:\"last_checked\";i:1697165421;s:15:\"version_checked\";s:5:\"6.3.1\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO ceba_options VALUES("144","_transient_googlesitekit_verification_meta_tags","a:0:{}","yes");
INSERT INTO ceba_options VALUES("145","googlesitekit_db_version","1.3.0","yes");
INSERT INTO ceba_options VALUES("146","_site_transient_timeout_browser_12cff7c401b241581c1f347ece73543d","1697719713","no");
INSERT INTO ceba_options VALUES("147","_site_transient_browser_12cff7c401b241581c1f347ece73543d","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"116.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO ceba_options VALUES("148","_site_transient_timeout_php_check_362d31fcd631a144704a59b89d531acf","1697719713","no");
INSERT INTO ceba_options VALUES("149","_site_transient_php_check_362d31fcd631a144704a59b89d531acf","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no");
INSERT INTO ceba_options VALUES("151","_site_transient_timeout_community-events-7d5234ba3e277fff7172ac49a5f2b194","1697158120","no");
INSERT INTO ceba_options VALUES("152","_site_transient_community-events-7d5234ba3e277fff7172ac49a5f2b194","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"197.250.228.0\";}s:6:\"events\";a:0:{}}","no");
INSERT INTO ceba_options VALUES("153","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1697158120","no");
INSERT INTO ceba_options VALUES("154","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 16:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.4-alpha-56702\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 16:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16101\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:206:\"WordPress 6.4 Beta 3 is now ready for testing!\n\nThis version is under development, so please do not install, run, or test it on production websites. Learn what\'s new and how to get involved in beta testing.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7440:\"\n<p>WordPress 6.4 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 3 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta3</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> for details.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Your help testing WordPress 6.4 Beta 3 is key to ensuring its quality. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 3</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Update on the Font Library</h2>\n\n\n\n<p><strong>The Font Library feature, initially planned for WordPress 6.4, is now set to release in 6.5</strong>. WordPress is committed to delivering the best possible experience. This decision allows time to address enhancement opportunities, <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\" data-type=\"link\" data-id=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">test</a>, and get enough feedback to meet WordPress&#8217;s quality standards. Thanks for your support as contributors work towards an exceptional Font Library experience.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 3 contains more than 60 updates since the Beta 2 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F04%2F2023..10%2F10%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">29 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=10%2F04%2F2023..10%2F10%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since Beta 2</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta 3 arrives<br>Testing where progress derives<br>Iterate, it thrives</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: </em><a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a> and <a href=\'https://profiles.wordpress.org/michelleames/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>michelleames</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 17:25:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:288:\"WordPress 6.4 Beta 2 is now ready for testing!\n\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8284:\"\n<p>WordPress 6.4 Beta 2 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 2 in four ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta2</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to increase participation and partnership with those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> and tune into <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\">Episode 63 of the WP Briefing podcast</a> for details.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How to get involved with testing</h2>\n\n\n\n<p>Your help testing the WordPress 6.4 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/blob/a854e6e7a2a49a6b1ec5ef377c756a30e1c7ac5a/lib/experimental/fonts/font-library/README.md\">Font Library feature</a>, currently available in <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a>, requires more testing and feedback to ensure it is ready for inclusion in the upcoming 6.4 release. <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Check out this guide for detailed test instructions</a>.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 2</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 2 contains more than 50 updates since the Beta 1 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=09%2F27%2F2023..10%2F03%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">18 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&amp;changetime=09%2F27%2F2023..10%2F03%2F2023&amp;milestone=6.4&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Closed Trac tickets since Beta 1</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Note on Twenty Twenty-Four</h3>\n\n\n\n<p>Please note that some images in the Twenty Twenty-Four theme may not load correctly. A fix is in the works! Learn more on this <a href=\"https://core.trac.wordpress.org/ticket/59526\">Trac ticket</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Note on pattern management improvements in non-block themes</h3>\n\n\n\n<p>While WordPress 6.4 will bring several exciting pattern advancements, improvements to pattern management in non-block themes will eventually be addressed in WordPress 6.5. The <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Beta 1 announcement</a> has been updated to reflect this change accordingly.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p>Not the first, nor last<br>A second space to reflect<br>Both new and not new</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/ironprogrammer/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ironprogrammer</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16050\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:274:\"Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don\'t miss this opportunity for an insider\'s look!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2023/09/WPB063-Enhanced.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:40977:\"\n<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Guest: <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a><br>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo: <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production: <a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>TwentyTwentyFour <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Theme</a> \n<ul>\n<li><a href=\"https://github.com/WordPress/twentytwentyfour\">Repo</a></li>\n\n\n\n<li><a href=\"https://www.figma.com/file/AlYr03vh4dVimwYwQkTdf6/Twenty-Twenty-Four?type=design&amp;node-id=16-14852&amp;mode=design\">Figma File</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/51132\">Image Lightbox Github</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\">Upcoming WordPress Meetings</a> for Contributors</li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li>Find announcements for WordPress 6.4 Beta at:\n<ul>\n<li><a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#Core</a> Slack Channel</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/\">WordPress.org/news/</a></li>\n</ul>\n</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/06/documentation-translation-localization/\" target=\"_blank\">Proposal: Documentation translation/localization</a></li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/20/seeking-proposals-for-interop-2024/\" target=\"_blank\">Seeking proposals for Interop 2024</a>&nbsp;&#8211; Interop 2024 is happening! WordPress developers, please contribute your proposals for 2024&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/web-platform-tests/interop/issues/new/choose\" target=\"_blank\">on GitHub</a>&nbsp;or as a comment on this post.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/15/wordcamp-us-2023-qa/\" target=\"_blank\">WordCamp US 2023 Q&amp;A</a> &#8211; With a successful WCUS in the books, an extensive list of post-event questions and answers are available and inspired by the event&#8217;s community and <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=3Fa0Q-brSeI\" target=\"_blank\">Q&amp;A</a>.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/2023/09/13/accessibility-office-hours/\" target=\"_blank\">Accessibility Office Hours</a>&nbsp;&#8211; In an effort to improve accessibility knowledge in the WordPress project,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/\" target=\"_blank\">the accessibility team</a>&nbsp;will hold Office Hours every Wednesday at 14:00 UTC</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16050\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project some insight into the community that supports it. And get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> I have with me today, Sarah Norris. She is the Core Tech Editor in the WordPress 6.4 release. Welcome, Sarah.</p>\n\n\n\n<p>[00:00:47] <strong>Sarah:</strong> Oh, hi, and thanks for having me.</p>\n\n\n\n<p>[00:00:50] <strong>Josepha:</strong> First, I should give everyone kind of a concept of what we&#8217;re doing.</p>\n\n\n\n<p>So this is the WordPress 6.4 sneak peek episode of our podcast, which means that we&#8217;re going to talk a little bit about like the stuff that we are excited to get into the release stuff that we&#8217;re hoping is actually going to make it into the final release. But also, we&#8217;re going to talk a little bit about like stuff that we wish people knew.</p>\n\n\n\n<p>That we were working on. Things that are going to be really cool for users or developers or plugin authors, theme authors, things like that, that otherwise people would miss because it&#8217;s just hard to see. And so before we get started on all of that, is this your first release where you&#8217;re part of a squad like this?</p>\n\n\n\n<p>[00:01:31] <strong>Sarah:</strong> Ah, so, it&#8217;s actually my second. I was part of 6.1 as well. I led the default theme of 2023. But I am finding that the experience is a little bit different. So I&#8217;m still learning probably just as much.&nbsp;</p>\n\n\n\n<p>[00:01:42] <strong>Josepha:</strong> Yeah, absolutely. Well, and in 6.1 versus 6.4, for one, the themes are very different. Like the default themes are very different, but also the tasks involved with leading a default theme are very different from like leading things happening in the core editor in that Gutenberg plugin.</p>\n\n\n\n<p>[00:02:01] <strong>Sarah:</strong> Yeah, there&#8217;s so many different tasks. Yeah, like, I guess maybe there&#8217;s such, there&#8217;s maybe just like a set of tasks for every part of the release squad. But they&#8217;re so different. And much more involved.</p>\n\n\n\n<p>[00:02:12] <strong>Josepha:</strong> Yeah, absolutely. And as of the time of this recording, we&#8217;re recording this on September 27th. It comes out a little bit later. But as of the time of this recording, like we just wrapped up beta 1 for WordPress 6.4 yesterday. But I understand that, like an hour ago, you wrapped up a final release of the Gutenberg plugin as well.</p>\n\n\n\n<p>So you&#8217;re just kind of everywhere with us right now.</p>\n\n\n\n<p>[00:02:36] <strong>Sarah:</strong> Yeah, that&#8217;s exactly right. Yeah, we tried to make the beta 1 for 6.4 and the latest release of Gutenberg quite close together to make it easier to, to merge those latest changes for beta 1 of 6.4. So yes, that&#8217;s why it&#8217;s so close together, and fingers crossed, they both went really smoothly, so I&#8217;m really happy about that.</p>\n\n\n\n<p>[00:02:53] <strong>Josepha:</strong> Now we all sit around and watch the support queues and hope. That part, the sitting around and watching the support queues, is both my most favorite and least favorite sometimes part of releases. Like, it&#8217;s a little bit my most favorite because I get to talk to our support folks. I&#8217;m like, hey, is anything happening? But also, it&#8217;s my least favorite because it&#8217;s like the Schrödinger&#8217;s cat of releases. You&#8217;re like, as long as I don&#8217;t look at it, it could be all well or all bad, and I just don&#8217;t know.</p>\n\n\n\n<p>[00:03:23] <strong>Sarah:</strong> I hear you. I&#8217;ve just been doing something similar with watching test releases.</p>\n\n\n\n<p>[00:03:27] <strong>Josepha:</strong> Yeah. Just waiting and waiting and waiting. Yeah, absolutely. Absolutely.</p>\n\n\n\n<p>Well, let&#8217;s talk a little bit about 6.4. So WordPress 6.4 is our third major release of 2023, which is kind of a big deal for one because, like, three major releases a year is always exciting. But this particular one is, on the one hand, much larger from a feature standpoint than we kind of expected it to be, or so far, it looks like it&#8217;s going to be a bit larger than we expected.</p>\n\n\n\n<p>But also, it is our second iteration of an underrepresented gender release squad. Which I am very excited about. It&#8217;s a way for us to kind of bring in a lot of voices that otherwise we don&#8217;t see in the space. And so we&#8217;re going to just kind of talk through both of those things today. But let&#8217;s start with first: what are the things that are going into the release that you personally are most excited about, that you are most interested in making sure that we get all the way to the end of the release cycle?</p>\n\n\n\n<p>[00:04:27] <strong>Sarah:</strong> So, ones that I am particularly excited for. So, the first one on my list is the Font Library. This is looking really good to include as well. So it&#8217;s gonna do your way for users to manage fonts across their site regardless of their active themes. So similar how to how their media library works at the moment for images and other media.</p>\n\n\n\n<p>[00:04:44] <strong>Josepha:</strong> And if I recall correctly when I was looking at the prototypes for that, like the early demos of it, that has a lot of local font management as well, which helps us with GDPR concerns that we have had with font management in the CMS for a while. One, is that still correct? And two, does it look like it&#8217;s going to make it into the release?</p>\n\n\n\n<p>[00:05:04] <strong>Sarah:</strong> Yes. Yeah. Both correct. Yes. Yeah. Very easy. Yeah, that&#8217;s exactly right. So yeah, all the fonts will be managed locally. So, including things like Google Fonts. And any of the popular libraries and the way it&#8217;s been built, as it calls its files like this, it&#8217;s been built with extensibility in mind. So yeah, hopefully, the possibility should be endless for any number of font collections to be added.</p>\n\n\n\n<p>[00:05:23] <strong>Josepha:</strong> Yeah. Yeah. I, I know, for folks who are listening to this later, hopefully not much later, but if you are listening to this between when beta 1 came out and between and beta 2 is coming out, we didn&#8217;t get as much of that into beta 1 as we expected, but beta 2 should have a good chunk of it in there.</p>\n\n\n\n<p>So get out there and test that.</p>\n\n\n\n<p>[00:05:43] <strong>Sarah:</strong> It&#8217;s also just been released with Gutenberg 16.7 as well. So, I guess for anyone that you just mentioned listening in between.&nbsp;</p>\n\n\n\n<p>[00:05:51] <strong>Josepha:</strong> I&#8217;m one of those folks that has not; I don&#8217;t run trunk because I&#8217;m not that good with like preventing WordPress from falling apart. I&#8217;m not a developer, but I do run the nightlies and for the major releases for Core, and I run also the beta of Gutenberg. And so, I got both updates done this morning and started going in and looking at everything because I don&#8217;t run trunk. I didn&#8217;t have some of the weird edge cases that I saw reported over the last few weeks, which is probably good.&nbsp;</p>\n\n\n\n<p>[00:06:21] <strong>Josepha:</strong> But also, if anyone&#8217;s running trunk and is running all of the nightlies of anything, let us know where the problems are because there are not a lot of you. It feels like, like, a thousand people in the particular combination. What else is in there that you are very excited to see?</p>\n\n\n\n<p>[00:06:37] <strong>Sarah:</strong> I&#8217;m also looking forward to, so we have a new feature called Block Hook, and for anyone who follows Gutenberg, you might have heard it&#8217;s called Auto Inserting Blocks, but we&#8217;ve renamed it to Block Hook. And yes, this is another powerful feature that expands the extensibility of block themes. And so it allows plugins to automatically insert blocks into content relative to another block.</p>\n\n\n\n<p>And so, a good example that we&#8217;ve been using is automatically adding a like button to the post content block. And so yeah, I think it&#8217;s a, it&#8217;s maybe a more developer-centric feature.&nbsp;</p>\n\n\n\n<p>[00:07:09] <strong>Josepha:</strong> So, like, it detects what block you have and suggests bits and pieces that otherwise would make sense there that other people are usually using in those blocks.</p>\n\n\n\n<p>[00:07:20] <strong>Sarah:</strong> Yeah. Yeah. So you can add all through JSON as well. You can add a block that will automatically be added.</p>\n\n\n\n<p>[00:07:25] <strong>Josepha:</strong> All right. Excellent. That was part of the Interactivity API, or is, is early parts of it rather, I guess.</p>\n\n\n\n<p>[00:07:35] <strong>Sarah:</strong> Yes, that&#8217;s right. Yeah. Yeah. It&#8217;s the start.</p>\n\n\n\n<p>[00:07:39] <strong>Josepha:</strong> Another thing that is a part of the Interactivity API, which we&#8217;ve been working on, folks. I think everybody knows for like a year or two. The other part that is shipping in 6.4 is, I think, the Lightbox for images. Is that right?</p>\n\n\n\n<p>[00:07:55] <strong>Sarah:</strong> Yes, that&#8217;s right. Yes. And yeah, that&#8217;s due to be included with 6.4 as well.</p>\n\n\n\n<p>[00:07:59] <strong>Josepha:</strong> I&#8217;m going to just tell us all a weird story. So, for maybe my entire life, like I understand what a lightbox is from a image and photography standpoint, but for the majority of my life, I thought that lightbox referred to those like big initial letters in old manuscripts. I don&#8217;t actually know what those are called if not lightboxes, but in my mind, that&#8217;s what they were.</p>\n\n\n\n<p>[00:08:22] <strong>Josepha:</strong> And so when we first started talking about this, I was like, that&#8217;s what we&#8217;re shipping is like the drop capital letter, like the big one, but it&#8217;s not. In case anyone else also was confused about what a lightbox is, it&#8217;s the image-based concept of a lightbox.</p>\n\n\n\n<p>[00:08:37] <strong>Sarah:</strong> I think it&#8217;s an important one because previously you would have to install, maybe a third-party plugin or, or build lightbox yourself so. It may sound like a, oh, it&#8217;s a tiny feature that&#8217;s been included, but it&#8217;s actually pretty awesome. You don&#8217;t have to include even more extra code.&nbsp;</p>\n\n\n\n<p>[00:08:51] <strong>Josepha:</strong> Speaking of things that we have been working on for two years or so, I think that every sneak peek for the last year, the folks of WordPress have heard me say that I was super excited about navigation and how we&#8217;re managing it, but it turns out that is a very complicated thing. Like we know that, managing menus, managing navigation on a site is complicated from just like a philosophical standpoint. When our users of WordPress, when consumers of WordPress like go through that process, that is the hardest one to explain. And therefore, very hard to manage as well.&nbsp;</p>\n\n\n\n<p>We have had like a requirement that you know three different admins in order to manage your menu, manage your navigation on your site, but we shipped some early components for it in 6.3 and in 6.4. I believe that we are planning; I&#8217;m crossing my fingers no one can see it, crossing my fingers. We&#8217;re planning on getting an updated treatment for the toolbar out. Is that correct?</p>\n\n\n\n<p>[00:09:53] <strong>Sarah:</strong> Yes, yeah, I was a little bit worried because I didn&#8217;t know too much in detail, but I did know about the toolbar. So, yes, yes, I believe that is planned to get into 6.4.</p>\n\n\n\n<p>[00:10:01] <strong>Josepha:</strong> Yeah. So, and the point of that, because for folks who have not tried this out yet, the point of that is that the navigation is kind of, when you look at it, individual components, it&#8217;s like a bunch of little blocks together, and then we wrap it as like a collection that shows up as the navigation block, but because it&#8217;s a bunch of little blocks and each of the little blocks has their own like toolbar that goes with it, it took a lot of work to kind of figure out how to get all of those toolbars to have a primary expression with the navigation. Versus like every single thing that you put into your navigation has its own toolbar, and good luck to you.</p>\n\n\n\n<p>[00:10:44] <strong>Sarah:</strong> Yeah, it&#8217;s a really, really complicated problem, and I guess maybe it always has been, and hopefully we just keep improving and all the time, and we probably never will stop improving because it&#8217;s, yeah, it&#8217;s just such a complicated thing to edit, and I think particularly in an editor without using any code.</p>\n\n\n\n<p>[00:11:00] <strong>Josepha:</strong> Yes.</p>\n\n\n\n<p>[00:11:01] <strong>Sarah:</strong> We&#8217;re getting there, it always, it always is getting better.</p>\n\n\n\n<p>[00:11:04] <strong>Josepha:</strong> Yeah. Before we move into the question of like things that you wish people knew about the release that maybe they&#8217;re not going to know, I do want to stop and talk about the default theme a little bit. Everyone loves the default theme at the end of the year. But every year, Matt and I talk about, like, what would it look like if we didn&#8217;t have a default theme.</p>\n\n\n\n<p>What if we just were like, all themes are great. Just do whatever you want, which seems too difficult, frankly. But the way that this default theme is envisioned is so different. It&#8217;s got basically three different focuses. Do you know much about this year&#8217;s default theme?</p>\n\n\n\n<p>[00:11:41] <strong>Sarah:</strong> Yeah, a little bit, so I, yeah, I know, I don&#8217;t know, I think it&#8217;s shaping up to be a really good starting point for so many different types of projects. So, I know that that is maybe the aim of every default theme. But we usually show off a lot of the features that are going into the release, like via the default theme.</p>\n\n\n\n<p>I know we did that last time as well, but this time, we&#8217;re doing that stealth. But we&#8217;re also creating like a great baseline for so many different types of projects. And I think maybe in the past, we&#8217;ve maybe only hit like one type of project. And, like, this is a good example for this one very specific thing.</p>\n\n\n\n<p>But yeah, this time, I know that that&#8217;s always like, especially working with other themers, they&#8217;re like, what&#8217;s the best base theme for this type of thing? And I&#8217;m hoping Twenty Twenty-Four is going to be the new answer for so many people.</p>\n\n\n\n<p>[00:12:23] <strong>Josepha:</strong> Yeah, yeah, I looked at the early designs for that with the, because what it has, and these, we&#8217;ll put a link to this in the show notes to the repo about it and the Figma file and all those things. But what it has is like a really robust set of default patterns for anyone who&#8217;s wanting to have like a big commercial site with a lot of things that are required, a really complicated site. Then we have a suite of default patterns that are shipping so that artists and people who are focused primarily on visual assets on their site have the specific patterns and blocks and things required for that and then one that is specific to people who focus on the content in their site.</p>\n\n\n\n<p>I am one of the people who specifically focuses on the content in the site. I was delighted to see that, but it kind of has three different levels of varying complexity based on what it is that people might, might want to have to, oh, not want to have to, might want to be able to do on their sites. And I think that&#8217;s kind of cool.</p>\n\n\n\n<p>[00:13:31] <strong>Sarah:</strong> Yeah. Yeah. It&#8217;s super cool. And I think while we&#8217;re still in the development cycle as well, for 6.4, this is a; the default theme is a great way to jump into contributing if people are looking for good ways to jump in.</p>\n\n\n\n<p>[00:13:44] <strong>Josepha:</strong> Yeah, it runs in a separate repo. And so it has a little bit of a different process, but also it feels like a little bit of a faster process. It kind of runs independently of the release cycle that we have for either the plugin or core. And so it kind of goes a bit faster.</p>\n\n\n\n<p>[00:14:03] <strong>Sarah:</strong> Yes.</p>\n\n\n\n<p>[00:14:05] <strong>Josepha:</strong> Yeah. Excellent. So, then, obvious next question. What Is happening in this release that you wish people knew about?</p>\n\n\n\n<p>[00:14:15] <strong>Sarah:</strong> Yep. Okay. So, I think maybe things that are difficult to fit into the bigger categories that will be easy to shout about when we talk about the release when it&#8217;s been released. There&#8217;s a lot of accessibility enhancement that are going to be included. So there&#8217;s things like better button placements and upgraded spoken messages, especially in site health.</p>\n\n\n\n<p>There&#8217;s also so many performance improvements that are scheduled to be included, so I know there was many performance improvements included in 6.3. We are continuing that for 6.4. There&#8217;s many more improvements to block themes and classic themes in the way the templates are loaded. And we&#8217;ve also got a we&#8217;re including a usage of the new defer and async loading strategies as well for script.</p>\n\n\n\n<p>So these are sort of like, nitty-gritty detail sort of things that will be included that don&#8217;t sound too exciting but are actually really, really cool.&nbsp;</p>\n\n\n\n<p>[00:15:07] <strong>Josepha:</strong> Yeah. I understand the whole like, this is not very exciting. This doesn&#8217;t sound interesting but trust me, it is like, sometimes it feels like half of my job is that I&#8217;m like, I know that nothing I&#8217;m about to say sounds cool, but trust me, it&#8217;s amazing. We&#8217;ve been working on it for a long time, and it&#8217;s cool.</p>\n\n\n\n<p>That&#8217;s great. That&#8217;s great. And so. For those things, it sounds like a lot, this is going to particularly be of interest to folks who are developing for other people using WordPress. But also obviously a little bit of, of benefit, maybe invisible benefit, but still benefit for our end users as we go.</p>\n\n\n\n<p>[00:15:46] <strong>Sarah:</strong> Yeah, yeah, that&#8217;s right, exactly.</p>\n\n\n\n<p>[00:15:48] <strong>Josepha:</strong> So those are kind of the sneak peek items that we&#8217;ve got going into the release. As always, with this particular episode, we&#8217;re not promising that any of those things will 100 percent for sure get in there. There is part of being a release squad that kind of doesn&#8217;t really get talked about outside of WordPress but is probably worth mentioning, which is that the release squad has the really unpleasant job of saying no at the last second for things that are breaking something, things that are not actually a better user experience.</p>\n\n\n\n<p>Like we have the uncomfortable job of saying like, no, it wasn&#8217;t good enough. Sorry, thank you. Come again in the next release cycle. And so, like, all of these things are things that are currently in and being tested, but in the event that we discover it breaks 10 percent of the sites that we have on WordPress, like, we&#8217;re gonna, we&#8217;re gonna pull it.</p>\n\n\n\n<p>So, right now, that&#8217;s all in there, we hope, and if listening to me for a whole year get excited about the changes in navigation, and then also not getting them in didn&#8217;t teach you anything, just because I want it in doesn&#8217;t mean that I get to have it in either. So, but yeah, so that&#8217;s exciting. The other exciting thing about this release, we mentioned it a bit at the top of the discussion, is that it is a gender-upresented, gender-underrepresented release squad. Not upresented, because that is a, not a word. And so this is the second one. Did you participate in the first one?</p>\n\n\n\n<p>[00:17:22] <strong>Sarah:</strong> No, I didn&#8217;t no. Yeah, but I have read all about it, especially in prep to this release as well.</p>\n\n\n\n<p>[00:17:28] <strong>Josepha:</strong> Oh, did you learn anything from it that you brought into this one, or was it just like, I need to know what I&#8217;m getting into kind of reading a lot about it?&nbsp;</p>\n\n\n\n<p>[00:17:36] <strong>Sarah:</strong> Yeah, basically, yeah, I was trying to prep myself, ever since I was involved in 6.1, I&#8217;ve tried to be, I&#8217;ve tried to follow along closely with the releases. But sometimes, there&#8217;s just so much going on all the time. Sometimes it&#8217;s a little bit much. But yeah, I just wanted to see if there was any, any big differences.</p>\n\n\n\n<p>There shouldn&#8217;t be, right? So yeah, it&#8217;s all good.</p>\n\n\n\n<p>[00:17:54] <strong>Josepha:</strong> I think all of the differences were in that boring part where people don&#8217;t, they&#8217;re like, that sounds so un-fun, we&#8217;re going to just stop listening. But it was like, in the planning and preparation for it, and the way that we did all the training, like the initial one had like an 18 month period between like, we&#8217;re gonna do it, and now it&#8217;s done, where we did a lot of additional work to get everybody in there.</p>\n\n\n\n<p>[00:18:18] <strong>Josepha:</strong> And this time, we were like, get in here! That&#8217;s all we did. So, how has your experience been on the release squad? I know that you did one before. You did one in 6.1, but is this particular squad any different compared to your last experience of it, or what you expected?</p>\n\n\n\n<p>[00:18:35] <strong>Sarah:</strong> So, I would say everyone is equally as amazing as every release and, including the resource they&#8217;re involved with. I think that the biggest difference for me, and maybe this links to something you just said, is that I, I knew I was going to be involved in the release squad a lot earlier, especially compared to me for 6.1, but I think I&#8217;ve heard other people say that as well. So, I think that&#8217;s a great thing for this release. We all have had some time ahead of the release and including during this 6.3 release as well, so I was able to watch particular people in, not in a non-creepy way, and make sure I knew which, like what the processes were.</p>\n\n\n\n<p>Yes, to try and get my head around when when I&#8217;d be doing it. And, and obviously, the big help was that I&#8217;d be doing it immediately after they&#8217;d just done it as well. And the previous release squad has been a massive help as well when I&#8217;ve come across either very, very complicated issues or like super silly issues; I can write them and answer your questions so that I think if we could carry that forward with the future releases as well.</p>\n\n\n\n<p>[00:19:28] <strong>Josepha:</strong> Yeah, absolutely. So this time around, we had almost 50 percent new folks that that, like, let us know that they were participating, probably quite a few more than that. But, like, of the people who let us know that they wanted to participate in this release, we had like 28 out of 50 people, something like that, who are brand new to contributing to WordPress in some cases, but certainly, all of them are brand new to contributing to a major release like this. Have you, cause this is not your first time doing this, but it is your first time in this type of release. Have you found that, like, you&#8217;re feeling able to help new people see what&#8217;s happening also, like, do you feel seasoned enough for that? Or are you just like, nope, I&#8217;m also new.</p>\n\n\n\n<p>[00:20:17] <strong>Sarah:</strong> Maybe a little bit of both. I guess I, yeah, I&#8217;m fortunate to have at least experienced, maybe, like how the deadlines roll. Actually, especially the point we&#8217;re at at the moment, where the weekly beta cycles happened. Last time, it took me by surprise. I was like, oh wow, okay, we have a week. Until the next one, and then a week, and so yeah, I feel a bit more psyched up for that this time around.</p>\n\n\n\n<p>And hopefully, I can tap that on you to the new folks as well. But yeah, I also noticed we have a lot of new people. We have, especially from a core editor tech lead; I think we have nearly 30 people who are sort of officially following us along or shadowing us.</p>\n\n\n\n<p>So yeah, yeah, but it&#8217;s really cool. I hope we can teach so many more people if they want to get involved with the next release or even just contributing in general. Yeah, it&#8217;d be amazing.</p>\n\n\n\n<p>[00:21:00] <strong>Josepha:</strong> Yeah. If you are listening to our podcast, and you think to yourself, well, I&#8217;m here. And I wonder if anyone knows because I&#8217;m just watching everyone in a non-creepy way, like feel free at the next meeting that you&#8217;re watching to, to raise your hand and say, I&#8217;m new. We want to know that you&#8217;re there.</p>\n\n\n\n<p>Not because we feel creepy otherwise. But also because we just want to celebrate that you exist new folks that are scared of us. Don&#8217;t be scared of us.</p>\n\n\n\n<p>Oh, man, I feel compelled now to tell everybody about the first time that I led a core chat. So the core chat, I watched that without telling anyone I was watching it for like a year before I had to actually lead it, and I just didn&#8217;t tell anybody I was there like I didn&#8217;t even participate in the waving part at the start where it&#8217;s just like, Hey, everyone, I exist, like, when I was just silently watching it all go by and so when I got announced as part of a release squad. It was shocking for everyone, I think. And there is a public record of a moment where I was panicking. I felt like everyone was asking me a thousand questions, and I didn&#8217;t know the answers to any of them. And I just told all of them, like, there are a million of you and one of me, and you&#8217;re kind of scaring me, so would you stop?</p>\n\n\n\n<p>And so there&#8217;s a public record of me calling out every developer that existed in WordPress at the time. I felt bad about it in the moment, but also like, whew, that was, I don&#8217;t think we have experiences like that for new contributors anymore, but it was, it was quite a moment. I remember distinctly, so Jeffrey Paul, he&#8217;s like one of our, I think we have three or four like self-declared project managing people.</p>\n\n\n\n<p>He is a project manager person in WordPress that I really rely on, and I was DM&#8217;ing him in the background in a full panic. I was like, I don&#8217;t know the answer to any of these questions. What am I supposed to do? And he was like no is also an answer. So, like, just tell them no. Tell them you don&#8217;t know. That&#8217;s fine. And I was like, Oh, God! So, I think that we maybe don&#8217;t have too much of that happening anymore, but I also understand that I wouldn&#8217;t see it if it were happening. No one&#8217;s coming to me to be like, is this normal? Should I panic? They&#8217;re probably coming to you with that.</p>\n\n\n\n<p>[00:23:21] <strong>Sarah:</strong> I think it&#8217;s a sort of good, I&#8217;m not good for you, maybe, but good for observers especially. You know, to see you go through that as well. I can really relate to, like, not even showing, like, a wave emoji because I&#8217;ve totally been in that situation. I think maybe we&#8217;re similar in that regard, like, it, sometimes I just feel really nervous even just showing an emoji.</p>\n\n\n\n<p>And I think, again, shouting out about that and to, to those people who also feel like that, who are watching yeah, yeah, wave if you, if you feel like you want to, and don&#8217;t wave, it&#8217;s also fine just to watch.&nbsp;</p>\n\n\n\n<p>[00:23:48] <strong>Josepha:</strong> Once you&#8217;ve been to 52 meetings, then you can wave. Oh, it&#8217;s so hardworking in open source that way because, like, there is a lot of, like, basically faith in other people because trust comes with, like experiencing things together. But initially, you do just kind of have to have faith that no one&#8217;s going to laugh you out of the room or say that your ideas are stupid or that you are like even remotely understanding the problem, and so that&#8217;s a, it&#8217;s a part of the new contributor experience that I always find so interesting I used to routinely give presentations about like this is how you get started first get ready to be uncomfortable I don&#8217;t give those presentations very often anymore but probably probably I should ask someone to get out there and be like, It&#8217;s scary for everyone, including you!</p>\n\n\n\n<p>Come be scared together! Cause I think that&#8217;s important to normalize. Fear&#8217;s normal. When you first started contributing to WordPress in general, let alone like being on a release squad, what is the team that you first joined through?</p>\n\n\n\n<p>[00:25:02] <strong>Sarah:</strong> So, I guess, full-time contribution, it was themes. I was very involved with themes, and I still am as well; I really love themes, especially block themes. And also with the editor. But, like, years and years ago, I guess it was still themes. I used to build themes.</p>\n\n\n\n<p>But that was very much; I was a forum user, and well, actually, I guess it goes back to me being very nervous and not wanting to admit the question that I wanted to ask, so I would hunt the forums, but afterwards just so helpful.</p>\n\n\n\n<p>Like, yeah, I know this is a lot of people&#8217;s story, but yeah, the forums and just chatting amongst other community members is so, so helpful. So yeah, when I became a full-time contributor, I really, I love talking to other people who are trying to get help or, yeah, reaching out any way they can because I was like, I feel that I was you and still am you as well.</p>\n\n\n\n<p>[00:25:50] <strong>Josepha:</strong> I mean, the good thing about it, like, we will always feel like we&#8217;re learning something because we are, but in my experience of folks in WordPress, and I haven&#8217;t been new in a long time, obviously been doing this for like eight years now which is ancient by technology standards, but like my favorite thing about folks in WordPress is that they are wanting to like learn enough to probably not break it forever.</p>\n\n\n\n<p>Like it&#8217;s the probably is in there, and the forever is in there like I want to. I want to know just enough to be mildly dangerous and then bring everybody with me. Let&#8217;s go be dangerous together. And I think that is really charming in a way because it&#8217;s like we know enough to sort of break it. But not break it a lot.</p>\n\n\n\n<p>So let&#8217;s go see how we break it a little bit to make it better. I think that&#8217;s such a charming attitude for some reason because then we all just get to kind of learn and be a little bit messy together, which is the nature of openly collaborating on a half-written software—all the time. But yeah, I think it&#8217;s kind of neat.</p>\n\n\n\n<p>[00:27:05] <strong>Sarah:</strong> Yeah, yeah, exactly. It&#8217;s exciting too, like if you&#8217;re staying, you&#8217;ve got that enough red push and edge that you&#8217;re just like, Ooh, I might break something. But then there&#8217;s so many people that help you out that, you know, just before you could actually break something important.&nbsp;</p>\n\n\n\n<p>[00:27:18] <strong>Josepha:</strong> Exactly. The one time when I did a very breaking thing because I didn&#8217;t know to ask about it and fixed it immediately was that I mentioned in the middle of a core chat that we were about to have a security release. But it wasn&#8217;t about it wasn&#8217;t like in the next 15 minutes, it was like three weeks away, which is not what you&#8217;re allowed to do like you are not allowed to mention that you have a security release coming in three weeks, and then hope that nobody figures out what it&#8217;s patching.</p>\n\n\n\n<p>Yeah, I got so many messages in such a short amount of time from it felt like every lead developer of WordPress. That was my, my worst moment.</p>\n\n\n\n<p>And I fixed it immediately. So that was good. But also, I don&#8217;t remember if we had to like move up the, the timeline for that release or what. I don&#8217;t; I have no idea what the outcome was because I was just in an outright panic about what I had done incorrectly.</p>\n\n\n\n<p>Anyway, so that&#8217;s the; I&#8217;m just going to tell everybody my most embarrassing early contribution stories today. That&#8217;s what I&#8217;m doing. Excellent. Well, Sarah, before we head out of here, is there a final thought that you would like to share with either our listeners here or future potential contributors to WordPress?</p>\n\n\n\n<p>[00:28:37] <strong>Sarah:</strong> Please help test 6.4, especially through the next few cycles of beta. It would be amazing to have everyone and anyone who would like to help. That is one of the best ways you can help is to test. And then, yeah, if you want to get involved a little bit further, then yeah, I guess, please reach out wherever you think you fit, which I know sounds a bit fake, but there are a lot of different places, and I&#8217;m sure there will be somewhere you fit as well.</p>\n\n\n\n<p>00:28:59] <strong>Josepha:</strong> I will leave in the show notes a link to the page that has all of the upcoming meetings on it. You can probably go to almost any meeting and say, I think this is where I would like to contribute, but also, this is the kind of thing I can contribute, and they will be able to head you in the right direction if you&#8217;re not already in the right direction. But also, like, sometimes your skills that you have are going to be applicable in places where you&#8217;re not aware of yet. And so, go to any meeting—wave to the friendly WordPressers that are around, the Sarah Norrises that exist in the project.&nbsp;</p>\n\n\n\n<p>[00:29:36] <strong>Josepha:</strong> Sarah, thank you so much for joining me today. This was a delight.</p>\n\n\n\n<p>[00:29:39] <strong>Sarah:</strong> Thanks so much for having me on; I really enjoyed it.</p>\n\n\n\n<p>[00:29:42] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:29:42] <strong>Josepha:</strong> That brings us now to our small list of big things. First thing to know is that tomorrow we have Beta 2 for WordPress 6.4. This is our final release of the year, as you know because we&#8217;ve been talking about it for the entire episode. But, just like Sarah said at the end of our conversation, we absolutely need people to help us test it, make sure that it is working in as many places as possible so that we can have the best release possible. So keep an eye out on the core channel in the Making WordPress Slack, and of course, keep an eye on WordPress.org/news as those releases get packaged and ready to go.&nbsp;</p>\n\n\n\n<p>So the second thing is a proposal for documentation translation localization process update. This is an initial step to consolidate all of that documentation into a single easy-to-reach location. So we need some feedback on it. Head on over there, leave a comment to share your feedback about where that should possibly go, where is most useful and valuable for you.&nbsp;</p>\n\n\n\n<p>The second proposal that I have is actually sort of a tangentially related one, but so it&#8217;s not specific to WordPress but does need some WordPress input. There is a call for proposal for Interop 2024. There&#8217;s a post that has a lot more information about it than I do, but we would like for any WordPress developer who&#8217;s interested to head over there and submit a proposal for what they could speak about at Interop, I believe. You can leave your thoughts on the post itself as a comment, or there&#8217;s also a GitHub repo where you can interact as well.</p>\n\n\n\n<p>The next thing on our small list of big things is that the WordCamp US Q&amp;A, the questions that we didn&#8217;t get to because there were something like 87 or something in the queue. The questions that we didn&#8217;t get to, the answers have been posted. They&#8217;re over on make.WordPress.org/project, but I&#8217;ll include a link to those to that post in the show notes.&nbsp;</p>\n\n\n\n<p>And the final thing on the small list of big things, I&#8217;m actually quite excited about. We are hosting now accessibility office hours. In an effort to improve accessibility knowledge in the WordPress project in general, the accessibility team will be holding office hours every Wednesday at 14:00 UTC.</p>\n\n\n\n<p>That started on September 20th. And so it&#8217;s been going for a couple of weeks now. And the purpose is to make sure that we have a dedicated space and time to discuss accessibility principles and best practices as we go through those things.&nbsp;</p>\n\n\n\n<p>[00:32:29] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Hayden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:32:38] (Music interlude)&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"16050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Help Influence the Future of WordPress by Taking the 2023 Annual Survey Today\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/news/2023/09/help-influence-the-future-of-wordpress-by-taking-the-2023-annual-survey-today/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 10:52:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15982\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. The results can influence the direction of the WordPress project by identifying areas that need attention. Annual surveying can also help track trends over time, with data points often finding their way into the yearly State of the Word address.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4813:\"\n<p>Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. The results can influence the direction of the WordPress project by identifying areas that need attention. Annual surveying can also help track trends over time, with data points often finding their way into the yearly <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> address.</p>\n\n\n\n<p>This survey helps those who build WordPress understand more about how the software is used and by whom. The survey also allows WordPress open source project leaders to learn more about our contributors’ experiences.&nbsp;&nbsp;</p>\n\n\n\n<p>To ensure your WordPress experience gets represented in the 2023 survey results, take the survey now (link).</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>You may also take the survey in other languages by using the link above and switching to another language, thanks to the efforts of WordPress polyglot contributors.&nbsp;</p>\n\n\n\n<p>The survey will be open for five weeks. Results will be published on the News blog in early December.</p>\n\n\n\n<p>This year, like last year, the survey has undergone some improvements to the flow and question set. A new platform is also being piloted, offering an updated interface, enhanced multi-lingual support, expanded analysis and visualization tools for the results, and more. The new platform also has built-in accessibility and privacy controls, ensuring the survey meets the diverse needs of the WordPress community.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Spread the word</strong></h2>\n\n\n\n<p>Please help spread the word about the survey by sharing it with your network, through Slack, or within your social media accounts. The more people who complete the survey and share their experience with WordPress, the more the project will benefit.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Security and privacy</strong></h2>\n\n\n\n<p>Data security and privacy are paramount to the WordPress project and community. With this in mind, all data will be anonymized: no email addresses or IP addresses will be associated with published results. To learn more about WordPress.org’s privacy practices, view the <a href=\"https://wordpress.org/about/privacy/\">privacy policy</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you</strong></h2>\n\n\n\n<p>Thank you to the following WordPress contributors for assisting with the annual survey project, including question creation, strategy, survey build-out, and translation:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/adamsilverstein/\">adamsilverstein</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">audrasjb</a>, <a href=\"https://profiles.wordpress.org/alvarogois/\">alvarogóis</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbénard</a>, <a href=\"https://profiles.wordpress.org/hassantafreshi/\">hassantafreshi</a>, <a href=\"https://profiles.wordpress.org/juliagasparyan/\">juliagasparyan</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">kittmedia</a>, <a href=\"https://profiles.wordpress.org/manudavidos/\">manudavidos</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nilovelez/\">nilovelez</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, and <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner</a>.</p>\n\n\n\n<p>Thanks to <a href=\"https://www.hostinger.com/\">Hostinger</a>, <a href=\"https://cloud.jetpack.com/\">Jetpack</a>, and <a href=\"http://wordpress.com\">WordPress.com</a>, for assisting with promoting the survey to their respective clients.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>The survey closes on <time datetime=\"2023-10-31T16:00:00-04:00\" data-iso=\"20231031T1600\" class=\"wporg-time\">Tuesday, October 31, 2023 at 12:00</time>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 6.4 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Sep 2023 20:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15994\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:301:\"WordPress 6.4 Beta 1 is now ready for download and testing!\n\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 1 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:19031:\"\n<p>WordPress 6.4 Beta 1 is ready for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>.<strong> </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 1 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 1 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin:</strong> Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download: </strong>Download the <a href=\"https://wordpress.org/wordpress-6.4-beta1.zip\">Beta 1 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line:</strong> Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br><code>wp core update --version=6.4-beta1</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Your help testing this version is key to ensuring everything in the release is the best it can be.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\" target=\"_blank\"><strong>underrepresented gender release squad</strong></a>&nbsp;to increase participation&nbsp;of and partnership with&nbsp;those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p class=\"has-extra-large-font-size\">Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for further details.</p>\n</blockquote>\n\n\n\n<p><em><strong>This post has been updated as of October 5, 2023, to reflect the latest changes.</strong></em></p>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How you can help: Testing</h2>\n\n\n\n<p>Testing for issues is a critical part of developing any software, and it’s a meaningful way for anyone to contribute—whether you have experience or not. <strong><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing key features in WordPress 6.4.</strong></p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates that have debuted since WordPress 6.3 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>WordPress 6.4 Beta 1 contains over 400 enhancements and 370 bug fixes for the editor, including more than <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.4&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">190 tickets for WordPress 6.4 core</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 1</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities is doubled</a>. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A first look at WordPress 6.4</h2>\n\n\n\n<p>WordPress 6.4 will introduce a versatile default theme, new features, and numerous updates designed to enhance your WordPress experience across multiple areas—from writing and design to workflow efficiency. All while the foundational work continues for Phase 3 of the <a href=\"https://wordpress.org/about/roadmap/\">WordPress roadmap</a>. Read on for some highlights.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meet the Twenty Twenty-Four theme</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a> is a new default theme that will launch with 6.4. With a versatile collection of templates and patterns, this theme covers a diverse range of use cases, from entrepreneurs to small businesses to artists and writers. Twenty Twenty-Four also emphasizes the latest design tooling and site editing features, enabling you to leverage the flexibility of blocks and unlock numerous creative possibilities with just a few tweaks. Follow the theme&#8217;s progress and report any issues on <a href=\"https://github.com/WordPress/twentytwentyfour\">this GitHub repo</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Manage fonts across your site</h3>\n\n\n\n<p>WordPress 6.4 will introduce new font management features:</p>\n\n\n\n<p>The <a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a> enables you to handle fonts across your site, regardless of your active theme—just like you manage assets in the Media Library. Easily install local and Google Fonts and choose which to activate for each theme. This new font manager is a powerful way to control a fundamental piece of your site&#8217;s design and branding without coding. Thanks to its <a href=\"https://github.com/WordPress/gutenberg/issues/53307\">extensibility</a>, custom typographic collections can expand your font choices.</p>\n\n\n\n<p>On the other hand, <a href=\"https://core.trac.wordpress.org/ticket/59165\">Font Face</a> provides server-side <code>@font-face</code> style generation and printing support. It introduces a new global function called <code>wp_print_font_faces()</code>, which processes font data received from styles set in the editor or by the active theme.</p>\n\n\n\n<p><em><strong>Update (October 5, 2023): </strong>The Font Library feature will not debut in WordPress 6.4. Instead, it has been postponed to the next major release, 6.5. WordPress is committed to delivering the best possible experience, meaning this feature requires more feedback and testing to shine. Thank you for your understanding!</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Add lightbox functionality to your images</h3>\n\n\n\n<p>Showcase your images in an interactive fashion with <a href=\"https://github.com/WordPress/gutenberg/issues/51132\">lightbox functionality</a>. This new core feature will be available for Image blocks, allowing visual assets to be opened and enlarged on top of the existing content.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enjoy new writing improvements</h3>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/issues/53305\">Many enhancements</a> in 6.4 will ensure that your WordPress writing experience remains smooth and enjoyable, from new keyboard shortcuts to more reliable pasting from other sources. Moreover, a fresh toolbar experience will be available for the <a href=\"https://github.com/WordPress/gutenberg/pull/53697\">Navigation</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53306\">List</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53699\">Quote</a> blocks, making working with their tooling options more efficient and intuitive.</p>\n\n\n\n<h3 class=\"wp-block-heading\">More design tools, greater creativity</h3>\n\n\n\n<p>New design tools will improve the overall creation experience with WordPress while providing greater layout control and flexibility. Some updates include:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53934\">Background images for Group blocks</a>, allowing for creative and customized layouts.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54216\">Aspect ratios for image placeholders</a>—a new feature that’s particularly useful when creating and using patterns. After setting a placeholder’s desired aspect ratio, you can drag and drop an image, which will adjust to maintain the design consistency.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53667\">Button and heading color customization in Group</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/54104\">Columns blocks</a>, enabling you to define the appearance of these elements when placed within these container blocks. This feature takes a step towards allowing <a href=\"https://github.com/WordPress/gutenberg/issues/40318\">section-specific styling</a>, which will continue to develop in upcoming releases.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54416\">Alignment settings in synced patterns</a>. When creating and converting a synced pattern with wide, full-width, left or right-aligned blocks, this improvement ensures alignment attributes remain intact for a seamless site editing and pattern creation experience.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Upgrades for smoother workflows</h3>\n\n\n\n<p>As the Site Editor continues to evolve and expand its capabilities, so do the interface and tools that support it.</p>\n\n\n\n<p>First introduced in WordPress 6.3, the <a href=\"https://wordpress.org/documentation/article/site-editor-command-palette/\">Command Palette</a> helps you perform actions, search, and quickly navigate your site&#8217;s content and settings. It will receive significant updates in 6.4, featuring an <a href=\"https://github.com/WordPress/gutenberg/pull/53117\">updated design</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/52509#top\">new commands</a> to accomplish block-specific actions, and <a href=\"https://github.com/WordPress/gutenberg/pull/53496\">better command language and action consistency</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/list-view/\">List View</a> provides a great way to browse and work with the blocks that make up your site. This release will introduce enhancements to its interface and usability, making it even more powerful. You can <a href=\"https://github.com/WordPress/gutenberg/pull/53735\">rename Group blocks</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53381\">view media previews for Gallery and Image blocks</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53559\">duplicate blocks with a keyboard shortcut</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Pattern advancements</h3>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/site-editor-patterns/\">Patterns</a><strong> </strong>play an essential role in site editing, and its importance remains prominent in the upcoming release.</p>\n\n\n\n<p>6.4 will allow you to better organize <a href=\"https://github.com/WordPress/gutenberg/pull/53835\">your synced and unsynced patterns with categories</a> as part of the creation process. These categories are available for sorting within the insertion flow to make discovering and adding patterns easier. In addition, you can conveniently access all your custom patterns from the same place—the Patterns section of the Block Inserter, which removes the separate tab for synced patterns.</p>\n\n\n\n<p>Other improvements include <a href=\"https://github.com/WordPress/gutenberg/pull/54337\">importing and exporting patterns as JSON files</a>, ensuring backward compatibility with Reusable blocks, and enabling pattern transfer across sites.</p>\n\n\n\n<p>Lastly, building on the groundwork laid in WordPress 6.3, this release will improve the <a href=\"https://github.com/WordPress/gutenberg/issues/52150\">pattern management experience for non-block themes</a> by adding a <a href=\"https://core.trac.wordpress.org/ticket/58827\">Patterns tab</a> under the Appearance menu, allowing access to the Pattern list page of the admin screen.</p>\n\n\n\n<p><strong><em>Update (October 2, 2023): </em></strong><em>While 6.4 will bring several exciting pattern advancements, the previously mentioned improved pattern management experience for non-block themes will regrettably not be included in the 6.4 release. Thank you for your understanding, and be on the lookout for it in WordPress 6.5.</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Introducing Block Hooks</h3>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a> is a new powerful feature that enriches the extensibility of block themes, drawing inspiration from the familiar WordPress <a href=\"https://learn.wordpress.org/tutorial/wordpress-filter-hooks/\">Hooks</a> concept. Upon activation, plugins can automatically insert blocks into content relative to another block. For example, a &#8220;Like&#8221; button block can automatically be inserted after the Post Content block.</p>\n\n\n\n<p>While developer-centric, Block Hooks enhances the user experience by making block usage more intuitive and allowing for further customization and control over where and how the auto-inserted blocks appear. A <a href=\"https://github.com/WordPress/gutenberg/pull/52969\">new block inspector panel</a> named &#8220;Plugins&#8221; is designed to respect creators&#8217; preferences, ensuring you can add, dismiss, or relocate Block Hooks as desired.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>WordPress 6.4 has 70 accessibility improvements slated for inclusion, 60 of those are included in Beta 1. Notable updates focused on enhancing the user interface (UI) experience include <a href=\"https://core.trac.wordpress.org/ticket/40822\">better button placements</a>, <a href=\"https://core.trac.wordpress.org/ticket/47125\">improved context for “Add New” admin menu items</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58573\">upgraded spoken messages in Site Health</a>.</p>\n\n\n\n<p>Additionally, fixes for <a href=\"https://core.trac.wordpress.org/ticket/58756\">image editing in the Media Library</a>, <a href=\"https://core.trac.wordpress.org/ticket/30685\">error reporting on the login screen</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58756\">&#8220;no motion&#8221; settings for GIFs</a> have been implemented. The cause of some <a href=\"https://core.trac.wordpress.org/ticket/58703\">false positives in automated UI tests</a> has been corrected, and users without JavaScript now see a <a href=\"https://core.trac.wordpress.org/ticket/59229\">direct link to install the Classic Editor plugin</a>. Learn more about these changes and other accessibility improvements for 6.4 on <a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&amp;milestone=6.4&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">WordPress Trac</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.4 will include more than 100 performance-related updates, including <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&amp;component=Themes&amp;milestone=6.4\">improvements to template loading performance</a> for Block Themes and Classic Themes, <a href=\"https://core.trac.wordpress.org/query?focuses=~javascript+performance&amp;milestone=6.4\">usage of the new script loading strategies “defer” and “async”</a> in core, blocks, and themes, and new functions to optimize the use of <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&amp;component=Options%2C+Meta+APIs&amp;component=Database&amp;milestone=6.4\">autoloaded options</a>.</p>\n\n\n\n<p><strong><em>Please note that features in this list are subject to change before final release.</em></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">A haiku for 6.4</h2>\n\n\n\n<p>Inline fonts, lightbox<br>Command blocks like CLI<br>Almost to 6-4</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/meher/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meher</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>, <a href=\'https://profiles.wordpress.org/meaganhanes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>meaganhanes</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/flixos90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>flixos90</a>, <a href=\'https://profiles.wordpress.org/richtabor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>richtabor</a>,&nbsp; <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a></em>, <em><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/luminuu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>luminuu</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15994\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WP Briefing: Episode 62: Enterprise Clients and the Business of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wordpress.org/news/2023/09/episode-62-enterprise-clients-and-the-business-of-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 18 Sep 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=15971\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Join WordPress Executive Director Josepha Haden Chomphosy as she discusses the role WordPress Enterprise plays along with the WordPress community.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://wordpress.org/news/files/2023/09/WPB062.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16338:\"\n<p>Join WordPress Executive Director Josepha Haden Chomphosy as she discusses the role WordPress Enterprise plays along with the WordPress community.</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host:&nbsp;<a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>The 2023&nbsp;<a href=\"https://communitysummit.wordcamp.org/2023/\">Community Summit</a>&nbsp;in Washington, DC</li>\n\n\n\n<li><a href=\"https://wordpress.org/enterprise/\">WordPress Enterprise</a></li>\n\n\n\n<li><a href=\"https://beta.nasa.gov/\">NASA Website (beta)</a></li>\n\n\n\n<li><strong>A small list of big things</strong> (SLBT)\n<ul>\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/07/evolving-the-fse-outreach-program/\" target=\"_blank\">Evolving the FSE Outreach Program</a>&nbsp;&#8211; With WordPress 6.3 bringing Phase 2 to completion, it’s time for the FSE Outreach Program to evolve alongside the broader WordPress project and needs.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/08/31/proposal-an-update-to-the-field-guide/\" target=\"_blank\">Proposal: An update to the Field Guide</a>&nbsp;&#8211; This proposal is one step, but not necessarily the only step, at improving communication around WordPress releases and making it easier for WordPress updates to instill confidence.</li>\n\n\n\n<li>We are still looking to receive more&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpressdotorg.survey.fm/next-generation-of-wordpress-events\" target=\"_blank\">ideas on the future of WordPress events</a>&nbsp;&#8211; We have brought this up in the past, but there is still time to submit ideas.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/support/2023/08/proposal-for-updated-support-guidelines/\" target=\"_blank\">Proposal for updated support guidelines</a>&nbsp;&#8211; As these result from work during WordCamp Us 2023, if you are at the venue and wish to discuss something, please feel free to reach out.</li>\n\n\n\n<li>&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/05/call-for-testing-performant-translations/\" target=\"_blank\">Call for Testing: Performant Translations</a>&nbsp;&#8211; Provide your feedback; if you encounter any issues or have questions about the plugin, please comment or open a new support topic. In addition to that,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/swissspidy/performant-translations\" target=\"_blank\">contributions can be made on GitHub</a>.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://www.eventbrite.com/e/speaker-workshop-for-indian-women-in-the-wordpress-community-sept-23-24-tickets-633636773647\" target=\"_blank\">WordPress Diversity Training</a>&nbsp;&#8211; This is a 2-day workshop for women in India (other countries are welcome to join us, too) who are considering speaking at a WordPress Meetup or WordCamp.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://www.meetup.com/antelope-valley-wordpress-meetup/events/295817501\" target=\"_blank\">Let&#8217;s talk about WordPress</a>! &#8211; The WordPress Community team is looking for some folks to take the lead in hands-on organizing your Meetups</li>\n\n\n\n<li><a href=\"https://wpincludes.me/\">WP Includes</a></li>\n\n\n\n<li><a href=\"https://www.meetup.com/philadelphia-wordpress-meetup-group/events/296006705\">WordPress Insights</a>: WCUS Recap and WCEU Vision with Ruth Kalinka</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-15971\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it. And get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>(Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:29] <strong>Josepha:</strong> In our last episode, we talked about the Community Summit and some trends that I was seeing. I&#8217;ve spent a lot of time since then summarizing the notes from each session, and I was processing notes from the session about aligning WordPress Enterprise and WordPress Community, which is a session that explored the various strengths and weaknesses of WordPress from an enterprise perspective, but especially when it comes to contributing to or communicating about WordPress.</p>\n\n\n\n<p>Now, my vantage point on analyses like these is generally pretty different. Since I work mainly in an operations space for the project, I&#8217;m almost always looking at the health and safety of our ecosystem, product excellence, funding, things like that. So, I especially like to attend sessions that are from the vantage point of people who are much closer to the work than I am.</p>\n\n\n\n<p>[00:01:15] <strong>Josepha:</strong> When I looked at the brainstormed list of things from the session, my first inclination was to catalog the relationships between what we saw as a positive or a negative and the things that we saw as intrinsic to us versus part of the environment. But the more I look at it, the more I see that there&#8217;s confirmation of what I have always known to be true. That WordPress is a valuable starting point for web-based solutions of all sizes and any purpose. Let&#8217;s take a look at some of the biggest themes that shine through from that session. I was able to distill them down to about nine primary themes, but I especially want to focus on some that come up year after year in talking with our community.</p>\n\n\n\n<p>[00:01:57] <strong>Josepha:</strong> The first, of course, is the community and ecosystem. If you&#8217;ve listened to this podcast 62 times, then you&#8217;ve heard me say at least like 60 times that the community is what sets us apart from other open source projects. But, I would encourage you to expand that understanding to include the ecosystem that the community provides.</p>\n\n\n\n<p>The community not only helps to plan and create WordPress, our primary software, but it also makes it distributable through the Polyglots team and Accessibility and Docs and Training. It also makes it extendable through plugins and themes and all of the work that goes into reviewing plugins and themes and the support that&#8217;s provided to people who come to the WordPress.org site, trying to figure out how to make this thing work for them.</p>\n\n\n\n<p>And we also, this community, make it knowable, not only through the community part with our event series but also in marketing and the videos that we provide on WordPress TV and all of the training and learning cohorts that we provide on learn.WordPress.org, all of those teams make WordPress learnable and knowable and easy to use and usable to more people and available across the world, regardless of whether you speak English or not. And so yeah, the community and the ecosystem are some of the things that makes WordPress valuable for enterprise, but also WordPress valuable in general.&nbsp;</p>\n\n\n\n<p>[00:03:24] <strong>Josepha:</strong> The second is the software&#8217;s usability and flexibility. I said at WordCamp US that we exist for as long as people want to use our software, and that&#8217;s a funny little two-sided coin for us. WordPress remains very usable for folks who come to it in the same way that I came to it, which is as a user who is trying to accomplish a goal unrelated to WordPress. I didn&#8217;t start using WordPress because I wanted to figure out how WordPress worked or because I wanted to figure out how to contribute to WordPress. I came to WordPress because I was trying to market something, and WordPress was the best choice for that. But it&#8217;s also flexible for our brilliant developers out there who are doing things like building a suite of sites for NASA or creating bespoke social networks. So, our usability and flexibility, both of those things working together, are certainly one of the things that make me know that WordPress is incredibly valuable for anyone who needs to use it.</p>\n\n\n\n<p>[00:04:22] <strong>Josepha:</strong> But the final thing is WordPress&#8217;s longevity or our resilience. So, I used to work at a marketing agency that served enterprise-level clients. And any time we pitched a new site build to a client, one of the main elements of discussion during decision-making was how long the decision would last. Do you want a page that you can launch in a day, run a six-week campaign through, and then abandon it forever? Or do you want a site that can take up to six weeks to build but can be yours to refine and hone for years after that? I know this seems like a silly example, but when you&#8217;re looking at the potential for a long-term bet, what you&#8217;re worried about, what you&#8217;re asking is, is this a software trusted in my industry? Is it time-tested by those companies I aspire to be? Is the available workforce composed of seasoned professionals or flash-in-the-pan peddlers of the latest craze? And of that workforce, how many will still be doing this in five years? </p>\n\n\n\n<p>The question of how long we&#8217;ve been doing this and why it matters that WordPress has been here for 20 years and has no intention of going anywhere should be so much higher on everyone&#8217;s list of reasons to use this software. Yes, the WordPress software is powerful enough to be everything you might want it to be someday, but the WordPress ecosystem brought to us by this community has shown resilience through major breaking changes in 2008, 2016, 2018, 2020, and probably a lot of things between there that we have forgotten. So, if I were hoping to hedge my bets on a long-term solution, I would absolutely place those bets on this community, this ecosystem, and this software.&nbsp;</p>\n\n\n\n<p>(Music interlude)&nbsp;</p>\n\n\n\n<p>[00:06:17] <strong>Josepha:</strong> And now, it&#8217;s time for our small list of big things. I actually have a very big list today, so I&#8217;m just gonna break it out into two chunks. The first chunk is that we actually have a lot of calls for feedback and testing right now. We have six calls for feedback and testing that I really could use your input on.</p>\n\n\n\n<p>The first one is that we still are having that discussion about how to evolve the FSE outreach program. That program started as a way to get faster, more fluid user feedback, specifically about full site editing inside Gutenberg. But there is a question now about where it needs to exist, how it&#8217;s serving current project needs, and what the future project needs will be. And so stop by that one. That should be a good, lively discussion.&nbsp;</p>\n\n\n\n<p>[00:07:06] <strong>Josepha:</strong> Speaking of discussions that are lively, we also have an update to the field guide. We have a proposed update to the field guide. This is not something that we&#8217;re looking to put in place for WordPress 6.4, just because that is coming so quickly. But it is something that we want to look at for future iterations of the field guide that come out with every major release. We want to make sure that we&#8217;re getting valuable information to the right people at the right time without having so much that it&#8217;s overwhelming but also without having so little that we miss really important things.&nbsp;</p>\n\n\n\n<p>[00:07:47] <strong>Josepha:</strong> There is another request for feedback, which is about additional ideas on the future of WordPress events. I brought this up in the past. I think I mentioned it on one other small list of big things, but there&#8217;s still time. So, if you&#8217;ve been shy about sharing your ideas, let this be your sign to get brave. Go share your thoughts on what events of the future should be for us.&nbsp;</p>\n\n\n\n<p>[00:08:03] <strong>Josepha:</strong> There&#8217;s also a proposal for updated support guidelines. This proposal comes out of a discussion that was had at WordCamp US, and so there is a summary of the discussion and then also the proposal that&#8217;s out there. I think that for all guidelines like this, support guidelines, and probably all things that require some review from ourselves, we always could stand to take a look at where those are, what brought us to where we are today, and what we can use to be better and more current in our client&#8217;s needs and our customers needs users needs as we are looking through those guidelines I think that the deadline for feedback on that is around the middle of September as well.&nbsp;</p>\n\n\n\n<p>[00:08:47] <strong>Josepha:</strong> And then the final bit of feedback/call for testing is on performant translations. That is a testing call for feedback. Contributions to that can be made on GitHub as well if that&#8217;s something where you test it and you immediately know how to offer some patches to make things better. That&#8217;s great, but you can always just leave your feedback in a comment or a new support topic.&nbsp;</p>\n\n\n\n<p>[00:09:19] <strong>Josepha:</strong> Okay, so that was the first chunk of the small list of big things. We have the second chunk of the small list of big things, which is to say that if all of that was new to you and sounds a little bit daunting and, you need some support to get started. There are also a couple of kind of group things that you can do in the coming weeks to get you started on that.&nbsp;</p>\n\n\n\n<p>There is a new WordPress diversity training session that&#8217;s happening. It&#8217;s a two-day workshop for women, specifically in India, but other countries are welcome to join us, too. We&#8217;ll be thinking about how to pull together your first presentation proposal, I believe.</p>\n\n\n\n<p>The next one is that the WordPress community team is looking for folks to learn more about organizing meetups. And so, I&#8217;ll include a link to that in the show notes as well, but if you&#8217;ve never done this before and that did not sound like a getting started thing, trust me, organizing meetups not only is something that is easy to do because it&#8217;s kind of casual, you can get people together like in a coffee shop to talk about WordPress, but also the team over there has excellent onboarding. And so give it a try; at the very least, give it a read.&nbsp;</p>\n\n\n\n<p>The third thing on that set of things is that there&#8217;s a new group called WP Includes working to pair women in the WordPress community with one another for support and advice along their career paths. I will include a link to that in the show notes as well.</p>\n\n\n\n<p>And then the final thing is that there is a meetup event that&#8217;s focused on flagship events coming up on September 21st. It will recap WordCamp US and host an open discussion for ideas for WordCamp Europe as well. Like I said, that&#8217;s going to take place on September 21st. I will include a link to that in the show notes as well.</p>\n\n\n\n<p>[00:11:04] <strong>Josepha:</strong> If you don&#8217;t know where the show notes are, if you, sorry, if you&#8217;re listening to this on, like, Pocketcasts or Spotify or any other thingy, and you don&#8217;t know what I mean when I say the show notes, and you&#8217;ve literally never seen them in your life. You can go to WordPress.org/news/podcast, and there are transcripts and show notes with every podcast I put up, and that&#8217;s what I mean when I say that. WordPress.org/news/podcast, and then you get a bunch of links. It&#8217;ll be great.&nbsp;</p>\n\n\n\n<p>That, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.<br></p>\n\n\n\n<p>(Outro music)</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15971\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Openverse Wins the 2023 OEG Open Infrastructure Award\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wordpress.org/news/2023/09/openverse-wins-the-2023-oeg-open-infrastructure-award/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Sep 2023 18:04:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Awards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"award\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15967\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:403:\"WordPress is excited to announce that Openverse has been awarded the 2023 Open Education Award for Excellence in the Open Infrastructure category! The Open Education Awards for Excellence, organized by the non-profit organization Open Education Global (OEG), celebrate people, resources, and initiatives that have significantly contributed to the open education field and community. This year, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Madison Swain-Bowden\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3017:\"\n<figure class=\"wp-block-image size-full\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1800\" height=\"1013\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?resize=1800%2C1013&#038;ssl=1\" alt=\"\" class=\"wp-image-15959\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?w=1800&amp;ssl=1 1800w, https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/09/openverse-image.png?resize=1536%2C864&amp;ssl=1 1536w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>WordPress is excited to announce that <a href=\"https://openverse.org/\">Openverse</a> has been awarded the <a href=\"https://awards.oeglobal.org/awards/2023/open-infrastructure/openverse/\"><strong>2023 Open Education Award for Excellence</strong></a> in the <strong>Open Infrastructure</strong> category!</p>\n\n\n\n<p>The Open Education Awards for Excellence, organized by the non-profit organization <a href=\"https://www.oeglobal.org/\">Open Education Global (OEG)</a>, celebrate people, resources, and initiatives that have significantly contributed to the open education field and community. This year, they received 172 nominations across 16 award categories, representing individuals and projects from 38 countries.</p>\n\n\n\n<p>This award honors Openverse&#8217;s work to make it easy for everyone to discover and use open educational resources. The award reviewers were particularly impressed by <strong>Openverse&#8217;s <a href=\"https://twitter.com/WordPress/status/1514349743144685577\">one-click attribution feature</a></strong>. Moreover, they highlighted the tool’s ability to filter searches by source collections and other parameters, such as image orientation and specific license, which they noted “provides seekers of open content important affordances to find clearly licensed media they can reuse.”&nbsp;</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><em>“This is an exceptional search engine for the open education community. The one click attribution copy for images makes attribution very straight-forward and easy, even for novice users. The design is excellent; the results are returned fast.”</em> </p>\n<cite>Award reviewer for the 2023 OEG Award for Open Infrastructure </cite></blockquote>\n\n\n\n<p>This recognition not only underscores Openverse and WordPress&#8217;s commitment to open content but also celebrates the work of their dedicated contributors, community, and partners in advancing open education and creative works.</p>\n\n\n\n<p><a href=\"https://awards.oeglobal.org/awards/2023/open-infrastructure/openverse/\">Learn more about this Openverse award on the OEG page</a>.</p>\n\n\n\n<p><strong>Congratulations, Openverse!</strong></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15967\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress – August 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2023/09/the-month-in-wordpress-august-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Sep 2023 10:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15933\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:410:\"August 2023 marked another exciting chapter in WordPress, with the Community Summit and WordCamp US bringing the community together for meaningful discussions, knowledge sharing, and learning. This month also welcomed the long-awaited WordPress 6.3 release and offered a glimpse of what&#8217;s to come. Let&#8217;s dive into it. Meet WordPress 6.3 “Lionel” WordPress 6.3 &#8220;Lionel&#8221; was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13875:\"\n<p>August 2023 marked another exciting chapter in WordPress, with the Community Summit and WordCamp US bringing the community together for meaningful discussions, knowledge sharing, and learning. This month also welcomed the long-awaited WordPress 6.3 release and offered a glimpse of what&#8217;s to come. Let&#8217;s dive into it.</p>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Meet WordPress 6.3 “Lionel”</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/08/lionel/\"><strong>WordPress 6.3 &#8220;Lionel&#8221;</strong></a> was released on August 8, 2023, and named after the acclaimed vibraphonist, pianist, and jazz percussionist Lionel Hampton.</p>\n\n\n\n<p><strong>This major update makes bringing your vision to life with blocks more intuitive and efficient.</strong> Your content, templates, and patterns are now seamlessly integrated into the Site Editor, enabling you to craft every aspect of your online presence within a single location. You can sharpen your designs with new tools, enjoy fine-tuned control over navigation menus, and work faster with the Command Palette. <a href=\"https://wordpress.org/download/releases/6-3/\">Explore what&#8217;s new</a>.</p>\n\n\n\n<p>WordPress 6.3 features over 500 features and enhancements with a continued emphasis on <a href=\"https://make.wordpress.org/core/2023/08/07/wordpress-6-3-performance-improvements/\">performance</a> and accessibility. This release was made possible by more than 650 contributors from 52 countries.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/6JhJcOLySLY?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>While the Site Editor will continue to be enhanced, this release means a significant milestone as <strong>it marks the conclusion of Gutenberg Phase 2</strong>. Take a moment to watch “<a href=\"https://www.youtube.com/watch?v=FcTLMTyD2DU\">Designed with WordPress</a>”—an ode to this remarkable journey worth celebrating.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 6.3.1</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Roadmap to 6.4</h2>\n\n\n\n<p>Contributors are already working on WordPress 6.4, expected to be released on<strong> November 7, 2023</strong>. This release, led by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a>, will focus on enhancing different aspects of the WordPress experience while continuing the foundational work for Gutenberg Phase 3. Users can anticipate features like font management and a new default theme, Twenty Twenty-Four.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\"><strong>Twenty Twenty-Four</strong></a> aims to be a versatile theme, featuring a range of templates and patterns specifically designed for three use cases: entrepreneurs and small businesses, photographers and artists, and writers and bloggers.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/core/2023/08/22/roadmap-to-6-4/\">Check out the 6.4 roadmap post</a> for a tentative preview of expected features.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">New in the Gutenberg plugin</h2>\n\n\n\n<p>Two new versions of Gutenberg shipped in the last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\"><strong>Gutenberg 16.4</strong></a> was released on August 9, 2023. It introduced a new “auto-inserting blocks” experimental feature, a progress bar component that can be used throughout the interface, and block supports for the Footnotes block.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\"><strong>Gutenberg 16.5</strong></a><strong> </strong>shipped on August 23, 2023, and focused on enhancements to the Command Palette and enabling further customization of blocks.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/core/2023/02/01/core-editor-improvement-strengthening-style-options/\"></a>Follow the “<a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s new in Gutenberg</a>” posts to stay on top of the latest enhancements.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Team updates: Next generation of WordPress events, WP Admin redesign, and more</h2>\n\n\n\n<ul>\n<li>The Community team has been busy ushering in the next generation of WordPress events. <a href=\"https://make.wordpress.org/community/2023/08/02/recap-inaugural-nextgen-pilot-events/\">Four pilot events were successfully held</a> in July and August, with another five planned before the end of the year.</li>\n\n\n\n<li>The <a href=\"https://make.wordpress.org/design/2023/08/10/admin-design-kickoff/\">Admin Design Kickoff post</a> elaborates on the concepts explored so far to revitalize the WordPress admin experience.</li>\n\n\n\n<li>In response to <a href=\"https://www.european-cyber-resilience-act.com/\">Europe&#8217;s Cyber Resilience Act</a> (CRA), leaders from Drupal, Joomla!, TYPO3, and WordPress <a href=\"https://wordpress.org/news/2023/08/concerns-over-the-european-unions-cyber-resilience-act-cra/\">co-authored an open letter</a> addressing concerns about the current CRA definitions and terms and the implications for open source projects.</li>\n\n\n\n<li><a href=\"https://wordpress.org/blocks/\">Check out WordPress.org/blocks</a>—A <a href=\"https://make.wordpress.org/meta/2023/08/11/introducing-wordpress-org-blocks/\" data-type=\"link\" data-id=\"https://make.wordpress.org/meta/2023/08/11/introducing-wordpress-org-blocks/\">new page</a> that explores the power of blocks within WordPress and as a broader framework.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/08/21/wordpresscs-3-0-0-is-now-available/\">WordPressCS 3.0.0 is now available</a>. This update to the WordPress Coding Standards introduces improvements in accuracy, performance, stability, and compatibility with modern PHP versions.</li>\n\n\n\n<li>The first cohort of the WordPress Contributor Mentorship Program, which aims to help new contributors onboard to Make teams, <a href=\"https://make.wordpress.org/project/2023/08/11/the-inaugural-cohort-of-the-wordpress-contributor-mentorship-program-has-concluded/\">successfully concluded</a> last month.</li>\n\n\n\n<li><a href=\"https://wordpress.org/remembers/\">WordPress Remembers</a> went live in August to honor contributors who left a lasting impact on the project and have since passed away.</li>\n\n\n\n<li>Core team members proposed to <a href=\"https://make.wordpress.org/core/2023/08/01/proposal-improve-the-editor-tech-workflow-for-major-releases/\">sync Gutenberg code with core earlier in the release cycle</a> to streamline the integration of new features and reduce risks and delays in major release milestones.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2023/08/11/blue-note-the-second-community-theme-is-released/\">Blue Note</a>, the second block theme born from the Community Themes initiative, is live on the Theme Directory.</li>\n\n\n\n<li>Every month, the Training team works to expand the <a href=\"https://learn.wordpress.org/\">Learn WordPress</a> catalog with new courses, tutorials, online workshops, and more. <a href=\"https://make.wordpress.org/updates/2023/09/02/whats-new-on-learn-wordpress-in-august-2023/\">See what’s new</a>.</li>\n\n\n\n<li>Openverse maintainers met in Copenhagen for an exciting exchange with Statens Museum for Kunst (SMK), Denmark’s largest art museum. <a href=\"https://make.wordpress.org/openverse/2023/08/17/cultivating-collaborative-pathways-with-statens-museum-for-kunst-smk/\">Learn about their discussions and collaboration efforts</a> to advance openly licensed works.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Keen to see new WordPress event formats happening in your local community? <a href=\"https://make.wordpress.org/community/2023/08/30/the-nextgen-event-project-your-ideas-your-wordpress-community/\">Get inspired by these creative concepts</a> and <a href=\"https://wordpressdotorg.survey.fm/next-generation-of-wordpress-events\">share your ideas</a>!</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>Core team members <a href=\"https://make.wordpress.org/core/2023/08/31/proposal-an-update-to-the-field-guide/\">suggested updating the WordPress Field Guide</a> by publishing it earlier in the development cycle and introducing a simplified Field Guide on the WordPress Developer Blog. Feedback is open until September 15, 2023.</li>\n\n\n\n<li>Help test the <a href=\"https://make.wordpress.org/core/2023/09/05/call-for-testing-performant-translations/\">new Performant Translations plugin</a>, which aims to make localized WordPress sites faster.</li>\n\n\n\n<li>A new proposal aims to <a href=\"https://make.wordpress.org/support/2023/08/proposal-for-updated-support-guidelines/\">refine and update WordPress’ support guidelines</a>. You can provide your input by October 1, 2023.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/06/mobile-team-update-september-6th-2/\">Version 23.2</a> of the WordPress mobile app for iOS and Android is ready for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>The Training team seeks feedback on the first learning pathways outlined to improve the Learn WordPress educational experience. <a href=\"https://make.wordpress.org/training/2023/08/24/looking-for-feedback-learning-pathway-outlines/\">Share your thoughts by September 15, 2023</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress events updates</h2>\n\n\n\n<ul>\n<li>On August 22-23, a group of WordPress contributors gathered at the <a href=\"https://communitysummit.wordcamp.org/2023/\"><strong>Community Summit</strong></a> to discuss key topics concerning the project. Read the notes from each session and join the conversations at <a href=\"https://make.wordpress.org/summit/\">make.wordpress.org/summit</a>.</li>\n\n\n\n<li>Following the Summit, Washington, D.C. hosted <a href=\"https://us.wordcamp.org/2023/\"><strong>WordCamp US 2023</strong></a> from August 24-26. This event brought together nearly 2,000 attendees for a Contributor Day and two conference days filled with engaging <a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7EQWcZBkBtb9YQlziKJ7nvpv\">sessions</a>, conversations, and <a href=\"https://twitter.com/WordPress/status/1695145857232904260\">open source art</a>. Saturday’s agenda concluded with keynotes by WordPress co-founder Matt Mullenweg and Executive Director Josepha Haden Chomphosy and a subsequent Q&amp;A session. <a href=\"https://wordpress.org/news/2023/08/the-future-of-wordpress-whats-next-for-gutenberg/\">Check out the event recap for highlights</a>.</li>\n\n\n\n<li>Join #WPDiversity with a free online <a href=\"https://www.eventbrite.com/e/speaker-workshop-for-indian-women-in-the-wordpress-community-sept-23-24-tickets-633636773647\">speaker workshop for Indian women in the WordPress Community</a>. The event will take place on September 23-24, 2023.</li>\n\n\n\n<li>The WordCamp Asia 2024 organizing team opened calls for <a href=\"https://asia.wordcamp.org/2024/call-for-speakers-is-now-open/\">speakers</a>, <a href=\"https://asia.wordcamp.org/2024/volunteer-registrations-are-open/\">volunteers</a>, <a href=\"https://asia.wordcamp.org/2024/call-for-sponsors/\">sponsors</a>, and <a href=\"https://asia.wordcamp.org/2024/call-for-media-partners-is-now-open/\">media partners</a>.</li>\n\n\n\n<li>Be sure to visit <a href=\"https://central.wordcamp.org/schedule/\">WordCamp Central</a> to find out about upcoming WordCamps.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Join Josepha Haden Chomphosy in <a href=\"https://wordpress.org/news/2023/09/episode-61-community-summit-all-at-washington-d-c/\">Episode 61 of WP Briefing</a> as she discusses her takeaways from the Community Summit.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-text-color has-light-grey-color has-alpha-channel-opacity has-light-grey-background-color has-background\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em>The following folks contributed to this Month in WordPress: <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15933\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WP Briefing: Episode 61: Community, Summit, all at  Washington D.C.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wordpress.org/news/2023/09/episode-61-community-summit-all-at-washington-d-c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 04 Sep 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=15911\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:168:\"Join WordPress Executive Director Josepha Haden Chomphosy as she discusses the latest from the Community Summit and her takeaways from the 2023 event in Washington, DC.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2023/09/WP-Briefing-061-1.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:17586:\"\n<p>Join WordPress Executive Director Josepha Haden Chomphosy as she discusses the latest from the Community Summit and her takeaways from the 2023 event in Washington, D.C.</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br>Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo: <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production: <a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br>Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>The 2023 <a href=\"https://communitysummit.wordcamp.org/2023/\">Community Summit</a> in Washington, DC</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/02/episode-49-everything-you-need-to-know-about-the-community-summit/\">WP Briefing Episode 49</a>: Everything You Need to Know About the Community Summit!</li>\n\n\n\n<li><a href=\"https://href.li/?https://make.wordpress.org/community/2023/05/08/the-next-generation-of-wordcamps/\">The Next Generation of WordCamps</a></li>\n\n\n\n<li><a href=\"https://href.li/?https://make.wordpress.org/community/2023/05/24/idea-generation-next-gen-wordcamps/\">Idea generation: Next Gen WordCamps!</a></li>\n\n\n\n<li><a href=\"https://pressnomics.com/\">PressNomics</a></li>\n\n\n\n<li><a href=\"https://loopconf.io/\">LoopConf</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/summit/\">WordPress Community Summit</a></li>\n\n\n\n<li><strong>A small list of big things</strong>\n<ul>\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/community/2023/08/23/call-for-ideas-new-features-for-our-nexgen-wp-events-central-page/\" target=\"_blank\">Call for ideas: new features for our NexGen WP events central page</a>&nbsp;&#8211; Open call for ideas to find the most desirable features for a future homepage that would host a list of all NextGen WordPress events. </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Introducing Twenty Twenty-Four</a>&nbsp;&#8211; Announced at Contributor Day, this new theme will be part of the 6.4 release. </li>\n\n\n\n<li>With the release of 6.3 behind us,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/6-4/\" target=\"_blank\">we are working hard on bringing 6.4</a>&nbsp;to the community. You can get involved with the development of this important release. </li>\n\n\n\n<li>A successful WCUS is behind us, and if you missed the event, we have you covered. <a href=\"https://wordpress.org/news/2023/08/the-future-of-wordpress-whats-next-for-gutenberg/\">Here is a recap of the event</a>.</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-15911\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong>&nbsp;Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong>&nbsp;We are back and catching up from our midyear break. And in true WordPress fashion, we&#8217;re just going to start off running. The WordPress Community Summit happened a couple of weeks ago. I&#8217;ve been talking about it on this podcast for a few months now, but if you&#8217;ve missed it and you want a refresher, go ahead and give episode 49 a listen.</p>\n\n\n\n<p>At the Community Summit, there were 125 people, if I remember correctly. And we covered a wide array of topics that were brought to us directly from the community itself. While the event is small, it is specifically designed for gathering and sharing information. So, I&#8217;ve got some top-level trends that I noticed that I&#8217;m going to share with you all today, as well as just like a reminder of what happens after a Community Summit.</p>\n\n\n\n<p>[00:01:27] <strong>Josepha:</strong>&nbsp;So there are three, maybe four, big trends that I noticed. The first one that I noticed is that we have a lot of discussions right now about contributor acknowledgment. That also, for what it&#8217;s worth, came with an unresolved question around whether acknowledgment and recognition are the same. I don&#8217;t think they are the same.</p>\n\n\n\n<p>But it also was part of a conversation around whether we treat those two things the same. And if they are not the same, should we treat them differently? And et cetera, et cetera, et cetera. For folks who&#8217;ve been around for a bit, you know, that we spent a lot of time working on our contributor recognition a few years back and had really made quite a bit of difference in just reported feelings about how the community felt they were being recognized for their contributions.</p>\n\n\n\n<p>And so a lot of the conversations that we ended up having were around whether or not the project as a whole has changed the way that we provide that recognition or acknowledgment. Or, as an alternative, if the community that is supporting WordPress has changed how they would like to be recognized.</p>\n\n\n\n<p>[00:02:32] <strong>Josepha:</strong>&nbsp;There were also some questions about whether or not making sure that contributors can see their impact. Like they can say, I contributed 10 hours last month, and these are the two things that I got accomplished over there, and that everyone else can see those things too. So, how we can do that more easily while also not having so many metrics and making the metrics so prevalent that we start to close out the people who are truly just doing this for fun.</p>\n\n\n\n<p>Like many of the problems that we have at the Community Summit, this is a bunch of pretty much unsolved mysteries at the moment. But it did; it came up across probably five or six different sessions that I heard about, quite a few that I went to myself, and so contributor acknowledgment and recognition is on our minds again.</p>\n\n\n\n<p>A second thing that I noticed across multiple sessions, and this one honestly is not a surprise at all, is that there were a lot of questions about what the next big thing is after Gutenberg. I always love when people are asking big questions about what comes next because it means that we all still believe that there will be a next.</p>\n\n\n\n<p>[00:03:43] <strong>Josepha:</strong>&nbsp;And so I never hesitate when I hear these questions to give some ideas about what I think might be coming. But a lot of the discussions that we were having were around, we think this is coming, but now that we think this is coming, what should we do now to make sure that we are ready for it? One of the biggest assumptions that we all had is that for the CMS, for the software itself, probably our next big area after Gutenberg is going to be something about artificial intelligence.</p>\n\n\n\n<p>Matt pointed out in his presentation that he has told us twice to learn something deeply. One was in 2016 when he said, learn JavaScript Deeply. And then one was in 2022 when he said to learn AI deeply. And so we all kind of are guessing that that is our future area. And so that&#8217;s an area for everyone to spend some time in. Make sure you understand it. Make sure you know it a bit.&nbsp;</p>\n\n\n\n<p>The second thing that came up as like a future, where are we going here? It was kind of on the business-y side. It was on a lot of questions about enterprise and are we selling properly to enterprise. Can we sell, can we appeal to enterprise? Whose job is it to sell any of these things? Questions like that. So, lots of business questions again. This is not something that I have any concerns about. I&#8217;m very excited to see that people are talking about it. That&#8217;s been a topic of conversation since, I want to say, February of this year. And so it also wasn&#8217;t a surprise inclusion today. And, and I was excited to see, am excited to see what we get out of those conversations over time.&nbsp;</p>\n\n\n\n<p>[00:05:17] <strong>Josepha:</strong>&nbsp;As far as like questions around what&#8217;s next for the community, I&#8217;m going to address that separately because it was a huge question for everyone. So I&#8217;m going to discuss that as soon as we get finished with this chunk about like the big thing that, that is coming after Gutenberg.</p>\n\n\n\n<p>But, from an ecosystem perspective. Like a WordPress project operations perspective, this came up a couple of times. Never in as clear a word, a set of words as that, but the question about, like, what are we doing with our tools? Are we making sure that we are keeping the tools that our contributors use maintained and still in an excellent space with features that are useful and, necessary, and requested?</p>\n\n\n\n<p>And so that is a big question. I do have a lot of questions about that. Also, there are so many tools that I have wanted in order to make organizing the WordPress community better and easier, but also making contributing better and easier. And hopefully, here soon, we have an opportunity to get to some of those.</p>\n\n\n\n<p>[00:06:16] <strong>Josepha:</strong>&nbsp;So, the third big trend that I kept seeing at the Community Summit is actually about the community itself, specifically about events. So I was part of or listened to many, many, many conversations over the course of the week that were specifically focused on what we&#8217;re going to do with the future of our events. Like are meetups still sustainable? Are WordCamps still sustainable? And that&#8217;s from not only the idea of sustainability that we all tend to know from like an ecological standpoint but also, you know, checking in on the resources. So the kinds of questions that folks had were, is it time to continue having many small events, or is it time to move to a few giant events?</p>\n\n\n\n<p>Should we bring back midsized, WP-adjacent events like PressNomics or LoopConf? And if we are bringing those back, do we want to have them be part of a semi-official thing along with a clearly WordPress event and like do joint sales in there? Try to figure out how to get people from one to the other, so that it&#8217;s not just WordPress people that we&#8217;re talking to, but also business people and advanced developers, things like that.</p>\n\n\n\n<p>There was also a lot of discussion about whether or not we have gotten too big, should we double down on our grassroots efforts? Just go all the way back to, like, BarCamp style, WordPress in a forest kind of thing.&nbsp;</p>\n\n\n\n<p>[00:07:46] <strong>Josepha:</strong>&nbsp;And yeah, and among all of these conversations, there were questions about the resources that we need. Do we have what we need now? Do we have plans for how to maintain those resources in the future? Do we have enough time? Do we have enough money? Do we have an expertise? The people? So many questions, so many questions. And on the community side of things, we also had a lot of questions that are routine in open source. Like, do we have a pipeline for future maintainers, for future team reps, for future leaders in the project? All of the questions.&nbsp;</p>\n\n\n\n<p>So, those are the three slash four, depending on how you break it out, really big trends that I saw across the conversation at the Community Summit. And I don&#8217;t necessarily know the answers to all of these things. Like, I know what my gut tells me, I know what I believe the answer to be. From my own perspective, but as you&#8217;ve been told many times with many eyes, all bugs are shallow. And so here is what happens next with a Community Summit. So we&#8217;ve gathered all of these things together. We&#8217;ve had these conversations, and now all of the notes from every conversation that we had will be put on make.wordpress.org/summit.&nbsp;</p>\n\n\n\n<p>[00:09:10] <strong>Josepha:</strong>&nbsp;There, you can do any of the following three things, but at least do one before we get any further. I think it&#8217;s important to remind everyone that no decisions were made at the Community Summit. There are a few things that will come out of the Community Summit where the answer the way forward is really obvious. And so those probably will get done quickly thereafter because it&#8217;s just an obvious thing to do. It makes sense for everyone in the project. It makes sense for everyone who&#8217;s using WordPress. Whatever reason.&nbsp;</p>\n\n\n\n<p>So those things will probably move quickly, but mostly not even mostly there were no decisions made. And so if it looks like something is moving quickly there, it is because it makes sense after the fact. So there&#8217;s that. But the three things that you can do in order to take part in this information gathering and sharing that happened at the Community Summit.&nbsp;</p>\n\n\n\n<p>Number one, head over to make.wordpress.org/summit and just read the notes. There are a lot of them you can pick and choose based on the teams you contribute to or the topics that are specifically interesting. Or if you have been assigned to read one of these things, obviously, go ahead and read that. But find the notes read them. Take a look at the discussion as far as you can tell it happened and get a sense for what the essential question is.</p>\n\n\n\n<p>The second thing that you can do while you&#8217;re there is that you can join in that discussion right there in the comments if you would like to. You can, if you feel like your perspective is not quite accounted for in that, obviously leave some comments and let folks know. But also, if you feel like your perspective was accounted for, but there&#8217;s also a very specific question that was not necessarily answered or not even brought up, share those as well. That&#8217;s stuff that we would like to know as we are working through this.&nbsp;</p>\n\n\n\n<p>And then the third thing that you can do is you can take those conversations, and if there&#8217;s anything that looks like it&#8217;s particularly relevant to your local WordPress community, absolutely take those there and have those conversations with them.</p>\n\n\n\n<p>[00:11:23] <strong>Josepha:</strong>&nbsp;And once you&#8217;ve had those conversations, let us know what you thought also in those comments, or take it directly into your weekly teams&#8217; chat, either way. We want to hear what you think about the questions that were brought because you brought them to us. And so you should have an opportunity to tell us what you think.</p>\n\n\n\n<p>[00:11:39] (Music Interlude)&nbsp;</p>\n\n\n\n<p>[00:11:48] <strong>Josepha:</strong>&nbsp;That brings us now to our small list of big things. My friends, there&#8217;s nothing but big things left for the rest of the year. And so here we go. Number one, uh, I mentioned it quite a bit. There&#8217;s a conversation, an ongoing conversation about the future of events for our community. Right now, there is an open call for ideas, new features for our NextGen WordPress events, especially on the page that exists on WordCamp Central.</p>\n\n\n\n<p>So, we want to find the most useful and desirable features for a future homepage on central.wordcamp.org that would host a list of all of our upcoming WordPress events. And so we want your opinion there. Please let us know what would be especially useful to you as you are looking for WordPress events to attend.</p>\n\n\n\n<p>The second thing is that we introduced 2024, the default theme that is coming with WordPress 6.4, was announced. We have had, I think, 32 contributors to it at the time of this recording. And yeah, it&#8217;s beautiful. It&#8217;s got a lot of different implementation options, a lot of default patterns, and curated patterns so that you can get exactly what you want out of that theme. I think it&#8217;s going to make a great default theme, a great starter theme for our final release of the year.&nbsp;</p>\n\n\n\n<p>And then, speaking of 6.4, with the release of 6.3 behind us, we are working hard on bringing 6.4 to the community. You can get involved with the development of that. There is a core chat every Wednesday. It happens. I want to say at 21:00 UTC, but I don&#8217;t actually know off the top of my head. I just go when my calendar tells me to go, and I live in the central time zone. And so, my UTC conversion is not the best, but we will leave the actual information about that in the show notes so that you can see it. But you can also go over to make.wordpress.org, and then there&#8217;s a little card on that homepage that tells you exactly when those core meetings are, including the new contributor meeting, which happens every two weeks.&nbsp;</p>\n\n\n\n<p>And then the fourth thing is that there is a successful WordCamp US behind us. That is our final flagship event of the year, which is always exciting. If you missed it, for one, we missed you. And for two, we have you covered. We&#8217;ve got a recap of the event. There is a link to that in the show notes as well.&nbsp;</p>\n\n\n\n<p>[00:14:05] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thanks for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\n\n\n<p>[00:14:15] (Music Outro)&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15911\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.3.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2023/08/wordpress-6-3-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Aug 2023 14:43:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"minor-releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15886\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.3.1 is available!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5097:\"\n<h2 class=\"wp-block-heading\">WordPress 6.3.1 is now available!</h2>\n\n\n\n<p>This minor release features&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.3.1&amp;group=status&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;col=keywords&amp;order=priority\">4 bug fixes in Core</a>&nbsp;and&nbsp;<a href=\"https://github.com/orgs/WordPress/projects/103/\">6 bug fixes for the block editor</a>. You can review a summary of the maintenance updates in this release by reading the&nbsp;<a href=\"https://make.wordpress.org/core/2023/08/23/wordpress-6-3-1-rc1-is-now-available/\">Release Candidate announcement</a>.</p>\n\n\n\n<p>WordPress 6.3.1 is a short-cycle release. The next major release will be&nbsp;<a href=\"https://make.wordpress.org/core/6-4/\">version 6.4</a>&nbsp;planned for November 2023.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can&nbsp;<a href=\"https://wordpress.org/wordpress-6.3.1.zip\">download WordPress 6.3.1 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”.</p>\n\n\n\n<p>For more information on this release, please&nbsp;<a href=\"https://wordpress.org/support/wordpress-version/version-6-3-1\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> and <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, with the help of <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>&nbsp;on mission control, and <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> who worked on Gutenberg backports.</p>\n\n\n\n<p>WordPress 6.3.1 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-medium\" style=\"font-size:18px\"><a href=\'https://profiles.wordpress.org/antonvlasenko/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>antonvlasenko</a>, <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/austinginder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>austinginder</a>, <a href=\'https://profiles.wordpress.org/azaozz/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>azaozz</a>, <a href=\'https://profiles.wordpress.org/dd32/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dd32</a>, <a href=\'https://profiles.wordpress.org/dlh/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>dlh</a>, <a href=\'https://profiles.wordpress.org/frankit/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>frankit</a>, <a href=\'https://profiles.wordpress.org/get_dave/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>get_dave</a>, <a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromTonya</a>, <a href=\'https://profiles.wordpress.org/khokansardar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>khokansardar</a>, <a href=\'https://profiles.wordpress.org/mathsgrinds/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mathsgrinds</a>, <a href=\'https://profiles.wordpress.org/mukesh27/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mukesh27</a>, <a href=\'https://profiles.wordpress.org/peterwilsoncc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>peterwilsoncc</a>, <a href=\'https://profiles.wordpress.org/presskopp/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>Presskopp</a>, <a href=\'https://profiles.wordpress.org/rajinsharwar/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rajinsharwar</a>, <a href=\'https://profiles.wordpress.org/ravanh/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>RavanH</a>, <a href=\'https://profiles.wordpress.org/sergeybiryukov/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sergeybiryukov</a>, and <a href=\'https://profiles.wordpress.org/tmatsuur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tmatsuur</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac,&nbsp;<a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the&nbsp;<a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C055Y7FKS7N\">#6-4-release-leads</a> channels. Need help? Check out the&nbsp;<a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thanks to&nbsp;<a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"15886\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 12 Oct 2023 12:48:40 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 10 Oct 2023 16:37:31 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20211220193300\";}","no");
INSERT INTO ceba_options VALUES("155","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1697158120","no");
INSERT INTO ceba_options VALUES("156","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1697114920","no");
INSERT INTO ceba_options VALUES("157","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1697158120","no");
INSERT INTO ceba_options VALUES("158","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordPress.com Enters the Fediverse with ActivityPub Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150137\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordpress-com-enters-the-fediverse-with-activitypub-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4623:\"<p>WordPress.com <a href=\"https://wordpress.com/blog/2023/10/11/activitypub/\">added support for ActivityPub</a> today, a decentralized social networking protocol that is now available for across free and paid plans. This allows users to join the fediverse from their WordPress.com sites, and interact with content across federated platforms like Mastodon (and many others) with replies automatically published back to the blog as comments.</p>\n\n\n\n<p>The <a href=\"https://wptavern.com/activitypub-1-0-0-released-introducing-blog-wide-accounts-and-new-blocks\">latest version</a> of the <a href=\"https://wordpress.org/plugins/activitypub/\">ActivityPub plugin</a> for WordPress allows blogs or sites to have their own ActivityPub profile. (Previously, profiles were limited to individual authors). Automattic acquired the plugin in March 2023, from German developer <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> who joined the company and has continued to improve it and add new features.</p>\n\n\n\n<p>Practically speaking, this new ActivityPub support allows fediverse users to follow participating WordPress.com blogs on their chosen service, and comment on the content with those comments synced back to the blog &#8211; all without leaving their federated platform.</p>\n\n\n\n<p>WordPress.com users can activate ActivityPub support under <em>Settings > Discussion</em>. They also have the option to use a custom domain for a shorter, more memorable identifier.</p>\n\n\n\n<p>Once activated, ActivityPub support is available on new posts only &#8211; it is not retroactive. There may also be a delay in short delay for newly published posts appearing on federated platforms.</p>\n\n\n\n<p>One WordPress.com user asked &#8220;When will WordPress Reader be able to follow Fediverse accounts?&#8221; This isn&#8217;t yet on the roadmap, based on the response from WordPress.com representatives, but may now be on their radar for future improvements to ActivityPub support.</p>\n\n\n\n<p>This plugin and its addition to WordPress.com marks a significant expansion for the availability of ActivityPub interoperability, as support can now be effortlessly added for WordPress.com sites in addition to self-hosted sites. </p>\n\n\n\n<p>In 2022, Automattic CEO Matt Mullenweg said Tumbler would add support for ActivityPub but this has not yet materialized and a current Tumblr employee said in July 2023, that they are <a href=\"https://indieweb.social/@_jv_@mastodon.social/110692572899315822\">still evaluating it</a> but that it may cost more than it&#8217;s worth to the company. It may have become a lower priority, as Tumblr doesn&#8217;t appear to be in a position to embrace new projects that don&#8217;t generate cash flow. </p>\n\n\n\n<p>Adoption of the ActivityPub protocol has been slow moving and has not yet delivered the avalanche of new users that Twitter/X has practically gift wrapped with its many unfavorable changes and, most recently, its laughable <a href=\"https://slate.com/technology/2023/10/elon-musk-x-twitter-news-links-headlines-why.html\">treatment of external links</a>, which is an affront to the open web. Blogging pioneer and podcaster Dave Winer, who has watched social networks come and go, is not banking on ActivityPub and believes &#8220;<a href=\"http://scripting.com/2023/10/10/114018.html\">the world will not coalesce behind ActivityPub</a>&#8221; in its search for a standard. </p>\n\n\n\n<p>For those who are already active on fediverse platforms that support ActivityPub, WordPress.com&#8217;s new features may be useful for ensuring that blogs can meaningfully participate there. It&#8217;s a quick and easy way to allow more people to follow WordPress sites and give their content further reach into the fediverse. </p>\n\n\n\n<p>The future adoption of the ActivityPub protocol across more apps and platforms remains to be proven. In July, when Threads announced it would support the protocol, Mastodon CEO Eugen Rochko said in a <a href=\"https://blog.joinmastodon.org/2023/07/what-to-know-about-threads/\">blog post</a>, &#8220;The fact that large platforms are adopting ActivityPub is not only validation of the movement towards decentralized social media but a path forward for people locked into these platforms to switch to better providers.&#8221; Although this wider network of ActivityPub support gives users more choice about the platforms they use to communicate, the evolution of the social media landscape is still volatile and unpredictable, leaving many people with the burden of hedging their bets by interacting across multiple networks while waiting for the dust to settle.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Oct 2023 04:07:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordPress Contributors Speed Up Twenty Twenty-Four Default Theme Performance by 40%\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150121\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wordpress-contributors-speed-up-twenty-twenty-four-default-theme-performance-by-40\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4348:\"<p>WordPress 6.4 will be shipping a new default theme, <a href=\"https://wptavern.com/wordpress-unveils-design-for-upcoming-twenty-twenty-four-default-theme\">Twenty Twenty-Four</a> (TT4), expected in early November. This theme is more feature-rich than previous default themes, and contributors have been working on <a href=\"https://core.trac.wordpress.org/ticket/59465\">identifying potential performance improvements</a> that can be made ahead of the release.</p>\n\n\n\n<p>As a starting point, Google-sponsored Performance team contributor Felix Arntz conducted several benchmarks comparing TT4 with the TT3 block theme. These included overall Web Vitals covering both server-side (TTFB) and client-side (LCP-TTFB), along with a separate server-side load time performance benchmark. Arntz posted a summary of this data:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<ul>\n<li>For the home page:\n<ul>\n<li>Overall load time (LCP) is 58.8% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Client-side performance (LCP-TTFB) is 93.5% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Server-Timing (<code>wp-total</code>) is 71.8% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n\n\n\n<li>For the singular post:\n<ul>\n<li>Overall load time (LCP) is 3.9% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Client-side performance (LCP-TTFB) is 40.1% faster. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f7e2.png\" alt=\"🟢\" class=\"wp-smiley\" /></li>\n\n\n\n<li>Server-Timing (<code>wp-total</code>) is 42.3% slower. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f534.png\" alt=\"🔴\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n</ul>\n</blockquote>\n\n\n\n<p>He noted that the reason TT4 is slower is because it provides a lot more feature rich content out of the box than TT3.</p>\n\n\n\n<p>&#8220;Interestingly, the server-side performance difference between TT4 and TT3 seems to come almost exclusively from the number of block editor features used by the theme, but not by any problems from the theme itself,&#8221; Arntz said. &#8220;In fact, the theme only includes a single function of PHP logic. It does however include more complex content than TT3 and comes with a large number of patterns, so potentially that plays a role there.&#8221;</p>\n\n\n\n<p>After just two weeks of work on specific tickets for a few flagged issues, performance contributors were able to make the new Twenty Twenty-Four theme (and other themes) load more than 40% faster.</p>\n\n\n\n<p>&#8220;I am very excited to report that most (if not all) of the server-side performance concerns have been addressed, via additional general performance fixes that landed in core,&#8221; Arntz said.</p>\n\n\n\n<p>He summarized the improvements in the server-timing benchmarks when comparing TT4 and TT3 with the latest core trunk:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<ul>\n<li>TT4 home page loads in 85.91ms, compared to 78.08ms in TT3.\n<ul>\n<li>→&nbsp;<strong>10.0% slower, but before was 71.8% slower</strong>&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n\n\n\n<li>TT4 &#8220;Hello world!&#8221; post loads in 96.44ms, compared to 86.35ms in TT3.\n<ul>\n<li>→&nbsp;<strong>11.7% slower, but before was 42.3% slower</strong>&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" /></li>\n</ul>\n</li>\n</ul>\n</blockquote>\n\n\n\n<p>There are a few outstanding client-side performance enhancements, but Arntz said these require more thought and time investment so they have been milestoned for the 6.5 release. </p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\">WordPress 6.4 Beta 3</a> was released yesterday. Although the flagship Font Library feature has been <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\">punted to 6.5</a>, contributors said this change will not affect Twenty Twenty-Four, as the theme will ship with preselected fonts that get loaded from the theme assets, just like previous default themes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 22:42:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: #94 – Birgit Olzem and Jill Binder on Creating a Diverse and Sustainable WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=150098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/podcast/94-birgit-olzem-and-jill-binder-on-creating-a-diverse-and-sustainable-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55141:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, diversity in the WordPress community.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Birgit Olzem and Jill Binder.</p>\n\n\n\n<p>Birgit Olzem is a WordPress enthusiast who juggles diverse roles, and advocates for mental health awareness, diversity and unsung contributors. A proud mother and grandmother, she also consults on personal branding and explore surface pattern design. Birgit champions the WordPress community, as you&#8217;ll hear, in many ways.</p>\n\n\n\n<p>Jill Binder is the founder and CEO of Diverse In Tech. She leads the diverse speaker training group in the wordpress.org community team, which encourages people from underrepresented groups to speak at WordPress events. She helped organize the first BuddyCamp, and for three years, co-organized WordCamp Vancouver.</p>\n\n\n\n<p>Jill and Birgit join me today to discuss the importance of diversity, equity, inclusion, and belonging, D E I B for short, within the WordPress community.</p>\n\n\n\n<p>They share valuable insights regarding their efforts to create a more global and inclusive WordPress ecosystem. This includes the formation of a new working group on the make WordPress Slack account, and the use of GitHub project boards to track tasks and ideas.</p>\n\n\n\n<p>We talk about the need for unity within the community, the significance of diverse perspectives, and the importance of effective communication.</p>\n\n\n\n<p>We also get into Jill&#8217;s experience, organizing a training program for the Vancouver meetup. Emphasizing the importance of understanding the specific needs of different communities.</p>\n\n\n\n<p>We explore the concept of sustainability within the WordPress community, addressing the financial support and resources necessary to retain and support active contributors.</p>\n\n\n\n<p>Throughout the episode, both Jill and Birgit stress the importance of inclusivity, creating a welcoming environment, and providing opportunities for underrepresented voices to participate and contribute.</p>\n\n\n\n<p>If you&#8217;ve been wanting to know more about how to make the WordPress community more diverse and welcoming, this episode is for you.</p>\n\n\n\n<p>In some places, the audio is a little choppy, so apologies for that, but it really is more than listable.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Birgit Olzem and Jill Binder.</p>\n\n\n\n<p>I am joined on the podcast today by Birgit Olzem and Jill Binder. Hello.</p>\n\n\n\n<p>[00:04:11] <strong>Jill Binder:</strong> Hi there.</p>\n\n\n\n<p>[00:04:12] <strong>Birgit Olzem:</strong> Hello.</p>\n\n\n\n<p>[00:04:13] <strong>Nathan Wrigley:</strong> It is absolutely lovely to have you both on the show today. We&#8217;re going to get into an interesting topic. It really isn&#8217;t something that we&#8217;ve touched for a very long time. A new initiative, perhaps not a new initiative, new initiative for an old problem shall we say. And we&#8217;re going to talk about that.</p>\n\n\n\n<p>But before we begin the podcast and talk about the subject at hand, I think it would be important to give you both an opportunity to introduce yourself. Obviously we&#8217;re talking about a WordPress community issue today.</p>\n\n\n\n<p>Be nice to know a little bit about your involvement in the WordPress community. Perhaps a little bit about your backstory, which companies you work for? Anything really. And let&#8217;s start with Birgit, shall we?</p>\n\n\n\n<p>[00:04:53] <strong>Birgit Olzem:</strong> Yeah thank you Nathan. Thank you very much for giving us the room to talk about this amazing topic.</p>\n\n\n\n<p>So I&#8217;m from Germany and as a listener here I struggle a bit. But I&#8217;m a mom of five children, well almost grown up children. And I used WordPress since its first release. I was always curious how things work. I&#8217;m always curious looking behind the scenes, and I want to know how things are building up. I&#8217;ve contributed to WordPress for over a decade now. I was at my first WordCamp in 2010 and since then I&#8217;m totally invested into the WordPress community.</p>\n\n\n\n<p>And as my friend Carole Olinger always cites, &#8221; we came for the software and stayed for the people&#8221;. And I am a people person, and I love to connect people with each other. And I try to help people to find their way and their path on a big journey. And so that&#8217;s why I&#8217;m so invested into the WordPress community because we are building a great software environment, not just software at all, but also the people around it.</p>\n\n\n\n<p>I&#8217;m currently a freelancer, and not sponsored to contribute to WordPress yet, but I&#8217;d like to. I&#8217;m currently part of the new contributor mentorship program, with the cohort in July as a mentor. And I had a great mentee from Austria so we tried also the localised mentorship program.</p>\n\n\n\n<p>We are also currently organising WordCamp Germany at the time of this recording. We&#8217;re in the middle of August. WordCamp Germany will happen in October this year in my hometown, in a small hometown in Germany, Western Germany. So yeah. I will also be part of a female and non binary release squad for WordPress 6.4 as a cohort member for the test team. And besides that I&#8217;m locale manager for the de.wordpress.org site and organising also polyglots, and publishing posts on de.wordpress.org news, and do a lot of stuff.</p>\n\n\n\n<p>[00:07:05] <strong>Nathan Wrigley:</strong> Yeah that was going to be what I was going to say. You do a lot of stuff. That really is a remarkable litany. I know that everybody that uses WordPress realises that there&#8217;s a lot of people in the background doing bits and pieces, but that is quite the laundry list of achievement. So from me to you, thank you for all of the different things that you do. That&#8217;s pretty remarkable. Okay, Jill.</p>\n\n\n\n<p>[00:07:29] <strong>Jill Binder:</strong> How do I follow that? I don&#8217;t know.</p>\n\n\n\n<p>[00:07:32] <strong>Nathan Wrigley:</strong> Yeah. So it&#8217;s your turn. Basically the same question, just give us a little bit of a backstory about yourself and WordPress and so on.</p>\n\n\n\n<p>[00:07:39] <strong>Jill Binder:</strong> Sure thing. So I&#8217;m Jill Binder and I&#8217;m the lead of the diverse speaker training group, #wpdiversity. I was a web developer from 2011 to 2018 ish. And what happened is I was a co organiser for WordCamp Vancouver 2013 and we had hardly any women and people from other underrepresented groups apply to speak at our WordCamp. And that started me on a whole journey. I found out we weren&#8217;t the only ones who had the issue. I asked other groups you know, how do you get more applications? And they&#8217;re like, you had seven? That&#8217;s amazing.</p>\n\n\n\n<p>So in Vancouver we wound up solving the problem for us. We created a workshop that gathered as many women and non binary and other genders in the room who wanted to join, which was a full room. And we went through the myths of what it is to be a, well let me back up a second.</p>\n\n\n\n<p>So we wound up solving the problem for us in Vancouver. We created a workshop and we based the workshop around the issue that we were having which is, when we would ask people if they would apply to speak at our WordCamp they would say, oh well I don&#8217;t even know what I would talk about. Or I&#8217;m not good enough in anything to give a talk, I&#8217;m not an expert.</p>\n\n\n\n<p>So we created a workshop that answers both those questions. It busts through the myth of what it is to be the speaker at the front of the stage. And it goes through, helps people find a topic, and having a whole room of people saying yes, I want to hear you talk about that topic. Goes a huge way in helping people overcome any obstacles they have to wanting to speak.</p>\n\n\n\n<p>We had so much success with that other cities ran it, and it was so successful that in late 2017 Andrea Middleton asked if I would create this group. And I found that it was totally my purpose and passion. And now since 2019 this has been my full time job. This is what I do. Half for WordPress, half for other companies.</p>\n\n\n\n<p>The company that I have now is called diversein.tech. That&#8217;s the website. That&#8217;s what I do. Currently in WordPress I&#8217;m sponsored by Automattic and by Green Geeks to do this work.</p>\n\n\n\n<p>[00:09:47] <strong>Nathan Wrigley:</strong> Thank you so much. I feel that we should just lay the groundwork a little bit, because for many people, myself I think included, the discussion around diversity, I find it difficult sometimes to get my hands on that, and to know who we&#8217;re talking about and who we&#8217;re trying to push this message out to.</p>\n\n\n\n<p>So could you just lay the groundwork for, well I guess in Jill&#8217;s case, she&#8217;s just described how she came up with this training program for the Vancouver meetup and so on. So you obviously had some sort of handle there as what you thought was going wrong, because if you&#8217;re going to create training materials, you must have some idea of what was the problem and what the solution was to that.</p>\n\n\n\n<p>Could you just describe the problem? Because there&#8217;s bound to be people listening to this who will be just thinking, okay interesting podcast but I need more data, more information about who these people are.</p>\n\n\n\n<p>[00:10:37] <strong>Jill Binder:</strong> Yeah that&#8217;s a great question. So the way that we think about it is, each region has people who are well represented. In North America that&#8217;s typically straight, cisgender, meaning same gender now as they were at birth. Male, white, able bodied people. And basically everybody else is underrepresented.</p>\n\n\n\n<p>That&#8217;s specific to North America. So North America we&#8217;ve got ethnicity, race, neurodivergence, different physical abilities, age, different genders, that&#8217;s kind of typically who the underrepresented is.</p>\n\n\n\n<p>And I have learned a lot over the last couple of years that in other parts of the world there are different underrepresented groups. So there might be religion, different spoken languages, different countries that people come from, culture, caste, class, et cetera. Birgit, do you want to add anything to that?</p>\n\n\n\n<p>[00:11:31] <strong>Birgit Olzem:</strong> You put it in the right word and as you said, especially in European countries, but also Asian, African. Australia for instance, you are more difficult to find their BIPOC people on the stage. And when you go to Asia, colored people are more in the lower represented.</p>\n\n\n\n<p>But as Jill already said, diversity is not only race or gender, but also I think diversity is a bit broader as well. Like how we think. And this is influenced by where we are born into and where we are born at. So everyone shares and brings into an own perspective.</p>\n\n\n\n<p>And also the perspective itself is also diversity. When we bring not only people of a kind of label into the community, but also allowing different perspectives and diverse perspectives. Learn from this.</p>\n\n\n\n<p>[00:12:29] <strong>Jill Binder:</strong> 100% to what Birgit just said. Part of the whole reason that I&#8217;ve gotten so passionate about this is because of the different perspectives that different people bring into the communities.</p>\n\n\n\n<p>You know most of my work is around the people on stage and by having different voices on stage we bring in ideas that help bring in more of that kind of person. So make it more inclusive. As well as bring in ideas that wind up benefiting everyone. So for example, closed captioning used to be for people with hearing impairments, limited hearing. But it winds up being great for everyone, you know. Somebody has a crying baby, can&#8217;t hear, they&#8217;re on the bus, they&#8217;re watching something at work, winds up helping everybody.</p>\n\n\n\n<p>[00:13:09] <strong>Nathan Wrigley:</strong> Thank you for that. Yeah really interesting. So one piece that I just took out of that was that the location that you are on the planet might have a very significant effect on the work that you would be doing. So you described the scenario in North America and then you know we heard about all the different parts of the world.</p>\n\n\n\n<p>I&#8217;m really interested in that because I&#8217;m guessing that in the future, the materials that you&#8217;re going to provide, the bits and pieces that you&#8217;re hoping to promote, would be encouraging that. You&#8217;re not in this scenario trying to have a one template fits all. It&#8217;s more of a, look here&#8217;s the underlying things that need to be thought about. Now go and figure out what the jigsaw puzzle of life in your part of the world is like. And then work through what it is that you&#8217;re going to do based upon where you are.</p>\n\n\n\n<p>[00:14:00] <strong>Birgit Olzem:</strong> Yeah exactly. When you see it, not everyone has the privilege of a fast internet connection, for instance. We have contributors in a region where they are depending on mobile cell phones, and are only contributing on a mobile phone. I heard a story that someone was contributing on an old mobile phone with an old internet access browser and was able to do that, but with a hard effort.</p>\n\n\n\n<p>When you see the difference in culture, and where the people come from it influences us like that a lot. And the template that you mentioned, we can&#8217;t bring a one fits all solution. As you already said. We want to invite our contributors, or people who are interested into contributing, to find their own mission but also their values. What is diversity for their community, for their tribe? What is diversity? What makes their event diverse? What makes their contributing team diverse?</p>\n\n\n\n<p>When we see also our contributing teams in the global WordPress community, we have the makewordpress.org teams but we have also local communities with their own Make teams. What is the diversity for them? How can they include people? How can open the gate for new contributors, for instance? Maybe Jill might add something on this.</p>\n\n\n\n<p>[00:15:26] <strong>Jill Binder:</strong> In the team that I&#8217;ve been working in, it&#8217;s a pretty mature team at this point. And so we have completely refined materials, and we have already helped 100 cities in 50 countries around the world with these issues. And we&#8217;re actually now at three programs. One is the diverse speakers. One is actually placing underrepresented speakers at events. But the other one is creating more inclusive, and welcoming and diverse events.</p>\n\n\n\n<p>And so for that first and last one we have set materials, and we&#8217;ve basically generalised, and we&#8217;ve made it, for our material, we&#8217;ve made it like people of underrepresented groups and we&#8217;ve just kind of boxed them in. I&#8217;m really excited for Birgit&#8217;s work that is going to make it more customised for the other things in the project. And maybe even bring some of that into the work that my team is doing.</p>\n\n\n\n<p>But we also just added in some content into our organising inclusive and diverse events workshop to help people define what is diversity in their own region. And to compare what we think it is with actual data of, you know in Vancouver I&#8217;m like, okay I&#8217;m pretty sure that we want to reach out to more of the black community. And I look at the data and find oh the black community is tiny.</p>\n\n\n\n<p>We don&#8217;t want to forget about the black community, but we have to remember actually, there&#8217;s a lot of Asian, South Asian, East Asian and so if they&#8217;re not showing up to our events and not speaking at our stages, what is going on? But I also want to say I&#8217;m not an organiser in Vancouver right now, so I&#8217;m not actually having a say in it. It&#8217;s just an example in my workshop.</p>\n\n\n\n<p>[00:17:00] <strong>Nathan Wrigley:</strong> One curious thing that&#8217;s just popped into my head, as a result of what you&#8217;ve both been saying, we will get very much onto how WordPress is doing with all of this throughout the globe. But one thing that occurs to me is that, I guess as members of the WordPress community, let&#8217;s hope that we&#8217;re behind everything that you&#8217;ve just said, all of us. But there has been in the past sort of little disagreements within the WordPress community. Where people have raised concerns about a particular event which is happening over there. And maybe they&#8217;ve looked at the speaker lineup and they&#8217;ve been unhappy with the different faces that are in that list and all of that.</p>\n\n\n\n<p>But what you&#8217;ve just said is really important because we need to be mindful that if the teams in those different locations have different requirements, if you like around diversity, that&#8217;s just something we be mindful of.</p>\n\n\n\n<p>[00:17:48] <strong>Birgit Olzem:</strong> Exactly, especially this particular discussion sparked my idea, or brought this onto the surface of what was boiling for several years now. Our first attempt to start a global diversity team was in 2018. Germany started a kind of umbrella group awareness team for the WordCamps in Germany.</p>\n\n\n\n<p>But also we thought already about to create some global working group to connect all teams. And this idea sparked and growed over several years now. And the pandemic also showed us where we have issues, and where we are struggling to stay connected with our community and with the people around us.</p>\n\n\n\n<p>But also it opened the gate for new contributors and finding new ways to communicate with each other. But we still have to learn and grow much better. But I think it&#8217;s not only bringing diverse people into it and discuss and judge people about how they are pronouncing something if they are not a native speaker in English, for instance.</p>\n\n\n\n<p>Especially written communication is hard to understand. And when you are not a native English speaking person you&#8217;re trying to find the right words to express your thought on it. And someone else put on his or hers or theirs filter on. And there&#8217;s an expression in German that you have a different listening ear and a different filter when you read something online. And you have only one channel, input channel, into your understanding where you can digest information.</p>\n\n\n\n<p>And when we are seeing each other&#8217;s face in-person meeting, we have the full surrounding, like hearing, seeing, feeling. And text is very condensed and it&#8217;s difficult to understand ideas and concepts and written word. Especially in heated discussions on platforms with limited characters for instance.</p>\n\n\n\n<p>And as I said, it is really important that we stay open minded and instead of calling out, calling in. And contact the person first on one on one level. And ask, hey I see an issue, this is what I feel about, what is your thinking about it? And what can we do about it? Before we&#8217;re calling out something in public, for instance.</p>\n\n\n\n<p>It&#8217;s one thing which fuels a better inclusion feeling, and belonging feeling into the community. Instead of pointing a finger to someone, or a group of people for wrongdoing. Because everyone has an own value system and own experience. Instead of asking what is their different culture.</p>\n\n\n\n<p>And as you said, every event has an individual setting, an individual group around it, that needs to fulfill other requirements and legal requirements for instance. So we can&#8217;t ask for a gender or more details on personal level, for instance, in Germany. Because we have to obey the GDPR regulations. How we can collect data, and how can we work with this data. So it is really helpful when we also create documents to showcase how diverse our global community is. To educate our community members who are also willing to learn how different and diverse we are.</p>\n\n\n\n<p>[00:21:32] <strong>Nathan Wrigley:</strong> I think it&#8217;s a really amazing time that we live in, but it&#8217;s also full of so many tripwires and pitfalls. Because we are, well I don&#8217;t really know if the term we are the first generation. But certainly in the last 20 years, we&#8217;re the first generations of human beings that have been able to communicate with people really straightforwardly at any point in the globe.</p>\n\n\n\n<p>So all of a sudden we&#8217;re thrown into the mix of, okay I can see Australian things and I can see Cambodian things and I can see Mexican things and American things. And you are going to bring the prejudice, for want of a better word, the things that you have been brought up with. I guess some of that is going to be transferred into your expectations of what those things are.</p>\n\n\n\n<p>And it was lovely, the language that you use there. Because again, a new experiment that we&#8217;re running globally I guess is the whole social media thing. And one of the outcomes I have seen of that, is that it is very easy to adopt a tone that doesn&#8217;t, well that seems perhaps more aggressive than you may have intended. This truncated little portion of texts that you&#8217;ve got. Sometimes you don&#8217;t manage to be perhaps as polite as you wanted, and so on and so forth. So there&#8217;s an awful lot in there.</p>\n\n\n\n<p>But one of the things that I took out of that Birgit, was the need to, if you have something to say, and if you have something that you&#8217;d like to be changed. A good way to go about that is to think about saying, okay this is what I think, and here&#8217;s my suggestion, but not to sort of put the boot down and say you need to be doing in this way. That does seem to be a more wholesome and straightforward way of going about it. And Jill, I&#8217;m conscious that you didn&#8217;t get a chance to add anything to that.</p>\n\n\n\n<p>[00:23:12] <strong>Jill Binder:</strong> Birgit said it perfectly.</p>\n\n\n\n<p>[00:23:14] <strong>Nathan Wrigley:</strong> Great. Okay a completely different question. Slightly off piste from the topic that we&#8217;re covering directly. I just wonder, broadly, how does WordPress do in this sphere? Because it feels from the outside, or from the inside that, on the whole the WordPress community, which is fairly unique, it spans all the globe, it&#8217;s got thousands of people involved in it. It&#8217;s pretty unique and it&#8217;s very often a fairly philanthropic thing, people giving up their time and all of that kind of stuff.</p>\n\n\n\n<p>How does WordPress compare? I feel like this might be a question for Jill, given that she&#8217;s been looking around elsewhere. But Birgit perhaps it is for you as well. How do we compare to other industries? Other, yeah, industries is probably the best word I&#8217;ve got. Are we really behind in all of this, or are we at the vanguard, or are we just sort of somewhere in the middle?</p>\n\n\n\n<p>[00:24:04] <strong>Jill Binder:</strong> So I don&#8217;t have official data and I don&#8217;t actually know. But anecdotally from what I&#8217;ve seen, at least in the open source world, so looking at, I don&#8217;t want to name the other ones specifically. In the open source world, which is what WordPress is part of, WordPress tends to be more diverse overall. And we also have the resources to put into working on this issue.</p>\n\n\n\n<p>So WordPress tends to have an easier entry point, at least when I started doing this work back in 2011, 2013 ish, when I was thinking about this a lot. Such that anybody no matter their level of education, no matter their background, can jump into it, start creating blog posts. Then start wanting to tweak the CSS a little. Start coding, and then next thing you know the person is a full blown web dev agency, and so starting is easier.</p>\n\n\n\n<p>And then there&#8217;s this amazing, rich community of people to help teach, that people can learn from. And now we&#8217;ve got even more robust systems with Learn WordPress where there&#8217;s official, easy to grasp, knowledge on all things WordPress. And so our community tends to be more diverse from that standpoint.</p>\n\n\n\n<p>When I started my work the issue was, well our audience is diverse, but the people on stage are not. And now we&#8217;re looking more at contributors and Birgit can maybe talk more about that. But it&#8217;s definitely an issue with our contributors as well. So we&#8217;re anecdotally, unofficially, I would say we are ahead of the curve, but there&#8217;s so much more curve to get over.</p>\n\n\n\n<p>[00:25:55] <strong>Nathan Wrigley:</strong> I like that expression. We&#8217;re ahead of the curve but there&#8217;s lots more curve. Birgit, anything to add?</p>\n\n\n\n<p>[00:26:00] <strong>Birgit Olzem:</strong> Jill already said it nicely, and I just want to add my personal experience. When I was visiting open source events, WordPress was not the focus. And I heard a lot that the WordPress community is the most welcoming community over several years now. And I love that we improve. We are eager to improve our efforts to be more welcoming again.</p>\n\n\n\n<p>Jill mentioned the learn.wordpress.org platform, for instance. On my last WordPress Community Summit in 2014, I was part of the early years of the training team of the WordPress community. And to see how this evolved over the year, that we have a pillar into our WordPress community to educate our user base but also our contributors.</p>\n\n\n\n<p>The recent experience from the mentorship program was very helpful to digest and to evaluate where we have to improve, or where we can improve our ways into contributing. But as Jill mentioned it is easy to contribute to WordPress. The entry way has a lower barrier.</p>\n\n\n\n<p>But I think we have a big challenge to keep active contributors, and over a long term. Because I saw a lot of people burning out over the years, including myself. Over contributing to such an open source system in a higher amount of hours putting into it, for instance. I&#8217;m talking for the people who are more maintaining WordPress instead of contributing occasionally. I think there&#8217;s a lot of room for improvement to support and also create a sustainable social sustainability into our WordPress community.</p>\n\n\n\n<p>And I see the social component, social sustainable component and also a big pillar into the DEIB proposal I wrote, to make sure that active contributors who are investing more than 10 hours, for instance, are well funded, who need to be funded, and who asked to be funded.</p>\n\n\n\n<p>We have a great base of contributors who are already sponsored, or have the ability during their work time to contribute to WordPress. And there are people, for instance like me who are a freelancer, who invests on private time and has no financial backing. But also needs to decide, do I need to make client work to fill my fridge, or do I contribute to WordPress?</p>\n\n\n\n<p>I always have the struggle to maintain my time, for instance. And I think this experience translates also to the initiatives to create a sustainable WordPress community and keep contributors active, not losing that. I guess I went a bit away from it, but I think you get what I want to say.</p>\n\n\n\n<p>[00:29:04] <strong>Nathan Wrigley:</strong> Yeah, thank you. So I think we painted a reasonably good picture of what the issue at hand here is. Okay let&#8217;s pivot slightly and change the direction, because I feel like we&#8217;ve laid the groundwork pretty well there for what is going on, and what we would like to change. As I say, let&#8217;s move it on and let&#8217;s talk about the things that you are both involved with, amongst others I&#8217;m sure, to help change this.</p>\n\n\n\n<p>So one of the things, I&#8217;m going to use the acronym first, it&#8217;s DEIB. That stands for diversity, equity, inclusion, and belonging. Now we&#8217;re going to be referring to that. I&#8217;ll try to use those words instead of the acronym because it&#8217;s probably going to be a lot easier.</p>\n\n\n\n<p>The idea here is that there&#8217;s going to be a team put together. Maybe the team is already in existence and fully fledged. But I just want to flesh out what the things are that you&#8217;re hoping to tackle with that. Now as luck would have it, both Birgit and Jill, they have both been very helpful in providing me with some show notes to this episode. And there&#8217;s a bunch of links in those show notes which will provide an awful lot of context.</p>\n\n\n\n<p>So it&#8217;s links in all sorts of direction, explaining what the philosophy is, how it&#8217;s going to be achieved, how you can get involved, all of those kinds of things. So if at any point you&#8217;re curious about that, pause the podcast, search for this episode on WP Tavern and then come back and you&#8217;ll have more context to the discussion at hand.</p>\n\n\n\n<p>In the show notes you&#8217;ve put five key messages down. I&#8217;ll just run through them quickly now. The first one is diversity is strength. The second one is inclusion means everyone. Third one, unified efforts, bigger impacts. Fourth one, shared responsibility. And the fifth one, call to action. Now I don&#8217;t know who wants to take this first, but I&#8217;m guessing they&#8217;re the underpinnings.</p>\n\n\n\n<p>It looks like it&#8217;s going to be Birgit who&#8217;s going to take this first. I&#8217;m guessing these are the underpinnings. I don&#8217;t know if you want to just take them in the round or do them one at a time. But maybe we should talk through what those individual pieces are for, and why it&#8217;s been distilled to those five key messages.</p>\n\n\n\n<p>[00:31:10] <strong>Birgit Olzem:</strong> Thank you Nathan. Yeah, I was thinking about to find the really key messages to digest the information better because it&#8217;s a very, very complex topic. Diversity, equity, inclusion and belonging is a mouthful to speak for many people, but the meaning behind it. Diversity, it&#8217;s not a buzzword.</p>\n\n\n\n<p>As we already said, you need to have diverse perspectives, diverse input, that a sustainable WordPress can grow and grow much better and more sturdy. Imagine you&#8217;re buying a house, you need strong basement where you put your house on. Diversity brings the strengths to keep the house sturdy and build the pillar.</p>\n\n\n\n<p>And inclusion is, for my instance, you&#8217;re inviting people and lowering the barrier to come into your house and celebrate a party with you. Work with you on the house building. And that&#8217;s also translated to the unified efforts. If you are building a house you need more people that only, you can&#8217;t build it on your own. So the more people the better impact you have.</p>\n\n\n\n<p>But also when you see shared responsibility, no one in the WordPress community has the weight of all decisions on their shoulder. It&#8217;s a team effort, and everyone takes a part of the responsibility. So you don&#8217;t have to put the weight of the world on your shoulders alone, you can share the responsibility with others.</p>\n\n\n\n<p>My perspective, and also what I was proposing with the team, the global team, is that everyone can contribute to that. We in the WordPress community have more diversity, more equity, and more inclusion, and everyone feels belonging to the WordPress community.</p>\n\n\n\n<p>It&#8217;s late in the day for me. I&#8217;m struggling for words. I apologise to our listeners and it&#8217;s a very important message and I invite everyone to read the proposal. It&#8217;s a long proposal, and I also digested it from seven pages down to four pages. But it&#8217;s full of information and so please read it when you have time and find your personal key points also in it.</p>\n\n\n\n<p>[00:33:33] <strong>Nathan Wrigley:</strong> I will copy and paste the exact phrasing of your five key messages there because I just paraphrased them very quickly, but there&#8217;s more in depth. And as I said, all of the links will be provided. So Jill, I think you might have something to add to that.</p>\n\n\n\n<p>[00:33:45] <strong>Jill Binder:</strong> I just want to add that Birgit&#8217;s proposal is brilliant and yes you should read it, audience members of this podcast. The only things that I&#8217;ll add is that I&#8217;m going to add another link to the show notes on an article that I wrote called, why is diversity important to WordPress and your local community?</p>\n\n\n\n<p>And that&#8217;s specifically to do with you know, why do we care about this for meetups and WordCamps? Whereas Birgit is talking about overall all contributing groups, why is it important? So, if anybody is wondering for the specific niche of events, I&#8217;ll add a link for people to read there.</p>\n\n\n\n<p>[00:34:23] <strong>Nathan Wrigley:</strong> Great thank you for that. What&#8217;s the status of this team at the moment? So we&#8217;re recording this right in the middle of August 2023. I don&#8217;t know the status, whether this is an official team, whether it&#8217;s become an official part of the WordPress project. Maybe it&#8217;s an aspirational thing at the moment. So just let&#8217;s clarify that for everybody.</p>\n\n\n\n<p>[00:34:44] <strong>Birgit Olzem:</strong> Yeah at the current status we have already managed to create a new Slack channel on a Make WordPress Slack account. It&#8217;s called deib-working-group, and everyone is invited to join. And we also have GitHub project board to track tasks, ideas, et cetera, where we can work together on this big topic.</p>\n\n\n\n<p>It&#8217;s a long term project and we are in the very first beginning to make it more global, and incorporate the current pillars, like WP Diversity initiative. Like the speaker support group.</p>\n\n\n\n<p>But also the sustainability team which was officially announced during WordCamp Europe this year. So where also the social sustainability is also part of the sustainability team. And with the upcoming WordPress Community Summit, we are also running a session about the diversity, equity, inclusion and belonging team efforts. My hope is that we get an official team sooner than later, so that we can form a team and start working on the key objectives.</p>\n\n\n\n<p>[00:36:05] <strong>Nathan Wrigley:</strong> I have a question surrounding the second of your bullet points, which is inclusion means everyone. And I just want to get some context nailed down here. And I&#8217;m going to read what you said, because I think it sums it up beautifully. Inclusion means everyone. So that&#8217;s clarifying the D E I B, the acronym we&#8217;ve been mentioning, efforts aren&#8217;t about favouring some over others, but ensuring that everyone has equal opportunity and feels welcomed.</p>\n\n\n\n<p>And I guess that&#8217;s the crucial point, isn&#8217;t it? The intention here isn&#8217;t to have some sort of tick list of things which must be achieved at every event, and it must look like this, and sound like this, and be written in this. It&#8217;s more about making sure that everybody, well, I say it&#8217;s. Is it more about just laying the groundwork, making sure that everybody knows that they are welcome, and hoping that they feel welcomed enough to show up and then contribute, and make it their own, and feel that they&#8217;re part of the whole thing?</p>\n\n\n\n<p>So again, it&#8217;s not a tick list of things which must be done. It&#8217;s more, well, here&#8217;s what we would like to have happen. Let&#8217;s just make it an open, welcoming space, make sure that everybody understands that it&#8217;s open and welcoming and therefore, we hope, that they will show up. I may have misrepresented that, but if I haven&#8217;t, I will be happy with myself.</p>\n\n\n\n<p>[00:37:24] <strong>Jill Binder:</strong> This is sort of my area of stuff. It&#8217;s a great question. I love this question. We&#8217;ll just make it open and welcoming and people will show up. There&#8217;s a lot of things that, we see the world through our own lens, and there&#8217;s a lot of things that we don&#8217;t think about.</p>\n\n\n\n<p>So we make it open welcoming for ourselves, and don&#8217;t think about things for other people. For example, for my first few years of participating with Meetup and WordCamp Vancouver, our events were held in an amazing space on a third floor, up three flights of really rickety stairs.</p>\n\n\n\n<p>And even me, as a mostly able bodied person still hated those stairs, and we excluded a lot of people from our community. But it was such a beautiful space, and we were getting it for free and so nobody really questioned it. When we held our first speaker workshop for underrepresented members of our community, I insisted we have to find a space with elevators.</p>\n\n\n\n<p>And then I suggested that, and then we wound up having people with wheelchairs, walkers, people who&#8217;d never come out to our events before attend that event. And then I asked if we could move all of our meetups there, and we did. So, it&#8217;s just a simple little thing that, try to make it welcoming. There&#8217;s a lot of things we don&#8217;t think about.</p>\n\n\n\n<p>People might be thinking, well, what can I do? How can I learn how to do this? Oh, well, I&#8217;m so glad to tell you there&#8217;s a workshop on Learn that you can watch. The workshop on Learn, the name of it there is, creating more diverse and inclusive WordPress spaces. I think that&#8217;s what it&#8217;s called. But also I am putting together all of my knowledge and material into one spot. And I&#8217;m going to have a link to it there. So, that along with some other articles that people should read to learn more about what can we do. It&#8217;s all going to be there, the short link is tiny.cc/wpdiversity. And that links to a page in our WordPress handbook. And so it goes through like mindset, community, spaces, allyship, et cetera. Lots of great info.</p>\n\n\n\n<p>[00:39:25] <strong>Nathan Wrigley:</strong> I guess the whole premise of, I don&#8217;t know because I don&#8217;t know, that&#8217;s what you&#8217;re tackling really, isn&#8217;t it? You are saying, well, if you don&#8217;t know, here&#8217;s how to know. Here&#8217;s a bunch of stuff that you can access. It&#8217;s all online. We know you&#8217;re in the WordPress community. Very likely you have access to a computer, so you can read these things. So here it is.</p>\n\n\n\n<p>[00:39:45] <strong>Jill Binder:</strong> Yeah, yeah.</p>\n\n\n\n<p>[00:39:46] <strong>Nathan Wrigley:</strong> That, kind of excuse, I guess, going forward of, I don&#8217;t know, because I don&#8217;t know, becomes a little bit more difficult to maintain. If you don&#8217;t know, here&#8217;s the resources, go and have a look, educate yourself in those things, and hopefully in the future, we can have a more diverse WordPress than we do currently.</p>\n\n\n\n<p>I have asked all of the things that I wish to ask. However, I&#8217;m keen to let you just take the floor. If there&#8217;s something that you wish to mention or something that I just neglected to ask.</p>\n\n\n\n<p>[00:40:16] <strong>Birgit Olzem:</strong> Yeah, I just want to add something on my mind. It&#8217;s the part of the digital accessibility. It&#8217;s also part of the diversity, equity, inclusion and belonging. Especially for people with, I don&#8217;t want to focus on that, but for instance, people who are are in a neurodivergent spectrum. Accessing information, digesting information, understand how to contribute to GitHub, for instance. It can be a barrier contributing to Slack. It&#8217;s also a barrier.</p>\n\n\n\n<p>I learned that Slack is not that accessible as it should be, for instance. But also the WordPress backend itself, complies not yet to digital accessibility. That is something we also want to think about, and also to understand that there are barriers. An able person don&#8217;t think of it, because as Jill also said, everyone has, looks through their own lens.</p>\n\n\n\n<p>That&#8217;s the aim also of this initiative, to bring all Make teams to one table. Ask question, how can we improve, and where are the blind spots we also have? Because everyone has a blind spot. Where we very not aware, be aware of what someone might be hindering someone to access the community, access the software itself.</p>\n\n\n\n<p>And, I think that is something we need to focus on. To have also this in mind. Not only the visible disabilities, for instance, like a wheelchair or someone with a cane. I&#8217;m circling a bit to events.</p>\n\n\n\n<p>Events need to be also inclusive for people with neurodivergent spectrum. Where they can find some quiet room, but also attendees who need to take some breaks in between walking distances. When I attend to a WordCamp, I need to overcome distances. I need to take sitting breaks in between, because I need to catch my breath, especially after I got COVID two years ago. It&#8217;s difficult for me to navigate through a large venue, to come from spot A to spot B, without taking a break in between. And we need to take this also into consideration when we are looking for event venues.</p>\n\n\n\n<p>My key message on it, we have a lot of good material already gathered, but it&#8217;s freckled around the community handbooks. I imagine to have a central place where we can guide and have a kind of a contributor or user journey, and a learning path. Where can willing people or contributors find the information easier? Currently, it&#8217;s all over, spread over every head book and, yeah, creating a central place to find this information.</p>\n\n\n\n<p>[00:43:15] <strong>Nathan Wrigley:</strong> Could I ask Birgit, where currently, I know you&#8217;ve just said that it&#8217;s spread all over the place, if somebody having listened to this podcast, their interest is piqued and you would have just one memorable thing, memorable place, where you would send them to a page or a contact form or whatever it may be. What would be in your mind, the quickest way to get involved and express your interest in all of this?</p>\n\n\n\n<p>[00:43:39] <strong>Birgit Olzem:</strong> As I said, it&#8217;s currently difficult to tackle this specifically because there is no central place yet.</p>\n\n\n\n<p>[00:43:46] <strong>Jill Binder:</strong> I have a suggestion of where to point people to. Birgit, I&#8217;ll ask if agree, but I think the Slack channel might be kind of a easy first.</p>\n\n\n\n<p>[00:43:57] <strong>Birgit Olzem:</strong> Yes. Yeah.</p>\n\n\n\n<p>[00:43:58] <strong>Nathan Wrigley:</strong> Okay. So that is most certainly going to be linked in the show, and I will make sure that that&#8217;s in there. I&#8217;m conscious Jill that I asked Birgit if there was anything that she wanted to say. So I&#8217;ll pass the torch to you. Did we miss anything? Was there anything that you thought we failed to discuss?</p>\n\n\n\n<p>[00:44:13] <strong>Jill Binder:</strong> Things that I will add are that I&#8217;m really excited about Birgit&#8217;s proposal and Birgit&#8217;s new group. I feel like this is something that we&#8217;ve needed for a long time. And to have somebody as passionate and driven as Birgit behind it to see it through is so amazing.</p>\n\n\n\n<p>You know, the work that I&#8217;m doing with events is just one small piece of the puzzle. One of the things that I&#8217;ve said all along is when we get more people on stage, magic things happen, like they become contributors, they help out more with the project.</p>\n\n\n\n<p>And pre pandemic we had systems in place for that to happen, and post pandemic we haven&#8217;t really had that anymore. And so Birgit&#8217;s group is going to be one of the things that is going to help with that. And her group to have diversity considered in all of our Make teams, is going to be just incredible. It&#8217;s going to be so vital for our work. And I&#8217;m so excited it&#8217;s happening. And I&#8217;m really honored that the events work, the diverse speaker training group, is going to be able to basically be a piece of this bigger picture that Birgit is putting together.</p>\n\n\n\n<p>[00:45:21] <strong>Nathan Wrigley:</strong> One of the nice things about doing this podcast is getting to meet wonderful people, doing wonderful things. And I kind of feel this is a really important, really interesting, really meaningful, impactful work. So full bravo to the pair of you, and anyone else who is in fact touching this.</p>\n\n\n\n<p>I&#8217;m sure there&#8217;s more people that we could thank, as well. And Birgit&#8217;s nodding her head. So yeah, the answer to that is yes. But, I have you two on the call. So I&#8217;m thanking you. Really amazing stuff.</p>\n\n\n\n<p>Very final question. A very brief one. If somebody wants to reach out to you personally, A, is that possible? And B, what&#8217;s your preferred method for them reaching out? I guess it could be a, an email address or a website, or a social media handle, whatever you like.</p>\n\n\n\n<p>[00:46:06] <strong>Jill Binder:</strong> Can I add, not just me, but our group as well. There&#8217;s a few links I wanted to mention for our work. So to read up more on the diverse speaker training group, as well as to get all of our resources that I am, in August right now, currently putting together before I&#8217;m away for a few months starting in September, and I want to make sure the community has all of the resources there.</p>\n\n\n\n<p>They can all be found at tiny.cc/wpdiversity. And this is going to answer things like how do you achieve more diversity inclusion at your WordCamps? And how do you actually get that diverse speaker lineup? And also being able to hold our workshops for your local communities. So holding our diverse speaker workshop, which we&#8217;ve renamed to, how to own your expertise and find a topic to speak on. As well as holding the how to create a diverse and inclusive WordPress event.</p>\n\n\n\n<p>And so that&#8217;s all at tiny.cc/wpdiversity. I also invite people to join our Slack channel, which is purely around supporting the underrepresented voices in WordPress to speak at events. Which is diverse-speaker-support. I will make sure it&#8217;s in the show notes.</p>\n\n\n\n<p>And also to mention that the first part of my break is not an entire break. I&#8217;m still holding two big events, speaker workshop for women in India is happening September, the weekend of September 23rd, Saturday and Sunday morning in India time.</p>\n\n\n\n<p>And also a women, both of them are for WordPress, a women in WordPress Speaker Workshop, for Latin America that we&#8217;re holding in San Jose, Costa Rica, in person. Except that I&#8217;m unable to travel myself, so my head on a giant screen. It&#8217;s worked out very well when we&#8217;ve done this previously, along with a Spanish translator, and that&#8217;s happening November 11th in person for everyone but me.</p>\n\n\n\n<p>And to reach me, I won&#8217;t really be available from September to December of this year, but I would love if people go ahead and follow me on social media, and I might post some of my adventures from my break. And of course, more diversity knowledge when I come back, and maybe some things while I&#8217;m on break too if I want to put things out into the world. On Twitter, LinkedIn and Mastodon.social, I am Jill Binder on all three.</p>\n\n\n\n<p>[00:48:22] <strong>Nathan Wrigley:</strong> Thank you very much. And Birgit.</p>\n\n\n\n<p>[00:48:25] <strong>Birgit Olzem:</strong> Yeah. Thank you. And I&#8217;m kind of a sad little face for Jill leaving us for a sabbatical. But I&#8217;m also very grateful that Jill has opportunity to take a break after a long, long work in the WordPress project. And I&#8217;m very thankful for the groundwork you did already. Yeah, thank you.</p>\n\n\n\n<p>When someone wants to reach me, I&#8217;m always with my handle coachbirgit on all socials. Also on my personal website coachbirgit.com. And I&#8217;m really inviting everyone to join our Slack channel to discuss and contribute to the initiative on, dib-working-group on a Making WordPress Slack account.</p>\n\n\n\n<p>[00:49:10] <strong>Nathan Wrigley:</strong> Jill Binder, Birgit Olzem, thank you so much for chatting to me on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:49:17] <strong>Jill Binder:</strong> Thank you.</p>\n\n\n\n<p>[00:49:18] <strong>Birgit Olzem:</strong> Thank you. Bye.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/coachbirgit\">Birgit Olzem</a> and <a href=\"https://twitter.com/jillbinder\">Jill Binder</a>.</p>\n\n\n\n<p>Birgit Olzem is a WordPress enthusiast who juggles diverse roles and advocates for mental health awareness, diversity, and unsung contributors. A proud mother and grandmother, she also consults on personal branding and explores surface pattern design. Birgit champions the WordPress community, as you’ll hear, in many ways.</p>\n\n\n\n<p>Jill Binder is the Founder and CEO of Diverse in Tech. She leads the Diverse Speaker Training Group in the WordPress.org Community Team, which encourages people from underrepresented groups to speak at WordPress events. She helped organise the first BuddyCamp, and for three years co-organised WordCamp Vancouver.</p>\n\n\n\n<p>Jill and Birgit join me today to discuss the importance of diversity, equity, inclusion, and belonging (DEIB for short) within the WordPress community.</p>\n\n\n\n<p>They share valuable insights regarding their efforts to create a more global and inclusive WordPress ecosystem. This includes the formation of a new working group on the Make WordPress Slack account and the use of GitHub project boards to track tasks and ideas.</p>\n\n\n\n<p>We talk about the need for unity within the community, the significance of diverse perspectives, and the importance of effective communication.</p>\n\n\n\n<p>We also get into Jill&#8217;s experience organising a training program for the Vancouver Meetup, emphasising the importance of understanding the specific needs of different communities.</p>\n\n\n\n<p>We explore the concept of sustainability within the WordPress community, addressing the financial support and resources necessary to retain and support active contributors.</p>\n\n\n\n<p>Throughout the episode both Jill and Birgit stress the importance of inclusivity, creating a welcoming environment, and providing opportunities for underrepresented voices to participate and contribute.</p>\n\n\n\n<p>If you’ve been wanting to know more about how to make the WordPress community more diverse and welcoming, this episode is for you.</p>\n\n\n\n<p>In some places the audio is a little choppy, so apologies for that, but it really is more than listenable.</p>\n\n\n\n<h2 class=\"wp-block-heading\">5 key messages mentioned in the podcast.</h2>\n\n\n\n<ol>\n<li><strong>Diversity is Strength:</strong>&nbsp;Emphasize that diversity isn’t just a buzzword; it’s the backbone of innovation and progress, especially in collaborative spaces like the WordPress community.</li>\n\n\n\n<li><strong>Inclusion Means Everyone:</strong>&nbsp;Clarify that DEIB efforts aren’t about favoring some over others, but ensuring everyone has equal opportunity and feels welcomed.</li>\n\n\n\n<li><strong>Unified Efforts, Bigger Impact:</strong>&nbsp;Talk about the importance of consolidating individual initiatives for a broader, more cohesive impact on the WordPress ecosystem.</li>\n\n\n\n<li><strong>Shared Responsibility:</strong>&nbsp;It’s not just up to a single group or team to promote DEIB; it’s a collective responsibility of the entire community.</li>\n\n\n\n<li><strong>Call to Action:</strong>&nbsp;Everyone can and should play a role in fostering DEIB in the WordPress community. Get involved, offer support, and be part of the change.</li>\n</ol>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links provided by Birgit and Jill.</h2>\n\n\n\n<ul>\n<li>Diversity, Equity and Inclusion Statement: <a href=\"https://make.wordpress.org/handbook/diversity-equity-and-inclusion-in-wordpress/\">https://make.wordpress.org/handbook/diversity-equity-and-inclusion-in-wordpress/</a></li>\n\n\n\n<li>DEIB team proposal: <a href=\"https://make.wordpress.org/project/2023/07/13/proposal-for-establishing-a-make-diversity-equity-inclusion-and-belonging-deib-team-within-the-wordpress-community/\">https://make.wordpress.org/project/2023/07/13/proposal-for-establishing-a-make-diversity-equity-inclusion-and-belonging-deib-team-within-the-wordpress-community/</a></li>\n\n\n\n<li>Quicklink to the Diverse Speaker Training Group (#WPDiversity) <a href=\"https://tiny.cc/wpdiversity\">https://tiny.cc/wpdiversity</a></li>\n\n\n\n<li>For tasks of the working-group: <a href=\"https://github.com/WordPress/DEIB-Issue-Tracker/issues\">DEIB-Issue-Tracker</a> and the <a href=\"https://github.com/orgs/WordPress/projects/131\">related project board</a></li>\n\n\n\n<li>Slack channel for the DEIB working group: <a href=\"https://wordpress.slack.com/archives/C05ND1KPW0Y\">#deib-working-group</a></li>\n\n\n\n<li>Slack channel to support underrepresented speakers in WP: <a href=\"https://wordpress.slack.com/archives/C028SE81N3H\">#diverse-speaker-support</a></li>\n\n\n\n<li>WP Briefing Podcast: <a href=\"https://wordpress.org/news/2021/07/episode-13-cherishing-wordpress-diversity/\">Episode 13: Cherishing WordPress Diversity</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Other links mentioned in the podcast.</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/project/2023/05/17/wordpress-contributor-mentorship-program-pilot-program-proposal/\">Contributor Mentorship Program</a></p>\n\n\n\n<p><a href=\"https://germany.wordcamp.org/2023/\">WordCamp Germany</a></p>\n\n\n\n<p><a href=\"https://vancouver.wordcamp.org/2023/\">WordCamp Vancouver</a></p>\n\n\n\n<p><a href=\"https://diversein.tech/\">Diverse in Tech website</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/community/2021/10/19/tuesday-training-why-is-diversity-important-to-wordpress-and-your-local-community/\">Why is diversity important — To WordPress and YOUR local community?</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/summit/\">WordPress Community Summit</a></p>\n\n\n\n<p><a href=\"https://twitter.com/jillbinder\">Jill&#8217;s Twitter</a></p>\n\n\n\n<p><a href=\"https://twitter.com/coachbirgit\">Birgit&#8217;s Twitter</a></p>\n\n\n\n<p><a href=\"https://coachbirgit.com/\">Birgit&#8217;s website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: State of the Woo 2023: WooCommerce Highlights AI-Powered Future and Continued Core Blockification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=150044\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://wptavern.com/state-of-the-woo-2023-woocommerce-highlights-ai-powered-future-and-continued-core-blockification\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5792:\"<p><a href=\"https://woosesh.com/\">WooSesh 2023</a>, the virtual conference for WooCommerce store builders, kicked off today with the State of the Woo address. This year’s theme is “Next Generation Commerce,&#8221; featuring advances across the e-commerce industry, as well as WooCommerce core and the wider ecosystem of tools and payment integrations. </p>\n\n\n\n<p>WooCommerce CEO Paul Maiorana began the presentation with a few stats on Woo&#8217;s growth in 2023:</p>\n\n\n\n<ul>\n<li>4.4M+ live websites currently using WooCommerce (<a href=\"https://storeleads.app/\">StoreLeads.app</a> Woo usage)</li>\n\n\n\n<li>33% of the top 1 million online store are powered by Woo </li>\n\n\n\n<li>8.9% of the internet is powered by Woo (<a href=\"https://w3techs.com/technologies/details/cm-woocommerce\">W3Techs</a>)</li>\n\n\n\n<li>270M+ Woo downloads to date (WooCommerce internal data)</li>\n\n\n\n<li>908 products in the Marketplace</li>\n\n\n\n<li>66 languages supported</li>\n</ul>\n\n\n\n<p>Maiorana highlighted a few e-commerce trends the company is watching, including the expansion of chatbots, on-site search, and AR. WooCommerce is seeing more merchants attracting non-local buyers through cross-boarder selling strategies, with high-growth stores focused on expanding across countries, languages, channels, and payment methods. Maiorana said customers are now expecting seamless experiences across devices and store must be fast, smooth, and intuitive from screen to screen.</p>\n\n\n\n<p>Maiorana also shared insights from <a href=\"https://woocommerce.com/partner-program/\">WooExperts</a>, officially endorsed WooCommerce agencies, who are seeing an increase in merchants embracing multi-channel selling, diversified payment options, and immersive buying experience that leverage AI, AR, virtual try-ons, and 3D images.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2100\" height=\"1178\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.13.52-PM.png\" alt=\"\" class=\"wp-image-150047\" />\n\n\n\n<p>The State of the Woo featured several milestones WooCommerce logged this year. WooCommerce Payments is now available in 38 countries. WooPay, the gateway&#8217;s opt-in single-click cross-site checkout experience, is out of beta. WooCommerce has also continued expanding its payment integrations covering more geographies and localized payment methods. The company recently launched <a href=\"https://woocommerce.com/products/tiktok-for-woocommerce/\">TikTok for WooCommerce</a> as a new integration to help merchants improve conversion by selling directly via TikTok Shop.</p>\n\n\n\n<p>WooExperts onboarded 88 new agencies, who are ambassadors for Woo, building enterprise projects at scale. They are also invited to collaborate with WooCommerce on technical planning.</p>\n\n\n\n<p>WooCommerce core has crossed several important milestones in 2023, including making High-Performance Order Storage (HPOS), more commonly known as custom order tables, the default on <a href=\"https://developer.woocommerce.com/2023/10/10/woocommerce-8-2-0-released/\">version 8.2</a>. This major overhaul delivers significant performance gains and makes databases more scalable.</p>\n\n\n\n<p>The full blockification of WooCommerce core is on the way <a href=\"https://developer.woocommerce.com/roadmap/block-based-product-creation-experience/\">a new product management experience using the Blocks API</a>. It was auto-enabled for a subset of new stores in 7.9, released in July, and will be enabled for more stores as soon as WooCommerce adds variable product management support.</p>\n\n\n\n<p>Block-based order confirmation is next on the roadmap, and block-based cart and checkout will soon be the default, as WooCommerce is working closely with partners to increase extension support.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Woo Express: More AI-Powered Features Coming Soon</h3>\n\n\n\n<img width=\"2440\" height=\"1242\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.32.27-PM.png\" alt=\"\" class=\"wp-image-150061\" />\n\n\n\n<p>During today&#8217;s WooSesh keynote, WooCommerce also highlighted a few milestones for Woo Express, the all-in-one WooCommerce plan hosted on WordPress.com. The product launched in 2023 as &#8220;Woo&#8217;s biggest bet ever.&#8221; It kicked off in September 2022, launched free trials in April 2023, and had 1,000 paying customers as of July 2023.</p>\n\n\n\n<p>The team demonstrated the new onboarding flow and store personalization experience. Woo Express&#8217; current priorities are making store setup easier with an AI-driven assistant to guide merchants through setup and growing stores, along with offering smart recommendations to drive more revenue, based on store analytics. The product defaults to a block-based theme, cart, and checkout. It includes the Woo AI plugin for early feedback.</p>\n\n\n\n<p>Woo Express is currently only available on WordPress.com, but WooCommerce representatives said what its features will also be surfaced in Woo core. The product is being used as a proving ground for the next phases of product development.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2056\" height=\"1132\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-10-at-12.31.30-PM.png\" alt=\"\" class=\"wp-image-150059\" />\n\n\n\n<p><a href=\"https://woosesh.com/\">WooSesh</a> will be live again tomorrow with more sessions on using AI tools for support, creating effective landing pages, using Amazon Pay, shipping trends, case studies, and more. Registration is free but the sessions must be viewed live. The sessions will be recorded and published to <a href=\"https://wpsessions.com/?utm_source=WooSesh\">WPSessions</a> after the live event has ended, available with a subscription.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Oct 2023 03:39:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.4 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7126:\"<p>WordPress 6.4 Beta 3 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you evaluate Beta 3 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 3 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta3.zip\">Beta 3 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-beta3</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\"><strong>underrepresented gender release squad</strong></a> to welcome the participation and partnership of those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> for details.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Get involved in testing</h2>\n\n\n\n<p>Your help testing WordPress 6.4 Beta 3 is key to ensuring its quality. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 3</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Update on the Font Library</h2>\n\n\n\n<p><strong>The Font Library feature, initially planned for WordPress 6.4, is now set to release in 6.5</strong>. WordPress is committed to delivering the best possible experience. This decision allows time to address enhancement opportunities, <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">test</a>, and get enough feedback to meet WordPress&#8217;s quality standards. Thanks for your support as contributors work towards an exceptional Font Library experience.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 3 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 3 contains more than 60 updates since the Beta 2 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F04%2F2023..10%2F10%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">29 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 2 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=10%2F04%2F2023..10%2F10%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets since Beta 2</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 3 haiku</h2>\n\n\n\n<p>Beta 3 arrives<br />Testing where progress derives<br />Iterate, it thrives</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: </em><a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a> and <a href=\"https://profiles.wordpress.org/michelleames/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michelleames</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 16:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Meher Bala\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: Breaking Down YMIR and a Lot of Other Things in Carl Alexander’s Mind\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76836\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/breaking-down-ymir-and-a-lot-of-other-things-in-carl-alexanders-mind/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:457:\"<p>When you dive deep into Carl\'s mind to learn more about what he built for WordPress, the end result is today\'s show.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/breaking-down-ymir-and-a-lot-of-other-things-in-carl-alexanders-mind/\">Breaking Down YMIR and a Lot of Other Things in Carl Alexander&#8217;s Mind</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 11:15:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: WordPress Reverts Live Preview Button on Plugins After Developer Backlash\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/wordpress-reverts-live-preview-button-on-plugins-after-developer-backlash\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7858:\"<img width=\"2036\" height=\"1438\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screenshot-2023-09-15-at-6.29.19-pm.png\" alt=\"\" class=\"wp-image-150011\" />\n\n\n\n<p>Last week WordPress meta contributors <a href=\"https://meta.trac.wordpress.org/changeset/12931\">implemented a &#8220;Live Preview&#8221; button</a> for plugins in the official directory, with the intention of allowing users to safely test any plugin in one click. The button went live across all of WordPress.org&#8217;s 59,000+ plugins but took plugin developers by surprise as it was pushed through without any communication or input from stakeholders. </p>\n\n\n\n<p>The implementation was premature and failed to take into consideration the many different types of plugins that appear to be broken due to inadequate support in the Playground testing environment. </p>\n\n\n\n<p>Five weeks ago, Automattic-sponsored Meta team contributor Steve Dufresne <a href=\"https://meta.trac.wordpress.org/timeline?from=2023-09-07T00%3A29%3A45Z&precision=second\">commented</a> on the ticket, &#8220;Adding that it&#8217;s likely still the case (someone else can confirm), not all plugins work in the Playground so we should build in an opt-out mechanism.&#8221;</p>\n\n\n\n<p>This suggestion was roundly ignored by other participants on the ticket and the Playground previews went live. It became immediately apparent that this was done without thorough testing as many plugin authors reported the previews created an unfavorable, broken experience for users. </p>\n\n\n\n<p>&#8220;Who decided to release Preview without posting on <a href=\"https://make.wordpress.org/plugins/\">make.wordpress.org/plugins/</a> with some advanced warning to plugin devs?&#8221; WordPress developer Alan Fuller asked, starting a <a href=\"https://wordpress.slack.com/archives/C02QB8GMM/p1696523391533419\">discussion</a> in the #meta Slack channel. &#8220;Was that a #meta decision? Can it be reverted and due notice given?&#8221;</p>\n\n\n\n<p>Retired Plugins team rep Mika Epstein identified three major use cases that were missed, which she estimates will impact 30-40% of plugins not working in the Playground environment: </p>\n\n\n\n<ol>\n<li>It won’t work for add-on plugins (ie. anything for Woo) because we have no way to identify plugin dependancies, and the sandbox won’t know to install the ‘parent’ plugin</li>\n\n\n\n<li>It won’t work (well) for anything that requires a lot of customization (WooCommerce itself)</li>\n\n\n\n<li>It won’t work AT ALL for anything that’s a server integration (Memcached, Redis, etc).</li>\n\n\n\n<li>Multisite</li>\n</ol>\n\n\n\n<p>Participants noted that DEBUG is also set to True, allowing unrelated warnings and notices to be displayed to the visitor.</p>\n\n\n\n<p>&#8220;It stinks to work really hard on a plugin and then have some preview show up that makes it look totally broken when it&#8217;s not,&#8221; WordPress developer Ben Sibley said.</p>\n\n\n\n<p>&#8220;This feature is a neat idea, but it needs a lot more work. We&#8217;ve gone decades without live previews; why was there suddenly a rush to launch this today when it&#8217;s demonstrably unreliable?</p>\n\n\n\n<p>&#8220;As others have stated, this should be rolled back immediately and switched to an opt-in feature. Once it&#8217;s rolled back, work on giving plugin devs information about how the preview works so we can decide if it&#8217;s right for us or not. There is no rush to release this without proper communication and testing!&#8221;</p>\n\n\n\n<p>Newsletter Glue co-founder Lesley Sim requested the feature be opt-in, contending that the average user won&#8217;t have patience if something appears broken and will assume there is a problem with the plugin, not the directory or the playground.</p>\n\n\n\n<p>&#8220;So it ends up reflecting badly on the plugin developer, which can be really stressful for them if it means a loss in (potential) revenue/installs (yes, I understand that many people think this shouldn&#8217;t be a key concern, but it is the reality for many small plugin devs) or if they have additional support burden as a result of this feature, which is completely out of their hands,&#8221; Sim said.</p>\n\n\n\n<p>After others echoed these concerns, Automattic-sponsored contributor Alex Shiels, who implemented the feature, <a href=\"https://meta.trac.wordpress.org/timeline?from=2023-10-06T02%3A26%3A06Z&precision=second\">said</a> he didn&#8217;t expect it would be controversial and <a href=\"https://wordpress.slack.com/archives/C02QB8GMM/p1696571100525509?thread_ts=1696523391.533419&cid=C02QB8GMM\">said</a> he was &#8220;over-optimistic about how smoothly it would work.&#8221; He deployed a commit that <a href=\"https://meta.trac.wordpress.org/changeset/12933\">added an opt-out toggle</a> so plugin committers could disable the Live Preview button.</p>\n\n\n\n<p>&#8220;The reason I didn’t communicate prior to deploy is, there was discussion on the ticket for a month prior; and because Playground has been live for several months now,&#8221; Shiels said. &#8220;Every published plugin in the directory has already been available for running in the Playground since well before this ticket. All I did was make it easy to get there with a single click. Apologies for catching you all off-guard.&#8221;</p>\n\n\n\n<p>Others requested WordPress.org implement a customizable Demo link url in the readme file, instead of turning Playground previews on for all plugins, along with many more suggestions for making the environment better for showcasing  plugins.</p>\n\n\n\n<p>After continued pushback urging Shiels to make the feature opt-in instead of opt-out, he <a href=\"https://meta.trac.wordpress.org/changeset/12934\">removed the button</a> on Friday, October 6. </p>\n\n\n\n<p>&#8220;I do want to emphasize that a lot of the worry and concern wasn’t about the fact that a plugin was broken in Playground,&#8221; plugin developer Aurooba Ahmed said. &#8220;Most of us know if our plugin works in playground or not, it was that a very apparent feature was pushed to the plugin repo that affects how users evaluate plugins, without discussion and feedback from enough of the key stakeholder audiences.</p>\n\n\n\n<p>&#8220;I look forward to seeing how the feature is iterated upon (because ultimately it’s a fantastic concept) so that it can be useful in all the right ways for all stakeholders.&#8221;</p>\n\n\n\n<p>In the meantime, users who enjoy having quick access to Playground may want to check out the Chrome browser extension created by LUBUS, a development agency. It <a href=\"https://wptavern.com/new-chrome-browser-extension-enables-one-click-plugin-and-theme-testing-with-wordpress-playground\">adds a Playground” button to theme and plugin pages</a> on WordPress.org so users can test drive extensions with one click.</p>\n\n\n\n<p>When adding the opt-out toggle, Shiels commented on the ticket that plugins broken in Playground were broken before the ticket was opened and will remain that way even if the plugin does not opt into the Live Preview button.</p>\n\n\n\n<p>&#8220;I know the Playground team is hard at work on addressing bugs and compatibility issues there,&#8221; Shiels said. &#8220;And I intend to further improve the Live Preview support in the plugin directory to make things better for users and plugin developers alike. Many of your concerns can be addressed using <a href=\"https://wordpress.github.io/wordpress-playground/blueprints-api/index\">Blueprints</a> which will allow configuring and installing dependencies, importing demo content, and other neat things. I&#8217;ll work on making Blueprint support available as soon as I&#8217;ve confirmed some engineering details with the Playground team.&#8221;</p>\n\n\n\n<p>There is more work to be done before this feature is ready for rollout. The live preview button is currently disabled while contributors iron out compatibility issues.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Oct 2023 03:18:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:152:\"Gutenberg Times: Font Library punted, WordPress 6.4 sneak peek, Design tools for Artists, create block package, and so much more – Weekend Edition 271\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25863\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"https://gutenbergtimes.com/font-library-punted-wordpress-6-4-sneak-peek-design-tools-for-artists-create-block-package-and-so-much-more-weekend-edition-271/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:17557:\"<p>Howdy, </p>\n\n\n\n<p>Seems Summer break is over for many developers, designers, and site builders, and they came back inspired to write and share their learning with the rest of the community.  There is a ton of material in today&#8217;s weekend edition for every level of WordPress users. Dig in.  And if you still us browser bookmarks bookmark it. </p>\n\n\n\n<p>Have a wonderful weekend!!</p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\"><strong>WordPress 6.4 Beta</strong> <strong>2</strong></a> was released this week, and again, two calls for testing will help you familiarize yourself with new features, and also help the underrepresented gender release squad to make it the best version it could be. </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Help Test the Font Library</a> (for 6.5)</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Help Test WordPress 6.4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></li>\n</ul>\n\n\n\n<p>Before everyone headed into the weekend, core contributors and release squad discussed the state of the Font Library and concluded, in the words of Tonya Mork, core tech lead 6.4, &#8220;The feature is not ready yet.&#8221; and &#8220;It needs more time. &#8221; Release lead, Josepha Haden Chomphosy, decided to punt the Font Management feature to WordPress 6.5. </p>\n\n\n\n<p><strong>Sarah Gooding </strong>at the WPTavern has the details for you: <a href=\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\"><strong>WordPress 6.4 Font Library Feature Punted to 6.5 Release</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Listening to the <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\" target=\"_blank\" rel=\"noreferrer noopener\"><strong>WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek</strong></a> you can join WordPress Executive Director, <strong>Josepha Haden Chomphosy</strong>, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest <strong>Sarah Norris</strong>, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p>Reminder: <strong>Nick Diego, Justin Tadlock</strong> and <strong>Ryan Welcher</strong> invite you to their <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296105065/\"><strong>Hallway Hangout: What&#8217;s new for developers in WordPress 6.4</strong></a> on October 12th, 2023 at 18:00 UTC. They will cover, among other things, Block Hooks and the Default theme Twenty-Twenty-Four. </p>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<p><strong>Anne McCarthy</strong> invites you to join her for a <a href=\"https://make.wordpress.org/core/2023/10/02/hallway-hangout-working-session-consolidating-modes/\"><strong>Hallway Hangout: Working session on consolidating various navigation modes</strong></a> on November 15, 2023, at 15:00 UTC. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Vicente Canales</strong> is released <strong><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v16.8.0-rc.1\">16.8 RC1 is available for testing</a>.</strong> Mainly the release contains fixes and improvements that were necessary after WordPress 6.4 beta testing. Out of 160 PRs, <a href=\"https://github.com/WordPress/gutenberg/pulls?page=2&q=is%3Apr+milestone%3A%22Gutenberg+16.8%22+is%3Aclosed+I+just+cherry-picked+this+PR\">49 were back ported</a> to the WordPress 6.4 Beta branches.  many bug fixes that came from WordPress 6.4 Beta testing or improved code quality. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p>In the 10-minute tutorial, <a href=\"https://learn.wordpress.org/tutorial/templates/\"><strong>Using Page Templates</strong></a>, <strong>Wes Theron</strong> teaches you what templates are, how you can expand them to create full-page layouts with header, sidebar, and footer areas. You will learn how to use, edit and add templates to customize your site by giving your posts and pages their own unique look and feel.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Gooding</strong> researched <a href=\"https://wptavern.com/why-nasa-chose-wordpress-for-revamping-its-flagship-website\"><strong>Why NASA Chose WordPress for Revamping Its Flagship Website </strong></a> and identified 3 major reasons: Ample access to resources, a a plugin ecosystem around real time content analysis, and, as expected, ease of use of the content authoring environment. &#8220;The block editor’s flexibility for authoring landing pages and breaking free of a rigid templating system was one of the most important factors in NASA’s selection of WordPress as a CMS.&#8221; she wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In their post <a href=\"https://block-museum.com/2023/10/03/get-creative-with-wordpress-6-4s-design-tools/\"><strong>Get Creative with WordPress 6.4’s Design Tools</strong></a>, <strong>Anne McCarthy</strong> summarized the upcoming changes to Design Tools for artists who would like to submit new Block patterns to the Block Museum of Art. The new Font Library vertical text orientation, and background image for Group block enrich the block artist&#8217;s toolbox, together with the core blocks enhance support for more design tools. Of those, the stretch alignment for column blocks is probably the most interesting one. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://www.youtube.com/@TylerMoore/\"><strong>Tyler Moore</strong></a>, WordPress YouTuber with 450+K Subscribers , published his first Block Theme in the WordPress repository. Meet <strong><a href=\"https://wordpress.org/themes/variations/\">Variations</a> &#8211;</strong> &#8220;a block theme and hopefully the last theme you will even have to install. It comes with many templates and block patterns to make creating a website easy.&#8221; he wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his video, <strong><a href=\"https://www.youtube.com/watch?v=OZW8wREJT6A\">WordPress Block Themes are amazing</a>,</strong> <strong>Jamie Marsland</strong> showed how to create custom post layouts, custom post archives, and display custom fields using Block Themes  (oh and snazzy CSS Grids with the query loop block),as he announced in <a href=\"https://twitter.com/pootlepress/status/1709832407338135553\">his tweet.</a> </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mike McAlister</strong> reported <a href=\"https://olliewp.com/the-ollie-block-theme-is-now-available-on-wordpress-org/\"><strong>the Ollie block theme is now available on WordPress.org!</strong></a> It sports 50 beautiful pattern designs, 7 full-page pattern layouts,&nbsp;and a fully customizable design system with Global Styles. <a href=\"https://wordpress.org/themes/ollie/\">Download Ollie here</a></p>\n\n\n\n<p><strong>Sarah Gooding</strong> at the WPTavern, accompanied McAllister on his contributor odyssey to get his theme approved. She wrote several articles (<a href=\"https://wptavern.com/ollie-theme-previews-new-onboarding-wizard-in-development\">here</a>, <a href=\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\">here</a>, <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\">here</a> and <a href=\"https://wptavern.com/ollie-theme-now-available-on-wordpress-org\">here</a>) to give context and background with comments from the wider community. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>On <strong>October 17, 2023, at 20:00 UTC</strong>, <strong>Wes Theron</strong> will host an online live tutorial on <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296575670/\"><strong>Using the Query Loop block and Category templates</strong></a>. This will cover the heart of a website that is how to display archive pages and category summary pages. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://memberpress.com/blog/author/syble/\">Syble Harrison</a> </strong>celebrates the release of MemberPress version 1.11.7. It comes with&nbsp;<a href=\"https://memberpress.com/blog/gutenberg-membership-blocks/\"><strong>Gutenberg Membership Blocks</strong></a>&nbsp;and all MemberPress widgets now also work as Gutenberg membership blocks. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>Let <strong>Ganesh Dahal </strong>take you on a journey <strong><a href=\"https://www.smashingmagazine.com/2023/09/exploring-enhanced-patterns-system-wordpress/\">Exploring Enhanced Patterns In WordPress 6.3</a></strong> on Smashing Magazine.  Synched patterns (former <em>Reusable blocks)</em> and block patterns give users &#8220;the ability to&nbsp;write content once and synch it&nbsp;across pages and posts and modular components to&nbsp;enforce a consistent visual experience&nbsp;throughout a site.&#8221; Dahal wrote. Don&#8217;t forget to replace &#8220;reusable blocks&#8221; with &#8220;synched patterns&#8221;. One of the curses of a fast-moving development project. Features names sometimes change. </p>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<p><strong><a href=\"https://johannes-wp.com/\">Johannes</a></strong> is a wireframe and UX kit that wants to help you with your  next WordPress design project. Built by the WordPress VIP partner <a href=\"https://twitter.com/be_api\"><strong>Be API </strong></a>in France, the tool consists of a library of ready-to-use components in Figma, Hero and other samples templates, styles, and pattern variations. Johannes uses Figma features, including components, auto-layout and variants.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In <strong><a href=\"https://href.li/?https://www.youtube.com/watch?v=TtmdYbHKDL0\">Developer Hours: Building better blocks with the create-block package</a>,</strong> <strong>Nick Diego </strong>and <strong>Ryan Welcher</strong> covered the official scaffolding tool for custom block development. Besides the fundamentals, participants learned about other features such as external project templates and variants for dynamic blocks or blocks using the interactivity API.&nbsp;</p>\n\n\n\n<p>If you&#8217;d like to participate in a live online tutorial, <strong>Jonathan Bossenger</strong> will hold a session on the same topic on October 12th, 2023 at 14:00 UTC. You can RSVP on Meetup.com <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/296580191/\"><strong>The WordPress Create Block tool</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Gabriel Rose</strong>, developer at 10up, created the Microsoft VS Code extension: <a href=\"https://marketplace.visualstudio.com/items?itemName=GabrielRose.wordpress-theme-json-css-autosuggest\"><strong>WordPress theme.json CSS Autosuggest</strong></a> that provides autocomplete for your WordPress theme.json tokens in your CSS.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Mark Wilkinson</strong> of Highrise Digital and co-host of the <em><a href=\"https://wpcafe.show/\">WP Café podcast</a></em>, shared his approach and code to make the <a href=\"https://markwilkinson.dev/code-snippets/wordpress-search-block-to-only-search-in-a-custom-post-type/\"><strong>WordPress search block to only search in a custom post type</strong></a>. Once implemented, users can use patterns to add the feature to their site.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ronald Huereca</strong> wrote a tutorial on <a href=\"https://dlxplugins.com/tutorials/how-to-create-a-permanent-unique-id-for-your-wordpress-block/\"><strong>How to Create a Permanent Unique ID for Your WordPress Block</strong></a>. Maybe that&#8217;s something you were always wondering about. The tutorial is reach on  code examples and gives you step-by-step instructions to follow along. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Next in his series <em>Block Developer Cook Book recipes</em>, <strong>Ryan Welcher</strong> tackles the <a href=\"https://www.youtube.com/watch?v=asCNlHxtemE\"><strong>Formats API</strong></a> in his latest video. &#8220;Uncover the secrets of the Format API to flavor your text, just like a master chef creates unique sauces.&#8221; her wrote in the description. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-center has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-center has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: Hawa Mahal, Jaipur, Rajasthan by Bigul Malayi</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Oct 2023 11:21:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Ollie Theme Now Available on WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149955\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wptavern.com/ollie-theme-now-available-on-wordpress-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4011:\"<p>The free <a href=\"https://olliewp.com/\">Ollie block theme</a>, created by Mike McAlister and Patrick Posner, is now available for <a href=\"https://wordpress.org/themes/ollie/\">download on WordPress.org</a>. A <a href=\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\">contentious review process</a> led the team to remove the onboarding features, despite having gotten the green light from WordPress&#8217; leadership who advocated for moving forward with the experiment. The version of Ollie available on WordPress.org is simply the theme without the guided onboarding experience that reduces the amount of time it takes to get through the first 30-40 minutes of setting up the theme.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1144\" height=\"858\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/ollie-wporg.webp\" alt=\"\" class=\"wp-image-149959\" />\n\n\n\n<p>McAlister explained why the team reached this surprising decision in a 10-minute <a href=\"https://twitter.com/mikemcalister/status/1708929134490005759\">video</a> earlier this week, as well as in the theme&#8217;s launch <a href=\"https://wordpress.org/themes/ollie/\">post</a>:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>In a surprising twist of events, WordPress leadership actually <em>wanted</em> to give it a shot as an experiment! While it was awesome to see that kind of support, by this point it had become clear that it was too controversial to try this right now.</p>\n\n\n\n<p>There were valid concerns that without a system or understanding in place at the directory level, this could set a precedent with unknown outcomes and potentially burden volunteers with longer theme review queues. We don’t want that, and the idea that a feature of Ollie would burden anyone is <em>the antithesis</em> of our aim of helping users through this exciting era of modern WordPress.</p>\n</blockquote>\n\n\n\n<p>Ollie&#8217;s creators are working on putting the onboarding into a plugin in order to &#8220;deliver our original vision, free of constraints.&#8221; It will be available on GitHub and they <a href=\"https://twitter.com/mikemcalister/status/1710050878042821071?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1710050878042821071%7Ctwgr%5Eb107394162dfda43307002c16128506f013147ff%7Ctwcon%5Es1_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149955action%3Dedit\">plan to submit it to WordPress.org</a>, but the severe backlog may prevent it from being live in the directory for a few months.</p>\n\n\n\n<p>The theme on WordPress.org has more hurdles to getting started with a new website. Users will need to know how to navigate the Site Editor to edit templates and place patterns. After installing the theme, it&#8217;s painfully clear how much simpler the onboarding wizard would make everything. Ollie comes with seven full-page pattern layouts, which helps if you want to build a site similar to the demo. It also packages seven style variations and an astonishing 50 custom block patterns for building nearly any kind of website.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2842\" height=\"1296\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-06-at-9.22.42-PM.png\" alt=\"\" class=\"wp-image-149968\" />\n\n\n\n<p>With different combinations of patterns, Ollie is suitable for personal websites, agencies, portfolios, nonprofit organizations, blogs, and businesses of various kinds. Although this version doesn&#8217;t deliver on the &#8220;40-hour head start&#8221; that the onboarding offers, it&#8217;s still a very well designed theme with meticulous attention to detail and an abundance of customizable patterns.</p>\n\n\n\n<p>Check out the <a href=\"https://demo.olliewp.com/\">Ollie demo</a> to see the theme in action and <a href=\"https://wordpress.org/themes/ollie/\">install/download it from WordPress.org</a> to take it for a test drive.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 07 Oct 2023 03:00:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Why NASA Chose WordPress for Revamping Its Flagship Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/why-nasa-chose-wordpress-for-revamping-its-flagship-website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7984:\"<img width=\"2836\" height=\"1306\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-06-at-3.48.43-PM.png\" alt=\"\" class=\"wp-image-149947\" />\n\n\n\n<p>NASA has removed the beta label from the new <a href=\"https://t.co/EnLX4Rmld4\" target=\"_blank\" rel=\"noreferrer noopener\">nasa.gov</a> website, which was launched on WordPress, replacing Drupal as the CMS. After a lengthy process, which required 18 months of active web development, data migration, and content building, NASA has emerged with modernized flagship and science websites, showcasing the innovation and discoveries that have defined the agency for more than 65 years.</p>\n\n\n\n<p>The multi-million dollar project began a few years ago when a combination of the IDEA Act and Drupal 7 EOL provided an opportunity for NASA to reconsider the CMS they were using for nasa.gov. <a href=\"https://lonerockpoint.com/\">Lone Rock Point</a>, a WordPress.com VIP Gold Agency Partner, led the project, which began with  a year of UX design and an evaluation of various enterprise CMS&#8217;s that would ultimately end up supporting 456 CMS users, 68,698 migrated pages, and 3,023 new landing pages. As part of the project, NASA&#8217;s website infrastructure was migrated from an Amazon Web Services environment to WordPress.com VIP.</p>\n\n\n\n<p>&#8220;In earlier discovery phases of the project, content authors were were vocal that they were interested in a CMS that allowed them to break free of templates that were perceived to be rigid,&#8221; Lone Rock Point President J.J. Toothman said. &#8220;The block based authoring approach of Gutenberg is delivering on that and user testing showed that WordPress could provide that. Now that the site is live, the different types of landing pages being created with block based approach further validates that.&#8221;</p>\n\n\n\n<p>NASA evaluated both proprietary and open source solutions, and Toothman said they took a high level look at over a hundred CMS platforms. They narrowed it down to four CMS&#8217;s &#8211; two were commercial and two were open source (WordPress and Drupal). The team completed high level prototyping and user evaluation on all four of the finalists, and used this data in the CMS selection process.</p>\n\n\n\n<p>Toothman outlined a few of the factors that set WordPress apart from the others:</p>\n\n\n\n<ul>\n<li>Access to resources. Simply put, there’s a huge community around WordPress. That community is extending WordPress in innovative ways; sharing knowledge and training for WordPress; and continuously building up WordPress skills amongst the community. That makes it easier for an organization like NASA to acquire support. There’s options for that. What was found with commercial CMS solutions is that, more often than not, NASA would have to go back to the original CMS vendor to find resources. That’s limited flexibility, which is undesirable for them.</li>\n\n\n\n<li>A plugin ecosystem that delivered real time content analysis capabilities within the WordPress admin environment in the ares of SEO and accessibility. The fact that content could be analyzed by the author before it was published was significant.</li>\n\n\n\n<li>Ease of use of the content authoring environment</li>\n</ul>\n\n\n\n<p>&#8220;It’s a big win for open source,&#8221; Toothman said. &#8220;There were a number of CMS capabilities that would have been more time consuming to implement without previous work by others in the WordPress community.&#8221;</p>\n\n\n\n<p>He cited the  integration that the NASA WordPress site has with NASA’s image library at <a href=\"http://images.nasa.gov/\" target=\"_blank\" rel=\"noreferrer noopener\">images.nasa.gov</a> as one example. Content authors in the CMS can search for images in the library and include them in their content via an augmentation that was made to the WordPress media library. Human Made did some previous work with commercial digital asset management solutions that NASA was able to leverage for the <a href=\"http://images.nasa.gov/\" target=\"_blank\" rel=\"noreferrer noopener\">images.nasa.gov</a> integration.</p>\n\n\n\n<h3 class=\"wp-block-heading\">NASA Goes All In on WordPress&#8217; Block Editor</h3>\n\n\n\n<p>The block editor&#8217;s flexibility for authoring landing pages and breaking free of a rigid templating system was one of the most important factors in NASA&#8217;s selection of WordPress as a CMS. As part of the project, Lone Rock Point created 55 custom editor blocks to help NASA website authors share discoveries and tell their stories.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1692\" height=\"1080\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/tabbed-content-block.gif\" alt=\"\" class=\"wp-image-149949\" />NASA&#8217;s Tabbed Content block &#8211; source: <a href=\"https://lonerockpoint.com/2023/10/nasa-flagship-wordpress-site-launch/\">Lone Rock Point</a>\n\n\n\n<p>&#8220;There’s over 400 content authoring/editor users in NASA’s WordPress CMS,&#8221; Toothman said. &#8220;With that many users, there’s a lot of variance in pre-existing familiarity to WordPress and Gutenberg. It was challenging. The learning curve was more significant than expected and change management was a big part of this project. </p>\n\n\n\n<p>&#8220;Some took the block editor quickly, others needed more support. It wasn’t just learning the mechanics of a new CMS, but learning about the storytelling options available via the new design system and the block editor. We built a lot of custom of blocks to bring the design system to live in WordPress, while also attempting to adhere to the intention of those design system components.&#8221;</p>\n\n\n\n<p>Toothman and his team found strategic ways of helping new block editor users become familiar with the authoring tools. They created hands-on training and working sessions to build pages in real time alongside users and created an online knowledge base.</p>\n\n\n\n<p>&#8220;To encourage the user community as they learned the new CMS, we created weekly blogs and newsletters that featured screenshots of pages in progress,&#8221; Toothman said. &#8220;Seeing their peers’ work and out-of-the-box use of the custom blocks, users were inspired to try different things and ask more questions. Our content team held weekly office hours for managing editors to answer questions users may have, hold live demonstrations, and collect feedback to produce more user resources. </p>\n\n\n\n<p>&#8220;By creating an environment that invites discussion, collaboration, and creativity, the content team was able to enforce content quality control standards on a massive scale while delivering a high-quality end-user experience.&#8221;</p>\n\n\n\n<p>Toothman said he was surprised and delighted by the creative ways authors utilized certain blocks.</p>\n\n\n\n<p>&#8220;Content authors figured out ways to use some of the custom Gutenberg editor blocks as design layout options and broke free of the content intention they were originally designed for,&#8221; he said.</p>\n\n\n\n<p>NASA will be open sourcing some of its custom blocks and other pieces of the project to give back to the WordPress community as part of the roadmap. The completed project stands as a high-profile testament to the agency&#8217;s confidence in the block editor and the wider ecosystem of available tools. It also highlights WordPress as a reliable CMS with exemplary adaptability for enterprise-level projects with complex publishing requirements.</p>\n\n\n\n<p>&#8220;For years, myself and many of us in the WordPress community have been mythbusting the perception from customer stakeholders in 2 areas: (a) WordPress isn’t enterprise. It’s just a blogging platform. (B) WordPress is not a secure CMS,&#8221; Toothman said.</p>\n\n\n\n<p>&#8220;While I don’t expect NASA choosing WordPress to wipe out those pre-existing perceptions, it is further evidence to support the fact that WordPress is enterprise class, and that it can meet security benchmarks.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 20:17:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Do The Woo Community: Thoughts on WordPress News, Resources and Paid Exposure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76771\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://dothewoo.io/thoughts-on-wordpress-news-resources-and-paid-exposure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:421:\"<p>How to get exposure from your WordPress product or service? There are many options, but also a lot of competition.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/thoughts-on-wordpress-news-resources-and-paid-exposure/\">Thoughts on WordPress News, Resources and Paid Exposure</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 11:52:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress 6.4 Font Library Feature Punted to 6.5 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149884\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/wordpress-6-4-font-library-feature-punted-to-6-5-release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5306:\"<p>The WordPress 6.4 release squad has decided to <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696525101347939\">punt the planned Font Library feature to 6.5</a> after core maintainers found major gaps in the Font APIs that cannot be resolved in time for the upcoming release.</p>\n\n\n\n<p>&#8220;I am currently reviewing the font APIs <a href=\"https://github.com/WordPress/wordpress-develop/pull/5285\" target=\"_blank\" rel=\"noreferrer noopener\">PR</a>,&#8221; WordPress REST API co-maintainer Jonny Harris said. &#8220;I must say, I am very worried about the PR in its current state. The code simply doesn&#8217;t follow the WP core code style and doesn&#8217;t feel WordPress.&#8221; He listed a number of problems he found with the feature:</p>\n\n\n\n<ul>\n<li>Limited developer API. We need functions like <code>wp_insert_font</code> / <code>wp_create_font</code> etc.</li>\n\n\n\n<li>Lack of filter or actions</li>\n\n\n\n<li>No way to unregister font collections</li>\n\n\n\n<li>Capabilities. Creating new fonts should have capabilies and not simply map to&nbsp;<code>edit_theme_options</code></li>\n\n\n\n<li>Confusing API structure.&nbsp; Collection should have embedded font objects</li>\n\n\n\n<li>What happens to fonts when collections are unregistered?</li>\n\n\n\n<li>If fonts are stored as post object, can I query to get all fonts from a collection?</li>\n\n\n\n<li>Are fonts deleted when the user is deleted?</li>\n\n\n\n<li>No way to filter where a font is stored</li>\n</ul>\n\n\n\n<p>&#8220;With time very limited in this release, it feels like actioning the above, feel like it is going too hard to achieve in this release,&#8221; Harris said.</p>\n\n\n\n<p>&#8220;I think this feature needs some more time to bake.&#8221;</p>\n\n\n\n<p>Harris said none of the REST API maintainers were involved in the early stages of the Font Library feature and they are currently &#8220;playing catch up.&#8221; The team was attempting to patch the existing design, but Harris said if a redesign of the API is planned, he would like to understand the requirements for the feature before drawing up a design.</p>\n\n\n\n<p>Punting a flagship feature is never an easy decision, but it&#8217;s far more preferable than shipping poorly designed API&#8217;s that don&#8217;t allow users to modify and disable the feature to fit their needs.</p>\n\n\n\n<p>&#8220;No is temporary but yes is forever,&#8221; WordPress core committer Aaron Jorbin said. &#8220;Once the code is merged into core for release, it’s something that needs to be maintained for our extenders forever. To me, the concerns I see being raised about how people will extend the feature are enough to punt the feature.&#8221;</p>\n\n\n\n<p>The Font Library feature was put forward late in the release cycle, landing in <a href=\"https://wptavern.com/gutenberg-16-7-introduces-font-management\">Gutenberg 16.7</a> last week, with very little time for testing.</p>\n\n\n\n<p>&#8220;Features have landed after beta 1 in the past,&#8221; WordPress core committer Jonathan Desrosiers said. &#8220;But my preference is to <em>not</em> land something with this much outstanding feedback. We&#8217;d be making last minute changes and merging for public release with very little actual testing. Sure, everyone here would test as best they can. But &#8216;in the wild&#8217; WordPress testing is much different and always uncovers some strange use cases or issues that we can&#8217;t foresee.&#8221;</p>\n\n\n\n<p>Contributors briefly considered delaying the release date to allow the feature more time but the consensus was for punting to 6.5, with the decision anchored in <a href=\"https://wordpress.org/about/philosophy/\">WordPress&#8217; philosophy</a> of &#8220;deadlines are not arbitrary.&#8221;</p>\n\n\n\n<p>&#8220;Changing a scheduled release date to leave room for finalizing a feature—no matter its priority—should not be considered,&#8221; WordPress core committer Joe McGill said. &#8220;This would not be the first time that we really hoped to have a feature shipped in a release but delayed it to the next release. It seems to me that a lot of effort has gone into preparing this feature for release and the consensus is that folks need more time to get it into a state that is ready to ship in a major WordPress release, which I know is disappointing, but also speaks to the care and quality folks want to ensure we put into these releases. If it&#8217;s not ready, it&#8217;s not ready. Let&#8217;s delay it — meanwhile we are still getting valuable user feedback via the Gutenberg plugin, which is a good thing.&#8221;</p>\n\n\n\n<p>WordPress 6.4 release lead Josepha Haden Chomphosy made the difficult <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696522535253159\">decision to punt the feature</a> based on contributor feedback. The removal of the Font Library does not affect other key features anticipated to land in the release. Jessica Lyschik, 6.4 default theme co-lead, <a href=\"https://wordpress.slack.com/archives/C02RQBWTW/p1696525030439049\">confirmed</a> the Font Library isn&#8217;t a requirement for Twenty Twenty-Four. The theme will ship with preselected fonts that get loaded from the theme assets, just like previous default themes.</p>\n\n\n\n<p>WordPress 6.4 Beta 3 is scheduled for October 10, 2023. This will be the last scheduled beta before RC1. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Oct 2023 02:41:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"Do The Woo Community: The Contributor Orientation Tool with Milana Cap and Aleksandar Predić\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76765\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://dothewoo.io/contributor-orientation-tool-with-milana-cap-and-aleksandar-predic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:471:\"<p>The Contributor Orientation Tool on WordPress.org. How this tool came to be, how it has evolved and its future for helping contributors.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/contributor-orientation-tool-with-milana-cap-and-aleksandar-predic/\">The Contributor Orientation Tool with Milana Cap and Aleksandar Predić</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Oct 2023 10:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: #93 – Piermario Orecchioni on How and Why WordPress Gets Translated\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=149789\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/podcast/93-piermario-orecchioni-on-how-and-why-wordpress-gets-translated\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:45768:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how and why wordPress gets translated.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Piermario Orecchioni.</p>\n\n\n\n<p>Piermario a freelance web designer resides in Italy, and is deeply involved in the global WordPress community. His journey with WordPress began in early 2017, when he created his wordpress.org account. Among his many contributions Piermario has focused primarily on the Polyglots team, which, if you didn&#8217;t know, deals with translations. His dedication and involvement in this aspect of the WordPress community have been important to him, and he shares more about his experiences with the team and how they work.</p>\n\n\n\n<p>Piermario begins by questioning the moral and legal obligations of making websites available in multiple languages. Is it simply a nice thing to do, or are they legal reasons behind it? He sheds light on the importance of language localisation, especially when WordPress is used on government websites to provide user centric experiences.</p>\n\n\n\n<p>But translating websites comes with its own set of challenges, and we discuss the difficulties in translating and reviewing strings in WordPress, where slight changes can lead to a large number of strings needing translations. He emphasizes the need for maintaining consistency, and standards in translations by having a glossary in each language.</p>\n\n\n\n<p>We then talk about Piermario&#8217;s journey as a contributor to the Polyglots team. He highlights recent improvements in the translation process, thanks to the GlotPress translation platform.</p>\n\n\n\n<p>We get into how the project is always on the lookout for new contributors, and discuss how they can become editors for specific projects, if their translations meet the required quality standards.</p>\n\n\n\n<p>We delve into the intricacies of language variations and the importance of localised translations. Piermario reiterates that coding expertise is not necessary for this work. Even newcomers with a curious mind and a willingness to help can contribute meaningfully. He paints a picture of how the work of translation is both accessible and beneficial, where short portions of text can be tackled in small amounts of time.</p>\n\n\n\n<p>We end with a discussion of the ongoing projects being translated, such as Learn and Openverse, which aims to reach a larger audience and make WordPress education accessible in multiple languages.</p>\n\n\n\n<p>Piermario shares insights into the Italian WordPress community, and the process of translating plugins and themes.</p>\n\n\n\n<p>So if you&#8217;re looking to help out translating WordPress, or just interested in hearing about a way that you can contribute, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Piermario Orecchioni.</p>\n\n\n\n<p>I am joined on the podcast today by Piermario Orecchioni. Hello!</p>\n\n\n\n<p>[00:04:31] <strong>Piermario Orecchioni:</strong> Hey. Hi Nathan. How are you doing?</p>\n\n\n\n<p>[00:04:33] <strong>Nathan Wrigley:</strong> Yeah really nice. Thank you for joining me on the podcast today. We&#8217;re going to stray into a subject which, I confess, as I often do on these episodes, it&#8217;s an area that I don&#8217;t really know a great deal about. So hopefully Piermario will be able to school me all about this.</p>\n\n\n\n<p>I was introduced to Piermario, I don&#8217;t know if he knows this, but it was Courtney Robertson that pointed me in your direction because she thought it would be fascinating on the WP Tavern Jukebox podcast to have an episode all about Polyglots and the Polyglot team. So that&#8217;s what we&#8217;re going to do today. That is the endeavor.</p>\n\n\n\n<p>Before we do that though, Piermario, I wonder if you wouldn&#8217;t mind just giving us two or three minutes of your time explaining, who you are, where you live, what your involvement is with WordPress. And I guess, importantly what your relationship is with Polyglots, translations, and the team that&#8217;s helping with that endeavor.</p>\n\n\n\n<p>[00:05:28] <strong>Piermario Orecchioni:</strong> Yeah. First of all, thanks again for having me, and thanks to the ever amazing Courtney for just making my name.</p>\n\n\n\n<p>In the everyday life I am a freelance web designer and besides that I&#8217;m part of the Italian and international WordPress community.</p>\n\n\n\n<p>I started contributing in, I think early 2017, was the time when I started my wordpress.org account. And I&#8217;ve been mainly contributing to the Polyglots team for reasons that we&#8217;ll cover soon.</p>\n\n\n\n<p>Over the course of the years I picked into other teams, like there&#8217;s a lot to be done in WordPress. Being not a native English speaker, so having access to bits and parts of WordPress that are not always translated. Everything must undergo some form of translation to allow people like me, and poeple that don&#8217;t speak English, to use it in a more comfortable way. So that&#8217;s what kept me going, and it&#8217;s still why I contribute to this day.</p>\n\n\n\n<p>[00:06:40] <strong>Nathan Wrigley:</strong> Oh thank you. That&#8217;s really nice. I should probably stress at the beginning that maybe there&#8217;s a line to be drawn between translating the front end of a website, and translating the backend, WordPress itself. The software that may download from .org.</p>\n\n\n\n<p>We&#8217;re probably, if you&#8217;re a WordPress user for any length of time, you&#8217;re probably aware that there&#8217;s a bunch of third party plugins which will handle the translations of say text on your homepage, or any other page or post from one language to another, and you&#8217;ve probably come across some of those. There&#8217;s a variety of them in the ecosystem.</p>\n\n\n\n<p>But this is not that. Polyglots is more about the backend. Translating WordPress. At least I think that&#8217;s the case.</p>\n\n\n\n<p>[00:07:27] <strong>Piermario Orecchioni:</strong> Well actually Polyglots, and the whole Polyglots team, is responsible, if we want to use a big word. But it actually touches all the WordPress ecosystem and touch points, because we translate WordPress Core. We translate and localise, which sometimes it&#8217;s a more appropriate term. Like the bundle teams, like every standard team that comes with a new release of WordPress. We also do that.</p>\n\n\n\n<p>We translate and contribute to plugins, like all the plugins that exist in some language and must be translated, go somehow, somewhere through a polyglots. A polyglots that localised it. Localises that plugin into their own language.</p>\n\n\n\n<p>We also translate what we call Rosetta. That&#8217;s kind of an internal lingo. But Rosetta is just like the stone. It&#8217;s basically every localised version of wordpress.org, like the Italian wordpress.org, Spanish wordpress.org. So we&#8217;re basically everywhere the WordPress ecosystem needs a translation.</p>\n\n\n\n<p>[00:08:44] <strong>Nathan Wrigley:</strong> Yeah now that you say that it makes so much sense. I for some reason hadn&#8217;t managed to parse that. But of course the wordpress.org website needs translating, and of course there needs to be attention given over to plugins and things like that. So yeah, that&#8217;s great. Thank you for clarifying that. It does seem like there&#8217;s a lot of work to be done, and we&#8217;ll touch upon that in a moment.</p>\n\n\n\n<p>Slight aside, for somebody that is an English speaker the word polyglots is quite an unusual one. I mean, I can imagine it&#8217;s broken up into two parts. Poly I guess meaning multiple, more than one. But do you have any indication of what the glots bit means? I&#8217;m guessing it&#8217;s got something to do with language, but in all my years I&#8217;ve never just heard that word in an isolated environment. I&#8217;ve never heard anybody talk about a glot.</p>\n\n\n\n<p>[00:09:31] <strong>Piermario Orecchioni:</strong> Yeah, a glot is, now I didn&#8217;t do my homework. It definitely means language but I don&#8217;t remember if it&#8217;s Latin or Greek. I would guess Latin.</p>\n\n\n\n<p>[00:09:42] <strong>Nathan Wrigley:</strong> Well that&#8217;s the meaning anyway. If we collide those two bits, multiple languages is really kind of what it means.</p>\n\n\n\n<p>Let&#8217;s talk about the actual endeavor of doing this work then. And although it seems like a fairly basic question, this question could go in multiple directions. So I&#8217;ll just ask the question, then I&#8217;ll give you some more context on that.</p>\n\n\n\n<p>Why do we need there to be translations in our website? So that&#8217;s the basic question, and then I&#8217;ll pad it out a little bit more. What I mean by that is, is it just kind of like a morally decent thing to do to have something like WordPress, which is obviously downloaded across the globe millions of times. Is it just a nice, good thing to do to make it available to as many languages as possible?</p>\n\n\n\n<p>Or perhaps there is something a bit more pressing. In other words maybe there&#8217;s legal things which come into play. I don&#8217;t know if you have any insight into either of those things, but obviously it is a nice thing to do. But I also wonder if as a piece of software which is shipping, albeit an open source piece of software, I don&#8217;t know if there&#8217;s any legal compulsion to have it translated.</p>\n\n\n\n<p>[00:10:49] <strong>Piermario Orecchioni:</strong> I don&#8217;t think there is a legal obligation or some sort of legal requirement to have WordPress translated. Obviously if you use WordPress on a government website, the plugins or components you&#8217;re using should be localised into the language users will be using because that&#8217;s just user centricity 101.</p>\n\n\n\n<p>I think that the simple reason why WordPress must, and wants to be, translated into possibly any language in the world is that we like to make this tool available to anybody, anywhere for whatever reason. The more we make WordPress available in somebody&#8217;s native language, the higher the chance that they will use it, and they could start something.</p>\n\n\n\n<p>I think it&#8217;s just one of the few left idealistic things of the web. Do things for the common good, and having WordPress in your language definitely is quite something. And I was just digging a little bit into the Polyglots pages yesterday on the WordPress site, and one of the bits I found is that, as of June 2020, roughly 55% of all WordPress websites running were not running in English.</p>\n\n\n\n<p>[00:12:17] <strong>Nathan Wrigley:</strong> That&#8217;s a big statistic, isn&#8217;t it? Yeah I did not know that number. That&#8217;s extraordinary.</p>\n\n\n\n<p>[00:12:22] <strong>Piermario Orecchioni:</strong> I might even argue it&#8217;s even higher by now because in three years we improved and we have way more translation available by now. But it&#8217;s true that English is the international language, but it&#8217;s also true that there&#8217;s a lot of people that does not English, or are not fluent enough to go into a backend of a site and deal with that, if that&#8217;s not in their language. So with the translation we remove this barrier and we make WordPress available to everybody.</p>\n\n\n\n<p>[00:12:58] <strong>Nathan Wrigley:</strong> So let&#8217;s dig into the work of the team, the Polyglots team, the people who are translating. I noticed incidentally that you use the word locale a little bit. And so I guess these terms are interchangeable, if anybody&#8217;s listening and not quite sure what that word might mean.</p>\n\n\n\n<p>So let&#8217;s start, let&#8217;s begin with the number of languages that WordPress has been translated into. Again, sorry I&#8217;m putting you on the spot. I haven&#8217;t actually primed you to know these facts, but I&#8217;m curious as to which languages seek attention, and indeed if there&#8217;s any kind of order there.</p>\n\n\n\n<p>So you mentioned English, obviously that&#8217;s a very large language. I&#8217;m guessing you could pick the names of a dozen or more other equally large languages where you know there&#8217;s millions and millions of people. But I guess as you go slowly down that order the languages have less people, and I do wonder, are there any which are just being implemented for the first time? Or ones that you tackle later? Ones that you give more importance to? So yeah, just that question to begin.</p>\n\n\n\n<p>[00:14:01] <strong>Piermario Orecchioni:</strong> I think that the importance is relative and it&#8217;s given by the amount of people that contributes to that language. And just as I was saying, in the bit I saw yesterday, this page which most likely was last updated in 2020, speaks about 172 languages.</p>\n\n\n\n<p>But, I found there&#8217;s another interesting link which is make.wordpress.org/polyglots/teams, which lists all the locale. And I&#8217;m going to get into that a little bit right after this. And that lists, as of today, 208 locale. A locale is, it&#8217;s kind of a polyglots lingo, but it&#8217;s basically, let&#8217;s say the combination of a language code, a regional code, and peculiarities that make even a variation of a language different.</p>\n\n\n\n<p>For example, even if we take English, we have American English, we have British English, we have Australian and so on. Or Spanish, there&#8217;s the Spanish spoken in Spain but then there&#8217;s the whole of South America. So even the translation of WordPress is not in one single version of Spanish, but it&#8217;s localised. So it&#8217;s made closer and we strive to make it as familiar as possible to every local speaker.</p>\n\n\n\n<p>I translate only in Italian, but all the contributors that work on every language can pick their very specific language. Because there&#8217;s obviously have like hundreds of millions of speakers. But in the locale list you&#8217;ll find languages or dialects with like one contributor. So somebody who just started translating WordPress in their own dialect or regional language. Great. It&#8217;s a lot of work, but it&#8217;s possible. So we have the tools to make that happen.</p>\n\n\n\n<p>[00:16:12] <strong>Nathan Wrigley:</strong> That&#8217;s absolutely fascinating. I run up against this, actually. Curiously, because I&#8217;m British, there&#8217;s quite a few differences in the way that the translations that I have to do, the transcriptions for this podcast. And there are some words which are spelt in American English differently. So typically, for example, they use a zed or a zee character at the end of a word, like customise might have a Z or a Z at the end. Whereas in British English we&#8217;d replace that with an S. And I&#8217;m always confused as to how I should translate things for this podcast, because I never know, should I just stick with what I would use? Or should I try to think more about broader audience?</p>\n\n\n\n<p>In the end I settled on just having it done in the way that I would spell it, because then I can spot those mistakes more or less automatically. Whereas if it&#8217;s looking for a spelling error in American English I may not be able to pick that up. But thank you for clarifying that. So we now know difference between locales, and the fact that that obviously complicates the job of translating WordPress even more.</p>\n\n\n\n<p>Who does this work? And, is there a base language which it&#8217;s built upon? So as an example, is WordPress originally created in, let&#8217;s say, American English? And then the translation team, they get their hands on it and they begin from that baseline of that language to make the translations where necessary.</p>\n\n\n\n<p>Perhaps it&#8217;s not done that way. So yeah just tell us how it&#8217;s done, what the process is and who is doing it? And I don&#8217;t mean names I mean, who are the people? Bunch of volunteers I&#8217;m guessing just like much else in WordPress.</p>\n\n\n\n<p>[00:17:49] <strong>Piermario Orecchioni:</strong> Yeah I think it all starts with the American English version. Since 2010, I did my homework here, we do have a platform which is called, we call it Translate but it&#8217;s actually based on a system called GlotPress which is developed and maintained by the WordPress community.</p>\n\n\n\n<p>Anybody can go to translate.wordpress.org and pick and choose basically. So if you go there you can start by choosing the language you want to translate, or help with. And then once you pick the language you can pick what you would like to help with. So you can suggest translations into the WordPress Core, a plugin, a theme, or really anything that&#8217;s available. For example, other projects that we translate are like Open Verse which has been growing fast over this last years.</p>\n\n\n\n<p>New, very interesting things like Learn WordPress. That&#8217;s all in the process of being translated and made available to a larger audience, because even Learn WordPress, it&#8217;s kind of new at least in the form it has now. But it could potentially open the doors of WordPress education to everybody virtually in any language, and make WordPress education available for free to anybody. So there&#8217;s a lot of work being done on that as well.</p>\n\n\n\n<p>[00:19:28] <strong>Nathan Wrigley:</strong> That&#8217;s really fascinating, because as a consumer of WordPress news, I love it when these new initiatives come along. So you know Open Verse is a perfect point, and the new revamped, revitalized efforts into Learn and all of that. I&#8217;m just looking at it and thinking oh that&#8217;s brilliant, look there&#8217;s loads of new resources.</p>\n\n\n\n<p>And of course completely forgetting the part that you&#8217;ve got to play, your team, the team has got to play in order to make that available to everybody else. So it kind of seems like this is a hamster wheel which just gets faster and faster all the time. I&#8217;m guessing there&#8217;s never less translations to be done, there&#8217;s only more translations to be done as new ideas and new initiatives and new projects come with the growth of WordPress.</p>\n\n\n\n<p>[00:20:12] <strong>Piermario Orecchioni:</strong> Yeah, yeah. There&#8217;s always new translations or even projects. The project that personally I really hold close to my heart is the Italian localisation of the Gutenberg plugin, because it&#8217;s really one of the first project where in the Italian community somebody gave me the responsibility to kind of take care of that.</p>\n\n\n\n<p>So even to this day, but for some time, I was really focused on maintaining and you know helping people come on board to help translate Gutenberg, and have it as close to a hundred percent of translated strings.</p>\n\n\n\n<p>Our unit of thinking is string. We could go into that like super quickly. But basically anything you use in WordPress that you find on translate.wordpress.org is conveniently listed as endless, or less endless, series of strings that must be translated to have a hundred percent of the English content of that specific project or plugin, or anything translated into your language.</p>\n\n\n\n<p>So even projects like Gutenberg that, yay, a hundred percent. So we have like three minutes to celebrate because Gutenberg comes out every two weeks. So every two weeks, the strings are added or different or wait, there&#8217;s parts of the full site editing experience that now are called differently. Like we&#8217;ve seen now I didn&#8217;t prepare any examples, but I mean even going to what&#8217;s current, like 6.3 has synced patterns.</p>\n\n\n\n<p>[00:22:03] <strong>Nathan Wrigley:</strong> Right. Reusable blocks became synced patterns.</p>\n\n\n\n<p>[00:22:05] <strong>Piermario Orecchioni:</strong> We&#8217;re kind of starting to, let&#8217;s translate and do our best every time we translate. But let&#8217;s also, especially when it&#8217;s something so fluid and so fast moving as the whole new block themes, full site editing effort. Let&#8217;s just make the best we can do because it might change in weeks or months, or when we find a better way to communicate that or market that.</p>\n\n\n\n<p>[00:22:36] <strong>Nathan Wrigley:</strong> That&#8217;s really interesting. So I&#8217;ve learned a couple of things. We have this expression by the way in the UK and the expression goes, it&#8217;s like painting the Forth Bridge. There&#8217;s this very long bridge in Scotland, and there is a team of people who paint it. And because of its great length it takes them you know multiple years to get from one end to the other. And you can guess what happens. As soon as they the end they just start right over again at the far end that they, you know, a couple of years ago began. And so this process of painting never ends, and thus it is with the project that you are talking about.</p>\n\n\n\n<p>But also what I learned there was that the translations are sort of grouped into blocks. And I don&#8217;t mean blocks as in a WordPress block, I mean groups of things. So Gutenberg, that is an object if you like, that needs translating. And you can achieve a hundred percent of that, albeit that&#8217;s an example which is constantly changing and probably never quite stays at a hundred percent for particularly long because it&#8217;s constantly in flux.</p>\n\n\n\n<p>So I&#8217;m guessing that there are other groups like that. And I&#8217;m wondering if some of those things receive more importance. So as an example, something like Gutenberg which has become really the bedrock of WordPress, I&#8217;m guessing that when a new version of WordPress comes out, let&#8217;s go with a new version of WordPress rather than the plugin itself for Gutenberg. When a new version of WordPress comes out, 6.3.</p>\n\n\n\n<p>Do you have to sort of drop the translations temporarily of other things, so that you can make sure that that ships perfectly? Or at least as perfectly as you can. Do you have some sort of system of saying, okay this is the important thing for this week or this month, and some of these things may have to wait? Is there an overarching authority that makes all that happen? Or is it really just left to the contributors to decide what they&#8217;re going to do and when they&#8217;re going to do it?</p>\n\n\n\n<p>[00:24:23] <strong>Piermario Orecchioni:</strong> It&#8217;s really left to the community but we set ourselves with priorities, like when a new major version of WordPress is about to be released, lets focus on that. We do not forget Gutenberg for a few weeks, but we just focus on getting all the strings for the new version translated. Usually after a few release candidates there&#8217;s like a string freeze. At that point nothing is moving. At that moment we just check what&#8217;s left to translate and what needs our attention.</p>\n\n\n\n<p>In a way the beauty of this is that the WordPress Core and Gutenberg are so tightly related that they&#8217;re constantly above I would say 90, 95%. Like we hardly drop, as I&#8217;m talking about Italian localisation, but we hardly drop below 98% of translated strings. Sometimes we have like 50 new strings, or a hundred strings that need to be translated or reviewed because something has been slightly changed or synced pattern.</p>\n\n\n\n<p>[00:25:38] <strong>Nathan Wrigley:</strong> That&#8217;s a good example at the moment, isn&#8217;t it? Because can you imagine how many times the word, in English, reusable blocks would appear on all of the .org properties? I mean I&#8217;m guessing it&#8217;s multiple thousands. The idea of going back and changing that in, not just WordPress Core but also in, like you say, the Learn materials and the documentation for WordPress. It&#8217;s a big search and replace, isn&#8217;t it?</p>\n\n\n\n<p>[00:26:02] <strong>Piermario Orecchioni:</strong> Well in a way it could be, but we do have a few tools. We have many tools but two of the tools that are really our bread and butter as Polyglots team is the, like every locale, every language has it&#8217;s own glossary which is the reference for translating WordPress into your language. Because the Polyglots team of each country is also responsible for choosing what&#8217;s the standard translation for an English term.</p>\n\n\n\n<p>In Italy we do have this tendency to gleefully adopt English terms, which is fine by me in some cases, because I speak English. But not everybody is as tech savvy or has a specific knowledge of English that allows them to make sense of any English term you want to squeeze into a plugin translation or something, so we have to set boundaries.</p>\n\n\n\n<p>For example, one we always use when we onboard new contributors to the Italian community, is that the Italian translation of a post, like blog post, it&#8217;s articolo. It&#8217;s like article. Which kind of makes sense, but at the same time we do recognise that&#8217;s kind of weird in a world where any social media bit you publish is a post. So people are now familiar with the word post. So why don&#8217;t we just use it in WordPress? Because somebody years ago decided that we go with articolo and until, perhaps there&#8217;ll be in x time, a real reason to drop that translation that we set as standard, we&#8217;ll go with that.</p>\n\n\n\n<p>But having a glossary also allows you to create much more consistent translations. So I like to say, we like to say, that polyglots, it&#8217;s really probably or maybe just because we want to float our boat. It&#8217;s probably the easiest team to get involved with if you want to help in the WordPress community, because you don&#8217;t necessarily need to know coding. You don&#8217;t necessarily need to be an expert.</p>\n\n\n\n<p>Even in WordPress you could be a regular new user. Just have curiosity and will to help, and you can start pretty much anywhere. And when somebody&#8217;s new and it&#8217;s starting, all the entries that are in the glossary are already highlighted so that we help somebody suggesting new translation to stay consistent, and use the same terms that we already used over and over in tens, hundreds, thousands of strings all around the WordPress ecosystem.</p>\n\n\n\n<p>[00:29:09] <strong>Nathan Wrigley:</strong> I guess also, unlike many of the other teams, the enterprise of the work is fairly obvious in that you know that what you&#8217;ve got to do is look at one language, translate it into the other language, as best as you can, and rinse and repeat. So the enterprise is fairly straightforward.</p>\n\n\n\n<p>And I&#8217;m also guessing that it&#8217;s fairly atomised. What I mean by that is there&#8217;s going to be portions of text which are relatively short. So it&#8217;s the kind of thing that you could dip in and out of. Whereas maybe some of the other teams, the approach would have to be much more, you know this thing is going to take hours and hours and hours. With translations, I could be wrong forgive me if I am, but it feels like if you had the inclination you could dip in for several minutes and still achieve something valuable, but it would only have consumed a few minutes of your day which most people could probably find.</p>\n\n\n\n<p>[00:30:08] <strong>Piermario Orecchioni:</strong> Absolutely. Like I always keep some projects handy instead of playing wordle for the day. I open a plugin or something I&#8217;m curious about, or I want to help make available in Italian, and just punch in a few strings. But it&#8217;s really for everybody, like this is the message. It&#8217;s really for everybody and there&#8217;s no way you can break the internet by contributing because there&#8217;s like levels of contributors in the Polyglots team.</p>\n\n\n\n<p>[00:30:41] <strong>Nathan Wrigley:</strong> I was going to ask this. I thought this was an important point.</p>\n\n\n\n<p>[00:30:44] <strong>Piermario Orecchioni:</strong> So it&#8217;s safe, and can be really, you can take it as a game. Because if you have a wordpress.org account you can go, log in on translate.wordpress.org, pick a project and start suggesting translation for any project.</p>\n\n\n\n<p>So in that case you&#8217;ll be contributing to a translation, but at that point you are not an editor for that specific project. So basically if somebody who just discovered that they can do this thing suggests a translation, an editor, and we have two main categories of levels of editors, they can review the translation and approve it. And now that bit of WordPress is yours. Like you contributed to WordPress and it&#8217;s the best feeling.</p>\n\n\n\n<p>And usually, this is just a silly thing, but when a major version is coming out if you participate in translating the new strings for the new Core version, like 6.3 just few weeks ago. If your translation is approved you also get the warm fuzzy feeling of having your name in the WordPress translation credits.</p>\n\n\n\n<p>[00:32:11] <strong>Nathan Wrigley:</strong> That&#8217;s nice. I was curious about that because obviously the capacity to go in with your wordpress.org account and then just, well for want of a better word, and I hope it doesn&#8217;t happen all that often, but just to cause mayhem. Unless there was some sort of editorial hierarchical approach, where things entered a pending queue and then somebody with presumably more backstory in the translation team. So the longer you&#8217;ve been there, the more kudos you&#8217;ve built up, if you know what I mean, presumably the more responsibility you get.</p>\n\n\n\n<p>I would imagine that that&#8217;s probably really required. You need people who are going to get a notification or something to say okay things have been amended, go back, have a look. And so they may not be involved in doing all the translations, but they&#8217;re presumably the ones that get to say actually that one looks fine, move on. That one looks fine. Hold on a minute there&#8217;s something weird there, let&#8217;s not publish that one. Something seems to be weird. Let&#8217;s just reverse it and go back to what we had previously. So there&#8217;s those processes going on.</p>\n\n\n\n<p>[00:33:13] <strong>Piermario Orecchioni:</strong> Yeah It&#8217;s actually something we&#8217;re continuously trying to improve because in a nutshell, there&#8217;s like regular contributor, like somebody that comes in and for example, right now one of the things we are working on is the Italian translation of the new Italian WordPress website. Because if you go to the Italian website today it does not look like the English version, because the theme was not made available yet. But it&#8217;s about to be available once the translation is completed.</p>\n\n\n\n<p>So when I started with other contributors to translate that weeks ago, many strings were just version numbers. Like the page where WordPress versions are listed is version numbers, dates, and jazz musicians. So you don&#8217;t need to have like a specific knowledge of either English or jazz history or anything else to know that you can help with that bit of the translation.</p>\n\n\n\n<p>So when it comes to other projects obviously there&#8217;s like hundreds, and possibly thousands, I would leave the possibly out because there&#8217;s thousands of plugins in the WordPress plugin repo. So everybody wants to be translated in other languages.</p>\n\n\n\n<p>So at the top, let&#8217;s say with many quotes, at the top of the editor&#8217;s pyramid in the Polyglots team, that&#8217;s what we call GTEs, General Translation Editors, of which I&#8217;m one for the Italian team. Basically we have the power slash responsibility to proof and edit any string on any project related to WordPress. We can approve somebody&#8217;s suggested translation. We can edit a translation if something&#8217;s wrong or improper terms have been used in some way.</p>\n\n\n\n<p>But one of the improvements we&#8217;ve been doing, thanks to the team that develops GlotPress, and the whole platform that powers the translations, is that for probably less than a year we now have like a feedback tool. When somebody suggests a translation, as an editor you now have a field where you can ask the person to make some changes. Like, can you please change this because? Like check the glossary. You know, you can give them a hint on how to improve their translation.</p>\n\n\n\n<p>As new contributors get better at translating, and we see that their contributions are of course always welcome but the quality is good. If you want and if you show that your translation meets the standard we&#8217;re aiming for, you can become an editor for a specific project, which is usually a plugin or a theme.</p>\n\n\n\n<p>So we have lots of people that are either developers that have a plugin that they want to translate into Italian. So they want to become editors for that project and that is called, that position let&#8217;s say, it&#8217;s called PTE like Project Translation Editor.</p>\n\n\n\n<p>If you are a PTE you can approve all the strings for that specific project. So we love when somebody comes in and adopts their favorite plugin or theme that is not yet translated into their own language.</p>\n\n\n\n<p>I think it&#8217;s a beautiful way of contributing. There&#8217;s several people I admire in the WordPress community. But people like Rich Tabor, Anders Noren who have been putting out for years themes for free for the community. Having those themes translated right away, or almost right away, when they&#8217;re released, I think it&#8217;s also our way of giving back, because I think it&#8217;s just a beautiful thing and it makes us community.</p>\n\n\n\n<p>[00:37:40] <strong>Nathan Wrigley:</strong> There&#8217;s a little bit of quid pro quo there, isn&#8217;t there? Which I guess you based upon the endeavors that you&#8217;ve put in in the past.</p>\n\n\n\n<p>I have a curious question in that, and again forgive me because of my English, as in British, proclivity. So I speak English, I confess in terms of any other language I have no skills whatsoever, so it may very well be that this team is kind of out of the question for me because I couldn&#8217;t manage to translate anything. But it makes me wonder, is it possible to pollinate languages outside of English into other languages?</p>\n\n\n\n<p>So let&#8217;s say, for example that the Italian translations, like you&#8217;ve just said it sounds like your auspices and the team that you are working with, that those translations in many cases are done fairly rapidly. Which means that the Italian strings and translations could be looked at fairly swiftly as complete. Now if I don&#8217;t speak English but I do speak Italian and Japanese for example, is it possible to go in that direction? There has to be no single language which you are feeding from. Can you go from one language to another without having to have, let&#8217;s say, English in the mix?</p>\n\n\n\n<p>[00:38:51] <strong>Piermario Orecchioni:</strong> Yeah I would say so. It&#8217;s something I&#8217;ve hardly done, but sometimes I have the same curiosity so I just didn&#8217;t follow what happened next after I suggested a string in like Spanish or French. Or I translated Louis Armstrong&#8217;s name into Norwegian let&#8217;s say .</p>\n\n\n\n<p>I didn&#8217;t follow up to see if that string was approved, because if for Core versions the approved strings go into a big bucket and you get like a credit in the WordPress credit page of your localised version. But if you go check any plugin and check the translation for a specific language you can see who translated that plugin.</p>\n\n\n\n<p>So somebody translated one string, somebody 200, and so on. So I think it&#8217;s quite possible that you can suggest a string in a language that is not yours, and if it&#8217;s correct that can be approved. I just didn&#8217;t follow what happened after that, but it&#8217;s possible.</p>\n\n\n\n<p>[00:39:58] <strong>Nathan Wrigley:</strong> Yeah thank you. Just before we round it out I guess would be good to talk about the team itself and how you think about that. And then maybe move on to talking about how you can become involved. So I&#8217;ve got a few questions around that.</p>\n\n\n\n<p>The first one is, are there enough people doing this work to make it so that you know you&#8217;re all just having a very nice time of it? There&#8217;s a few things to be done each day, or is it more a case, I guess you can speak to the Italian I don&#8217;t what it&#8217;s like elsewhere, but maybe as a part of the team you&#8217;ve heard discussions around this.</p>\n\n\n\n<p>Are there enough people or does the team feel undersubscribed? Are you on the lookout constantly for new people? And are there any languages that you know of in particular or locales that you know of in particular that are crying out for help?</p>\n\n\n\n<p>[00:40:44] <strong>Piermario Orecchioni:</strong> Well every language in any part of the world could use some help, definitely. We always have room for new people, and we&#8217;re very happy when folks join us so that we can do more in less time. And we&#8217;re happy when somebody joins and stays and is happy and gets rewarded by having their translations approved, and seeing that something is in your own language because you helped. That&#8217;s always great.</p>\n\n\n\n<p>Sometimes I think we tend to think about WordPress as this huge, giant project that will be there no matter what, and is translated into my language because it has to be. Like, how can it be not available in Italian or so? But then when you go and see the numbers, I think the active general translation editors for Italian are about 15 people.</p>\n\n\n\n<p>We have hundreds of contributors that range from somebody who translated two strings two years ago, to somebody that needs a plugin, like a specific plugin, localised because their business needs it. So they become editors and they contribute even just to that.</p>\n\n\n\n<p>But there&#8217;s always room for new people in, and there&#8217;s like grunt work and weekly meetings where we hold Slack meetings, as all the WordPress community does. And having more people on board means that somebody else can host a weekly meeting. Otherwise it&#8217;s like 2, 3, 4 of us that rotate and do that. And it&#8217;s a pleasure, but sometimes you have life in your way.</p>\n\n\n\n<p>We always make space for WordPress because we love the project, and it means so much to us. And to answer your question, the team itself, I think I can even speak beyond the Italian team, because like at Work Camp Europe I had the chance to meet other Polyglots from other countries, and the vibe is really good. Like it&#8217;s a non-competitive team. Anybody&#8217;s welcome, and in the Italian community we&#8217;re really kind of family. Like we have WhatsApp chats to check on each other, like we really develop friendly relationships. That&#8217;s part of what keeps us going, because you feel like part of a group that is nice to be around.</p>\n\n\n\n<p>[00:43:23] <strong>Nathan Wrigley:</strong> Yeah that&#8217;s really nice to hear. It does strike me as a very, well I mean this may sound obvious, but it&#8217;s a very communicative team, because you are basically dealing in communication. So it&#8217;s really nice to hear that.</p>\n\n\n\n<p>Just before we wrap up, you&#8217;ve said that there&#8217;s always a need for people to do this work. And you did, I think, mention it earlier but maybe it&#8217;s a good idea to mention it again. Where&#8217;s the best place to go to get involved? For somebody that&#8217;s never touched on this before, where would you direct them?</p>\n\n\n\n<p>[00:43:51] <strong>Piermario Orecchioni:</strong> The go-to place is always make.wordpress.org or wordpress.org. Somewhere in the navigation there&#8217;s either a make menu item or a get involved menu item. So just go there and pick your team. I would suggest Polyglots.</p>\n\n\n\n<p>But really, every team, there&#8217;s like photography team. It&#8217;s something that did not really exist until a few years ago, and you can contribute to WordPress moderating photography or send in your photography so that everybody could use nice, copyright free, pictures. There&#8217;s really a space for everybody to help in every way. We like to be open and welcoming in WordPress. That&#8217;s really what we love.</p>\n\n\n\n<p>[00:44:43] <strong>Nathan Wrigley:</strong> Thank you. And finally, last question. If people wanted to get in touch with you. You may have a social media platform that you prefer to use or email address or a website, whatever it may be. Where do we get in touch with you?</p>\n\n\n\n<p>[00:44:57] <strong>Piermario Orecchioni:</strong> I&#8217;m on Slack as @Piermario. So on the WordPress Slack anybody can message me on the Italian, and the international Slack just with @ my name. I would say on what&#8217;s left of Twitter, I do have a weird handle because Piermario was taken. So my Twitter handle or X handle is succoallapera, which means pear juice, because I&#8217;m an avid pear juice drinker. And I would say that&#8217;s about it.</p>\n\n\n\n<p>One day I will keep updating piermario.com, which I&#8217;m slowly rebuilding and using. Even as a kind of sandbox or block theme playground. But I have more ideas and drafts than actually published posts for now, but one day it&#8217;ll be more lively.</p>\n\n\n\n<p>[00:45:58] <strong>Nathan Wrigley:</strong> Piermario, thank you so much for chatting to us on the podcast about this really intriguing subject. I&#8217;ve learned a lot. Thank you very much for joining us.</p>\n\n\n\n<p>[00:46:06] <strong>Piermario Orecchioni:</strong> Thank you so much and thanks again for having me.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/succoallapera\">Piermario Orecchioni</a>.</p>\n\n\n\n<p>Piermario Orecchioni, a freelance web designer, resides in Italy and is deeply involved in the global WordPress community. His journey with WordPress began in early 2017 when he created his wordpress.org account. Among his many contributions, Piermario has focused primarily on the Polyglots team, which, if you didn’t know, deals with translations. His dedication and involvement in this aspect of the WordPress community have been important to him, and he shares more about his experiences with the team and how they work.</p>\n\n\n\n<p>Piermario begins by questioning the moral and legal obligations of making websites available in multiple languages. Is it simply a nice thing to do, or are there legal reasons behind it? He sheds light on the importance of language localisation, especially when WordPress is used on government websites, to provide user-centric experiences.</p>\n\n\n\n<p>But translating websites comes with its own set of challenges, and we discuss the difficulties in translating and reviewing strings in WordPress, where slight changes can lead to a large number of strings needing translations. He emphasises the need for maintaining consistency and standards in&nbsp; translations by having a glossary in each language.</p>\n\n\n\n<p>We then talk about Piermario&#8217;s journey as a contributor to the Polyglots team. He highlights recent improvements in the translation process, thanks to the Glotpress translation platform.&nbsp;</p>\n\n\n\n<p>We get into how the project is always on the lookout for new contributors, and discuss how they can become editors for specific projects if their translations meet the required quality standards.</p>\n\n\n\n<p>We delve into the intricacies of language variations and the importance of localised translations.</p>\n\n\n\n<p>Piermario reiterates that coding expertise is not necessary to this work; even newcomers with a curious mind and a willingness to help can contribute meaningfully. He paints a picture of how the work of translation is both accessible and beneficial, where short portions of text that can be tackled in small amounts of time.</p>\n\n\n\n<p>We end with a discussion on the ongoing projects being translated, such as Learn WordPress and Openverse, which aim to reach a larger audience and make WordPress education accessible in multiple languages. Piermario shares insights into the Italian WordPress community and the process of translating plugins and themes.</p>\n\n\n\n<p>So if you’re looking to help out translating WordPress, or are just interesting in hearing about a way you can contribute, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/polyglots/teams/\">Polyglots team</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/polyglots/handbook/for-locale-managers/rosetta-for-the-community/\">Rosetta</a></p>\n\n\n\n<p><a href=\"https://translate.wordpress.com/glotpress/\">GlotPress</a></p>\n\n\n\n<p><a href=\"https://translate.wordpress.org/\">Translating WordPress</a></p>\n\n\n\n<p><a href=\"https://openverse.org/\">Openverse</a></p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></p>\n\n\n\n<p><a href=\"https://www.piermario.com/\">Piermario&#8217;s website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Akismet: Lead Magnet Checklist: 12 Proven Steps &amp; Inspiring Examples\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=281108\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://akismet.com/blog/lead-magnet-checklist/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:32781:\"<p>Lead magnets are like the golden ticket to Willy Wonka&#8217;s Chocolate Factory. They&#8217;re the irresistible tease that offers specific value to a prospect. And, in exchange, they hand over their contact information. In other words, they generate&nbsp;leads. </p>\n\n\n\n<p>But creating an effective lead magnet is not just about slapping together a quick guide or checklist. It requires careful planning, an in-depth understanding of your target audience, and a keen eye for what makes your offer&nbsp;irresistible.</p>\n\n\n\n<p>And that&#8217;s where our lead magnet checklist will come in&nbsp;handy.</p>\n\n\n\n<p>We&#8217;ll walk you through 12 proven steps to create lead magnets that not only generate leads but also convert them into loyal customers. Then we&#8217;ll share some inspiring lead magnet examples to help you visualize the&nbsp;process.</p>\n\n\n\n<p>Let&#8217;s dive&nbsp;in.</p>\n\n\n\n<span id=\"more-281108\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">1. Clearly define your target&nbsp;audience</h2>\n\n\n\n<p>The cornerstone of a successful lead magnet is a well-defined target audience. It&#8217;s not about appealing to everyone, but rather understanding and catering to a specific demographic that aligns with your&nbsp;offer.</p>\n\n\n\n<p>Start by identifying their challenges. What are the issues they&#8217;re grappling&nbsp;with?</p>\n\n\n\n<p>A study by <a href=\"https://www.salesforce.com/resources/research-reports/state-of-the-connected-customer/\" target=\"_blank\" rel=\"noreferrer noopener\">Salesforce</a> found that 56% of customers expect offers to be personalized and tailored to their needs, considering these qualities a must to win their&nbsp;business.&nbsp;</p>\n\n\n\n<p>So by fully understanding these pain points, you can tailor your lead magnets to offer a solution, making them more enticing to your&nbsp;audience.</p>\n\n\n\n<p>But you should pay attention to your customers&#8217; <em>interests</em> as well. What are they passionate about? What type of content do they engage with? Aligning your lead magnet with these interests can enhance its&nbsp;reception.</p>\n\n\n\n<p>Specificity is key here. As Seth Godin famously said, &#8220;Everyone is not your customer.&#8221; The more precise you are when defining your target market, the more effective your lead magnet offer will&nbsp;be.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Example of a defined target&nbsp;audience</h3>\n\n\n\n<p>For instance, if you&#8217;re a WordPress security services company, your target audience is likely to be WordPress site owners worried about security. They might fear hacking, data loss, or website downtime and be interested in website management, digital security trends, and WordPress&nbsp;tips.</p>\n\n\n\n<p>A lead magnet offering a comprehensive guide to securing a WordPress site would likely resonate with this&nbsp;audience.</p>\n\n\n\n<p>Understanding your audience is pivotal in creating a high converting lead magnet. So, invest time in research and truly get to know&nbsp;them.</p>\n\n\n\n<h2 class=\"wp-block-heading\">2. Ensure your lead magnet solves a&nbsp;problem</h2>\n\n\n\n<p>The second step in our lead magnet checklist is to ensure it solves a real problem for your target audience —&nbsp;rather than just offering free&nbsp;stuff.&nbsp;</p>\n\n\n\n<p>Customers usually realize they have a problem before they actively start looking for a vendor to solve it. So, your early touchpoints shouldn’t be all about selling your company or listing product&nbsp;features.</p>\n\n\n\n<p>Instead, your lead magnet format should be designed to address these problems directly. It should offer a solution that is not only valuable, but also immediately actionable. The more effectively your lead magnets can solve a problem, the more likely your audience is to exchange their contact information for&nbsp;them.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Example of a lead magnet that solves a&nbsp;problem</h3>\n\n\n\n<p>For instance, if you’re a marketer promoting website design services, your offer might be an easy-to-follow guide on creating a high-converting website. Not only does it solve a real problem for your target audience, but also provides an actionable solution they can implement right&nbsp;away.</p>\n\n\n\n<p>However, it&#8217;s not enough to just solve a problem. Your lead magnet should do so in a way that positions your product or service as the ultimate solution. This is where the concept of the &#8220;tripwire&#8221; comes&nbsp;in.</p>\n\n\n\n<p>A <a href=\"https://www.activecampaign.com/glossary/tripwire-marketing\" target=\"_blank\" rel=\"noreferrer noopener\">tripwire</a> is a low-cost offer that gets customers in the door, which can then lead to more significant sales down the line. Solving a problem with your lead magnet can set up a tripwire, showing your audience that you can provide value and solve their problems, which can then lead to them becoming paying&nbsp;customers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">3. Offer information that’s not readily available&nbsp;elsewhere</h2>\n\n\n\n<p>In a world where information is just a Google search away, it&#8217;s vital to offer something unique to your audience. Your lead magnet should provide information that isn&#8217;t readily available elsewhere or presents it in a unique, more accessible, or more comprehensive&nbsp;way.</p>\n\n\n\n<p>According to a <a href=\"https://contentmarketinginstitute.com/2018/10/research-b2b-audience/\" target=\"_blank\" rel=\"noreferrer noopener\">study by the Content Marketing Institute</a>, 96% of highly successful content marketers stated that their audience considers their organization as a reliable and trustworthy source. They established this trust by creating unique and excellent quality content that is not available&nbsp;elsewhere.</p>\n\n\n\n<h3 class=\"wp-block-heading\">How to develop a reliable and trustworthy&nbsp;reputation</h3>\n\n\n\n<p>To build up such a reputation, you could offer an in-depth guide on a niche topic, a comprehensive case study with unique insights, or a proprietary tool or template that you&#8217;ve created. This exclusive content not only attracts your audience but also positions your brand as an industry&nbsp;expert.</p>\n\n\n\n<h2 class=\"wp-block-heading\">4. Create a strong, enticing&nbsp;headline</h2>\n\n\n\n<p>The headline of your lead magnet is often the first thing your audience sees, and it can make or break their decision to engage&nbsp;further.</p>\n\n\n\n<p>According to <a href=\"https://www.copyblogger.com/magnetic-headlines/\" target=\"_blank\" rel=\"noreferrer noopener\">Copyblogger</a>, on average, 8 out of 10 people will read headline copy, but only 2 out of 10 will read the rest. This underscores the importance of a compelling&nbsp;headline.</p>\n\n\n\n<p>Your headline should be clear, concise, and communicate the value of your lead magnet. It should tell your audience exactly what they&#8217;ll get and why it&#8217;s beneficial to them. A strong headline often includes a powerful action verb, a clear benefit, and a sense of urgency or&nbsp;scarcity.&nbsp;</p>\n\n\n\n<p><strong>Pro-tip: </strong>Sometimes, what works on social media may also grab attention on your site. Draw from your most successful social media ads when working on copy for your next set of great lead&nbsp;magnets.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Example of a strong, enticing headline and effective lead&nbsp;magnet</h3>\n\n\n\n<p>Take a look at this example from education brand <a href=\"https://heggerty.org/\" target=\"_blank\" rel=\"noreferrer&nbsp;noopener\">Heggerty</a>:</p>\n\n\n\n<img width=\"1600\" height=\"841\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-1.png\" alt=\"Heggerty homepage\" class=\"wp-image-281110\" />\n\n\n\n<p>Their website’s homepage features a compelling headline that’s simple, but captivating. It immediately summarizes what they can offer to their&nbsp;audience.</p>\n\n\n\n<p>But they also have a great offer on their banner that promotes a free download of special summer curriculum. It’s a great way to further develop their relationship with key prospects —&nbsp;educators in need to quality language&nbsp;curriculum.&nbsp;</p>\n\n\n\n<p>Remember the headline is where you make your first impression. So make it count by ensuring it&#8217;s compelling, clear, and communicates the value of your lead&nbsp;magnet.</p>\n\n\n\n<h2 class=\"wp-block-heading\">5. Encourage action with an irresistible&nbsp;CTA</h2>\n\n\n\n<p>A call to action (CTA) is the final nudge that propels the audience towards a desired action. It&#8217;s the climax of your content, the point where the audience decides to either engage further or move on. So it&#8217;s essential to get this right and make your CTA as irresistible as&nbsp;possible.</p>\n\n\n\n<p>There are multiple things you can do to craft an effective CTA. Let&#8217;s take a&nbsp;look.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Be explicit and&nbsp;precise</h3>\n\n\n\n<p>Your CTA should be unambiguous and precise about the next steps. Instead of a generic &#8220;Learn more,&#8221; opt for specific phrases like &#8220;Download our free guide now&#8221; or &#8220;Start your free trial today.&#8221; This clarity can guide your audience towards the desired&nbsp;action.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Instill a sense of&nbsp;urgency</h3>\n\n\n\n<p>A sense of urgency can prompt your audience to act immediately rather than delay. Phrases like &#8220;Limited time offer&#8221; or &#8220;Only a few spots left&#8221; can induce a fear of missing out (FOMO), encouraging immediate&nbsp;action.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Employ persuasive&nbsp;language</h3>\n\n\n\n<p>The language of your CTA should be compelling. Use powerful command verbs like &#8220;Discover,&#8221; &#8220;Join,&#8221; or &#8220;Start&#8221; to persuade your audience to take&nbsp;action.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ensure it stands&nbsp;out</h3>\n\n\n\n<p>Your CTA should be visually prominent. Use contrasting colors, large fonts, and sufficient white space around your CTA to make it stand out on the&nbsp;page.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Highlight the value&nbsp;proposition</h3>\n\n\n\n<p>Your audience is more likely to respond to your CTA if they perceive it as valuable. Emphasize the benefits they&#8217;ll receive by taking the desired&nbsp;action.</p>\n\n\n\n<p>The effectiveness of a CTA can significantly influence the success of your content marketing strategy, so spend time crafting and testing different CTAs to see what works best for your&nbsp;audience.</p>\n\n\n\n<h2 class=\"wp-block-heading\">6. Use bullet points to outline key benefits or&nbsp;features</h2>\n\n\n\n<p>Bullet points are a powerful tool in your lead magnet garage. They allow you to succinctly and clearly communicate the key benefits or features of your&nbsp;offer.</p>\n\n\n\n<p>But you&#8217;ll definitely want to keep them concise. Bullet points should be short and to the point. Avoid long, complex sentences. Your audience should be able to quickly scan the list and understand the value of your&nbsp;offer.</p>\n\n\n\n<p>And don&#8217;t use bullet points to lay out all the features of your offer. Focus on benefits instead. While features are important, what your audience really cares about is how your offer will benefit them. For example, instead of saying &#8220;Our eBook has 100 recipes,&#8221; say &#8220;Discover 100 meals that save time and impress&nbsp;guests.&#8221;</p>\n\n\n\n<p>Making use of action words is a must as well. Just as with your CTA, start your bullet points with action verbs to make them more engaging and persuasive. So phrases like &#8220;Boost your website traffic,&#8221; or &#8220;Transform your marketing strategy,&#8221; are good&nbsp;options.</p>\n\n\n\n<p>Vague promises won&#8217;t convince your audience to take you up on the offer. So be specific about what it includes. For example: &#8220;Learn the 5-step process to double your website traffic in 30&nbsp;days.&#8221;</p>\n\n\n\n<p>Finally, think about what makes your offer different from others. Highlight this in your bullet points to show your audience why your lead magnet is worth their&nbsp;time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">The goal of bullet points when promoting a lead&nbsp;magnet</h3>\n\n\n\n<p>Your goal here is to quickly communicate the value of your lead magnet and convince your audience to commit. So, make your bullet points clear, compelling, and focused on the benefits your audience will&nbsp;receive.</p>\n\n\n\n<h2 class=\"wp-block-heading\">7. Include social proof to build&nbsp;credibility</h2>\n\n\n\n<p>When people see others doing something, they assume it&#8217;s the right thing to do and follow suit. This is called social proof. Even for a good lead magnet that’s already performing well, having social proof can make it more credible and&nbsp;appealing.</p>\n\n\n\n<p>You can incorporate social proof into most lead magnets in a number of ways,&nbsp;including:</p>\n\n\n\n<ul>\n<li><strong>Testimonials</strong>. Include testimonials from satisfied customers who have benefited from your offer. Make sure these are specific and highlight the value of your lead magnet. For example, &#8220;This guide helped me double my website traffic in just 30 days!&#8221;</li>\n\n\n\n<li><strong>Case studies</strong>. If applicable, include case studies that demonstrate the effectiveness of your offer. Case studies provide concrete evidence of your claims and can be very persuasive.</li>\n\n\n\n<li><strong>Endorsements</strong>. If your lead magnet has been endorsed or reviewed positively by industry experts, influencers, or reputable sources, be sure to highlight this.</li>\n\n\n\n<li><strong>User statistics</strong>. If you have impressive user statistics, such as a large number of downloads, subscribers, or active users, include these in your lead magnet. This shows that your offer is popular and trusted by many.</li>\n\n\n\n<li><strong>Certifications or awards</strong>. If your offer or your company has received any certifications or awards, these can serve as strong social proof.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">An example of social proof when promoting a lead&nbsp;magnet</h3>\n\n\n\n<p>A great example of a few of these social proof tactics come from <a href=\"https://jayclouse.com\">Jay Clouse&#8217;s&nbsp;website</a>.</p>\n\n\n\n<img width=\"1000\" height=\"518\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-2.png\" alt=\"Jay Clouse website showcasing social proof\" class=\"wp-image-281111\" />\n\n\n\n<p>The home page includes some impressive user statistics, &#8220;Join 22,000+ creators&#8230;&#8221; as well as endorsements, &#8220;Called &#8216;Exceptional&#8217; by Weber, and &#8216;Delightful&#8217; by&nbsp;ConvertKit.&#8221;</p>\n\n\n\n<p>Social proof helps your audience see that others have found value in your offer, making them more likely to see its value, too. So, don&#8217;t be shy about showcasing your achievements and positive&nbsp;feedback.</p>\n\n\n\n<h2 class=\"wp-block-heading\">8. Create a sense of urgency or limited-time&nbsp;availability</h2>\n\n\n\n<p>Creating a sense of urgency or limited availability is a powerful psychological trigger that can significantly increase the conversion rate of your lead&nbsp;magnet.</p>\n\n\n\n<p>The simplest way to do this is to set up a limited-time offer. When you make your lead magnet available for a limited time, your audience may feel that they need to act quickly, or they&#8217;ll miss&nbsp;out.</p>\n\n\n\n<p>But you could opt for a limited quantity method instead. Both ways create a sense of exclusivity and&nbsp;urgency.</p>\n\n\n\n<p>Another option is to display a countdown timer to put the pressure on. A countdown timer visually represents the limited availability of your offer, creating a sense of urgency. You can use a countdown timer on your landing page or in your email&nbsp;marketing.</p>\n\n\n\n<p>And you can&#8217;t forget about the appeal of seasonal offers. If your lead magnet is tied to a specific season or event, this can naturally create a sense of urgency. For example, a &#8220;Holiday Marketing Guide&#8221; would naturally be limited to the holiday&nbsp;season.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Scarcity is important, but authenticity is&nbsp;key</h3>\n\n\n\n<p>Creating urgency can encourage your audience to act quickly. However, it&#8217;s important to be genuine and not create false urgency, as this can damage your credibility. Always follow through on your promises and make sure your offer delivers value — no matter how long it&#8217;s&nbsp;available.</p>\n\n\n\n<h2 class=\"wp-block-heading\">9. Add an explainer video to engage&nbsp;users</h2>\n\n\n\n<p>Video content continues to dominate. According to research conducted by <a href=\"https://wyzowl.s3.eu-west-2.amazonaws.com/pdfs/Wyzowl-Video-Survey-2023.pdf\" target=\"_blank\" rel=\"noreferrer noopener\">wyzowl</a>, consumers want to see more video content from a brand or business they support. Adding an explainer video to your lead magnet can increase engagement and help your conversion&nbsp;rate.</p>\n\n\n\n<p>Here&#8217;s how you can maximize your&nbsp;video:</p>\n\n\n\n<ul>\n<li><strong>Keep it short and sweet</strong>. Your explainer video should be concise and to the point. Aim for a length of 1 to 2 minutes. Remember, the goal is to pique interest and encourage the viewer to download your lead magnet, not to provide a comprehensive overview.</li>\n\n\n\n<li><strong>Focus on benefits</strong>. Just like written content, your video should focus on the benefits of your offer, not just the features. What problem does your lead magnet solve? How will it improve the viewer&#8217;s life or business?</li>\n\n\n\n<li><strong>Include a clear call to action</strong>. At the end of your video, include a clear and compelling call to action. Encourage viewers to download your lead magnet and tell them exactly how to do it.</li>\n\n\n\n<li><strong>Make it professional</strong>. While you don&#8217;t need a Hollywood-level production, your video should be professional and high-quality. Poor audio or video quality can detract from your message and harm your credibility.</li>\n\n\n\n<li><strong>Optimize for mobile</strong>. Many of your viewers will be watching on mobile devices, so make sure your video is optimized for mobile viewing.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Why explainer videos are effective for promoting lead&nbsp;magnets</h3>\n\n\n\n<p>An explainer video is an opportunity to engage your audience differently and provide them with a quick, visual overview of your offer. Make it engaging, informative, and fun, and as long as it&#8217;s on-brand, you really can&#8217;t go wrong&nbsp;here.</p>\n\n\n\n<h2 class=\"wp-block-heading\">10. Offer a sneak peek preview to entice&nbsp;users</h2>\n\n\n\n<p>Giving your audience a sneak peek of your lead magnet&#8217;s content can be a powerful way to entice them to sign up. It&#8217;s like letting them take a test drive before they commit to the full&nbsp;product.</p>\n\n\n\n<p>You can make the most of your sneak peek preview by implementing the&nbsp;following:&nbsp;</p>\n\n\n\n<ul>\n<li><strong>Choose a high-value section</strong>. You don’t have to start at the beginning. Choose a section of your lead magnet that provides high value and showcases the quality of your content. This could be a particularly insightful chapter, a useful checklist, or a compelling case study.</li>\n\n\n\n<li><strong>Make it accessible</strong>. Provide this sneak peek in an easily accessible format. This could be a downloadable PDF, a video walkthrough, or even a blog post behind a membership wall.</li>\n\n\n\n<li><strong>Highlight the value</strong>. Make sure it&#8217;s clear to your audience what value they&#8217;re getting from this sneak peek. What will they learn? How will it benefit them?</li>\n\n\n\n<li><strong>Include a call to action</strong>. At the end of your sneak peek, include a clear call to action encouraging your audience to sign up for the full lead magnet. Remind them of the additional value they&#8217;ll get by signing up.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Example of a sneak preview that promotes a lead&nbsp;magnet</h3>\n\n\n\n<p>You can implement this in a number of ways, but one option is to tease the free preview as a sidebar or slide-in element. On the <a href=\"https://angerman.online/product/healing-anger-transforming-anger-into-growth-ebook/\" target=\"_blank\" rel=\"noreferrer noopener\">Moose Anger Management website</a>, they offer a free preview of an eBook about &#8220;healing&nbsp;anger&#8221;.</p>\n\n\n\n<img width=\"1000\" height=\"516\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-3.png\" alt=\"sneak preview lead capture example\" class=\"wp-image-281112\" />\n\n\n\n<p>When someone clicks the red button on the left hand side of the screen, an opt-in form slides into view where they can input their name and email address to review the free&nbsp;download.</p>\n\n\n\n<p>A sneak peek gives your audience a risk-free way to experience the value of your lead magnet. If they like what they see, they&#8217;ll be much more likely to sign up for the full&nbsp;offer.</p>\n\n\n\n<h2 class=\"wp-block-heading\">11. Keep your opt-in form short and&nbsp;simple</h2>\n\n\n\n<p>The opt-in form is the gateway between your audience and your lead magnet. If it&#8217;s too long or complicated, you risk losing potential&nbsp;leads.</p>\n\n\n\n<p>To do keep your forms short and sweet, you&nbsp;can:</p>\n\n\n\n<ul>\n<li><strong>Ask only for the essentials</strong>. The more information you ask for, the less likely people are to complete your form. Stick to the essentials, like name and email address. If you need more information for your marketing efforts, consider asking for it after they&#8217;ve signed up.</li>\n\n\n\n<li><strong>Keep your messaging to-the-point</strong>. Make sure it&#8217;s clear what your audience is signing up for. Use straightforward language and avoid jargon.</li>\n\n\n\n<li><strong>Make it fast to complete</strong>. The quicker your form is to complete, the more likely people are to do it. Use pre-filled fields, dropdown menus, and checkboxes to make it as easy as possible.</li>\n\n\n\n<li><strong>Test your form on mobile devices</strong>. Many of your audience members will be accessing your form on a mobile device. Make sure your form is easy to complete on a small screen.</li>\n\n\n\n<li><strong>Include a privacy statement</strong>. Reassure your audience that their information is safe with you. Include a brief privacy statement or link to your full privacy policy.&nbsp;</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Why your opt-in forms should be&nbsp;short</h3>\n\n\n\n<p>The goal of your opt-in form is to convert website visitors into leads. So by keeping it short, simple, and user-friendly, you&#8217;ll maximize your chances of&nbsp;success.</p>\n\n\n\n<h2 class=\"wp-block-heading\">12. Avoid using CAPTCHA in your opt-in&nbsp;form</h2>\n\n\n\n<p>It’s common to see CAPTCHAs used on opt-in forms. They act as a security measure to distinguish human users from bots. And they serve a purpose in improving website security. But they also present several challenges that can negatively impact user experience and conversion&nbsp;rates.</p>\n\n\n\n<p>For starters, <a href=\"https://akismet.com/blog/do-captcha-and-recaptcha-protect-wordpress-sites-from-bots/\">CAPTCHA</a> can be challenging for those with visual impairments. Traditional CAPTCHA often involves identifying obscured text in an image, a task that is difficult for users who rely on screen readers to interpret web&nbsp;content.&nbsp;</p>\n\n\n\n<p>Screen readers, being machines, are unable to decipher text in an image, making CAPTCHA inaccessible to these&nbsp;users.</p>\n\n\n\n<p>A CAPTCHA can also create a <a href=\"https://akismet.com/blog/wordpress-captcha/\">frustrating user experience</a>. The distorted characters used in CAPTCHA can be hard to decipher, leading to false positives where real humans are incorrectly identified as bots. This can be particularly challenging for people with certain cognitive disorders, such as&nbsp;dyslexia.</p>\n\n\n\n<p>And that&#8217;s to say nothing of the fact that CAPTCHA can be easily bypassed with sophisticated bots, rendering the security measure ineffective. This means that, while it poses a challenge to human users, it may not effectively keep out the very bots it&#8217;s designed to&nbsp;deter.</p>\n\n\n\n<p>Combine all this with potentially slower page load times, and you&#8217;re likely to drive prospective customers away with all the&nbsp;inconveniences.</p>\n\n\n\n<h3 class=\"wp-block-heading\">An alternative to the dreaded&nbsp;CAPTCHA</h3>\n\n\n\n<p>But a powerful tool like <a href=\"https://akismet.com\">Akismet</a> can solve all of these problems! Akismet is an AI-powered spam filtering service that provides automatic spam protection without interrupting the user experience.&nbsp;.</p>\n\n\n\n<img width=\"1000\" height=\"545\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-4.png\" alt=\"Akismet homepage with information about the tool \" class=\"wp-image-281113\" />\n\n\n\n<p>Akismet works by checking all form submissions against its global database of spam to prevent your site from accepting or publishing malicious content. It can effectively <a href=\"https://akismet.com/blog/best-anti-spam-wordpress-plugins-compared/\">block spam submissions</a> without the need for CAPTCHA, thereby improving the user experience and potentially leading to higher conversion&nbsp;rates.</p>\n\n\n\n<p>While CAPTCHA serves a purpose, its negative impact on user experience and conversion rates cannot be overlooked. And with a powerful alternative like Akismet that offers a more user-friendly solution, why wouldn&#8217;t you choose to use&nbsp;it?</p>\n\n\n\n<p>Of all the tools that can improve your existing content to generate more leads, this may just be the most&nbsp;powerful.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Real-world examples of powerful lead&nbsp;magnets</h2>\n\n\n\n<p>Do you need inspiration for creating an effective lead magnet? Below are some powerful lead magnet examples used by real-world&nbsp;businesses.</p>\n\n\n\n<h3 class=\"wp-block-heading\">1. Gravy for the&nbsp;Brain</h3>\n\n\n\n<img width=\"1000\" height=\"735\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-5.png\" alt=\"lead capture from Gravy for the Brain \" class=\"wp-image-281154\" />\n\n\n\n<p>The <a href=\"https://usa.gravyforthebrain.com/business-book-download/\">Gravy for the Brain</a> website is devoted to helping voice over artists establish careers for themselves through courses, webinars, and mentoring forums. They also offer a business eBook as one of their lead magnets to encourage people to sign up for additional&nbsp;tips.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. The Art of Aaron&nbsp;Blaise</h3>\n\n\n\n<img width=\"1000\" height=\"586\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-6.png\" alt=\"lead capture from the Art of Aaron Blaise\" class=\"wp-image-281155\" />\n\n\n\n<p>Another unique lead magnet idea comes from an offer on <a href=\"https://creatureartteacher.com/bears/\" target=\"_blank\" rel=\"noreferrer noopener\">The Art of Aaron Blaise</a>. Blaise is an artist who offers animation lessons, drawing tutorials, and digital painting courses. To encourage people to sign up for his email list, he currently offers a lead magnet consisting of a free &#8220;How to Draw Elephants&#8221; PDF and Photoshop sketching&nbsp;brushes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. Digital&nbsp;Trombone</h3>\n\n\n\n<img width=\"1000\" height=\"571\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-7.png\" alt=\"lead capture from Digital Trombone\" class=\"wp-image-281156\" />\n\n\n\n<p>Great lead magnet ideas can be leveraged for every niche and specialty. Just take a look at the <a href=\"https://www.digitaltrombone.com/newsletter-sign-up-free-trombone-course\" target=\"_blank\" rel=\"noreferrer noopener\">Digital Trombone</a> website. Trombone player and instructor, Anders Larson, offers a free 10-day trombone course when you sign up for his&nbsp;newsletter.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">FAQs about lead&nbsp;magnets</h2>\n\n\n\n<h3 class=\"wp-block-heading\">1. What is a lead magnet, and why is it important for my&nbsp;business?</h3>\n\n\n\n<p>A lead magnet is a valuable resource that businesses offer to potential customers in exchange for their contact information, typically an email address. This resource could be an eBook, a checklist, a webinar, or any other piece of content that provides&nbsp;value.&nbsp;</p>\n\n\n\n<p>Lead magnets are great for businesses because they help build an email list of potential customers that you can nurture into paying customers. They also allow businesses to provide value upfront, establishing trust and&nbsp;credibility.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. What are the key components of an effective landing page for my lead&nbsp;magnet?</h3>\n\n\n\n<p>An effective landing page for your lead magnet should have a compelling headline, a brief but persuasive description of the lead magnet, a clear and enticing call-to-action (CTA), and an easy-to-complete opt-in&nbsp;form.&nbsp;</p>\n\n\n\n<p>It&#8217;s also beneficial to include social proof, such as testimonials or case studies, to build credibility. The page should also be visually appealing and easy to&nbsp;navigate.</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. How can I optimize my opt-in form to maximize&nbsp;conversions?</h3>\n\n\n\n<p>To maximize conversions, keep your opt-in form short and simple. It should absolutely be just one page. Ask for only the essential information, typically just an email address. Make sure your CTA is clear and compelling, encouraging users to submit their information. And avoid using CAPTCHA, as it can create a barrier for users and potentially decrease&nbsp;conversions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">4. How can I add spam protection to my opt-in&nbsp;form?</h3>\n\n\n\n<p>You can add spam protection to your opt-in form by using a service like Akismet —&nbsp;a <a href=\"https://akismet.com/features/\">spam filtering service</a> that checks all form submissions against its global database of spam. It can effectively block spam submissions without the need for CAPTCHA, improving the user experience and potentially leading to higher conversion&nbsp;rates.</p>\n\n\n\n<img width=\"1600\" height=\"830\" src=\"https://akismet455732288.files.wordpress.com/2023/09/image-8.png\" alt=\"Akismet landing page with the text \" />\n\n\n\n<h3 class=\"wp-block-heading\">5. What is Akismet, and how can it help with form conversion&nbsp;rates?</h3>\n\n\n\n<p>Akismet is a spam filtering service that skips the use of CAPTCHAs and can provide a more user-friendly solution to form security. It works by checking all form submissions against its global database of spam to prevent your site from accepting or publishing malicious&nbsp;content.&nbsp;</p>\n\n\n\n<p>This can help prevent false positives and minimize user frustration, especially from those with visual or cognitive impairments, or who find CAPTCHAs&nbsp;confusing.</p>\n\n\n\n<h3 class=\"wp-block-heading\">6. What types of companies generally use&nbsp;Akismet?</h3>\n\n\n\n<p>Akismet is trusted by a wide range of companies, from small businesses to <a href=\"https://akismet.com/enterprise/\">large enterprises</a>. It&#8217;s used by over 100 million sites worldwide, including trusted brands like Microsoft, <a href=\"https://akismet.com/blog/convertkit-customerstory/\">ConvertKit</a>, and Bluehost. These companies rely on Akismet to protect their forms from spam, providing a better user experience and helping to maximize conversion&nbsp;rates.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Akismet: Non-intrusive anti-spam for lead capture&nbsp;forms</h2>\n\n\n\n<p>Lead magnets are a powerful tool for attracting quality leads and growing your email list. While there’s no such thing as a perfect lead magnet, following the tips in this article can get you pretty&nbsp;close.&nbsp;</p>\n\n\n\n<p>However, the effectiveness of your lead magnets will be significantly influenced by the user experience you provide. From the clarity of your target audience definition to the strength of your headline, every detail&nbsp;matters.</p>\n\n\n\n<p>One crucial aspect that often gets overlooked is the user experience of your opt-in form. CAPTCHA, while designed to protect your forms from spam, can often create barriers for genuine users, leading to frustration and lower conversion&nbsp;rates.</p>\n\n\n\n<p>That&#8217;s where Akismet can save the day. As a trusted spam filtering service used by over 100 million sites worldwide, Akismet offers a user-friendly solution to form security. It effectively blocks spam submissions without the need for CAPTCHA, providing a smoother user experience and higher conversion&nbsp;rates.</p>\n\n\n\n<p>So, if you&#8217;re looking to optimize your lead magnet and maximize your conversion rates, <a href=\"https://akismet.com/pricing/\">consider Akismet</a> for your form security. It&#8217;s a quick change that could make a big difference in your lead generation&nbsp;efforts.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 13:15:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"WPTavern: Contentious Review Process Leads Ollie Theme to Remove Innovative Onboarding Features, Amid Stagnating Block Theme Adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:143:\"https://wptavern.com/contentious-review-process-leads-ollie-theme-to-remove-innovative-onboarding-features-amid-stagnating-block-theme-adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14629:\"<p>Mike McAlister, creator of the <a href=\"https://olliewp.com/\">free Ollie theme</a>, will be dropping the innovative onboarding features from the theme in favor of putting them into a separate plugin after <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\">facing pushback during the review</a> for inclusion in WordPress.org&#8217;s Themes Directory.</p>\n\n\n\n<p>During what McAlister described as an &#8220;unnecessarily contentious&#8221; <a href=\"https://themes.trac.wordpress.org/ticket/149883\">review process</a> that turned unproductive and combative at certain points, and where he even <a href=\"https://twitter.com/carolinapoena/status/1707128165808713756?s=20\">became the target of subtweets</a> from a dissenting reviewer, his team decided it was not the right time to move forward with getting the whole experience approved as originally planned.</p>\n\n\n\n<p>McAlister published his decision to WordPress&#8217; Theme Review Slack channel:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>We’re going to forgo putting the onboarding feature into the Ollie theme for .org.</p>\n\n\n\n<p>While we appreciate the flexibility and open-mindedness to considering an exception for it, ultimately, it seems like it might not be the right time on the directory.</p>\n\n\n\n<p>Maybe in the future the directory has a more defined path for experiments like this, but right now it has a potential to be a burden to reviewers and other theme developers. Not to mention a very lively (and sometimes unnecessarily contentious) discussion that distracts from the excitement and positivity around block themes and Ollie. We don’t want that! That’s a lot of energy we could be using to bring something like this to core one day.</p>\n\n\n\n<p>Until then, we’re figuring out what the next steps are, but it looks like we’re going to continue with Ollie on the directory (sans onboarding) while we figure out how to deliver the onboarding experience via a plugin mechanism.</p>\n</blockquote>\n\n\n\n<p>McAlister&#8217;s decision comes as a surprise after he received the green light from WordPress project leader Matt Mullenweg, who encouraged Ollie&#8217;s approval as an experiment, and WordPress Executive Director Josepha Haden Chomphosy, who <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1696000530445789\">attempted to embolden McAlister towards giving the experiment a chance</a>. He also found the support of several forward-thinking members of the Themes team and much of the wider community.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">The rules are based on prior data, when something novel or new comes up that resonants with users we should be willing to try something else, even the opposite of what we did before, to make a new decision. Fine to allow 1-3 themes like this through and observe.</p>&mdash; Matt Mullenweg (@photomatt) <a href=\"https://twitter.com/photomatt/status/1707794756468896068?ref_src=twsrc%5Etfw\">September 29, 2023</a></blockquote>\n</div>\n\n\n\n<p>&#8220;I would not be a good steward of our community of users if I didn’t suggest that getting the whole thing into the repo so it’s easy to find and use is the best experience for them,&#8221; Chomphosy said.</p>\n\n\n\n<p>&#8220;There’s some risk to adding it as-is to the repo. But the potential upside, I think, is pretty substantial.</p>\n\n\n\n<p>&#8220;If we’re not wanting to include it because we are worried that in the future we won’t have the skills to review more of them, then that’s not exactly the theme’s problem. That’s something where we should equip our reviewers for the future as best we can.&#8221;</p>\n\n\n\n<p>She also suggested another option where the theme moves forward without removing the onboarding while contributors work towards WordPress core creating a standard for providing better onboarding experiences. </p>\n\n\n\n<p>&#8220;We get the theme in (including the onboarding) and in parallel start a feature plugin process to move the onboarding to be Core-first,&#8221; Chomphosy said.</p>\n\n\n\n<p>&#8220;That’s bold, I realize. But also, I did tell the entire hosting community at Cloudfest that if they wanted to one thing to help WP succeed, it was &#8216;better onboarding&#8217; and if they wanted to do two things, the second was &#8216;better time to launch.”</p>\n\n\n\n<p>Putting the onboarding solution into a plugin would reduce the long-term burden of maintenance and create a lower risk of failure from the theme, as Merlin WP themes onboarding wizard creator Rich Tabor <a href=\"https://twitter.com/richard_tabor/status/1707775941466837232\">contends</a>, but nobody knows how long it will be before core can offer a standard solution. By then WordPress may have missed many opportunities to seamlessly onboard more block theme users. </p>\n\n\n\n<p>Chomphosy&#8217;s suggestion of going ahead with the experiment in the theme while simultaneously working on a core solution allows theme authors to use training wheels to keep the momentum of block theme adoption going until a better, more elegant solution is available in core. </p>\n\n\n\n<p>WordPress leadership&#8217;s public approval was critical in this instance after the unwelcoming experience McAlister had in trying to get his free theme approved for the directory. He cited other factors regarding negative perception that influenced his decision.</p>\n\n\n\n<p>&#8220;There is a lot of subtle and not so subtle pressure from some higher visibility folks that feel strongly that this shouldn’t be in a theme,&#8221; McAlister said. &#8220;And I don’t want those relationships to degrade as a result of how this might play out.&#8221;</p>\n\n\n\n<p>McAlister said he is still interested in bringing the onboarding experience to WordPress.org as a plugin, where it can be studied and experimented with, but isn&#8217;t sure how soon that can happen given the long delays in plugin reviews. The current queue has 1,247 plugins awaiting review, with wait time for an initial review at 103+ days.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Evolving Theme Reviews: WordPress.org Must Stop Alienating Innovators While Block Theme Adoption Is Stagnating</h3>\n\n\n\n<p>Although WordPress leadership was quick to respond in support of experimentation, recalcitrant plugin reviewers, clinging to antiquated rules written for Classic Themes, had already driven Ollie&#8217;s innovation away with their chilly, unfriendly reception.</p>\n\n\n\n<p>Mullenweg has historically communicated his support for experimenting with themes on multiple occasions, encouraging developers to do novel things with WordPress that may not fit within the guidelines. In 2015, he went so far as to <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1432861605003292\">say</a>, &#8220;I am completely okay with having something in the directory that breaks every guideline, as long as it’s interesting.&#8221;</p>\n\n\n\n<p>A few months later in 2015, he <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1438195918001732\">recommended the review team</a> &#8220;try to think of it as a more general opening up to interesting things that might not fit the guidelines but are novel and warrant inclusion in our directory.&#8221; </p>\n\n\n\n<p>At that time, Mullenweg encouraged the team to step back and examine the submission process and the directory in a new way that would encourage creativity among theme authors with fewer guidelines and restrictions.</p>\n\n\n\n<p>A fundamental culture change is necessary for this team and long overdue. It should be a matter of urgency at this point, given the tone of reviewers in <a href=\"https://themes.trac.wordpress.org/ticket/149883\">Ollie&#8217;s trac ticket</a>. Theme reviews should bend more towards enabling innovators instead of preserving familiar processes. The response to theme authors trying new things should be friendly and helpful, especially when those new things stand to greatly benefit users. The process should not be burdensome to creators who are trying to offer their work for free.</p>\n\n\n\n<p>&#8220;As I mentioned earlier in the thread, another important note is that our vision for the onboarding — some of the features that people loved about it — were removed during this long review process,&#8221; McAlister said. &#8220;So even if it went live today, it doesn’t quite reach its maximum potential as is. And if we started adding some of those features back, I feel we’d be mired in more back and forth.&#8221;</p>\n\n\n\n<p>This situation should be a wake up call for the review team, as WordPress&#8217; best product creators are watching to see how this plays out when considering where to distribute their best work.</p>\n\n\n\n<p>A recent spreadsheet created by Munich-based digital agency owner Hendrik Luehrsen <a href=\"https://docs.google.com/spreadsheets/d/11X38e9w86XcgT4tybqfjKhrL0PIbDlIsUEJwLiKtJ7Q/edit#gid=931695972\">tracks the usage of themes with the FSE tag</a>. It shows that WordPress block theme adoption is stagnating, if not in full decline. In September 2023, the total number of active installs for block themes declined for the first time since Luehrsen started tracking. The average installs by theme are also slowly and steadily declining. This could be related to the growth of the number of FSE themes available, as active installs would presumably be spread across more themes, but the number of FSE themes is growing at a glacial pace.</p>\n\n\n\n<p>&#8220;I would say it’s too early to assume definitive decline,&#8221; Luehrsen said. &#8220;But we’re most certainly not growing the FSE usage.&#8221;</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1978\" height=\"536\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/10/Screen-Shot-2023-10-03-at-8.57.21-PM.png\" alt=\"\" class=\"wp-image-149806\" />\n\n\n\n<p>&#8220;Having run a number of block theme training courses, I&#8217;m not at all surprised,&#8221; Pootlepress founder Jamie Marsland <a href=\"https://twitter.com/pootlepress/status/1707820106556867027?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1707835806763622467%7Ctwgr%5E36cba479119394838ab431c2ac491926810ecd2b%7Ctwcon%5Es2_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149749action%3Dedit\">said</a>. &#8220;Until Block Themes get easier to use for beginners, my guess is the numbers won&#8217;t change significantly. The dev team should try running a training course and see for themselves.&#8221;</p>\n\n\n\n<p>Marsland recently <a href=\"https://www.pootlepress.com/2023/09/wordpress-block-themes-versus-classic-themes/\">interviewed</a> McAlister, discussing some of the reasons for the slow uptake in block themes. Their adoption is hindered by a lack of effective marketing for their innovative features as well as the complexities involved in creating a block theme that fully supports everything a user can imagine doing with the block editor.  McAlister highlighted the necessity to create more user-friendly experiences and the importance of onboarding and better education for those using and making block themes.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<div class=\"embed-vimeo\"></div>\n</div>\n\n\n\n<p>&#8220;I’m not kidding when I’m saying it’s in all our interests to start making sure this becomes better soon,&#8221; Joost de Valk <a href=\"https://twitter.com/jdevalk/status/1707835806763622467?ref_src=twsrc%5Etfw%7Ctwcamp%5Etweetembed%7Ctwterm%5E1707835806763622467%7Ctwgr%5E36cba479119394838ab431c2ac491926810ecd2b%7Ctwcon%5Es1_&ref_url=https%3A%2F%2Fwptavern.com%2Fwp-admin%2Fpost.php%3Fpost%3D149749action%3Dedit\">said</a> in response to the latest figures from the spreadsheet tracking FSE usage. &#8220;WP stands to lose market share if we don’t get better soon.&#8221;</p>\n\n\n\n<p>With block themes struggling to gain adoption, WordPress should be doing everything it can to enable any block theme that improves the user experience, especially in the absence of a core solution for onboarding. It&#8217;s important to remember that when major versions of WordPress are released, the only people who can take advantage of the latest and greatest editor features are those whose sites are using a block theme. After three years, WordPress.org block theme installs only account for 1.7 million sites out of an estimated <a href=\"https://colorlib.com/wp/wordpress-statistics/\">810 million</a>.</p>\n\n\n\n<p>&#8220;As someone who has been trying to get block themes to be adopted by a wider audience from early, I feel onboarding/switching to block themes is a big hurdle for users still,&#8221; ElmaStudio co-creator Ellen Baer <a href=\"https://wordpress.slack.com/archives/C02RP4Y3K/p1696321112372359?thread_ts=1696000530.445789&cid=C02RP4Y3K\">said</a> in the conversation in the Theme Review Slack channel.</p>\n\n\n\n<p>&#8220;I personally would love to see a core solution, a standarized way that all block theme users can get familiar with. I feel unfortunately while building the site editor experience this point has been missing and block theme authors are seeing the user struggling to get started.</p>\n\n\n\n<p>&#8220;I feel a bit sad that a positive innovation that helps block themes and the site editor to gain more momentum (which is what we really need) is dragged into a discussion that seemed at least from the outside not to be a productive or positive one at times.&#8221;</p>\n\n\n\n<p>McAlister&#8217;s attempt to improve WordPress.org theme users&#8217; onboarding experience was unsuccessful but he inadvertently highlighted some areas where the culture and process around theme reviews has stagnated and become counterproductive. This failure shed light on the need for a more dynamic, user-centric approach, as well as a reassessment of the current guidelines by which the team appears to be bizarrely and inextricably bound despite years of encouragement to experiment.</p>\n\n\n\n<p>&#8220;There is a deep, deep desire for evolution of the theme directory,&#8221; McAlister said. &#8220;I think we’ve always known this, but after wading through weeks of commentary, it’s clear to me that we’ve neglected it far too long. The theme pages should be at least as good as the plugin pages, the theme demos aren’t selling the value of themes, etc.</p>\n\n\n\n<p>&#8220;The hardline approach and the echos of longstanding esoteric debates need relaxing. Users largely don’t care about the theme vs plugin debate, they want to design and publish faster. That’s not to say we throw these things out, but we have to ask if they’re serving WordPress users in the ways we think they are.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Oct 2023 03:19:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.4 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=16065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8146:\"<p>WordPress 6.4 Beta 2 is now available for testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 2 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 2 in four ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download</strong>: Download the <a href=\"https://wordpress.org/wordpress-6.4-beta2.zip\">Beta 2 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line</strong>: Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-beta2</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for more information.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an <a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">underrepresented gender release squad</a> to increase participation and partnership with those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<p><strong>Want to know what&#8217;s new in WordPress 6.4?</strong> <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Read the Beta 1 announcement</a> and tune into <a href=\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\">Episode 63 of the WP Briefing podcast</a> for details.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How to get involved with testing</h2>\n\n\n\n<p>Your help testing the WordPress 6.4 Beta 2 version is key to ensuring everything in the release is the best it can be. While testing the upgrade process is essential, trying out new features is equally important. <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This guide</a> will walk you through testing features in WordPress 6.4.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/blob/a854e6e7a2a49a6b1ec5ef377c756a30e1c7ac5a/lib/experimental/fonts/font-library/README.md\">Font Library feature</a>, currently available in <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a>, requires more testing and feedback to ensure it is ready for inclusion in the upcoming 6.4 release. <a href=\"https://make.wordpress.org/test/2023/10/03/help-test-the-font-library/\">Check out this guide for detailed test instructions</a>.</p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> of the support forums or directly to <a href=\"https://core.trac.wordpress.org/newticket\">WordPress Trac</a> if you are comfortable writing a reproducible bug report. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates debuting in WordPress 6.4 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 2</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities</a> is doubled. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Beta 2 highlights</h2>\n\n\n\n<p>WordPress 6.4 Beta 2 contains more than 50 updates since the Beta 1 release, including <a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=09%2F27%2F2023..10%2F03%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">18 tickets for WordPress core</a>.</p>\n\n\n\n<p>Each beta cycle focuses on bug fixes; more are on the way with your help through testing. You can browse the technical details for all issues addressed since Beta 1 using these links:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.4\">GitHub commits for 6.4</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=closed&changetime=09%2F27%2F2023..10%2F03%2F2023&milestone=6.4&col=id&col=milestone&col=owner&col=type&col=priority&order=id\">Closed Trac tickets since Beta 1</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/twentytwentyfour/commits/\">GitHub commits for Twenty Twenty-Four</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Note on Twenty Twenty-Four</h3>\n\n\n\n<p>Please note that some images in the Twenty Twenty-Four theme may not load correctly. A fix is in the works! Learn more on this <a href=\"https://core.trac.wordpress.org/ticket/59526\">Trac ticket</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Note on pattern management improvements in non-block themes</h3>\n\n\n\n<p>While WordPress 6.4 will bring several exciting pattern advancements, improvements to pattern management in non-block themes will eventually be addressed in WordPress 6.5. The <a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">Beta 1 announcement</a> has been updated to reflect this change accordingly.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A Beta 2 haiku</h2>\n\n\n\n<p>Not the first, nor last<br />A second space to reflect<br />Both new and not new</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/priethor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>priethor</a>, <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ironprogrammer</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 17:25:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: An Inside Look at WordCamp Sponsorships with Jason Rouet and Jon Ang\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://dothewoo.io/an-inside-look-at-wordcamp-sponsorships-from-jason-rouet-and-jon-ang/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:456:\"<p>Jason and Jon open the blackbox to share their experiences and insights on flagship WordCamp Asia and Europe sponsorships.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/an-inside-look-at-wordcamp-sponsorships-from-jason-rouet-and-jon-ang/\">An Inside Look at WordCamp Sponsorships with Jason Rouet and Jon Ang</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 12:02:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"WPTavern: WordPress Global Sponsorship Program Raises Costs for 2024 to Support Expanding In-Person Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149761\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://wptavern.com/wordpress-global-sponsorship-program-raises-costs-for-2024-to-support-expanding-in-person-events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3363:\"<p>WordPress&#8217; Community team has <a href=\"https://make.wordpress.org/community/2023/09/28/proposed-2024-global-community-sponsorship-program/\">proposed a draft for the 2024 Global Community Sponsorship Program</a>, with fees increased to cover the costs of the rapidly expanding number of in-person events.</p>\n\n\n\n<p>The program supports the volunteer-organized local events so that they can provide free or low-cost access for attendees. It helps companies streamline their sponsorship contributions across multiple events with less administrative overhead than it would be to sponsor individual WordCamps. The program does not include flagship events such as WordCamps Europe, Asia, and US.</p>\n\n\n\n<p>Fees have gone up since 2023 for all three sponsorship packages: Gold, Silver, and Bronze, which offer varying degrees of visibility at in-person WordPress events.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<table><tbody><tr><td></td><td>Gold</td><td>Silver</td><td>Bronze</td></tr><tr><td>2023</td><td>$130,000</td><td>$95,000</td><td>$80,000</td></tr><tr><td>2024</td><td>$145,000</td><td>$115,000</td><td>$90,000</td></tr></tbody></table>\n\n\n\n<p>The 2021 and 2022 programs <a href=\"https://wptavern.com/wordpress-global-sponsorship-program-will-not-include-wordcamps-for-2022\">did not include funding for WordCamps</a>, due to the unpredictability of hosting in-person events when the pandemic made conditions unfavorable in many places across the world. At that time many WordCamp and meetup organizers opted to continue with virtual events. </p>\n\n\n\n<p>In 2023, WordPress events are ramping back up again. Automattic-sponsored community contributor Isotta Peira said the number of in-person events has increased by 60% compared to 2022, and they expect Next Gen events will keep the program growing into 2024. So far 15 pilot events have been confirmed for the new Next Gen format, with 11 of them happening in 2023.</p>\n\n\n\n<p>&#8220;As a result of the Meetup Reactivation project that started in July 2022 and ended in June 2023, 270 dormant Meetups started hosting events again,&#8221; Peira said. &#8220;Today, we have 729 WordPress Chapter Meetups in 107 countries and over 500,000 members globally. In the first 7 months of 2023, the WordPress Community has held 27 WordCamps, and another 29 are scheduled before year-end.&#8221;</p>\n\n\n\n<p>The proposal highlighted a few stats demonstrating the strong resurgence of community events: </p>\n\n\n\n<ul>\n<li>36 local WordCamps held in 2023 to date, with 25 more scheduled before year end</li>\n\n\n\n<li>173% increase in WordCamps since last year: 60 WordCamps anticipated to be held in 2023, compared to 22 in 2022</li>\n\n\n\n<li>729 meetup groups across 107 countries</li>\n\n\n\n<li>507,796 meetup group members, program-wide</li>\n\n\n\n<li>2,998 meetup events scheduled in 2023 to date, and over 340 more scheduled through the end of the year</li>\n</ul>\n\n\n\n<p>The uptick in events is the direct result of the Community team&#8217;s efforts in 2023 to reactivate dormant meetup groups, bring back in-person WordCamps, and evolve the WordCamp program to make room for new event types.</p>\n\n\n\n<p>Companies that are interested to support WordPress&#8217; burgeoning events program can get on board for 2024 by emailing <a href=\"mailto:support@wordcamp.org\">support@wordcamp.org</a> before November 30, 2023. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 03:14:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 12.0.0-beta3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=331464\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2023/10/buddypress-12-0-0-beta3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3035:\"<p>Hello BuddyPress contributors!</p>\n\n\n\n<p>If you haven&#8217;t tested our two first beta releases (<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> please read <a href=\"https://buddypress.org/2023/08/buddypress-12-0-0-beta1/\">this post about beta1</a>), please consider testing this <strong>third and last</strong> beta release. Beta testing is the best way to make sure the final release will fit perfectly into your WordPress / BuddyPress specific configuration. 12.0 is introducing a very important change about how BuddyPress URLs are built, analyzed and routed and more than ever we need your help to reach this important milestone for the plugin.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background wp-element-button\" href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">Test BuddyPress 12.0.0-beta3</a></div>\n</div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s new since <a href=\"https://buddypress.org/2023/09/buddypress-12-0-0-beta2/\">beta2</a>?</h2>\n\n\n\n<p>We&#8217;ve fixed 4 bugs and improved the BuddyPress URLs settings screen help area.</p>\n\n\n\n<p><strong>12.0.0 is slated to October 30</strong>, thanks in advance to all the contributors who will give us a hand to get there <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f60d.png\" alt=\"😍\" class=\"wp-smiley\" />.</p>\n\n\n\n<p>You can test <a href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">BuddyPress 12.0.0-beta3</a> in 4 ways :</p>\n\n\n\n<ul>\n<li>Try the&nbsp;<a href=\"https://wordpress.org/plugins/bp-beta-tester/\">BP Beta Tester</a>&nbsp;plugin.</li>\n\n\n\n<li><a href=\"https://downloads.wordpress.org/plugin/buddypress.12.0.0-beta3.zip\">Download the beta here (zip file)</a>.</li>\n\n\n\n<li>Check out our SVN repository:&nbsp;<code>svn co https://buddypress.svn.wordpress.org/trunk/</code></li>\n\n\n\n<li>Clone our read-only Git repository:&nbsp;<code>git clone git://buddypress.git.wordpress.org/</code></li>\n</ul>\n\n\n\n<p>If you find something weird, please report it on&nbsp;<a rel=\"noreferrer noopener\" href=\"https://buddypress.trac.wordpress.org/newticket\" target=\"_blank\">BuddyPress Trac</a>, post a reply to&nbsp;<a href=\"https://buddypress.org/support/topic/lets-prepare-the-buddypress-12-0-0-next-major-release/\">this support topic</a>&nbsp;or get in touch with us on our&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.slack.com/messages/buddypress\" target=\"_blank\">WordPress.org Slack channel</a>.</p>\n\n\n\n<p>Happy testing <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f469-1f3fb-200d-1f4bb.png\" alt=\"👩🏻‍💻\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9d1-1f3fe-200d-1f4bb.png\" alt=\"🧑🏾‍💻\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 02:56:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Matt: Preserving Harvard’s Blogging History\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=99750\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://ma.tt/2023/10/preserving-harvards-blogging-history/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3221:\"<p>This month, <a href=\"https://automattic.com/\">Automattic</a> had the privilege of working with the <a href=\"https://cyber.harvard.edu/\">Berkman Klein Center for Internet &amp; Society (BKC)</a> to migrate their early 2000s blogging platform over to our <a href=\"https://pressable.com/a-quick-guide-to-wordpress-multisite-what-you-need-to-know/\" target=\"_blank\" rel=\"noreferrer noopener\">Pressable</a> infrastructure. (Pressable is a small host Automattic runs to develop our <a href=\"https://wp.cloud/\">WP.cloud</a> infrastructure, it gets you all the performance and security of our high-end WP.com plans, but with a more plain-vanilla WP interface.)</p>\n\n\n\n<p>The Harvard Blogs network that the Center launched back in 2003 was an important milestone in internet history. It provided a platform for over 1,500 high-impact bloggers—including Harvard students, faculty, fellows, staff, and alumni—to publish and engage in discussion.</p>\n\n\n\n<p>We were alerted to BKC’s plans to decommission&nbsp;<a href=\"http://blogs.harvard.edu/\" target=\"_blank\" rel=\"noreferrer noopener\">blogs.harvard.edu</a>&nbsp;by none other than&nbsp;<a href=\"http://scripting.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Dave Winer</a>, the pioneering developer behind blogging, RSS, and podcasting, and a Berkman Center fellow from 2003-2004. As BKC shared in&nbsp;<a href=\"https://archive.blogs.harvard.edu/blog/2023/03/02/blogs-harvard-edu-shutting-down/\" target=\"_blank\" rel=\"noreferrer noopener\">their announcement</a>, the network played a formative role for many now-influential bloggers and internet figures. It also contributed to the rise of podcasting and projects like&nbsp;<a href=\"https://www.ushahidi.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Ushahidi</a>.</p>\n\n\n\n<p>When we learned BKC planned to retire the Harvard Blogs platform, we wanted to ensure this valuable archive of early internet culture was preserved. We offered to host the network’s blogs indefinitely so they can remain publicly accessible for years to come.</p>\n\n\n\n<p>The Harvard Blogs multisite consisted of around 1,500 blogs. To move it over, we systematically migrated the archive to our servers and then upgraded the network to the latest version of WordPress (we also updated a handful of plugins and themes and tested the updated versions against the original sites hosted by Harvard).</p>\n\n\n\n<p>Much like our recent unveiling of the&nbsp;<a href=\"https://wordpress.com/blog/2023/08/25/introducing-the-100-year-plan/\" target=\"_blank\" rel=\"noreferrer noopener\">100 Year Plan</a>&nbsp;for&nbsp;WordPress.com, the preservation of the&nbsp;<a href=\"https://archive.blogs.harvard.edu/\" target=\"_blank\" rel=\"noreferrer noopener\">Harvard Blogs archive</a>&nbsp;demonstrates Automattic’s commitment to protect vital pieces of internet history and culture for generations to come. By preserving these blogs, we hope to inspire future generations of online voices.</p>\n\n\n\n<p>There was something really nice about the neighborhood of blogs the Harvard blog network provided that I hope they or another university tries again sometime. Harvard is now 387 years old, I hope these blogs last at least that much longer (that would be 2,410 AD!).</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Oct 2023 00:53:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Gravatar: New Gravatar Hovercards: Faster, Open-Source, and Everywhere\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.gravatar.com/?p=722\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://blog.gravatar.com/2023/10/02/new-gravatar-hovercards-faster-open-source-and-everywhere/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2147:\"<p>Hovercards offer a sleek, interactive way to showcase user profiles. With just a hover over the Gravatar image, a card displays essential information about the user. This eliminates the need to navigate away from the current page and encourages engagement.</p>\n\n\n\n<img width=\"800\" height=\"433\" src=\"https://gravatar.files.wordpress.com/2023/10/gravatar-hover2.gif\" alt=\"\" class=\"wp-image-736\" />\n\n\n\n<p>A new open-sourced Gravatar Hovercards library is live for users of&nbsp;<a href=\"https://href.li/?https://WordPress.com\">WordPress.com</a>&nbsp;and&nbsp;<a href=\"https://href.li/?https://jetpack.com\">Jetpack</a>, and is available to be implemented by anyone around the web. Here’s what’s new:</p>\n\n\n\n<ul>\n<li><strong>Leaner and faster:</strong>&nbsp;By pruning redundant code and harnessing modern web APIs, we’ve achieved greater efficiency and reduced file sizes by more than 200%.</li>\n\n\n\n<li><strong>Improved UX:</strong>&nbsp;The hovercard design is more refined and will work better across sites with different styles and branding. The library now&nbsp;<a href=\"https://href.li/?https://github.com/gravatar/hovercards#placement-string--right\">supports different placements</a>&nbsp;to cater to a variety of needs.</li>\n\n\n\n<li><strong>Universal hovercards:</strong>&nbsp;The new library introduces the ability to attach hovercards to any element, not just the avatar image. For example, a site can @someone and show the hovercard on hover.</li>\n\n\n\n<li><strong>Open to the world:</strong>&nbsp;Developers can integrate it into their sites via the&nbsp;<a href=\"https://href.li/?https://www.npmjs.com/package/@gravatar-com/hovercards\">NPM package</a>.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p>If you aren&#8217;t seeing hovercards on your WordPress site, go to <strong>Settings -&gt; Discussion</strong> and look for the setting to enable pop-up business cards. You will need to be hosted on WordPress.com or have the free Jetpack plugin installed. </p>\n\n\n\n<p>We encourage you to explore Gravatar hovercards, and welcome your ideas and contributions via our <a href=\"https://href.li/?https://github.com/gravatar/hovercards\">GitHub repo</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:55:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WordPress.org blog: WP Briefing: Episode 63: A WordPress 6.4 Sneak Peek\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=16050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2023/10/episode-63-a-wordpress-6-4-sneak-peek/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40977:\"<p>Join WordPress Executive Director, Josepha Haden Chomphosy, as she offers an exclusive preview of the upcoming WordPress 6.4 release, accompanied by special guest Sarah Norris, one of the Editor Tech leads for this release. Don&#8217;t miss this opportunity for an insider&#8217;s look!</p>\n\n\n\n<p><em><strong>Have a question you’d like answered? You can submit them to&nbsp;<a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Host: <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden Chomphosy</a><br />Guest: <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a><br />Editor: <a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo: <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production: <a href=\"https://profiles.wordpress.org/bjmcsherry/\">Brett McSherry</a><br />Song: Fearless First by Kevin MacLeod</p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li>TwentyTwentyFour <a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Theme</a> \n<ul>\n<li><a href=\"https://github.com/WordPress/twentytwentyfour\">Repo</a></li>\n\n\n\n<li><a href=\"https://www.figma.com/file/AlYr03vh4dVimwYwQkTdf6/Twenty-Twenty-Four?type=design&node-id=16-14852&mode=design\">Figma File</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/51132\">Image Lightbox Github</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meetings/\">Upcoming WordPress Meetings</a> for Contributors</li>\n\n\n\n<li><strong>Small List of Big Things</strong>\n<ul>\n<li>Find announcements for WordPress 6.4 Beta at:\n<ul>\n<li><a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#Core</a> Slack Channel</li>\n\n\n\n<li><a href=\"https://wordpress.org/news/\">WordPress.org/news/</a></li>\n</ul>\n</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/06/documentation-translation-localization/\" target=\"_blank\">Proposal: Documentation translation/localization</a></li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/09/20/seeking-proposals-for-interop-2024/\" target=\"_blank\">Seeking proposals for Interop 2024</a>&nbsp;&#8211; Interop 2024 is happening! WordPress developers, please contribute your proposals for 2024&nbsp;<a rel=\"noreferrer noopener\" href=\"https://github.com/web-platform-tests/interop/issues/new/choose\" target=\"_blank\">on GitHub</a>&nbsp;or as a comment on this post.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/project/2023/09/15/wordcamp-us-2023-qa/\" target=\"_blank\">WordCamp US 2023 Q&amp;A</a> &#8211; With a successful WCUS in the books, an extensive list of post-event questions and answers are available and inspired by the event&#8217;s community and <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=3Fa0Q-brSeI\" target=\"_blank\">Q&amp;A</a>.</li>\n\n\n\n<li><a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/2023/09/13/accessibility-office-hours/\" target=\"_blank\">Accessibility Office Hours</a>&nbsp;&#8211; In an effort to improve accessibility knowledge in the WordPress project,&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/accessibility/\" target=\"_blank\">the accessibility team</a>&nbsp;will hold Office Hours every Wednesday at 14:00 UTC</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-16050\"></span>\n\n\n\n<p>[00:00:00] <strong>Josepha:</strong> Hello everyone. And welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project some insight into the community that supports it. And get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go!</p>\n\n\n\n<p>[00:00:28] (Intro Music)&nbsp;</p>\n\n\n\n<p>[00:00:39] <strong>Josepha:</strong> I have with me today, Sarah Norris. She is the Core Tech Editor in the WordPress 6.4 release. Welcome, Sarah.</p>\n\n\n\n<p>[00:00:47] <strong>Sarah:</strong> Oh, hi, and thanks for having me.</p>\n\n\n\n<p>[00:00:50] <strong>Josepha:</strong> First, I should give everyone kind of a concept of what we&#8217;re doing.</p>\n\n\n\n<p>So this is the WordPress 6.4 sneak peek episode of our podcast, which means that we&#8217;re going to talk a little bit about like the stuff that we are excited to get into the release stuff that we&#8217;re hoping is actually going to make it into the final release. But also, we&#8217;re going to talk a little bit about like stuff that we wish people knew.</p>\n\n\n\n<p>That we were working on. Things that are going to be really cool for users or developers or plugin authors, theme authors, things like that, that otherwise people would miss because it&#8217;s just hard to see. And so before we get started on all of that, is this your first release where you&#8217;re part of a squad like this?</p>\n\n\n\n<p>[00:01:31] <strong>Sarah:</strong> Ah, so, it&#8217;s actually my second. I was part of 6.1 as well. I led the default theme of 2023. But I am finding that the experience is a little bit different. So I&#8217;m still learning probably just as much.&nbsp;</p>\n\n\n\n<p>[00:01:42] <strong>Josepha:</strong> Yeah, absolutely. Well, and in 6.1 versus 6.4, for one, the themes are very different. Like the default themes are very different, but also the tasks involved with leading a default theme are very different from like leading things happening in the core editor in that Gutenberg plugin.</p>\n\n\n\n<p>[00:02:01] <strong>Sarah:</strong> Yeah, there&#8217;s so many different tasks. Yeah, like, I guess maybe there&#8217;s such, there&#8217;s maybe just like a set of tasks for every part of the release squad. But they&#8217;re so different. And much more involved.</p>\n\n\n\n<p>[00:02:12] <strong>Josepha:</strong> Yeah, absolutely. And as of the time of this recording, we&#8217;re recording this on September 27th. It comes out a little bit later. But as of the time of this recording, like we just wrapped up beta 1 for WordPress 6.4 yesterday. But I understand that, like an hour ago, you wrapped up a final release of the Gutenberg plugin as well.</p>\n\n\n\n<p>So you&#8217;re just kind of everywhere with us right now.</p>\n\n\n\n<p>[00:02:36] <strong>Sarah:</strong> Yeah, that&#8217;s exactly right. Yeah, we tried to make the beta 1 for 6.4 and the latest release of Gutenberg quite close together to make it easier to, to merge those latest changes for beta 1 of 6.4. So yes, that&#8217;s why it&#8217;s so close together, and fingers crossed, they both went really smoothly, so I&#8217;m really happy about that.</p>\n\n\n\n<p>[00:02:53] <strong>Josepha:</strong> Now we all sit around and watch the support queues and hope. That part, the sitting around and watching the support queues, is both my most favorite and least favorite sometimes part of releases. Like, it&#8217;s a little bit my most favorite because I get to talk to our support folks. I&#8217;m like, hey, is anything happening? But also, it&#8217;s my least favorite because it&#8217;s like the Schrödinger&#8217;s cat of releases. You&#8217;re like, as long as I don&#8217;t look at it, it could be all well or all bad, and I just don&#8217;t know.</p>\n\n\n\n<p>[00:03:23] <strong>Sarah:</strong> I hear you. I&#8217;ve just been doing something similar with watching test releases.</p>\n\n\n\n<p>[00:03:27] <strong>Josepha:</strong> Yeah. Just waiting and waiting and waiting. Yeah, absolutely. Absolutely.</p>\n\n\n\n<p>Well, let&#8217;s talk a little bit about 6.4. So WordPress 6.4 is our third major release of 2023, which is kind of a big deal for one because, like, three major releases a year is always exciting. But this particular one is, on the one hand, much larger from a feature standpoint than we kind of expected it to be, or so far, it looks like it&#8217;s going to be a bit larger than we expected.</p>\n\n\n\n<p>But also, it is our second iteration of an underrepresented gender release squad. Which I am very excited about. It&#8217;s a way for us to kind of bring in a lot of voices that otherwise we don&#8217;t see in the space. And so we&#8217;re going to just kind of talk through both of those things today. But let&#8217;s start with first: what are the things that are going into the release that you personally are most excited about, that you are most interested in making sure that we get all the way to the end of the release cycle?</p>\n\n\n\n<p>[00:04:27] <strong>Sarah:</strong> So, ones that I am particularly excited for. So, the first one on my list is the Font Library. This is looking really good to include as well. So it&#8217;s gonna do your way for users to manage fonts across their site regardless of their active themes. So similar how to how their media library works at the moment for images and other media.</p>\n\n\n\n<p>[00:04:44] <strong>Josepha:</strong> And if I recall correctly when I was looking at the prototypes for that, like the early demos of it, that has a lot of local font management as well, which helps us with GDPR concerns that we have had with font management in the CMS for a while. One, is that still correct? And two, does it look like it&#8217;s going to make it into the release?</p>\n\n\n\n<p>[00:05:04] <strong>Sarah:</strong> Yes. Yeah. Both correct. Yes. Yeah. Very easy. Yeah, that&#8217;s exactly right. So yeah, all the fonts will be managed locally. So, including things like Google Fonts. And any of the popular libraries and the way it&#8217;s been built, as it calls its files like this, it&#8217;s been built with extensibility in mind. So yeah, hopefully, the possibility should be endless for any number of font collections to be added.</p>\n\n\n\n<p>[00:05:23] <strong>Josepha:</strong> Yeah. Yeah. I, I know, for folks who are listening to this later, hopefully not much later, but if you are listening to this between when beta 1 came out and between and beta 2 is coming out, we didn&#8217;t get as much of that into beta 1 as we expected, but beta 2 should have a good chunk of it in there.</p>\n\n\n\n<p>So get out there and test that.</p>\n\n\n\n<p>[00:05:43] <strong>Sarah:</strong> It&#8217;s also just been released with Gutenberg 16.7 as well. So, I guess for anyone that you just mentioned listening in between.&nbsp;</p>\n\n\n\n<p>[00:05:51] <strong>Josepha:</strong> I&#8217;m one of those folks that has not; I don&#8217;t run trunk because I&#8217;m not that good with like preventing WordPress from falling apart. I&#8217;m not a developer, but I do run the nightlies and for the major releases for Core, and I run also the beta of Gutenberg. And so, I got both updates done this morning and started going in and looking at everything because I don&#8217;t run trunk. I didn&#8217;t have some of the weird edge cases that I saw reported over the last few weeks, which is probably good.&nbsp;</p>\n\n\n\n<p>[00:06:21] <strong>Josepha:</strong> But also, if anyone&#8217;s running trunk and is running all of the nightlies of anything, let us know where the problems are because there are not a lot of you. It feels like, like, a thousand people in the particular combination. What else is in there that you are very excited to see?</p>\n\n\n\n<p>[00:06:37] <strong>Sarah:</strong> I&#8217;m also looking forward to, so we have a new feature called Block Hook, and for anyone who follows Gutenberg, you might have heard it&#8217;s called Auto Inserting Blocks, but we&#8217;ve renamed it to Block Hook. And yes, this is another powerful feature that expands the extensibility of block themes. And so it allows plugins to automatically insert blocks into content relative to another block.</p>\n\n\n\n<p>And so, a good example that we&#8217;ve been using is automatically adding a like button to the post content block. And so yeah, I think it&#8217;s a, it&#8217;s maybe a more developer-centric feature.&nbsp;</p>\n\n\n\n<p>[00:07:09] <strong>Josepha:</strong> So, like, it detects what block you have and suggests bits and pieces that otherwise would make sense there that other people are usually using in those blocks.</p>\n\n\n\n<p>[00:07:20] <strong>Sarah:</strong> Yeah. Yeah. So you can add all through JSON as well. You can add a block that will automatically be added.</p>\n\n\n\n<p>[00:07:25] <strong>Josepha:</strong> All right. Excellent. That was part of the Interactivity API, or is, is early parts of it rather, I guess.</p>\n\n\n\n<p>[00:07:35] <strong>Sarah:</strong> Yes, that&#8217;s right. Yeah. Yeah. It&#8217;s the start.</p>\n\n\n\n<p>[00:07:39] <strong>Josepha:</strong> Another thing that is a part of the Interactivity API, which we&#8217;ve been working on, folks. I think everybody knows for like a year or two. The other part that is shipping in 6.4 is, I think, the Lightbox for images. Is that right?</p>\n\n\n\n<p>[00:07:55] <strong>Sarah:</strong> Yes, that&#8217;s right. Yes. And yeah, that&#8217;s due to be included with 6.4 as well.</p>\n\n\n\n<p>[00:07:59] <strong>Josepha:</strong> I&#8217;m going to just tell us all a weird story. So, for maybe my entire life, like I understand what a lightbox is from a image and photography standpoint, but for the majority of my life, I thought that lightbox referred to those like big initial letters in old manuscripts. I don&#8217;t actually know what those are called if not lightboxes, but in my mind, that&#8217;s what they were.</p>\n\n\n\n<p>[00:08:22] <strong>Josepha:</strong> And so when we first started talking about this, I was like, that&#8217;s what we&#8217;re shipping is like the drop capital letter, like the big one, but it&#8217;s not. In case anyone else also was confused about what a lightbox is, it&#8217;s the image-based concept of a lightbox.</p>\n\n\n\n<p>[00:08:37] <strong>Sarah:</strong> I think it&#8217;s an important one because previously you would have to install, maybe a third-party plugin or, or build lightbox yourself so. It may sound like a, oh, it&#8217;s a tiny feature that&#8217;s been included, but it&#8217;s actually pretty awesome. You don&#8217;t have to include even more extra code.&nbsp;</p>\n\n\n\n<p>[00:08:51] <strong>Josepha:</strong> Speaking of things that we have been working on for two years or so, I think that every sneak peek for the last year, the folks of WordPress have heard me say that I was super excited about navigation and how we&#8217;re managing it, but it turns out that is a very complicated thing. Like we know that, managing menus, managing navigation on a site is complicated from just like a philosophical standpoint. When our users of WordPress, when consumers of WordPress like go through that process, that is the hardest one to explain. And therefore, very hard to manage as well.&nbsp;</p>\n\n\n\n<p>We have had like a requirement that you know three different admins in order to manage your menu, manage your navigation on your site, but we shipped some early components for it in 6.3 and in 6.4. I believe that we are planning; I&#8217;m crossing my fingers no one can see it, crossing my fingers. We&#8217;re planning on getting an updated treatment for the toolbar out. Is that correct?</p>\n\n\n\n<p>[00:09:53] <strong>Sarah:</strong> Yes, yeah, I was a little bit worried because I didn&#8217;t know too much in detail, but I did know about the toolbar. So, yes, yes, I believe that is planned to get into 6.4.</p>\n\n\n\n<p>[00:10:01] <strong>Josepha:</strong> Yeah. So, and the point of that, because for folks who have not tried this out yet, the point of that is that the navigation is kind of, when you look at it, individual components, it&#8217;s like a bunch of little blocks together, and then we wrap it as like a collection that shows up as the navigation block, but because it&#8217;s a bunch of little blocks and each of the little blocks has their own like toolbar that goes with it, it took a lot of work to kind of figure out how to get all of those toolbars to have a primary expression with the navigation. Versus like every single thing that you put into your navigation has its own toolbar, and good luck to you.</p>\n\n\n\n<p>[00:10:44] <strong>Sarah:</strong> Yeah, it&#8217;s a really, really complicated problem, and I guess maybe it always has been, and hopefully we just keep improving and all the time, and we probably never will stop improving because it&#8217;s, yeah, it&#8217;s just such a complicated thing to edit, and I think particularly in an editor without using any code.</p>\n\n\n\n<p>[00:11:00] <strong>Josepha:</strong> Yes.</p>\n\n\n\n<p>[00:11:01] <strong>Sarah:</strong> We&#8217;re getting there, it always, it always is getting better.</p>\n\n\n\n<p>[00:11:04] <strong>Josepha:</strong> Yeah. Before we move into the question of like things that you wish people knew about the release that maybe they&#8217;re not going to know, I do want to stop and talk about the default theme a little bit. Everyone loves the default theme at the end of the year. But every year, Matt and I talk about, like, what would it look like if we didn&#8217;t have a default theme.</p>\n\n\n\n<p>What if we just were like, all themes are great. Just do whatever you want, which seems too difficult, frankly. But the way that this default theme is envisioned is so different. It&#8217;s got basically three different focuses. Do you know much about this year&#8217;s default theme?</p>\n\n\n\n<p>[00:11:41] <strong>Sarah:</strong> Yeah, a little bit, so I, yeah, I know, I don&#8217;t know, I think it&#8217;s shaping up to be a really good starting point for so many different types of projects. So, I know that that is maybe the aim of every default theme. But we usually show off a lot of the features that are going into the release, like via the default theme.</p>\n\n\n\n<p>I know we did that last time as well, but this time, we&#8217;re doing that stealth. But we&#8217;re also creating like a great baseline for so many different types of projects. And I think maybe in the past, we&#8217;ve maybe only hit like one type of project. And, like, this is a good example for this one very specific thing.</p>\n\n\n\n<p>But yeah, this time, I know that that&#8217;s always like, especially working with other themers, they&#8217;re like, what&#8217;s the best base theme for this type of thing? And I&#8217;m hoping Twenty Twenty-Four is going to be the new answer for so many people.</p>\n\n\n\n<p>[00:12:23] <strong>Josepha:</strong> Yeah, yeah, I looked at the early designs for that with the, because what it has, and these, we&#8217;ll put a link to this in the show notes to the repo about it and the Figma file and all those things. But what it has is like a really robust set of default patterns for anyone who&#8217;s wanting to have like a big commercial site with a lot of things that are required, a really complicated site. Then we have a suite of default patterns that are shipping so that artists and people who are focused primarily on visual assets on their site have the specific patterns and blocks and things required for that and then one that is specific to people who focus on the content in their site.</p>\n\n\n\n<p>I am one of the people who specifically focuses on the content in the site. I was delighted to see that, but it kind of has three different levels of varying complexity based on what it is that people might, might want to have to, oh, not want to have to, might want to be able to do on their sites. And I think that&#8217;s kind of cool.</p>\n\n\n\n<p>[00:13:31] <strong>Sarah:</strong> Yeah. Yeah. It&#8217;s super cool. And I think while we&#8217;re still in the development cycle as well, for 6.4, this is a; the default theme is a great way to jump into contributing if people are looking for good ways to jump in.</p>\n\n\n\n<p>[00:13:44] <strong>Josepha:</strong> Yeah, it runs in a separate repo. And so it has a little bit of a different process, but also it feels like a little bit of a faster process. It kind of runs independently of the release cycle that we have for either the plugin or core. And so it kind of goes a bit faster.</p>\n\n\n\n<p>[00:14:03] <strong>Sarah:</strong> Yes.</p>\n\n\n\n<p>[00:14:05] <strong>Josepha:</strong> Yeah. Excellent. So, then, obvious next question. What Is happening in this release that you wish people knew about?</p>\n\n\n\n<p>[00:14:15] <strong>Sarah:</strong> Yep. Okay. So, I think maybe things that are difficult to fit into the bigger categories that will be easy to shout about when we talk about the release when it&#8217;s been released. There&#8217;s a lot of accessibility enhancement that are going to be included. So there&#8217;s things like better button placements and upgraded spoken messages, especially in site health.</p>\n\n\n\n<p>There&#8217;s also so many performance improvements that are scheduled to be included, so I know there was many performance improvements included in 6.3. We are continuing that for 6.4. There&#8217;s many more improvements to block themes and classic themes in the way the templates are loaded. And we&#8217;ve also got a we&#8217;re including a usage of the new defer and async loading strategies as well for script.</p>\n\n\n\n<p>So these are sort of like, nitty-gritty detail sort of things that will be included that don&#8217;t sound too exciting but are actually really, really cool.&nbsp;</p>\n\n\n\n<p>[00:15:07] <strong>Josepha:</strong> Yeah. I understand the whole like, this is not very exciting. This doesn&#8217;t sound interesting but trust me, it is like, sometimes it feels like half of my job is that I&#8217;m like, I know that nothing I&#8217;m about to say sounds cool, but trust me, it&#8217;s amazing. We&#8217;ve been working on it for a long time, and it&#8217;s cool.</p>\n\n\n\n<p>That&#8217;s great. That&#8217;s great. And so. For those things, it sounds like a lot, this is going to particularly be of interest to folks who are developing for other people using WordPress. But also obviously a little bit of, of benefit, maybe invisible benefit, but still benefit for our end users as we go.</p>\n\n\n\n<p>[00:15:46] <strong>Sarah:</strong> Yeah, yeah, that&#8217;s right, exactly.</p>\n\n\n\n<p>[00:15:48] <strong>Josepha:</strong> So those are kind of the sneak peek items that we&#8217;ve got going into the release. As always, with this particular episode, we&#8217;re not promising that any of those things will 100 percent for sure get in there. There is part of being a release squad that kind of doesn&#8217;t really get talked about outside of WordPress but is probably worth mentioning, which is that the release squad has the really unpleasant job of saying no at the last second for things that are breaking something, things that are not actually a better user experience.</p>\n\n\n\n<p>Like we have the uncomfortable job of saying like, no, it wasn&#8217;t good enough. Sorry, thank you. Come again in the next release cycle. And so, like, all of these things are things that are currently in and being tested, but in the event that we discover it breaks 10 percent of the sites that we have on WordPress, like, we&#8217;re gonna, we&#8217;re gonna pull it.</p>\n\n\n\n<p>So, right now, that&#8217;s all in there, we hope, and if listening to me for a whole year get excited about the changes in navigation, and then also not getting them in didn&#8217;t teach you anything, just because I want it in doesn&#8217;t mean that I get to have it in either. So, but yeah, so that&#8217;s exciting. The other exciting thing about this release, we mentioned it a bit at the top of the discussion, is that it is a gender-upresented, gender-underrepresented release squad. Not upresented, because that is a, not a word. And so this is the second one. Did you participate in the first one?</p>\n\n\n\n<p>[00:17:22] <strong>Sarah:</strong> No, I didn&#8217;t no. Yeah, but I have read all about it, especially in prep to this release as well.</p>\n\n\n\n<p>[00:17:28] <strong>Josepha:</strong> Oh, did you learn anything from it that you brought into this one, or was it just like, I need to know what I&#8217;m getting into kind of reading a lot about it?&nbsp;</p>\n\n\n\n<p>[00:17:36] <strong>Sarah:</strong> Yeah, basically, yeah, I was trying to prep myself, ever since I was involved in 6.1, I&#8217;ve tried to be, I&#8217;ve tried to follow along closely with the releases. But sometimes, there&#8217;s just so much going on all the time. Sometimes it&#8217;s a little bit much. But yeah, I just wanted to see if there was any, any big differences.</p>\n\n\n\n<p>There shouldn&#8217;t be, right? So yeah, it&#8217;s all good.</p>\n\n\n\n<p>[00:17:54] <strong>Josepha:</strong> I think all of the differences were in that boring part where people don&#8217;t, they&#8217;re like, that sounds so un-fun, we&#8217;re going to just stop listening. But it was like, in the planning and preparation for it, and the way that we did all the training, like the initial one had like an 18 month period between like, we&#8217;re gonna do it, and now it&#8217;s done, where we did a lot of additional work to get everybody in there.</p>\n\n\n\n<p>[00:18:18] <strong>Josepha:</strong> And this time, we were like, get in here! That&#8217;s all we did. So, how has your experience been on the release squad? I know that you did one before. You did one in 6.1, but is this particular squad any different compared to your last experience of it, or what you expected?</p>\n\n\n\n<p>[00:18:35] <strong>Sarah:</strong> So, I would say everyone is equally as amazing as every release and, including the resource they&#8217;re involved with. I think that the biggest difference for me, and maybe this links to something you just said, is that I, I knew I was going to be involved in the release squad a lot earlier, especially compared to me for 6.1, but I think I&#8217;ve heard other people say that as well. So, I think that&#8217;s a great thing for this release. We all have had some time ahead of the release and including during this 6.3 release as well, so I was able to watch particular people in, not in a non-creepy way, and make sure I knew which, like what the processes were.</p>\n\n\n\n<p>Yes, to try and get my head around when when I&#8217;d be doing it. And, and obviously, the big help was that I&#8217;d be doing it immediately after they&#8217;d just done it as well. And the previous release squad has been a massive help as well when I&#8217;ve come across either very, very complicated issues or like super silly issues; I can write them and answer your questions so that I think if we could carry that forward with the future releases as well.</p>\n\n\n\n<p>[00:19:28] <strong>Josepha:</strong> Yeah, absolutely. So this time around, we had almost 50 percent new folks that that, like, let us know that they were participating, probably quite a few more than that. But, like, of the people who let us know that they wanted to participate in this release, we had like 28 out of 50 people, something like that, who are brand new to contributing to WordPress in some cases, but certainly, all of them are brand new to contributing to a major release like this. Have you, cause this is not your first time doing this, but it is your first time in this type of release. Have you found that, like, you&#8217;re feeling able to help new people see what&#8217;s happening also, like, do you feel seasoned enough for that? Or are you just like, nope, I&#8217;m also new.</p>\n\n\n\n<p>[00:20:17] <strong>Sarah:</strong> Maybe a little bit of both. I guess I, yeah, I&#8217;m fortunate to have at least experienced, maybe, like how the deadlines roll. Actually, especially the point we&#8217;re at at the moment, where the weekly beta cycles happened. Last time, it took me by surprise. I was like, oh wow, okay, we have a week. Until the next one, and then a week, and so yeah, I feel a bit more psyched up for that this time around.</p>\n\n\n\n<p>And hopefully, I can tap that on you to the new folks as well. But yeah, I also noticed we have a lot of new people. We have, especially from a core editor tech lead; I think we have nearly 30 people who are sort of officially following us along or shadowing us.</p>\n\n\n\n<p>So yeah, yeah, but it&#8217;s really cool. I hope we can teach so many more people if they want to get involved with the next release or even just contributing in general. Yeah, it&#8217;d be amazing.</p>\n\n\n\n<p>[00:21:00] <strong>Josepha:</strong> Yeah. If you are listening to our podcast, and you think to yourself, well, I&#8217;m here. And I wonder if anyone knows because I&#8217;m just watching everyone in a non-creepy way, like feel free at the next meeting that you&#8217;re watching to, to raise your hand and say, I&#8217;m new. We want to know that you&#8217;re there.</p>\n\n\n\n<p>Not because we feel creepy otherwise. But also because we just want to celebrate that you exist new folks that are scared of us. Don&#8217;t be scared of us.</p>\n\n\n\n<p>Oh, man, I feel compelled now to tell everybody about the first time that I led a core chat. So the core chat, I watched that without telling anyone I was watching it for like a year before I had to actually lead it, and I just didn&#8217;t tell anybody I was there like I didn&#8217;t even participate in the waving part at the start where it&#8217;s just like, Hey, everyone, I exist, like, when I was just silently watching it all go by and so when I got announced as part of a release squad. It was shocking for everyone, I think. And there is a public record of a moment where I was panicking. I felt like everyone was asking me a thousand questions, and I didn&#8217;t know the answers to any of them. And I just told all of them, like, there are a million of you and one of me, and you&#8217;re kind of scaring me, so would you stop?</p>\n\n\n\n<p>And so there&#8217;s a public record of me calling out every developer that existed in WordPress at the time. I felt bad about it in the moment, but also like, whew, that was, I don&#8217;t think we have experiences like that for new contributors anymore, but it was, it was quite a moment. I remember distinctly, so Jeffrey Paul, he&#8217;s like one of our, I think we have three or four like self-declared project managing people.</p>\n\n\n\n<p>He is a project manager person in WordPress that I really rely on, and I was DM&#8217;ing him in the background in a full panic. I was like, I don&#8217;t know the answer to any of these questions. What am I supposed to do? And he was like no is also an answer. So, like, just tell them no. Tell them you don&#8217;t know. That&#8217;s fine. And I was like, Oh, God! So, I think that we maybe don&#8217;t have too much of that happening anymore, but I also understand that I wouldn&#8217;t see it if it were happening. No one&#8217;s coming to me to be like, is this normal? Should I panic? They&#8217;re probably coming to you with that.</p>\n\n\n\n<p>[00:23:21] <strong>Sarah:</strong> I think it&#8217;s a sort of good, I&#8217;m not good for you, maybe, but good for observers especially. You know, to see you go through that as well. I can really relate to, like, not even showing, like, a wave emoji because I&#8217;ve totally been in that situation. I think maybe we&#8217;re similar in that regard, like, it, sometimes I just feel really nervous even just showing an emoji.</p>\n\n\n\n<p>And I think, again, shouting out about that and to, to those people who also feel like that, who are watching yeah, yeah, wave if you, if you feel like you want to, and don&#8217;t wave, it&#8217;s also fine just to watch.&nbsp;</p>\n\n\n\n<p>[00:23:48] <strong>Josepha:</strong> Once you&#8217;ve been to 52 meetings, then you can wave. Oh, it&#8217;s so hardworking in open source that way because, like, there is a lot of, like, basically faith in other people because trust comes with, like experiencing things together. But initially, you do just kind of have to have faith that no one&#8217;s going to laugh you out of the room or say that your ideas are stupid or that you are like even remotely understanding the problem, and so that&#8217;s a, it&#8217;s a part of the new contributor experience that I always find so interesting I used to routinely give presentations about like this is how you get started first get ready to be uncomfortable I don&#8217;t give those presentations very often anymore but probably probably I should ask someone to get out there and be like, It&#8217;s scary for everyone, including you!</p>\n\n\n\n<p>Come be scared together! Cause I think that&#8217;s important to normalize. Fear&#8217;s normal. When you first started contributing to WordPress in general, let alone like being on a release squad, what is the team that you first joined through?</p>\n\n\n\n<p>[00:25:02] <strong>Sarah:</strong> So, I guess, full-time contribution, it was themes. I was very involved with themes, and I still am as well; I really love themes, especially block themes. And also with the editor. But, like, years and years ago, I guess it was still themes. I used to build themes.</p>\n\n\n\n<p>But that was very much; I was a forum user, and well, actually, I guess it goes back to me being very nervous and not wanting to admit the question that I wanted to ask, so I would hunt the forums, but afterwards just so helpful.</p>\n\n\n\n<p>Like, yeah, I know this is a lot of people&#8217;s story, but yeah, the forums and just chatting amongst other community members is so, so helpful. So yeah, when I became a full-time contributor, I really, I love talking to other people who are trying to get help or, yeah, reaching out any way they can because I was like, I feel that I was you and still am you as well.</p>\n\n\n\n<p>[00:25:50] <strong>Josepha:</strong> I mean, the good thing about it, like, we will always feel like we&#8217;re learning something because we are, but in my experience of folks in WordPress, and I haven&#8217;t been new in a long time, obviously been doing this for like eight years now which is ancient by technology standards, but like my favorite thing about folks in WordPress is that they are wanting to like learn enough to probably not break it forever.</p>\n\n\n\n<p>Like it&#8217;s the probably is in there, and the forever is in there like I want to. I want to know just enough to be mildly dangerous and then bring everybody with me. Let&#8217;s go be dangerous together. And I think that is really charming in a way because it&#8217;s like we know enough to sort of break it. But not break it a lot.</p>\n\n\n\n<p>So let&#8217;s go see how we break it a little bit to make it better. I think that&#8217;s such a charming attitude for some reason because then we all just get to kind of learn and be a little bit messy together, which is the nature of openly collaborating on a half-written software—all the time. But yeah, I think it&#8217;s kind of neat.</p>\n\n\n\n<p>[00:27:05] <strong>Sarah:</strong> Yeah, yeah, exactly. It&#8217;s exciting too, like if you&#8217;re staying, you&#8217;ve got that enough red push and edge that you&#8217;re just like, Ooh, I might break something. But then there&#8217;s so many people that help you out that, you know, just before you could actually break something important.&nbsp;</p>\n\n\n\n<p>[00:27:18] <strong>Josepha:</strong> Exactly. The one time when I did a very breaking thing because I didn&#8217;t know to ask about it and fixed it immediately was that I mentioned in the middle of a core chat that we were about to have a security release. But it wasn&#8217;t about it wasn&#8217;t like in the next 15 minutes, it was like three weeks away, which is not what you&#8217;re allowed to do like you are not allowed to mention that you have a security release coming in three weeks, and then hope that nobody figures out what it&#8217;s patching.</p>\n\n\n\n<p>Yeah, I got so many messages in such a short amount of time from it felt like every lead developer of WordPress. That was my, my worst moment.</p>\n\n\n\n<p>And I fixed it immediately. So that was good. But also, I don&#8217;t remember if we had to like move up the, the timeline for that release or what. I don&#8217;t; I have no idea what the outcome was because I was just in an outright panic about what I had done incorrectly.</p>\n\n\n\n<p>Anyway, so that&#8217;s the; I&#8217;m just going to tell everybody my most embarrassing early contribution stories today. That&#8217;s what I&#8217;m doing. Excellent. Well, Sarah, before we head out of here, is there a final thought that you would like to share with either our listeners here or future potential contributors to WordPress?</p>\n\n\n\n<p>[00:28:37] <strong>Sarah:</strong> Please help test 6.4, especially through the next few cycles of beta. It would be amazing to have everyone and anyone who would like to help. That is one of the best ways you can help is to test. And then, yeah, if you want to get involved a little bit further, then yeah, I guess, please reach out wherever you think you fit, which I know sounds a bit fake, but there are a lot of different places, and I&#8217;m sure there will be somewhere you fit as well.</p>\n\n\n\n<p>00:28:59] <strong>Josepha:</strong> I will leave in the show notes a link to the page that has all of the upcoming meetings on it. You can probably go to almost any meeting and say, I think this is where I would like to contribute, but also, this is the kind of thing I can contribute, and they will be able to head you in the right direction if you&#8217;re not already in the right direction. But also, like, sometimes your skills that you have are going to be applicable in places where you&#8217;re not aware of yet. And so, go to any meeting—wave to the friendly WordPressers that are around, the Sarah Norrises that exist in the project.&nbsp;</p>\n\n\n\n<p>[00:29:36] <strong>Josepha:</strong> Sarah, thank you so much for joining me today. This was a delight.</p>\n\n\n\n<p>[00:29:39] <strong>Sarah:</strong> Thanks so much for having me on; I really enjoyed it.</p>\n\n\n\n<p>[00:29:42] (Music interlude)&nbsp;</p>\n\n\n\n<p>[00:29:42] <strong>Josepha:</strong> That brings us now to our small list of big things. First thing to know is that tomorrow we have Beta 2 for WordPress 6.4. This is our final release of the year, as you know because we&#8217;ve been talking about it for the entire episode. But, just like Sarah said at the end of our conversation, we absolutely need people to help us test it, make sure that it is working in as many places as possible so that we can have the best release possible. So keep an eye out on the core channel in the Making WordPress Slack, and of course, keep an eye on WordPress.org/news as those releases get packaged and ready to go.&nbsp;</p>\n\n\n\n<p>So the second thing is a proposal for documentation translation localization process update. This is an initial step to consolidate all of that documentation into a single easy-to-reach location. So we need some feedback on it. Head on over there, leave a comment to share your feedback about where that should possibly go, where is most useful and valuable for you.&nbsp;</p>\n\n\n\n<p>The second proposal that I have is actually sort of a tangentially related one, but so it&#8217;s not specific to WordPress but does need some WordPress input. There is a call for proposal for Interop 2024. There&#8217;s a post that has a lot more information about it than I do, but we would like for any WordPress developer who&#8217;s interested to head over there and submit a proposal for what they could speak about at Interop, I believe. You can leave your thoughts on the post itself as a comment, or there&#8217;s also a GitHub repo where you can interact as well.</p>\n\n\n\n<p>The next thing on our small list of big things is that the WordCamp US Q&amp;A, the questions that we didn&#8217;t get to because there were something like 87 or something in the queue. The questions that we didn&#8217;t get to, the answers have been posted. They&#8217;re over on make.WordPress.org/project, but I&#8217;ll include a link to those to that post in the show notes.&nbsp;</p>\n\n\n\n<p>And the final thing on the small list of big things, I&#8217;m actually quite excited about. We are hosting now accessibility office hours. In an effort to improve accessibility knowledge in the WordPress project in general, the accessibility team will be holding office hours every Wednesday at 14:00 UTC.</p>\n\n\n\n<p>That started on September 20th. And so it&#8217;s been going for a couple of weeks now. And the purpose is to make sure that we have a dedicated space and time to discuss accessibility principles and best practices as we go through those things.&nbsp;</p>\n\n\n\n<p>[00:32:29] <strong>Josepha:</strong> And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Hayden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\n\n\n<p>[00:32:38] (Music interlude)&nbsp;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Oct 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"Gutenberg Times: WordPress 6.4 Beta, NASA now on WordPress, Gutenberg 16.7, HTML API, Interactivity API – Weekend Edition #270\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25812\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://gutenbergtimes.com/wordpress-6-4-beta-nasa-now-on-wordpress-gutenberg-16-7-html-api-interactivity-api-weekend-edition-270/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15980:\"<p>Howdy, </p>\n\n\n\n<p>2009 I was invited to NASA first Launch TweetUp for <a href=\"https://www.flickr.com/photos/birgitpauli-haack/albums/72157622738192415\">STS 129 with ca 150 other Tweeple</a>. We learned about the shuttle lunch, it&#8217;s mission, talked to engineers, astronauts, and administrators of NASA, and shared it with our followers on Twitter. It was certainly one of the most interesting weekends in my life. </p>\n\n\n\n<p>In 2009, I also started my personal WordPress journey, testing and prodding searching for a CMS for a nonprofit internet service provider. I started on an incredible journey into web development, community building and open-source. </p>\n\n\n\n<p>Now in 2023, those two life threads come together. After three years building up to it, <a href=\"https://www.nasa.gov/general/nasa-publishes-beta-flagship-science-websites-as-improvements-continue/\">NASA launched their new website built with WordPress</a>. Members of the Website Modernization were invited to give WordCamp US participants a <a href=\"https://www.youtube.com/watch?v=LpDulftMkew\">sneak preview</a> and discussed the journey to get there. If you haven&#8217;t watched them yet, there were great presentations on the work. What a great way to showcase WordPress! WordPress and I have come a long way together. </p>\n\n\n\n<p>Other block editor and builder news are below. Enjoy! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-theme-development-for-full-site-editing-and-blocks\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p><strong><a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">WordPress 6.4 Beta 1</a></strong> was released, and is ready for testing. There are two calls for testing, you can follow: </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Help Test WordPress 6.4</a> </li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></li>\n\n\n\n<li>Damon Cook wrote <a href=\"https://wpengine.com/builders/beta-testing-wordpress-local-blueprints/\"><strong>Beta Testing WordPress with Local Blueprints</strong></a></li>\n</ul>\n\n\n\n<p><strong>Sarah Gooding</strong> also reported on the release for the WPTavern: <a href=\"https://wptavern.com/wordpress-6-4-beta-1-released\"><strong>WordPress 6.4 Beta 1 Released</strong></a>, with a short summary of all the great new features that will come to a WordPress instance near you. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his <strong><a href=\"https://make.wordpress.org/design/2023/09/25/design-share-sep-11-sep-22/\">Design Share: Sep 11-Sep 22</a>,</strong> <strong>Joen Asmussen</strong> highlighted the fabulous work of the WordPress design team: </p>\n\n\n\n<ul>\n<li>A second iteration for the WordPress Pattern Directory, features a refined submission flow and a new &#8220;Pattern Bundle&#8221; feature. You can navigate through a clickable prototype on Figma. </li>\n\n\n\n<li>Ongoing work in Pagination Design</li>\n\n\n\n<li>An Enterprise Notice on the WordPress site so link to a page about the &#8220;State of Enterprise for WordPress&#8221; guide. </li>\n\n\n\n<li>More exploration on organizing the Command Palette displays. </li>\n\n\n\n<li>A polished modal on Mobile</li>\n</ul>\n\n\n\n<p>Comment or contribute. </p>\n\n\n\n<a href=\"https://make.wordpress.org/design/2023/09/25/design-share-sep-11-sep-22/\"><img width=\"652\" height=\"360\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-14.59.59.png?resize=652%2C360&ssl=1\" alt=\"Pattern bundles shown in the Design share post \" class=\"wp-image-25831\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Sarah Norris</strong>, Editor Tech co-lead for WordPress 6.4, also was the release lead of Gutenberg 16.7 and published the release post to let you know<strong> <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">What’s new in Gutenberg 16.7? (27 September)</a></strong>. She highlighted a ton of features: <br /></p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/?p=108291#font-management-with-the-font-library\">Font Management with the Font Library</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#import-export-of-patterns\">Import/Export of Patterns</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#explore-new-pattern-filtering\">Explore New Pattern Filtering</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#naming-group-blocks-in-the-editor\">Naming Group Blocks in the Editor</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#my-patterns-category-reinstated-in-post-editor-inserter\">“My Patterns” Category Reinstated in Post Editor Inserter</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#simplified-lightbox-functionality-for-images\">Simplified Lightbox Functionality for Images</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#background-image-control-added-to-group-block\">Background Image Control Added to Group Block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/?p=108291#new-social-link-icon-for-x\">New Social Link Icon for X</a></li>\n</ul>\n\n\n\n<a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/#font-management-with-the-font-library\"><img width=\"652\" height=\"376\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/fonts.png?resize=652%2C376&ssl=1\" alt=\"Font management screenshot \" class=\"wp-image-25833\" /></a>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/dcook\">Damon Cook</a></strong> announced on X (former Twitter) : &#8220;I&#8217;ve helped write #WordPress themes that went on to have 80,000+ installs, but never under my own name and always under the guise of an agency I was working for. Today, I&#8217;ve finally contributed a theme on .org with sole attribution.&#8221; Congratulations to Damon Gook for getting his first theme into the repository. The Theme is a block theme and called <a href=\"https://wordpress.org/themes/bounds/\"><strong>Bounds.</strong></a> &#8220;This theme is meant for slide decks. Use it for your next presentation. The default experience includes scroll snapping on large screens. There is also a style variation for a horizontal scroll snapping.&#8221; Cook wrote. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><a href=\"https://twitter.com/m_munirkamal\"><strong>Munir Kamal</strong></a> announced a new feature for the almost evergreen EditorsKit plugin: <a href=\"https://www.youtube.com/watch?v=SGEhm4_sXT4\"><strong>adding and managing Block Styles.</strong> </a>It&#8217;s a great example of how the WordPress Site editor can be used as a modern Design Tool for all kinds of use cases.  Download the <a href=\"https://wordpress.org/plugins/block-options/\">EditorsKit from the WordPress repository.</a> </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/TarunVijwani\">Tarun Vijwani</a></strong> published the release notes for the <a href=\"https://developer.woocommerce.com/2023/09/29/woocommerce-blocks-11-2-0-release-notes/\"><strong>WooCommerce Blocks 11.2</strong></a> release and highlighted blockified order confirmation, product collection patterns, the new Store API order endpoints and more. </p>\n\n\n\n<img width=\"652\" height=\"274\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-18.18.52.png?resize=652%2C274&ssl=1\" alt=\"\" class=\"wp-image-25845\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-theme-development-for-full-site-editing-and-blocks\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><strong>Sarah Gooding </strong>recounts the story of <strong>Mike McAllister&#8217;s</strong> woes of being a trailblazer.   <a href=\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\"><strong>Ollie Theme Faces Pushback from WordPress Theme Review Team</strong></a>. Adding onboarding setting screens to his newest block theme, bump up against the Theme directory&#8217;s guidelines as plugin territory. People agree that there needs onboarding solutions for new WordPress users after they log in into their freshly installed WordPress instance. </p>\n\n\n\n<p>The team at Extendify also has a <a href=\"https://extendify.com/launch/\">launch solution</a> it offers to the hosting companies as a stand-alone product also built with Gutenberg components on top of WordPress. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>James Koussertari</strong> of Gutenberg Market updated his <a href=\"https://gutenbergmarket.com/news/a-comprehensive-guide-to-building-wordpress-block-themes\"><strong>Comprehensive Guide to Building WordPress Block Themes</strong></a>. &#8220;Now inline with the latest version of WordPress (I think)&#8221; <a href=\"https://twitter.com/jkoussertari/status/1707513300190142798\">he tweeted on X</a>. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In their <a href=\"https://www.youtube.com/watch?v=HfMYdvpbEqs\"><strong>September Friday Hangout,</strong></a> Webdev Studios folks, <strong>Brad Williams,</strong> <strong>Victor M Ramirez</strong>, <strong>Raquel Manriquez and Alfredo Navas</strong>, talked about full site editing and WordCamps. &#8220;<em>FSE is an exciting advancement in website development that makes it easier than ever for anyone to create a professional-looking website, regardless of their technical skills.&#8221;</em> They wrote in the description. They also mentioned their WDS <a href=\"https://github.com/webdevStudios/wd_f\"><strong>WordPress Site Editor (FSE) Starter Block Theme</strong></a>, that is available on GitHub. </p>\n\n\n\n<a href=\"https://www.youtube.com/watch?v=HfMYdvpbEqs\"><img width=\"652\" height=\"369\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-30-at-16.49.59.png?resize=652%2C369&ssl=1\" alt=\"Screenshot of the panel in September Friday Hangout.\" class=\"wp-image-25834\" /></a>\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p><strong><a href=\"https://twitter.com/marybaum\">Mary Baum</a> </strong>published an introduction to <a href=\"https://developer.wordpress.org/news/2023/09/the-html-api-process-your-tags-not-your-pain/\"><strong>The HTML API: process your tags, not your pain</strong></a> on the WordPress Developer blog: &#8220;All by itself, the HTML Tag processor is better than regular expressions. It&#8217;s convenient, reliable, fast—and You. Can. Read. It. This article shows you in two examples how to get started using the HTML Tag processor.&#8221; It also has a great list of resources for those who need to dive much, much deeper. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> posted another episode of his Block Cook Book recipes on YouTube: <a href=\"https://www.youtube.com/watch?v=Sj61X_Xtfzc\"><strong>The Interactivity API</strong></a>, and how to use the @wordpress/create-block-interactive-template template to scaffold a block that uses it.</p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: Screenshot of the WordPress site on nasa.gov in 2023. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Sep 2023 12:54:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: Gutenberg 16.7 Introduces Font Management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149617\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/gutenberg-16-7-introduces-font-management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3738:\"<p><a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">Gutenberg 16.7</a> was released this week, packed with several features that are headlining the upcoming WordPress 6.4 release. This will be the last plugin release that will be rolled into the next version of WordPress. </p>\n\n\n\n<p>Font management with the new font library is now available for testing in the plugin. These features standardize a way to add font collections to WordPress&#8217; new font library, so plugin authors can register lists of fonts and users can install the ones they want. It also enables font foundries to create their own WordPress plugins to provide access to their fonts.</p>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/issues/54169\">Font Library</a> manages fonts independently of a site&#8217;s active theme, allowing users to install, remove, and activate fonts from various sources in WordPress. This works in a similar way to the Media Library.</p>\n\n\n\n<p>After updating to Gutenberg 16.7, users can navigate to Styles > Typography to manage fonts. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1752\" height=\"1086\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.24.43-PM.png\" alt=\"\" class=\"wp-image-149693\" />\n\n\n\n<p>From there, users can launch the Font Library, which loads in a popup screen, and browse all of the installed fonts. A Google Fonts tab allows for installing additional fonts that will be loaded locally from the user&#8217;s server. This gives site editors  more freedom in selecting the typography for their websites instead of relying on a theme or plugin to provide font options.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2060\" height=\"1194\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.28.40-PM.png\" alt=\"\" class=\"wp-image-149694\" />\n\n\n\n<p>Gutenberg 16.7 also brings several important enhancements to patterns. Users can now <a href=\"https://github.com/WordPress/gutenberg/pull/54337\">import and export patterns as JSON files</a> from the Patterns screen, making it easier to share patterns to other WordPress sites. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"2184\" height=\"998\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-29-at-5.41.01-PM.png\" alt=\"\" class=\"wp-image-149697\" />\n\n\n\n<p>The &#8220;My Patterns&#8221; category designation has also been reinstated to the post editor&#8217;s inserter, based on feedback after it had been removed.</p>\n\n\n\n<p>Inside the the inserter in the post editor, pattern filters have been relocated to a dropdown at the top of the pattern list panel, along with a sticky header to help with navigation.</p>\n\n\n\n<p>Other notable highlights of Gutenberg 16.7 include the following: </p>\n\n\n\n<ul>\n<li>Group blocks can now have custom names, making it easier to know what they are in the List View</li>\n\n\n\n<li> New Social Link icon for the X service (formerly known as Twitter)</li>\n\n\n\n<li>New ability to toggle ‘nofollow’ setting for inline links (rich text only)</li>\n\n\n\n<li>Add aspect ratio to image placeholder</li>\n\n\n\n<li>Image block: Revise lightbox UI to remove ‘behaviors’</li>\n\n\n\n<li>Image block: UI updates for the image lightbox (redo)</li>\n</ul>\n\n\n\n<p>Gutenberg 16.7 includes 331 pull requests from 88 contributors. For more details on all the enhancements, bug fixes, accessibility, performance, code quality, testing, and tooling improvements, check out the full <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/#import-export-of-patterns\">changelog in the release post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Sep 2023 22:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Matt: Houston, we have a solution\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=99419\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://ma.tt/2023/09/houston-we-have-a-solution/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:420:\"<p>The new <a href=\"https://www.nasa.gov/\">NASA.gov</a> website has <em>launched</em> on WordPress powered by <a href=\"https://wpvip.com/\">WPVIP</a>. (Also their <a href=\"https://science.nasa.gov/\">science site</a>.)</p>\n\n\n\n<a href=\"https://www.nasa.gov/\"><img width=\"604\" height=\"553\" src=\"https://i0.wp.com/ma.tt/files/2023/09/nasa-homepage-min-1024x937.png?resize=604%2C553&ssl=1\" alt=\"\" class=\"wp-image-99420\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Sep 2023 17:44:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Do The Woo Community: Parts of the Brain Thinking About Ideas, Episodes and WordPress Highlights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76686\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://dothewoo.io/parts-of-the-brain-thinking-about-ideas-episodes-and-wordpress-highlights/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"<p>The week wraps up with my thoughts on an idea, WordPress and WooCommerce highlights, podcast episodes and parts of my brain.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/parts-of-the-brain-thinking-about-ideas-episodes-and-wordpress-highlights/\">Parts of the Brain Thinking About Ideas, Episodes and WordPress Highlights</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Sep 2023 13:21:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Ollie Theme Faces Pushback from WordPress Theme Review Team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/ollie-theme-faces-pushback-from-wordpress-theme-review-team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13737:\"<p>Mike McAlister, creator of the <a href=\"https://olliewp.com/\">free Ollie theme</a>, has been working towards getting his theme approved for hosting on WordPress.org. Ollie <a href=\"https://wptavern.com/ollie-block-theme-now-in-public-beta\">went into public beta</a> in April 2023 and gained momentum over the next few months when McAlister <a href=\"https://wptavern.com/ollie-theme-previews-new-onboarding-wizard-in-development\">previewed the theme&#8217;s new onboarding wizard</a>.</p>\n\n\n\n<p>WordPress users have been slow to adopt the block editor and block themes by extension. In 2022, only <a href=\"https://wordpress.org/news/files/2023/05/2022-Annual-Survey-Final.pdf\">54% of respondents to WordPress&#8217; annual survey have used the block editor</a>, four years after it was introduced. Block themes have trickled into the official directory, far behind the lofty goals set for their expansion. The sluggish movement towards block-based sites has led some to speculate on <a href=\"https://thewpminute.com/will-there-ever-be-a-market-for-commercial-block-themes/\">whether there will ever be a market for commercial block themes</a>.</p>\n\n\n\n<p>Ollie was designed to make onboarding to a block theme easier and the Site Editor more approachable, so that users don&#8217;t have to start from a blank canvas. The theme&#8217;s <a href=\"https://olliewp.com/ollie-demo/\">demo</a> boasts &#8220;a 40-hr head start&#8221; on setting up a new WordPress website, thanks in part to dozens of patterns for fast page building. Ollie&#8217;s built-in onboarding experience aims to drastically reduce the amount of time users spend getting started.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1200\" height=\"900\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/screenshot.png\" alt=\"\" class=\"wp-image-149635\" />\n\n\n\n<p>After receiving significant pushback from the Theme Review team during Ollie&#8217;s three weeks in the queue, McAlister has put up a poll requesting feedback on how he should proceed.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">After a very rocky (and downright combative) theme review process at <a href=\"https://t.co/SPJ2MEtIlL\">https://t.co/SPJ2MEtIlL</a>, I\'m not sure if it\'s the right place for our <a href=\"https://twitter.com/BuildWithOllie?ref_src=twsrc%5Etfw\">@BuildWithOllie</a> project. <br /><br />I\'m torn and would love your input. More context below and a poll at the end.</p>&mdash; Mike McAlister <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9d1-200d-1f680.png\" alt=\"🧑‍🚀\" class=\"wp-smiley\" /> (@mikemcalister) <a href=\"https://twitter.com/mikemcalister/status/1707446456037134471?ref_src=twsrc%5Etfw\">September 28, 2023</a></blockquote>\n</div>\n\n\n\n<p>Although provisionally approved by veteran theme reviewer Justin Tadlock, who said the onboarding functionality should be allowed until WordPress core offers a standard solution, Ollie was met with heavy criticism from other members of the team.</p>\n\n\n\n<p>&#8220;The setup wizard is plugin territory,&#8221; UXL Themes founder and theme reviewer Andrew Starr said. &#8220;Why not make this as a plugin that would work with any block theme? A plugin could be inspiration or a nudge to improve the core experience.&#8221;</p>\n\n\n\n<p>McAlister responded to this question in the <a href=\"https://themes.trac.wordpress.org/ticket/149883\">Trac ticket for the review</a> and in posts on X. He maintains that a plugin is a &#8220;far worse experience for the end user&#8221; and for his team as the maintainers of the product. Also, since the plugin review queue has 1,249 plugins awaiting review with developers waiting an average of 98 days for an initial review, a plugin for Ollie&#8217;s onboarding experience would likely not be live until next year.</p>\n\n\n\n<p>&#8220;As a compromise and show of good faith, I&#8217;ve chopped down the onboarding wizard to a fraction of what it was,&#8221; he said. &#8220;No dice. Still, it continues to be a highly contentious issue that is causing folks to publicly question my intentions and integrity. Disheartening to say the least.&#8221;</p>\n\n\n\n<p>Automattic-sponsored contributor Justin Tadlock, who helped author the guidelines in question many years ago and who has <a href=\"https://wptavern.com/wordpress-theme-review-team-is-cracking-down-on-violations-of-the-presentation-vs-functionality-guideline\">historically</a> been widely esteemed for his impeccable judgment in regards to the <a href=\"https://justintadlock.com/archives/2015/05/28/the-theme-review-teams-content-creation-discussion\">grey areas of content creation</a> in themes and the <a href=\"https://wptavern.com/why-wordpress-theme-developers-are-moving-functionality-into-plugins\">necessity of preserving data portability</a>, weighed in on the ticket after performing the initial review:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>As someone who co-wrote the original guideline for settings to use the customizer, I can say with 100% certainty that we never meant that to be a hard line drawn in the sand. The team reps can and have always had the capability to mark a theme as a &#8220;special case&#8221; (there&#8217;s even a tag for this in the backend, or there was when I was a rep). And there are themes where we felt like the functionality was unique enough to give it a bit of wiggle room. That was a position that we took when we wrote the &#8220;settings must be in the customizer&#8221; guideline. While I&#8217;m no longer one of the team reps, I feel like this settings page feature is unique enough to mark as a &#8220;special case.&#8221;</p>\n\n\n\n<p>With block themes, some things must be reevaluated because the customizer is not available by default and is not an expected part of the block theme experience. In fact, this guideline is very specific to classic themes. Nothing has been written yet for block themes. Whether that&#8217;s a good thing, I don&#8217;t know. This could be a good moment for experimentation.</p>\n\n\n\n<p>I disagree that the settings page should be packaged as a companion plugin. That defeats the purpose of its inclusion in the theme, and it would create an additional hurdle for the users who would benefit the most from this feature.</p>\n</blockquote>\n\n\n\n<p>Yoast-sponsored contributor Carolina Nymark <a href=\"https://themes.trac.wordpress.org/ticket/149883#comment:21\">contends</a> that allowing this onboarding experience will set a precedent that erodes the standard the team is trying to uphold for the ecosystem of themes hosted on WordPress.org and gives Ollie an unfair commercial advantage:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>&#8220;That settings pages are not allowed is in many ways unrelated to the customizer. And if we really want to angle it that way, it would be way easier to re-enable the customizer link in the theme.</p>\n\n\n\n<p>It is about having a&nbsp;<strong>standard</strong>&nbsp;that is easy for&nbsp;<strong>all</strong>&nbsp;theme authors to use and easy to review.<br />It is about not opening up the reviews to another situation with incredibly difficult and time consuming reviews of code that the theme developers themselves don&#8217;t understand because they copy-pasted it and managed to cause all sorts of errors and security issues.<br /><strong>Where</strong>&nbsp;that feature &#8220;lives&#8221;, in the customizer or on another page, is not the issue.</p>\n\n\n\n<p>I would like everyone to also consider that the Site Editor is not at all far away from solving the problem with the initial template selection. It does not solve all onboarding steps, like getting to the Site Editor, but it is improving.</p>\n\n\n\n<p>Compare it with the use of TGMPA. There is a problem that needs solving and a solution has been agreed upon where the theme author and reviewers only need to adjust a few variables and text strings.</p>\n\n\n\n<p>If something similar could be reached here I would support it.</p>\n\n\n\n<p>This is not about a special case, because it is an unfair commercial advantage over other theme developers.</p>\n</blockquote>\n\n\n\n<p>Ollie is a beautifully-designed multipurpose theme of the highest caliber, the likes of which WordPress.org doesn&#8217;t see very often. If expanding block theme adoption is an important goal, these are the kinds of experiences you want people building for WordPress users. It may be time to redefine theme guidelines based on the possibilities that the block editor enables, instead of saddling block themes with antiquated constraints <a href=\"https://twitter.com/carolinapoena/status/1707128165808713756?s=20\">for the sake of maintaining a more expedient review process</a>.</p>\n\n\n\n<p>&#8220;Just because there are problems with onboarding it doesn&#8217;t mean that a theme, any theme, is the right tool just because one can put code in it,&#8221; Nymark said. &#8220;Plugins extend features, themes display content.&#8221;</p>\n\n\n\n<p>Given the amount of pushback from the Theme Review team, McAlister is now torn about removing everything &#8220;extra&#8221; to get Ollie in the directory for better distribution, or to keep the innovations in place and forego the directory in favor of independent distribution. So far, the results of his poll are overwhelmingly in favor of McAlister distributing the theme himself. </p>\n\n\n\n<p>&#8220;I’m passionate about innovation and getting the most out of all the possibilities that modern WordPress affords us,&#8221; McAlister told the Tavern. &#8220;We were tasked to &#8216;Learn JavaScript Deeply&#8217; not to remain where we’ve been for so long, but to push the boundaries and scope out the future of WordPress and what’s possible. </p>\n\n\n\n<p>&#8220;So we designed and developed Ollie’s educational dashboard and onboarding wizard to help users get over some of the hurdles they’ve been plagued with for so long when setting up a new site or switching to a new theme. We even designed it in a very core-inspired way to match the site editor to create a very cohesive experience. The feedback has been inspiring!&#8221; </p>\n\n\n\n<p>After <a href=\"https://twitter.com/mikemcalister/status/1707446456037134471\">posting</a> about his experience with the Theme Review team, which McAlister characterized as &#8220;rocky (and downright combative),&#8221; the community following his work on Ollie <a href=\"https://twitter.com/mikemcalister/status/1706389121717969202\">over the past year</a> has rallied around him with advice and support.</p>\n\n\n\n<p>&#8220;I am torn about this,&#8221; Joost de Valk <a href=\"https://twitter.com/jdevalk/status/1707483200082100561\">commented</a> on McAlister&#8217;s poll on X. &#8220;I feel WordPress needs these onboarding experiences. Very very much. Should it be in themes? Not sure. Should the theme repository block this stuff? I don’t think so… we should be open to experimenting with this a bit more.&#8221;</p>\n\n\n\n<p>McAlister said that even as the theme&#8217;s creator, he is torn about the decision as well.</p>\n\n\n\n<p>&#8220;I built this as a good faith attempt to help people onboard into block themes and hopefully even help drive adoption,&#8221; he said. &#8220;My intentions are pure and steeped in 15 years of doing it &#8216;the WP way.&#8217; It’s an attempt to move the needle, worth a shot anyway.&#8221;</p>\n\n\n\n<p>&#8220;I always felt that onboarding like this should be part of Core,&#8221; Yoast-sponsored contributor Ari Stathopoulos <a href=\"https://twitter.com/aristath/status/1707483762336919738\">commented</a>. &#8220;The current experience for a newcomer to WP is not a good one. We have to start somewhere… if it’s in themes, then so be it.&#8221;</p>\n\n\n\n<p>WordPress&#8217; Theme Review team has a critical choice here, whether to stifle innovation and throw the book at one of the most highly anticipated block themes, or identify this as a special case where the author has the users&#8217; best interests at heart. </p>\n\n\n\n<p>Many participants in the discussion on X encouraged McAlister to distribute his work independently, citing examples of other WordPress products that have found success in doing so. This would be an unfortunate loss for WordPress.org where the project is essentially shooting itself in the foot by clinging to outmoded guidelines in order to deny high quality block themes that are innovating to create a better user experience. In pursuit of a more robust offering of block themes, the last thing WordPress needs to do is chase away its trailblazers.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Generally speaking, given the amount of pure sh*t available in the .org repo, the fact that they wont welcome you with open arms just stinks.<br /><br />Self distribute.<br /><br />You\'ve got something incredible here.</p>&mdash; Anthony (@ant_thedesigner) <a href=\"https://twitter.com/ant_thedesigner/status/1707490391316922793?ref_src=twsrc%5Etfw\">September 28, 2023</a></blockquote>\n</div>\n\n\n\n<p>&#8220;Since this morning, there has been an overwhelming amount of feedback telling me to avoid the WordPress.org directory,&#8221; McAlister said. &#8220;I’m kind of bummed by this because I think it says something about the directory that a lot of folks think but few want to say out loud. </p>\n\n\n\n<p>&#8220;Personally, I want the directory to succeed and be an inspiring and resourceful jump-off point for new WordPress users! It’s the front page of our open source project, of our community. It should be a showcase of the finest our community has to offer. But today, I’m disheartened and not sure if it’s the place where I want to put some of my best work to date.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Sep 2023 05:07:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Post Status: WordPress 6.4 • Annual Survey • Stats &amp; Dashboards • Global Sponsorship\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=155508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://poststatus.com/wordpress-6-4-annual-survey-stats-dashboards-global-sponsorship/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16119:\"<h2 class=\"wp-block-heading alignfull\" id=\"h-this-week-at-wordpress-org-september-14-2023\">This Week at WordPress.org (September 14, 2023)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">β WordPress 6.4 Beta 1 is out now<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2611.png\" alt=\"☑\" class=\"wp-smiley\" />︎ Take the annual WordPress survey<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4ca.png\" alt=\"📊\" class=\"wp-smiley\" /> Data about the WordPress Project<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f310.png\" alt=\"🌐\" class=\"wp-smiley\" /> Global Sponsorship Program </p></div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n<div class=\"gb-container gb-container-5e804289\">\n\n<h2 class=\"wp-block-heading\" id=\"h-news\"><a href=\"https://wordpress.org/news\">News</a></h2>\n\n</div>\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/09/help-influence-the-future-of-wordpress-by-taking-the-2023-annual-survey-today/\">Help Influence the Future of WordPress by Taking the 2023 Annual Survey Today</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">WordPress 6.4 Beta 1</a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-community-summit-notes\"><a href=\"https://make.wordpress.org/summit\">Community Summit Notes</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/summit/2023/09/21/community-summit-2023-your-role-in-whats-next/\">Community Summit 2023: Your Role in What’s Next</a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-2 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\">WordPress 6.4</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/07/18/wordpress-6-4-whats-on-your-wishlist/\">WordPress 6.4: What’s on your wishlist?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">WordPress 6.4 Development Cycle</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/14/hallway-hangout-whats-new-for-developers-in-wordpress-6-4/\">Hallway Hangout: What’s new for developers in WordPress 6.4</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-columns is-layout-flex wp-container-5 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/community\">Community</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2023/09/28/proposed-2024-global-community-sponsorship-program/\">Proposed 2024 Global Community Sponsorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/09/22/meetup-organizer-newsletter-september-2023/\">Meetup Organizer Newsletter: September 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/09/22/recap-of-the-contributor-working-groups-mentorship-chat-on-september-21-2023/\">Recap of the Contributor Working Group’s Mentorship Chat on September 21, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">What’s new in Gutenberg 16.7? (27 September)</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-developer-blog\"><a href=\"https://developer.wordpress.org/news/\">Developer Blog</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2023/09/the-html-api-process-your-tags-not-your-pain/\">The HTML API: process your tags, not your pain</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/09/understanding-block-attributes/\">Understanding block attributes</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/27/dev-chat-agenda-september-27-2023-2/\">Dev Chat agenda, September 27, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/26/editor-chat-agenda-27-september-2023/\">Editor Chat Agenda: 27 September 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/25/editor-chat-summary-september-20th-2023/\">Editor chat summary: September 20th, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/22/dev-chat-summary-september-20-2023/\">Dev Chat Summary, September 20, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2023/09/25/design-share-sep-11-sep-22/\">Design Share: Sep 11-Sep 22</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2023/09/25/end-user-docs-repo-workflows-and-settings/\">End-user docs repo – workflows and settings</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2023/09/22/online-monthly-docs-team-contributor-day-september-26-2023/\">Online monthly Docs Team Contributor Day September 26, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2023/09/26/set-up-two-factor-authentication-wordpress-org/\">Set up Two-Factor authentication WordPress.org</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/09/26/community-meeting-recap-2023-09-26/\">Community Meeting Recap (2023-09-26)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/09/25/last-week-openverse-2023-09-18-2023-09-25/\">A week in Openverse: 2023-09-18 – 2023-09-25</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/27/dev-chat-agenda-september-27-2023-2/\">Dev Chat agenda, September 27, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/09/19/update-turning-the-tide/\">Update: Turning the Tide</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/plugins/2023/08/21/xpost-wordpresscs-3-0-0-is-now-available/\">WordPressCS 3.0.0 is now available</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\" id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2023/09/20/previewing-patterns-during-translation/\">Previewing patterns during translation</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-project\"><a href=\"https://make.wordpress.org/project\">Project</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2023/09/25/request-for-feedback-make-team-dashboards/\">Request for Feedback: Make/Team Dashboards</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2023/09/agenda-for-september-28th-support-meeting-2/\">Agenda for September 28th Support Meeting</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/sustainability\">Sustainability</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/sustainability/2023/09/26/sustainability-chat-agenda-september-29-2023/\">Sustainability Chat Agenda, September 29, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/09/27/test-team-reps-submit-your-votes/\">Test Team Reps: Submit Your Votes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">Help Test WordPress 6.4</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-theme\"><a href=\"https://make.wordpress.org/theme\">Theme</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2023/09/27/themes-team-meeting-notes-september-26-2023/\">Themes Team Meeting Notes –&nbsp;September 26, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2023/09/15/theme-handbook-overhaul-phase-3-publishing-content/\">Theme Handbook Overhaul: Phase 3 (Publishing Content)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/training/2023/09/28/discussion-defining-active-and-engaged-faculty/\">Discussion: Defining Active and Engaged Faculty</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/09/27/looking-for-feedback-updates-to-github-issue-templates-and-labels/\">Looking for feedback: Updates to GitHub issue templates and labels</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/09/26/training-team-meeting-recap-19th-september-2023/\">Training Team Meeting Recap – 19th September 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/09/26/looking-for-feedback-learn-website-information-architecture/\">Looking for Feedback: Learn Website Information Architecture</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/09/21/proposal-updating-the-contributor-ladder-to-a-five-path-model/\">Proposal: Updating the Contributor Ladder to a five-path model</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=how-to-write-meeting-recap-notes-for-the-wordpress-training-team-2\">How to Write Meeting Recap Notes for the WordPress Training Team</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=how-to-write-meeting-recap-notes-for-the-wordpress-training-team\">How to Write Meeting Recap Notes for the WordPress Training Team</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=five-for-the-future-how-to-succeed-by-making-ongoing-contributions-to-wordpress-2\">Five for the Future: How to succeed by making ongoing contributions to WordPress</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=common-apis-settings\">Common APIs – Settings</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=developer-hours-building-better-blocks-with-the-create-block-package\">Developer Hours: Building better blocks with the ‘create-block’ package</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=a-brief-history-of-wordpress-4\">A Brief History of WordPress</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=apac-building-a-home-page\">APAC: Building a home page</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=building-a-home-page\">Building a home page</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://blog.jquery.com/2023/08/28/jquery-3-7-1-released-reliable-table-row-dimensions/\">jQuery 3.7.1 Released: Reliable Table Row Dimensions</a></li>\n\n\n\n<li><a href=\"https://github.com/nodejs/node/blob/main/doc/changelogs/CHANGELOG_V20.md#20.7.0\">Node</a> <a href=\"https://github.com/nodejs/node/blob/main/doc/changelogs/CHANGELOG_V20.md#20.7.0\">20.7.0</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-09-28-2\">PHP 8.3.0 RC 3 available for testing</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-09-28-1\">PHP 8.2.11 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-08-31-3\">PHP 8.1.23 Released!</a></li>\n\n\n\n<li><a href=\"https://github.com/PHPMailer/PHPMailer/releases/tag/v6.8.1\">PHPMailer 6.8.1</a></li>\n\n\n\n<li><a href=\"https://dev.mysql.com/doc/relnotes/mysql/8.0/en/news-8-0-35.html\">Changes in MySQL 8.0.35 (Not yet released, General Availability)</a></li>\n\n\n\n<li><a href=\"https://262.ecma-international.org/\">TC39</a></li>\n\n\n\n<li><a href=\"https://github.com/composer/composer/releases\">Composer </a><a href=\"https://github.com/composer/composer/releases/tag/2.6.3\">2.6.3</a></li>\n\n\n\n<li><a href=\"https://chromiumdash.appspot.com/schedule\">Chromium Roadmap</a></li>\n\n\n\n<li><a href=\"https://whattrainisitnow.com/calendar/\">Firefox Release Calendar</a></li>\n\n\n\n<li><a href=\"https://developer.apple.com/documentation/safari-release-notes\">Safari Release Notes</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong>   <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status&#8217; <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It&#8217;s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>.  </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and your whole team can <a href=\"https://poststatus.com/join/\">join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Sep 2023 17:10:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Managing Client Expectations, Partnerships, Woo Experts and Tips\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://dothewoo.io/woocommerce-agency-chat-alex-frison-nils-fredrik/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:444:\"<p>Nils and Alex chat about managing client expectation, partnerships and collaboration, the Woo expert program and end with agency tips.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-agency-chat-alex-frison-nils-fredrik/\">Managing Client Expectations, Partnerships, Woo Experts and Tips</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 28 Sep 2023 11:40:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: WordPress Opens 2023 Annual Survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wptavern.com/wordpress-opens-2023-annual-survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2238:\"<p>WordPress has <a href=\"https://wordpress.org/news/2023/09/help-influence-the-future-of-wordpress-by-taking-the-2023-annual-survey-today/\">launched its 2023 annual survey</a>, which is open to the entire community, including users, site builders, plugin and theme authors, and contributors. </p>\n\n\n\n<p>The <a href=\"https://wordpress.org/news/2023/05/2022-annual-survey-results-next-steps/\">2022 survey</a> collected responses from roughly 3,400 people, including approximately 800 contributors, a decline in submissions from previous years. The 2022 survey introduced the Likert scale, a rating scale that quantitatively assesses opinions, attitudes, or behaviors. The total number of questions were reduced, with socio-economic questions mostly removed. </p>\n\n\n\n<p>WordPress is still evolving the survey format to get a better understanding of the community&#8217;s sentiments and values.</p>\n\n\n\n<p>&#8220;This year, like last year, the survey has undergone some improvements to the flow and question set,&#8221; Automattic-sponsored contributor Dan Soschin said. &#8220;A new platform is also being piloted, offering an updated interface, enhanced multi-lingual support, expanded analysis and visualization tools for the results, and more. The new platform also has built-in accessibility and privacy controls, ensuring the survey meets the diverse needs of the WordPress community.&#8221;</p>\n\n\n\n<p>The 2023 survey takes approximately 5-10 minutes to complete. It collects information on some basic demographics, various community involvements, preferred WordPress editor, how and why you are using WordPress, and more. Several questions allow the community to weigh in on the most frustrating aspects of WordPress, areas that need more attention, and whether or not the current <a href=\"https://wordpress.org/about/roadmap/\">WordPress roadmap</a> reflects respondents&#8217; needs and desires for the future of the project. </p>\n\n\n\n<p>In addition to English, the survey is available in nine widely-used languages, which participants can select from a drop-down menu at the top of the page. All the data collected in the survey will be anonymized and WordPress does not associate IP addresses or email addresses with the results.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 22:53:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: #92 – Juliette Reinders Folmer on When Contributions Need to Be Paid\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=149350\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/podcast/92-juliette-reinders-folmer-on-when-contributions-need-to-be-paid\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49192:\"Transcript<div>\n<p>Juliette Reinders Folmer</p>\n\n\n\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case when contributions to WordPress deserve payment.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, well, I&#8217;m keen to hear from you, and hopefully get you all your idea featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Juliette Reinders Folmer.</p>\n\n\n\n<p>Juliette is a highly experienced professional in the field of coding standards. With a deep understanding of industry best practices, she has dedicated herself for many years to ensuring code quality and consistency within WordPress.</p>\n\n\n\n<p>Juliette acknowledges that coding standards encompass more than just formatting and white space, they also play a crucial role in maintaining compatibility and preventing conflicts between plugins.</p>\n\n\n\n<p>By adhering to these standards, developers can minimize errors, and fatal issues for end users. To facilitate the implementation of coding standards, Juliette talks about the importance of automated checks and continuous integration.</p>\n\n\n\n<p>We chat about her commitment to WordPress coding standards, and how the work that she&#8217;s done in this field have made her a trusted authority. Through her contributions and guidance, she has helped countless developers enhance their code quality, ultimately improving the overall WordPress ecosystem.</p>\n\n\n\n<p>We talk about Juliette&#8217;s role as one of the maintainers of WordPress Coding Standards or WordPress CS. Discussing the importance of consistent code and the challenges of maintaining, and funding, open source projects.</p>\n\n\n\n<p>Clearly there&#8217;s great value in tools like WordPress CS. Consistency is key for developers, and using a tool like WordPress CS makes it easier for them to meet expectations and be productive. It saves time by automating manual changes, and helps prevent conflicts and potential problems with other plugins or WordPress Core. Juliette emphasizes the continuous nature of the project. Where updates to a variety of PHP projects need to be kept in sync with the WordPress side of things.</p>\n\n\n\n<p>All that said maintaining open source projects like WordPress CS comes with its challenges. Juliette tells us about the importance of financial support and adequate resources to mitigate business risk, as projects that go on maintained can create dependency issues and pose problems during corporate audits.</p>\n\n\n\n<p>She speaks openly about her decision to step away from contributing. The project is so crucial, but underfunded and Juliette thinks it&#8217;s time to draw a line in the sand. It&#8217;s time for contributions in return for payment.</p>\n\n\n\n<p>It&#8217;s not just about financial contributions though. Juliette asks us to support the WordPress Community Collective, and for us all to explore other ways to assist the project. She highlights the need for all companies benefiting from WordPress to contribute towards funding more broadly, rather than relying on one or two of the larger companies in the space.</p>\n\n\n\n<p>If you&#8217;re a contributor who was even pondered how much WordPress relies on volunteers, this podcast is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Juliette Reinders Folmer.</p>\n\n\n\n<p>I am joined on the podcast today by Juliette Reinders Folmer. Hello, Juliette.</p>\n\n\n\n<p>[00:04:41] <strong>Juliette Reinders Folmer:</strong> Hi Nathan. And you got my name right.</p>\n\n\n\n<p>[00:04:43] <strong>Nathan Wrigley:</strong> I appreciate that. Thank you so much. I&#8217;ve had a little bit of a practice, let&#8217;s put it that way. I appreciate you being on the podcast today.</p>\n\n\n\n<p>This is going to be a really interesting subject. It could get a bit nerdy, but I suspect that we&#8217;ll avoid large proportion of the nerdiness. But we&#8217;re going to be talking today about something which I suspect a lot of the people who tune into this podcast regularly may not know anything about. Hopefully during the course of this podcast we&#8217;ll alert you to why you should know about it, why it&#8217;s important, what it is, what it does.</p>\n\n\n\n<p>But before we get into that, WordPressCS or WPCS, let&#8217;s ask Juliette just to introduce herself. Tell us a little bit about her background, working with WordPress, what she does and all of that. So Juliette, if that&#8217;s okay with you, over to you, little bio moment.</p>\n\n\n\n<p>[00:05:32] <strong>Juliette Reinders Folmer:</strong> Oh dear. I did not prepare for that bit. Basically I&#8217;ve been self employed for good 20 years now, and as a general rule of thumb, I do whatever I like and I hope that sometimes people actually pay me money to do it. Which is not always great from a commercial point of view but it keeps me happy.</p>\n\n\n\n<p>[00:05:51] <strong>Nathan Wrigley:</strong> Typically on this podcast we have people who are devoted to some aspect of WordPress. My understanding is that your technical expertise stretches beyond WordPress as well, PHP and various other different things. So is it true that you only operate in the WordPress space, or do you stretch a little bit further than that?</p>\n\n\n\n<p>[00:06:11] <strong>Juliette Reinders Folmer:</strong> I&#8217;m all over the place. I sometimes say for people who are really in the WordPress community, see me as the PHP community reaching out and helping.</p>\n\n\n\n<p>[00:06:20] <strong>Nathan Wrigley:</strong> Nice. So this podcast today is going to stem off a piece that I read on the WP Tavern. It was written by Sarah Gooding. If you want to find it I will link it in the show notes. But maybe for ease of use, it was published on August the 22nd 2023, and it&#8217;s called WordPress coding standards maintainer warns maintenance will be halted without funding, in quotes, this is an unsustainable situation.</p>\n\n\n\n<p>That maintainer is you, and that&#8217;s what we&#8217;re going to talk about today. We&#8217;re going to talk about that unsustainable situation. But I feel that we can&#8217;t really talk about why it&#8217;s unsustainable unless we learn a little bit about what WPCS is, what it does.</p>\n\n\n\n<p>I know that&#8217;s an enormous subject to deal with in just a few moments. But I wonder if you could paint a picture of what WCS is because I feel the listenership, there may be quite a proportion of us that don&#8217;t know.</p>\n\n\n\n<p>[00:07:17] <strong>Juliette Reinders Folmer:</strong> Absolutely. Okay so WordPress, like most projects, have coding standards. And now when I say coding standards a lot of people think, okay this is about how code should be formatted, white space, whether things should have comments and doc blocks. You know, how code should look.</p>\n\n\n\n<p>In part, yes that&#8217;s correct. We do have rules for that, because if code looks the same across your whole code base it makes it much easier to review code and only concentrate on the actual changes, instead of being distracted by all the inconsistencies in how the code is formatted. So, yes there are rules about code style, code formatting. But WordPress coding standards does much more.</p>\n\n\n\n<p>It also encompasses a number of rules around best practices, just industry best practices. Best practices for how to interact with WordPress. So as a plugin you don&#8217;t want to conflict with other plugins. So there are certain best practices you can apply, like prefixing everything you put in the global namespace.</p>\n\n\n\n<p>And if you apply those correctly the chance of your plugin conflicting with another plugin and creating a widescreen of death, fatal error, for end users is a lot smaller. And WordPressCS can help with that as well and has, on the one hand, has some rules for that. On the other hand, what you then get is WordPressCS as the package, because you have the written rule, but then you also have tooling which basically takes those written rules and codifies that into automated checks. Automated checks which can be run in continuous integration.</p>\n\n\n\n<p>So every time someone puts some code online those checks can be run to make sure that the code complies with the rules you&#8217;ve agreed upon. And WordPressCS is one of those packages. It&#8217;s a package which takes those rules, codifies them in automated checks and then can be run on your code. And it doesn&#8217;t just check it and point out errors, it can actually auto fix a lot as well.</p>\n\n\n\n<p>[00:09:29] <strong>Nathan Wrigley:</strong> So the enterprise of WPCS, and I should probably say that CS is the acronym for Code Sniffer. The enterprise is to create this suite of tests if you like, so that whilst you&#8217;re writing code, if you&#8217;re using CI, it&#8217;s constantly giving you alerts as to whether or not there&#8217;s a problem. We&#8217;ve identified that there&#8217;s a little problem here, you can take a look at it, and thereby mitigate the problems, right?</p>\n\n\n\n<p>[00:09:55] <strong>Juliette Reinders Folmer:</strong> It can even do it even more directly. If you use a modern IDE, individual development environment like a PHP Storm or VS Code, it can even give you those notifications while you&#8217;re coding. It integrates with that kind of tooling. So while you&#8217;re typing your code, it can fix things for you and it can notify you of the things it doesn&#8217;t fix.</p>\n\n\n\n<p>[00:10:19] <strong>Nathan Wrigley:</strong> So given the open source nature of WordPress, and the fact that anybody can download it and anybody can write a plugin for it, an interesting comparison would be something like the Mac App Store, or the Apple App Store where Apple, in effect, is the custodian of the code. Apple will go to great lengths to make sure that your code is compliant and it&#8217;s completely the opposite model. You put stuff into their ecosystem, they&#8217;ll do checks and make sure that it&#8217;s all compliant with oh let&#8217;s say iOS or something like that.</p>\n\n\n\n<p>[00:10:50] <strong>Juliette Reinders Folmer:</strong> In a way a similar situation is in place in the WordPress ecosystem at large, because if you want a plugin to be listed on wordpress.org it goes through a list of quality checks as well. And they have some specific checks from that team, but some of the checks they use also are based on WordPressCS or are from WordPressCS.</p>\n\n\n\n<p>[00:11:14] <strong>Nathan Wrigley:</strong> Yeah that&#8217;s a really good point. I was thinking also about the sort of third party plugin marketplace which exists in WordPress, into which anybody can drop their code. So it&#8217;s quite, you know, you can go to one of hundreds of thousands of websites and download a plugin which you can add to WordPress. And really there&#8217;s a bit of a gamble going on there. You&#8217;re hopefully able to determine that the code is good.</p>\n\n\n\n<p>But a tool like WPCS will give you some guidance. You can run it yourself. It&#8217;s not like you have to trust the repo. If you went out and got third party plugins you could run these tests yourself. And just before we started the call, you were talking about if you were, let&#8217;s say an agency, and you had a particular need and you had three or four plugins that you thought might be useful. They would, all of them satisfy the requirements that you&#8217;ve got. But you could run them through something like WPCS, and get a real useful insight into well, whether or not they meet the standards, how compliant they are and so on.</p>\n\n\n\n<p>[00:12:12] <strong>Juliette Reinders Folmer:</strong> Correct. You will get some noise messages about different white space requirements, for instance. But you will also get messages about, hang on, this is not prefixed and this could conflict. Or hang on, output is not escaped. This plugin may introduce XSS security vulnerabilities. There are actual sniffs in WordPressCS which scan your code for typical attack vectors, and whether your code is well enough defensive against those attack vectors.</p>\n\n\n\n<p>[00:12:45] <strong>Nathan Wrigley:</strong> And I&#8217;m guessing that the enterprise of keeping WPCS maintained is like a road that you never reach the end of. You are updating it but there&#8217;s always the next change out in the, I don&#8217;t know, PHP ecosystem, which means that you can&#8217;t ever say well it&#8217;s done. Because PHP 8 comes along, then PHP 8.1 and PHP 8.2 and so we go.</p>\n\n\n\n<p>So would that be fair to say? What kind of things is it sniffing for? Are we just working in the PHP space, or is it working with other things as well?</p>\n\n\n\n<p>[00:13:19] <strong>Juliette Reinders Folmer:</strong> Well PHP_CodeSniffer as the underlying tooling, at this point is capable of scanning PHP, CSS code and JavaScript code. For the most part WordPressCS just focuses on the PHP code, because by now if we look at the whole ecosystem in development, there is plenty of other tooling available for CSS and JavaScript. Which wasn&#8217;t available when PHP_CodeSniffer started, because this is an old project.</p>\n\n\n\n<p>I mean this project got started in 2005. So at that time that tooling was not available. So this was one of the only tools which could do something like this. The intention of PHP_CodeSniffer, because there&#8217;s so much other tooling available now for CSS and JavaScript, is to actually drop support for CSS and JavaScript. So with that in the back of our minds, our focus is completely on PHP.</p>\n\n\n\n<p>[00:14:11] <strong>Nathan Wrigley:</strong> And so getting back to the question about how this is a never ending road, I&#8217;m assuming there will have been no point in the past, or predictably in the future where you&#8217;ll be able to say, okay this is done, because there&#8217;s constant work that needs to be done because the technology, the PHP, is always adding lots and lots of different things from year to year.</p>\n\n\n\n<p>[00:14:34] <strong>Juliette Reinders Folmer:</strong> And it&#8217;s not just PHP. I mean if something changes in WordPress, WordPressCS needs to take that into account. For instance one of the scans is applied to plugins but also I think to WordPress Core is, are you using deprecated functions? Because those functions are deprecated for a reason. So you should use something else. There&#8217;s normally an alternative available.</p>\n\n\n\n<p>Or are you using particular PHP functions for which there is a WordPress alternative which should be used? So if WordPress introduces one of those alternatives then WordPressCS needs to be updated to add a new check. If WordPress deprecates functions, WordPressCS needs to be updated.</p>\n\n\n\n<p>On the other hand, like you already pointed out, every year there&#8217;s a new minor release of PHP, sometimes a major. But at least every year there&#8217;s a minor and those introduce new syntaxes. And in the past three, four years PHP has introduced so many new syntaxes it became really hard to keep up. All those syntaxes mean that code can be written in different ways.</p>\n\n\n\n<p>And sniffs basically look for a certain pattern of code. But if code can now be written in a different way, that new way of writing code needs to be taken into account. To prevent false positives, as in throwing an error when there shouldn&#8217;t be an error. But also prevent false negatives, for people using the new syntax and the sniff not being able to understand it and throw the error which should be thrown.</p>\n\n\n\n<p>Every single sniff basically needs to be reviewed after every PHP release, to be checked if it needs to take any of the new syntaxes into account. But before we can do that the underlying tooling needs to be updated as well, because it actually needs to recognise the new syntaxes.</p>\n\n\n\n<p>[00:16:26] <strong>Nathan Wrigley:</strong> So a constant study.</p>\n\n\n\n<p>[00:16:28] <strong>Juliette Reinders Folmer:</strong> Yeah it&#8217;s a whole domino chain of things and it&#8217;s basically a circle going round, because yes, we put dominoes in place and then we managed to get things merged in PHP_CodeSniffer. Then PHPCSUtils can update, and then we can update WordPressCS. And by that time a new PHP version has come out and we can start the whole circle again.</p>\n\n\n\n<p>[00:16:49] <strong>Nathan Wrigley:</strong> We have this expression in the UK, &#8220;it&#8217;s like painting the Forth Bridge&#8221;. The Forth Bridge is a particularly long bridge in Scotland, and you begin painting at one end and by the time a year or so later they&#8217;ve got to the other end, well, the paint on the far end has now become corroded, and they&#8217;ve got to begin again so it&#8217;s this never ending cycle.</p>\n\n\n\n<p>If you&#8217;ve heard of WPCS and have used it, I&#8217;m sure that you will recognise the utility of it. But if you haven&#8217;t, and as I said at the top of the show, I think there&#8217;s probably a lot of people listening to this who haven&#8217;t. How do we actually make use of it? How would a typical WordPress user get WPCS working, and giving them some insight into the suite of things that they&#8217;ve got in their WordPress site?</p>\n\n\n\n<p>[00:17:32] <strong>Juliette Reinders Folmer:</strong> Okay. Well for people who are not used to command line, this might be a bit scary. You need the command line. Then again I mean, as I said, it integrates with IDEs so you can run certain things in IDEs as well. But as a general rule of thumb if you want to scan for instance, say you&#8217;re evaluating those four plugins to find out which one you&#8217;re going to install, like the example you used earlier.</p>\n\n\n\n<p>The easiest way to use WordPressCS as part of your toolset when you&#8217;re evaluating, is to do so from the command line. And that means you need PHP installed. Well if you work with WordPress you generally should probably have PHP installed. You need Composer which is a package manager in the PHP world, like npm for JavaScript but then for the PHP world.</p>\n\n\n\n<p>And then you need to install WordPressCS and that&#8217;s a Composer require. And if you don&#8217;t work with code yourself I would say use a Composer global require, then you can use it anywhere on your system without it being project specific. If you do work with code, please use it on a project basis and require it for the project, because it will also make it transparent for other contributors that you expect them to comply with WordPressCS.</p>\n\n\n\n<p>So yeah, you can either install it globally or you can install it on a project base. And once you run the Composer require, it has all of that in the readme of course, so you can just copy and paste that command.</p>\n\n\n\n<p>Once you run that everything is set up, and you can just run the commands to run WordPressCS which is vendor, bin, phpcs, dash dash standard is WordPress.</p>\n\n\n\n<p>At the same time, most of the time, you will want to customise a little. For instance, I mentioned prefixing before to prevent conflicts with other plugins. If you want to check prefixes you need to tell WordPressCS which prefix to look for. If you don&#8217;t give it any prefixes, we cannot check whether things are prefixed. We need to know what to look for.</p>\n\n\n\n<p>In the WordPressCS repo, an example rule set, which has some of the common things which you should add to a custom rule set to use. There&#8217;s also, in the wiki, quite a lot of documentation about what the various options are you can toggle on and off. That way you can set up a customer rule set and get yourself running in a more detailed way.</p>\n\n\n\n<p>[00:20:08] <strong>Nathan Wrigley:</strong> I suspect that the proportion of people listening to this podcast who really never look at the code, they are, I don&#8217;t know, you maybe call them implementers or something like that, might be thinking well, why does any of this matter? What is the point? And I guess that&#8217;s something that I want to tease out.</p>\n\n\n\n<p>I want it to be clear that unless projects like WPCS occur and continue to occur, the bedrock of the software, which we&#8217;re all using for free, gratis, is not going to be something that you can trust as much, I guess.</p>\n\n\n\n<p>So I don&#8217;t know if there&#8217;s anything you want to throw into the mix there. If somebody was to come to you and say well I just use WordPress, why should I care about this? Why is this of interest to me? It&#8217;s a bit like, if I never go to a hospital, it&#8217;s not well we shouldn&#8217;t have hospitals because I&#8217;m perfectly well. Something along those lines.</p>\n\n\n\n<p>[00:21:01] <strong>Juliette Reinders Folmer:</strong> Yeah, well if your site&#8217;s never been hacked that&#8217;s the same comparison. Your site&#8217;s never been hacked. So why do we need security checks and security reviews?</p>\n\n\n\n<p>[00:21:10] <strong>Nathan Wrigley:</strong> So what would be the single, or maybe a couple of messages that you would tell people, this is why what I&#8217;m doing matters. This is why we all need to know that this project exists, and that it&#8217;s important.</p>\n\n\n\n<p>[00:21:23] <strong>Juliette Reinders Folmer:</strong> There&#8217;s different answers for different levels. So for developers it definitely makes it easier for them to be high productive. Because if code is consistent it makes it easier to work with, to know the expectations, to review code, et cetera, et cetera. So it&#8217;s a productivity tool for them, including the auto fixing.</p>\n\n\n\n<p>Some of the changes which may need to be done, if you&#8217;d need to do those manually that would take you like a week or two weeks. And if you use the auto fixer, it&#8217;s done in five minutes for you. So that is literally two weeks of work saved. That&#8217;s on the development level and the management, the IT department level.</p>\n\n\n\n<p>If you are an agency who normally doesn&#8217;t use code, it&#8217;s more about, okay if I install this plugin, will it cause problems with other plugins? Will it cause problems for WordPress Core? Because there are plugins which will gladly override a global variable from WordPress Core and then WordPress Core breaks.</p>\n\n\n\n<p>WordPressCS has checks against stuff like that. I already mentioned the conflict. If there&#8217;s two functions in two different plugins which use the same name, you have a fatal error and a white screen of death. Do you want your customer to get a white screen of death? No you don&#8217;t. So this tooling can help guard against that, can help prevent those kind of situations from happening.</p>\n\n\n\n<p>[00:22:52] <strong>Nathan Wrigley:</strong> So I&#8217;m going to go back to the piece on the WP Tavern. I&#8217;m going to read the title again because I think it&#8217;s important for the next part of our discussion. WordPress Coding Standards maintainer warns maintenance will be halted without funding, this is an unsustainable situation.</p>\n\n\n\n<p>So the person that is referenced in that article is you. You&#8217;ve obviously decided that this is an unsustainable situation. I think we&#8217;ve painted a picture as to why WPCS is an incredibly useful thing to have around. But i&#8217;m keen to know exactly how many people get their hands in the weeds with that tool? How many people do you have on your air quotes team? How many hours are contributed by those people per month, per year, whatever? Just give us an inkling as to how much goes into this important project.</p>\n\n\n\n<p>[00:23:42] <strong>Juliette Reinders Folmer:</strong> As I already mentioned, WordPressCS is not a completely standalone tool. It is built on the shoulders of giants. The underlying tool, PHP_CodeSniffer, needs to be maintained primarily before we can even do anything in WordPressCS. That tool currently has two maintainers and I&#8217;m one of them.</p>\n\n\n\n<p>There are outside contributors, and quite regularly we get an outside contributor with a pull request. But if you look at the bulk, to be honest, I don&#8217;t think I&#8217;m saying anything silly if I say that for the past few years a lot of that has come down to me. So that is the biggest giant we&#8217;re standing on.</p>\n\n\n\n<p>Then we have PHPCSUtils which is a layer on top of PHP_CodeSniffer which makes writing sniffs easier. Because writing sniffs can be pretty complex with all the syntaxes you have to take into account. Maintained by me, completely.</p>\n\n\n\n<p>Then we have PHPCSExtra, which is an external standard which WordPressCS uses quite a few sniffs from. About, I think more than 50% of the sniffs from PHPCSExtra are used in WordPressCS 3. Again, I&#8217;m the maintainer.</p>\n\n\n\n<p>Remember that I mentioned that you install everything via Composer? There&#8217;s a Composer plugin which makes sure that all those external standards get registered with PHP_CodeSniffer. I maintain that together with one other person.</p>\n\n\n\n<p>And then we have WordPressCS itself. And we have a maintainer team of three people. I&#8217;m really, really happy that there&#8217;s three of us. At the same time the majority of the actual code work comes down to me. Dennis would love to spend more time, but he hasn&#8217;t got the financial safety net to be able to do so without funding. Gary hasn&#8217;t got the time to do so anyway.</p>\n\n\n\n<p>So I&#8217;m really happy with Gary and Dennis&#8217;s support, and for all the code review they do. But if we actually look at the code changes, nearly everything comes down to me.</p>\n\n\n\n<p>[00:25:45] <strong>Nathan Wrigley:</strong> So we&#8217;re painting a picture here, and it&#8217;s a funny phrase to bring out but there&#8217;s this idea of the bus factor. And the bus factor is the idea that if, sadly, somebody was to be hit by a bus, and they were no longer able to contribute to the project. The bus factor being one is indicative that you only need to have one person removed from the project for the whole thing essentially to collapse.</p>\n\n\n\n<p>And that&#8217;s basically what we&#8217;ve got here. We&#8217;ve got a situation where you are maintaining an awful lot of what you&#8217;ve just described, and you&#8217;re doing it, well, gratis. You&#8217;re doing it largely I&#8217;m imagining, and you can correct me if I&#8217;m wrong, you&#8217;re doing this in your own time for no financial benefit.</p>\n\n\n\n<p>And I guess one of the things that&#8217;s come out of the article is that having done this for so many years, and contributed so many hours of your own time, you&#8217;ve reached the end of the road potentially about that and you feel that this situation is no longer sustainable. It&#8217;s a bit of a plea for help?</p>\n\n\n\n<p>[00:26:56] <strong>Juliette Reinders Folmer:</strong> Yes. I mean basically over the past two years this has dominated my daily life, in a way which isn&#8217;t healthy anymore. It&#8217;s not you know a nice side project anymore. No, it&#8217;s literally what I spend nearly all my time on. And I&#8217;m lucky that I have a few stable customers where I can scrounge some hours here and there to be able to actually pay for my bread at the supermarket.</p>\n\n\n\n<p>The balance is completely wrong now.. And I&#8217;m not alone. I mean this is valid for a lot of open source projects. But we&#8217;ve reached a point that the balance is so far off that this is just not sustainable anymore. I cannot afford to do this anymore. I cannot justify doing this anymore.</p>\n\n\n\n<p>[00:27:44] <strong>Nathan Wrigley:</strong> Forgive me asking this question, and I hope it doesn&#8217;t come out the way that it might, but I&#8217;m going to ask it anyway. Do you have regrets around the amount of time that you&#8217;ve contributed over the past? So you mentioned that it&#8217;s requiring lots and lots of your time, and you&#8217;re basically doing this as a, almost like a full time job really.</p>\n\n\n\n<p>Do you have any regrets getting into 2023 and that situation being the way it was? Or do you wish that you&#8217;d have managed to have this inspiration, if you like, this epiphany about enough is enough, a few years ago?</p>\n\n\n\n<p>[00:28:18] <strong>Juliette Reinders Folmer:</strong> When it&#8217;s enough I say so. It&#8217;s felt like it&#8217;s been enough for about a year, and a large part of that is the fact that, in my perception, I think there&#8217;s a disconnect between the open source user nowadays and open source maintainers.</p>\n\n\n\n<p>Open source users often don&#8217;t realise there&#8217;s no funding. They are not the product. And they come in with a sense of entitlements, and a sense of pressure which is being put on maintainers to release, and yes but you should do this. No, I shouldn&#8217;t do this. I&#8217;m doing this out of the kindness of my heart, and you should be a lot kinder to me if you want to make any suggestions for the project.</p>\n\n\n\n<p>[00:29:01] <strong>Nathan Wrigley:</strong> Can I just clarify, have you been at the receiving end then of things which you, in the way that you&#8217;ve described, you&#8217;ve had requests in well let&#8217;s not beat around the bush, less than polite, shall we put it that way?</p>\n\n\n\n<p>[00:29:13] <strong>Juliette Reinders Folmer:</strong> We actually at some point had to put, in a hurry, a code of conduct into the project. And we couldn&#8217;t wait for the WordPress project to get themselves sorted with a code of conduct, because we had an abusive user which was really going way too far.</p>\n\n\n\n<p>[00:29:28] <strong>Nathan Wrigley:</strong> Yeah I mean like you said, I think the word surrounding that is entitlement, isn&#8217;t it? Somebody who believes that it is your role. You have become the person doing this and so well it must now be what Juliette does. Juliette must fix it at the moment anything needs fixing. And of course I think you&#8217;ve reached the end of the road there, and you&#8217;ve decided that enough is enough.</p>\n\n\n\n<p>Does that mean that you are, well, let&#8217;s examine what that means. Let&#8217;s throw out a few scenarios. Does it mean that you would like more maintainers, so that you can step away from the project? Or is there a different possible outcome here where you would love to be continuing to work on this, but there needs to be some way of putting food on the table, i.e. payment in exchange for your time here? So I guess both of those options could coexist at the same time.</p>\n\n\n\n<p>[00:30:16] <strong>Juliette Reinders Folmer:</strong> Yes, and that would be the ideal situation because the thing is, it would be great if we could get more maintainers interested and more people be willing to contribute structurally to the project. Except this type of work has quite a steep learning curve. So to get to the point where you can function as a maintainer for a project like this, and actually take it seriously in the way it&#8217;s been taken seriously over the past few years, that will require quite a lot of coaching, and guess who&#8217;s doing the coaching then.</p>\n\n\n\n<p>[00:30:49] <strong>Nathan Wrigley:</strong> Yeah. So let&#8217;s ask that slightly different question. Over the past several years, have you had people go through the project? You know, that they&#8217;re interested in it, but they don&#8217;t stick around or is it literally that the door is open but nobody ever steps through it?</p>\n\n\n\n<p>[00:31:04] <strong>Juliette Reinders Folmer:</strong> There&#8217;s a number of different types of contributors. You have the drive by contributor. We will say okay, we have this sniff which we use in our own company, I&#8217;m going to throw it into PR and just drop it in the WordPressCS repo, because it could be useful for other people.</p>\n\n\n\n<p>You do an extensive review and give them feedback of you know, this needs changing that need changing. Because if you use it in your own company you can take some liberties because you know what the agreements are, what code is based on in that company. Except you can&#8217;t take those liberties with a project which has this many users as WordPressCS. So we require a higher quality. And the drive by contributor will just not respond to that review at all, and just let the PR rot and die. So that&#8217;s the one.</p>\n\n\n\n<p>Then you have, and I&#8217;ve seen two, three people over the past five years maybe in WordPressCS like that, will come in and actually understand what they&#8217;re doing and how to do a PR. But then don&#8217;t have enough time or have a family, have a job and their employer doesn&#8217;t allow them to contribute to open source regularly, et cetera. Or they get moved into a different position in their job, and then don&#8217;t have time anymore.</p>\n\n\n\n<p>Those are like the little jewels which I&#8217;d like to hold onto, and cherish and cuddle and watch to flourish in the project. Except they are rare and unfortunately we rarely manage to retain them.</p>\n\n\n\n<p>And then you have the, oh gosh how should I call it? What&#8217;s that called again? That month of code thingy, Oktoberfest. Yeah, I&#8217;m going to make a one character change in your readme. Let&#8217;s waste maintainers time, kind of PRs. Just so they can get a t shirt kind of thing.</p>\n\n\n\n<p>There&#8217;s a couple of different types of contributors. A lot of contributors, or people I talk with, will say like, oh I&#8217;d love to contribute. I&#8217;m going to write a new sniff. And I&#8217;m like okay but do you actually know what you&#8217;re doing already? No, you don&#8217;t. Okay. So now you&#8217;re going to write a new sniff, and that needs a lot of coaching to get to a point where it&#8217;s actually mergeable. Instead of helping with the grunge work which needs to be done every time, every year, at every WordPress release, every PHP release. And actually learning from the patterns you see in others existing code.</p>\n\n\n\n<p>And I know that the grunge work is boring, but it needs to be done, and we need people who will put up with the grunge work because otherwise the code base will just grow with new sniffs but nobody&#8217;s maintaining.</p>\n\n\n\n<p>[00:33:47] <strong>Nathan Wrigley:</strong> Yeah. So I guess what we&#8217;re discovering here is, A the project is important. B there&#8217;s not many people meaningfully contributing to it, apart from the ones that you mentioned including yourself. I think you mentioned two other people.</p>\n\n\n\n<p>[00:34:02] <strong>Juliette Reinders Folmer:</strong> We do get some contributions which are meaningful, absolutely. I&#8217;m not dissing that at all. But it&#8217;s the exception not the rule, in my experience. And that&#8217;s a shame. I mean I really would love to see more meaningful contributions.</p>\n\n\n\n<p>[00:34:16] <strong>Nathan Wrigley:</strong> Yeah okay. Thank you for clarifying that. That&#8217;s good. But it also sounds as if you&#8217;re not quite at the point where you want to completely distance yourself from this project and never touch it again. I think I&#8217;m right in saying that a possible desirable outcome would be that you found a way to make this work for your setup.</p>\n\n\n\n<p>And really what I&#8217;m talking about there is finance. Am I right in saying that you would continue this work if you were able to make it a job, if you like, and be paid for it?</p>\n\n\n\n<p>[00:34:49] <strong>Juliette Reinders Folmer:</strong> Absolutely. I mean I enjoy this kind of work. That&#8217;s obvious otherwise I wouldn&#8217;t have gotten involved in the whole stack, and even projects related to which I haven&#8217;t even mentioned yet. I do enjoy this kind of work, but I do not enjoy the abuse, and the abuse is something I will not put up with anymore. Only ever put up with if it&#8217;s paid, if I get paid for it.</p>\n\n\n\n<p>[00:35:11] <strong>Nathan Wrigley:</strong> So since the article was published on the Tavern, so we&#8217;re recording this just for context kind of probably about 20 plus days since that piece was published. There were a lot of comments, an unusually large amount of comments. So this topic is of great interest to people. And I wondered, given that there was great interest and a large amount of comments there, I wondered if anybody had figured out what your requirement was, and had approached you. In other words has anything changed or is it still the way it was?</p>\n\n\n\n<p>[00:35:42] <strong>Juliette Reinders Folmer:</strong> I can see some parties being interested in contributing to a solution, but I&#8217;ve not seen a solution yet. But one of the things which has changed, and which I think is an improvement, and i&#8217;m really hoping that will allow people to contribute to the funding of the project, is that the WPCC has in their open collective, has opened a project for WordPressCS and the stack around it, to raise funding for that.</p>\n\n\n\n<p>[00:36:15] <strong>Nathan Wrigley:</strong> So just for clarity, the WPCC is the WordPress Community Collective. And what you can do is you can go over there and they have a handful, at the moment, of projects which you can donate to. And it looks like you have been added to that, or at least the WPCS project has been.</p>\n\n\n\n<p>Do you have an amount, like a target that you want to get to in order for this to be possible for you? Or is it more a, well let&#8217;s just see where this goes, and bit of blue sky thinking, hopefully some people will help me out?</p>\n\n\n\n<p>[00:36:45] <strong>Juliette Reinders Folmer:</strong> I have a target in mind. I&#8217;m not comfortable calling that out on air though.</p>\n\n\n\n<p>[00:36:48] <strong>Nathan Wrigley:</strong> No that&#8217;s fine. So that&#8217;s where we&#8217;re at. As of the 5th of September 2023, we&#8217;ve got this incredibly important project which underpins the sort of security, the confidence that you can have in WordPress and the plugin ecosystem surrounding it. But we&#8217;ve got this one or two or three, but largely one person maintaining that entire project. But it looks as if, unless something radically changes in the near future, as if that whole edifice might tumble. How much more time are you going to give this before you actually finally call it a day? Maybe that&#8217;s not even in your thinking, and maybe it&#8217;s you know you&#8217;re hoping that it will change</p>\n\n\n\n<p>[00:37:29] <strong>Juliette Reinders Folmer:</strong> Well I&#8217;m definitely hoping it will change. As a rule of thumb I&#8217;m basically not touching the code anymore. Not until there is sight of a solution.</p>\n\n\n\n<p>WordPressCS is definitely not an exception. I mean I know open source projects where there&#8217;s much bigger problems with abuse than in WordPressCS. I&#8217;ve known people who&#8217;ve had death threats in their DMs, et cetera, et cetera. That open source and abuse is a whole different topic, but it&#8217;s definitely not isolated to WordPressCS. And WordPressCS need for funding is also not isolated. I mean the accessibility project also needs funding. There&#8217;s other projects in the periphery of WordPress which could do with funding.</p>\n\n\n\n<p>I think that it&#8217;s very easy for people to think, like okay but WordPress is open source and yeah there&#8217;s some big companies earning money so they should pay for everything. I do not agree. I think we should as companies which earn money from WordPress, that all those companies should get together in something like the WordPress Community Collective and fund those projects.</p>\n\n\n\n<p>It shouldn&#8217;t come down to one or two of the bigger ones. It should come down to all of us because all of us are making money off it. Well all of you, because I&#8217;m not.</p>\n\n\n\n<p>[00:38:48] <strong>Nathan Wrigley:</strong> Obviously the nuts and the bolts of that mechanism, the bits and the pieces that would need to be configured to make that work, i&#8217;ve come across that project yet. But that is a really interesting idea, isn&#8217;t it? The idea that there&#8217;d be somewhere, and the WPCC does seem the best bet we&#8217;ve got at the moment.</p>\n\n\n\n<p>It feels a little bit like five for the future or something like that. But instead of it being time, it&#8217;s, okay we&#8217;re a big company we make money off these things. We use PHP, we use the code sniffing, we do these plugins that are open source and so on. So let&#8217;s just put our flag in the sand and say we&#8217;ll donate 5% of our resources, and then that organisation, whatever it was, the WPCC or something else that&#8217;s new, could then distribute those resources and people like you could dip into that pool. That seems eminently sensible.</p>\n\n\n\n<p>[00:39:36] <strong>Juliette Reinders Folmer:</strong> I&#8217;ve written about this years ago already. It&#8217;s also about business risk. If you run a business which is built on an open source project, and you do not contribute back financially, as well as with people. You run business on quicksand. You are literally running it on quicksand. Any corporate audit type of your company will say you&#8217;ve got an unmitigated business risk.</p>\n\n\n\n<p>You have risk that those projects which you&#8217;re not contributing to, which you&#8217;re not paying for, for which don&#8217;t have a service contract, are just going to go unmaintained. And you are so dependent on these projects, you should mitigate that business risk. And one way of doing that is with funding. Another way is with resources, and preferably with both.</p>\n\n\n\n<p>And it&#8217;s not just WordPress yes, it&#8217;s all the open source projects in the stack. Go through the whole stack. You have PHP Units probably in your stack. You have Apache in your stack. You have a Chrome browser in which you test things in your stack.</p>\n\n\n\n<p>And Chrome, yes, everyone associates it with Google, but it&#8217;s built on top of Chromium which is open source. You might use Mastodon as a communication channel. Make sure you also fund your Mastodon instance. It&#8217;s the whole stack of all those open source projects which need funding. So go through your stack. Do a proper inventory and fund them. This is the only way to mitigate the business risk all of those companies are running.</p>\n\n\n\n<p>[00:41:05] <strong>Nathan Wrigley:</strong> Yeah, I think you&#8217;ve made a really compelling case for this. In that, A, we&#8217;ve painted the picture of what it is that you&#8217;re involved in, and how important it is as a real bedrock of reliance and the ability for us to be confident in WordPress. And then we&#8217;ve also painted the picture of how the underpinnings of that aren&#8217;t very stable. Because all of us, unless we&#8217;re incredibly lucky, have to put food on the table and we have to be paid for our work.</p>\n\n\n\n<p>And it does sound like the balance, certainly in your case, has gone really far in one direction, and you are the single biggest contributor to that project. And so it makes it all the more important that something like this gets funded, however that may be.</p>\n\n\n\n<p>Now if you happen to be listening to this podcast and you feel that you are able to change the direction here. Juliette, what would be the best way? It sounds like WPCC, which I&#8217;ll link to in the show notes, may be the best way at the moment. But I don&#8217;t know if you&#8217;ve got any other intuitions about how this project might be helped.</p>\n\n\n\n<p>[00:42:07] <strong>Juliette Reinders Folmer:</strong> Companies can always reach out to me, DM me, Slack, or DM the maintainers as a collective. Gary, Dennis, and me on the WordPress slack. Open Collective is definitely welcome to receive funding for us. Keep in mind, I look towards the companies. I do not look to individual developers to fund this. Because, yes, they feel it most if projects like this don&#8217;t continue. But they are the ones we should talk to management and tell management to fund it, because it shouldn&#8217;t come down to individual developers. And one time contributions are very welcome, but recurring contributions are what keeps the project alive.</p>\n\n\n\n<p>[00:42:48] <strong>Nathan Wrigley:</strong> Well let&#8217;s hope that there&#8217;s somebody listening to this for whom it has raised awareness enough. Let&#8217;s hope that we can come back in a year&#8217;s time, do another podcast episode and we&#8217;ll be talking about a different setup. Let&#8217;s hope that that&#8217;s the case.</p>\n\n\n\n<p>Juliette, I really appreciate you being on the podcast today, and telling us an awful lot about your personal circumstance and things. So I really appreciate that. Thank you so much.</p>\n\n\n\n<p>[00:43:11] <strong>Juliette Reinders Folmer:</strong> You&#8217;re very welcome. I enjoyed being here, and hopefully my bakery around the corner will enjoy it soon as well, because I can then actually start paying them.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://twitter.com/jrf_nl\">Juliette Reinders Folmer</a>.</p>\n\n\n\n<p>Juliette is a highly experienced professional in the field of coding standards. With a deep understanding of industry best practices, she has dedicated herself for many years to ensuring code quality, and consistency within WordPress.</p>\n\n\n\n<p>Juliette acknowledges that coding standards encompass more than just formatting and white space, they also play a crucial role in maintaining compatibility and preventing conflicts between plugins. By adhering to these standards, developers can minimise errors and fatal issues for end users. To facilitate the implementation of coding standards, Juliette talks about the importance of automated checks and continuous integration.</p>\n\n\n\n<p>We chat about her commitment to WordPress coding standards, and how the work that she’s done in this field have made her a trusted authority. Through her contributions and guidance, she has helped countless developers enhance their code quality, ultimately improving the overall WordPress ecosystem.</p>\n\n\n\n<p>We talk about Juliette’s role as one of the maintainers of WordPress Coding Standards (WordPress CS), discussing the importance of consistent code, and the challenges of maintaining and funding open source projects.</p>\n\n\n\n<p>Clearly, there’s great value in tools like WordPress CS. Consistency is key for developers, and using a tool like WordPress CS makes it easier for them to meet expectations and be productive. It saves time by automating manual changes, and helps prevent conflicts and potential problems with other plugins or WordPress Core. Juliette emphasises the continuous nature of the project, where updates to a variety of PHP projects need to be kept in sync with the WordPress side of things.</p>\n\n\n\n<p>All that said, maintaining open source projects like WordPress CS comes with its challenges. Juliette tells us about the importance of financial support and adequate resources to mitigate business risk, as projects that go unmaintained can create dependency issues and pose problems during corporate audits. She speaks openly about her recent decision to step away from contributing. The project is so crucial, but underfunded, and Juliette thinks it’s time to draw a line in the sand. It’s time for contributions in return for payment.</p>\n\n\n\n<p>It&#8217;s not just about financial contributions though. Juliette asks us to support the WordPress Community Collective, and for us all to explore other ways to assist the project. She highlights the need for all companies benefiting from WordPress to contribute towards funding more broadly, rather than relying on one or two of the larger companies in the space.</p>\n\n\n\n<p>If you’re a contributor who has even pondered how much WordPress relies on volunteers, this podcast is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://wptavern.com/wordpress-coding-standards-maintainer-warns-maintenance-will-be-halted-without-funding-this-is-an-unsustainable-situation\">WordPress Coding Standards Maintainer Warns Maintenance Will Be Halted Without Funding: “This Is an Unsustainable Situation.”</a></p>\n\n\n\n<p><a href=\"https://github.com/WordPress/WordPress-Coding-Standards\">WordPressCS</a></p>\n\n\n\n<p><a href=\"https://www.jetbrains.com/phpstorm/\">PHP Storm</a></p>\n\n\n\n<p><a href=\"https://code.visualstudio.com/\">VS Code</a></p>\n\n\n\n<p><a href=\"https://phpcsutils.com/\">PHPCSUtils</a></p>\n\n\n\n<p><a href=\"https://getcomposer.org/\">Composer</a></p>\n\n\n\n<p><a href=\"https://opencollective.com/thewpcc/contribute/wp-php-63406\">The WP Community Collective</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Akismet: 15 Best Practices to Create a Lead Capture Form that Converts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://akismet.com/?p=255688\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://akismet.com/blog/lead-capture-form/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:28720:\"<p>Sometimes you hear about companies growing their email lists with huge numbers of new subscribers, and you look at yours that’s barely treading water and wonder — what are we doing wrong? One place to start is to consider your lead generation forms and the content surrounding&nbsp;them.&nbsp;</p>\n\n\n\n<p>Assuming your websites are attracting a strong amount of relevant traffic, if not enough people are joining your email list, a number of potential sources could be the problem. These&nbsp;include:</p>\n\n\n\n<ul>\n<li>The lead capture form itself</li>\n\n\n\n<li>The landing pages where the forms can be found</li>\n\n\n\n<li>How well the rest of your site is directing people to the pages where they can subscribe</li>\n\n\n\n<li>How well your external marketing is motivating people to subscribe</li>\n</ul>\n\n\n\n<p>This article will introduce 15 strategies you can use for conversion rate optimization on your lead generation forms. And while most of these strategies relate to the form itself, some of them relate to other content and marketing assets that may be placed near the form, but that still play a big role in motivating people to opt in to your email&nbsp;list.</p>\n\n\n\n<span id=\"more-255688\"></span>\n\n\n\n<img width=\"1600\" height=\"812\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image.png\" alt=\"WPScan landing page, which includes a form\" class=\"wp-image-255690\" />\n\n\n\n<h2 class=\"wp-block-heading\">What is a lead capture&nbsp;form?</h2>\n\n\n\n<p>Also known as an opt-in form, a lead capture form is any form on your website that offers site visitors an opportunity to submit their information or join your email list —&nbsp;often in exchange for access to a “lead magnet” like an eBook or other downloadable asset. Forms can ask for as little information as just the email address, or as much as names, phone numbers, birthdays, and industry-specific interests and&nbsp;information.&nbsp;</p>\n\n\n\n<p>Lead gen forms can appear on homepages, blog posts, dedicated landing pages, and any other pages of your site. They can appear at the top of the page, in the footer, in sidebars, within the content, or as&nbsp;popups.&nbsp;</p>\n\n\n\n<p>Forms can use just text with fields to fill out, or they can also include graphics. A lead generation form typically includes a button that the visitor clicks once they’ve entered their information and are ready to sign&nbsp;up.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">What happens after someone fills out your&nbsp;form?</h2>\n\n\n\n<p>This matters. Most companies will send some sort of autoresponder email to confirm that the subscription has gone through. To confirm the subscriber is a real person, some companies will require them to click on another link within that first email to confirm they really want to subscribe. This is known as double&nbsp;opt-in.&nbsp;</p>\n\n\n\n<img width=\"1084\" height=\"1152\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-1.png\" alt=\"Rigby email example offering free shhipping\" class=\"wp-image-255691\" />\n\n\n\n<p><em>Example from Really Good Emails: </em><a href=\"https://reallygoodemails.com/emails/welcome-%2B-free-shipping\" target=\"_blank\" rel=\"noreferrer&nbsp;noopener\"><em>https://reallygoodemails.com/emails/welcome-%2B-free-shipping</em></a><em>&nbsp;</em></p>\n\n\n\n<p>But too many companies don’t take full advantage of all that an autoresponder welcome email can accomplish. Some just use what amounts to a robotic email that says something like “subscription&nbsp;confirmed.”&nbsp;</p>\n\n\n\n<p>Though this post is just about generating initial subscriptions, once you’ve followed some of these strategies and have seen your numbers swell, be sure to take the steps of creating an effective welcome series and consistent content that’s relevant and&nbsp;engaging.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to increase conversions from your lead generation&nbsp;forms</h2>\n\n\n\n<p>With all that in mind, let’s look at the 15 best strategies to check, “improve lead capture conversion rate” off your to-do&nbsp;list.</p>\n\n\n\n<h3 class=\"wp-block-heading\">1. Keep it simple — fewer fields, more&nbsp;conversions</h3>\n\n\n\n<p>In general, you’ll get more lead capture form conversions if you ask for less information. The more fields you require, the fewer people will fill them all out. But, the quality of the lead tends to be higher with more required fields. What matters more to you — high quality leads or quantity? Use that to guide how many required fields you&nbsp;use.</p>\n\n\n\n<p>Baseline information — the bare minimum — would be to ask for the email address and a first name. But sometimes, you do need a little more. A B2B company might ask for a company name, for instance. Or if you deliver segmented email marketing based on interests, demographics, or industry, you might include some checkboxes, so subscribers get added to the most relevant email list&nbsp;segments.</p>\n\n\n\n<img width=\"1224\" height=\"1078\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-2.png\" alt=\"form asking for name and email\" class=\"wp-image-255693\" />\n\n\n\n<p>You can also include other fields but not require them. For instance, requiring a phone number will depress your conversions. But keeping it as an optional field may alleviate this problem, and still give people who are willing to supply their number the chance to do&nbsp;so.</p>\n\n\n\n<h3 class=\"wp-block-heading\">2. Don’t use CAPTCHA — Opt for non-intrusive&nbsp;anti-spam</h3>\n\n\n\n<p>The data is in, and it doesn’t look good for CAPTCHA. These annoying little tests to verify you are not a robot mostly just tick people off, especially if they fail the test.<a href=\"https://medium.com/rareview/why-your-captcha-is-killing-conversions-f9be6fe17d1f\" target=\"_blank\" rel=\"noreferrer noopener\"> One study</a> found that 30% of users abandon lead generation forms during the CAPTCHA&nbsp;step.</p>\n\n\n\n<p>That’s almost offensive. If you’re using CAPTCHA, that means a third of your potential lead capture form conversions are being lost to grainy pictures of fire hydrants and school&nbsp;buses.&nbsp;</p>\n\n\n\n<p>Actually, according to<a href=\"https://web.stanford.edu/~jurafsky/burszstein_2010_captcha.pdf\" target=\"_blank\" rel=\"noreferrer noopener\"> another study</a>, it’s even <em>more</em> than a third. Only 71% of users even attempted to solve a CAPTCHA before quitting the signup process. That means lots of people won’t even attempt to solve the puzzles, and <em>of the ones who do</em>, 30% of those give up too. And audio CAPTCHAs are no better. They saw a 50% failure&nbsp;rate.</p>\n\n\n\n<p>So, the verdict on CAPTCHA is pretty simple: It&nbsp;sucks.&nbsp;</p>\n\n\n\n<p>Users hate it. It obliterates your conversion rates. And even worse, a lot of the spammers it’s attempting to block keep finding ways around it. So, it’s not even very good at doing the job it was created for. That’s why CAPTCHA keeps coming up with new puzzles —&nbsp;because spamming software has cracked the codes of the older&nbsp;ones.&nbsp;</p>\n\n\n\n<p>What should you do&nbsp;instead?&nbsp;</p>\n\n\n\n<p>You certainly don’t want email lists filling up with bogus subscribers. That wastes your email marketing dollars. It can also hurt your sender reputation if you keep sending emails to bad email&nbsp;addresses.&nbsp;</p>\n\n\n\n<p>A better alternative is to use<a href=\"https://akismet.com/features/\"> an anti-spam plugin</a> like Akismet that doesn’t require the user to solve any puzzles or tests. It happens in the background, blocks spammers from filling out your forms, seamlessly integrates with your lead form software, and thus optimizes your conversion&nbsp;rates.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"816\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-3.png\" alt=\"Akismet page with stats about the user experience and conversion rates\" class=\"wp-image-255694\" />\n\n\n\n<p>Akismet was built by and for developers. It enables you to build its code into other applications and on pretty much any platform, not just WordPress, even though that’s where it originated. You can use it on unlimited numbers of&nbsp;websites.&nbsp;</p>\n\n\n\n<p>Akismet has a 99.99% accuracy rate in identifying spam. It stops spammers from filling out your lead capture form, in addition to stopping spam comments on your web pages and blog posts. There’s even an<a href=\"https://akismet.com/enterprise/\"> enterprise-level version</a> for large&nbsp;companies.&nbsp;</p>\n\n\n\n<p><a href=\"https://akismet.com/blog/convertkit-customerstory/\">Read a case study about ConvertKit</a>, and how Akismet saved more than 400,000 creators each up to 20 hours of work per month. And this was all while restoring their email reputation, which was under threat from the proliferation of spammers joining the email lists of their&nbsp;customers.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">3. Use motivating button copy, not technical&nbsp;terms</h3>\n\n\n\n<p>Developers are not typically marketers. When developers write software, they use computer code language that makes sense to them, even on user-facing portions of their work. And the “Submit” button is a classic&nbsp;example.&nbsp;</p>\n\n\n\n<p>While “submit” makes sense to developers, it’s not how your customers&nbsp;think.&nbsp;</p>\n\n\n\n<p>This is marketing: Filling out lead capture forms is optional. You have to make prospects want it. Be excited about it. Feel good about agreeing to receive emails from your&nbsp;company.&nbsp;</p>\n\n\n\n<p>And “submit” isn’t going to get the job done. Many tests and studies have been conducted on this. <a href=\"https://blog.hubspot.com/blog/tabid/6307/bid/6737/don-t-submit-to-landing-page-button-text.aspx?hubs_content=blog.hubspot.com/blog/tabid/6307/bid/28472/the-5-critical-components-of-fantastic-lead-capture-forms.aspx&hubs_content-cta=Buttons%2520labeled%2520%25E2%2580%259Csubmit%25E2%2580%259D%2520had%2520lower%2520conversion%2520rates\" target=\"_blank\" rel=\"noreferrer noopener\">One such study</a> found “submit” to be the worst performing button copy of all the choices in the&nbsp;study.</p>\n\n\n\n<p>You won’t likely do much better with boring and generic terms like “join our list” or&nbsp;“subscribe.”</p>\n\n\n\n<p>Use language that’s fun, engaging, or specific to your company or the offer made on the lead capture form. Use language that fits your&nbsp;brand.&nbsp;</p>\n\n\n\n<p>For example, if your lead generation form strategy is to offer a coupon reward to everyone who joins the list, then make the button copy something like “Claim your discount!” or “Send my&nbsp;coupon!”</p>\n\n\n\n<p>If you’re offering a free guide or report, then say “Get your guide,” or “Access the free&nbsp;report.”</p>\n\n\n\n<h3 class=\"wp-block-heading\">4. A/B test for&nbsp;success</h3>\n\n\n\n<p>As long as your lead capture form pages are getting enough traffic to collect valid data, A/B testing can help you optimize your lead capture form conversions over&nbsp;time.</p>\n\n\n\n<p>And button copy is just one thing you can test on your lead gen form using A/B testing. You can also test many other items on this list, including headline, form design, button color, and location on the page. Find out what works best and build from&nbsp;there.</p>\n\n\n\n<h3 class=\"wp-block-heading\">5. Use headlines to communicate&nbsp;value&nbsp;</h3>\n\n\n\n<p>Yes, your lead capture form should have a headline. Use a headline to express, concisely, why your ideal customer would want to join your email&nbsp;list.&nbsp;</p>\n\n\n\n<p>A typical form tool will let you create a headline, or title, in large text and with colors you can manipulate. You should also create a subtitle that complements the main title with an additional&nbsp;incentive.&nbsp;</p>\n\n\n\n<p>As with button copy, your headline should not be “Subscribe to our&nbsp;newsletter!”&nbsp;</p>\n\n\n\n<p>Why?</p>\n\n\n\n<p>Again, this is marketing. No one has to join your email list. They didn’t start their day thinking about how much they look forward to finding a company whose email list they haven&#8217;t joined&nbsp;yet.&nbsp;</p>\n\n\n\n<p>You’re asking them to do something they didn’t plan on doing. You must give them good reasons for doing so if you want to optimize your lead gen&nbsp;forms.&nbsp;</p>\n\n\n\n<p>You do that by telling them why they should join. Pick one benefit, or two if you can fit the second in the subtitle, and use those to motivate more signups. Use action-oriented&nbsp;language.&nbsp;</p>\n\n\n\n<p>Tell them what to do, and why they should want to do&nbsp;it.&nbsp;</p>\n\n\n\n<p>And as with the button copy, the headline should relate to the main incentive you’re offering to new&nbsp;subscribers.&nbsp;&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">6. Make it pretty — design&nbsp;matters</h3>\n\n\n\n<p>Your lead generation form should stand out from the rest of your page. Design doesn’t just refer to the form itself, the colors, the sizes of the fields, the field label text, colors and fonts, or the shape. Yes, it includes all of&nbsp;that.</p>\n\n\n\n<img width=\"1280\" height=\"1600\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image.jpeg\" alt=\"color swatches on a desk\" class=\"wp-image-255695\" />\n\n\n\n<p>But design also refers to how the form interacts with the rest of the page. Is it set apart from the other content on the page to distinguish it? Can it be easily overlooked because it blends in too well? Is the rest of the page too crowded, so the form is getting lost? This, too, is&nbsp;design.&nbsp;</p>\n\n\n\n<p>As for the form itself, many companies are tempted to use their brand colors on their lead capture forms. But is this smart? Again, if the form blends in <em>too</em> well with the rest of the page, site visitors will miss it. We’re not saying to use colors that completely conflict, but you can use design strategies that draw attention to the form and set it apart from how the rest of the page&nbsp;looks.</p>\n\n\n\n<p>The fields and other elements can also be designed to look modern and appealing, not&nbsp;dated.</p>\n\n\n\n<p>Many lead capture form templates can deliver effective design without a huge time commitment. And many of these can also be customized too, as you see&nbsp;fit.&nbsp;</p>\n\n\n\n<p>Remember, you can A/B test all of this. If your marketing department has a disagreement about the color or some other design aspect, do both and see which form gets more&nbsp;conversions.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">7. Keep it visible — make sure customers can find your&nbsp;forms</h3>\n\n\n\n<p>A lead capture form that’s hard to see or find on your site isn’t going to convert very many people to sign up. You have to make it a priority for your company to grow your email list. That means, make sure they can find your opt-in&nbsp;forms.&nbsp;</p>\n\n\n\n<p>Too many websites just slap a form in the footer and call it done. Or, they stick one on their homepage, and nowhere&nbsp;else.&nbsp;</p>\n\n\n\n<p>But that’s not how everyone finds your site. Not everyone makes it to the footer. And not everyone who does find your home page will return there after browsing other&nbsp;pages.</p>\n\n\n\n<p>You need lead forms all over your&nbsp;site.&nbsp;</p>\n\n\n\n<p>Put them in the sidebars of articles. Embed them in key webpages. Use popups, some of which are triggered by time on page, and others of which are triggered when the user clicks on a relevant link. Create special landing pages and link to them from other pages using graphics and&nbsp;text.&nbsp;</p>\n\n\n\n<p>It should be almost impossible for anyone to visit your website and not see a lead capture&nbsp;form.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">8. Create marketing for your lead capture&nbsp;funnel</h3>\n\n\n\n<p>Joining your email list shouldn’t depend on customers coming to your website first. You can also create external marketing specifically for the purpose of gaining new&nbsp;subscribers.&nbsp;</p>\n\n\n\n<p>Create social media campaigns that link to landing pages containing lead capture forms. This could include posts, ads, graphics, and videos that aren’t selling products, but are offering incentives for joining your email list. Promote a 20% discount for new&nbsp;subscribers.</p>\n\n\n\n<p>The landing page these posts and ads link to will sell the value of subscribing to your list, and the discount is just their first&nbsp;reward.&nbsp;</p>\n\n\n\n<p>The point is, if you want more conversions from high quality leads, create marketing that will go after your target&nbsp;audience.</p>\n\n\n\n<h3 class=\"wp-block-heading\">9. Make sure your forms are&nbsp;responsive</h3>\n\n\n\n<p>This should go without saying by this point in the digital marketing world, but your forms need to show up and function on all devices, not just desktops and laptops. If users can’t see or easily navigate your lead capture form on their mobile device, they won’t complete&nbsp;it.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">10. Use social&nbsp;proof</h3>\n\n\n\n<p>This is less common to see within lead generation forms. But fitting a short testimonial within your form can make people more excited about signing up. This could even be your subtitle. You could also fit it below the fields and above the button, or below the&nbsp;button.&nbsp;</p>\n\n\n\n<img width=\"1316\" height=\"1264\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-4.png\" alt=\"example of testimonials near a form\" class=\"wp-image-255696\" />\n\n\n\n<p>You could also include testimonials near the form, but not within it. This way, someone looking in the direction of your form will see what other people like about being on your list, and consider&nbsp;joining.</p>\n\n\n\n<p>Do your testimonials have to be about the actual email list subscription? Not necessarily, but that’s the best possible version. If you send out a quick survey to your existing email list, you could probably get some great responses about why people like being on your&nbsp;list.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">11. Give your email list a&nbsp;name</h3>\n\n\n\n<p>Exclusivity sells. Generic doesn’t. “Join our email list” is&nbsp;boring.&nbsp;</p>\n\n\n\n<p>Create a name that makes your list feel more like a club, or a community, or a place where the smartest, most motivated, most clever, most successful, happiest customers can be&nbsp;found.&nbsp;</p>\n\n\n\n<p>Whatever describes your ideal customer persona, try to come up with a name for your email list that will appeal to those&nbsp;people.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">12. Break up the form into multiple&nbsp;steps</h3>\n\n\n\n<p>If you need to collect more than just a couple of pieces of information, you may earn higher conversion rates if you break the web form up into steps. The first page might just ask for their name, or zip code, or email address. The second one might ask for more information specific to them. And the third might ask for a few more&nbsp;things.&nbsp;</p>\n\n\n\n<p>You can also create multistep forms that store the information entered on previous steps, so if the person abandons the form at a later step, you still have the data they already&nbsp;submitted.</p>\n\n\n\n<p>But multistep forms feel faster to the user, and they look less intimidating. It’s less daunting to fill out two fields in three steps than to fill out six fields in one step. Same number of fields, but broken up into bite-size&nbsp;steps.</p>\n\n\n\n<h3 class=\"wp-block-heading\">13. Use a progress bar to encourage&nbsp;visitors</h3>\n\n\n\n<p>If you do use a multistep form, use a progress bar to show how far along they are toward completing the&nbsp;process.</p>\n\n\n\n<img width=\"1600\" height=\"640\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-1.jpeg\" alt=\"colorful progress bar\" class=\"wp-image-255697\" />\n\n\n\n<p>People like to feel like they’re getting things done. Watching the progress bar move along the top of the form motivates them to want to finish it. Online surveys have used this tool with great success to increase survey completion rates. It works just as well with lead generation&nbsp;forms.</p>\n\n\n\n<h3 class=\"wp-block-heading\">14. Clearly state your privacy policy and compliance&nbsp;information</h3>\n\n\n\n<p>You can do this in one of two ways. First, simply include a short statement with a link to “view our privacy policy.” Second, you can ask users to check a box saying they have read and agree to your&nbsp;policy.</p>\n\n\n\n<p>Either way, the main idea is to communicate that you <em>have</em> a privacy policy. This shows their data is important to you, and that they can trust you to handle it&nbsp;respectfully.&nbsp;</p>\n\n\n\n<p>Unless you specifically need to for legal or compliance reasons, you may not want to require users to check a box. Otherwise, they’ll find themselves wading through a page with legal jargon and privacy language that has nothing whatsoever to do with the benefits of joining your email&nbsp;list.&nbsp;</p>\n\n\n\n<p>So, it may be better to simply include the link for anyone who wants to see this information. You want them thinking about joining your list, not their data&nbsp;privacy.&nbsp;</p>\n\n\n\n<p>And, you can also include a short statement about how your email list complies with GDPR and other relevant email compliance&nbsp;regulations.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">15. Close the deal with&nbsp;video</h3>\n\n\n\n<p>If you really want to optimize your lead capture form conversion rate, have the face of your company or someone else your customers will admire, appreciate, or relate to, create a video that extols the benefits of joining your email&nbsp;list.&nbsp;</p>\n\n\n\n<p>The video should make joining seem desirable, appealing, and advantageous, with no risk and no downside. You can always remind people that they can unsubscribe at any&nbsp;time.&nbsp;</p>\n\n\n\n<p>Once this video is ready, place it on the landing page of your lead capture form. You can also put it on other web pages, your home page, and even post it on social media and on YouTube as a means of externally marketing your email&nbsp;list.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Which of these strategies is the easiest to start using&nbsp;now?</h2>\n\n\n\n<p>Some of these tips require a little work on your part, and you can have your marketing or sales team get going on&nbsp;those.</p>\n\n\n\n<p>But one of the most effective strategies to optimize lead forms for a higher conversion rate is one you can start using today. If you’re still using some version of CAPTCHA, <a href=\"https://akismet.com/features/\">Akismet will reduce</a> your lead generation form abandonment rate by leaps and&nbsp;bounds.</p>\n\n\n\n<p>As you saw earlier, with such high rates of people quitting the process when they run into these nonsensical puzzles, you’ll see far more signups simply by eliminating this needless&nbsp;barrier.</p>\n\n\n\n<p><a href=\"https://akismet.com/enterprise/\">Use Akismet</a> in place of CAPTCHA, and your lead conversion rate will&nbsp;increase.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">FAQs related to lead capture form&nbsp;optimization</h2>\n\n\n\n<h3 class=\"wp-block-heading\">How many fields should I include on my lead capture&nbsp;form?</h3>\n\n\n\n<p>While there’s no set requirement or ideal number, the fewer form fields you require, the more people will complete your web form. However, the quality of your leads tends to increase as you ask for more fields, so the balance may be somewhere in the&nbsp;middle.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">What information should I ask for on my lead capture&nbsp;form?</h3>\n\n\n\n<p>This depends on the goals you have set for your email list, and on your industry. If you are creating distinct marketing for different segments of your audience, you might ask for information on your form that will funnel people into the correct&nbsp;groups.&nbsp;</p>\n\n\n\n<p>At a minimum, you should ask for their email address and first name. This protects their privacy but gives you enough to start the&nbsp;relationship.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">How can I make my lead capture form visually&nbsp;appealing?</h3>\n\n\n\n<p>Use modern lead capture form templates that are both visually appealing and responsive to different devices and platforms. Use colors that are unique from the page it sits on, but that coordinate with your brand and overall site design. Add graphics and images of people, when appropriate, to humanize the form and make it feel a bit less&nbsp;transactional.&nbsp;&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Should I use a single or multistep lead capture&nbsp;form?</h3>\n\n\n\n<p>If you’re only asking for first name and email address, you only need a single-step form. But if you’re asking for four or more fields to be filled out, you might consider a multistep form, along with a progress bar, to encourage more users to complete the steps and fill out the entire&nbsp;form.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What are common mistakes when creating a lead capture&nbsp;form?</h3>\n\n\n\n<p>The most common mistake is to require too much information, especially phone numbers.<a href=\"https://unbounce.com/conversion-rate-optimization/how-to-optimize-contact-forms/\"> One site that changed its phone field</a> from required to optional saw its conversion rate go from 42.6% to 80%. There’s a sizable subset of people who simply will not give out their phone number in a lead capture&nbsp;form.&nbsp;</p>\n\n\n\n<p>A second common mistake is to not think about who your ideal customer is when creating these lead gen forms. The language of the offer, any incentives, and the button should appeal to your ideal customer, subscriber, or&nbsp;lead.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Should I use CAPTCHA to protect my form from&nbsp;spam?</h3>\n\n\n\n<p>No — CAPTCHA increases frustration and dramatically increases form abandonment.<a href=\"https://medium.com/rareview/why-your-captcha-is-killing-conversions-f9be6fe17d1f\" target=\"_blank\" rel=\"noreferrer noopener\"> A MOZ study</a> found that 30% of lead capture form users gave up while trying to solve these annoying puzzles. That’s a lot of lost&nbsp;subscribers.&nbsp;</p>\n\n\n\n<p>A better approach is to use anti-spam tools like Akismet that run in the background and use AI to identify and block spambots from completing your&nbsp;forms.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What is Akismet, and how can it improve my form conversion&nbsp;rate?</h3>\n\n\n\n<p>Akismet is an anti-spam plugin built for marketers and lead generation. It’s an open-source tool created by WordPress that can work on almost any website platform because it was written by developers, for&nbsp;developers.&nbsp;</p>\n\n\n\n<img width=\"1600\" height=\"813\" src=\"https://akismet455732288.files.wordpress.com/2023/08/image-5.png\" alt=\"Akismet homepage with the tagline \" />\n\n\n\n<p>Akismet improves lead capture form conversion rates because it identifies and blocks spam without requiring your actual users to do anything. There are no annoying puzzles to solve or grainy pictures to scour through. All the anti-spam work happens in the&nbsp;background.&nbsp;</p>\n\n\n\n<p>That means it protects your site and your email list from spammers, but doesn’t hinder anyone you want to join your list from doing&nbsp;so. </p>\n\n\n\n<h3 class=\"wp-block-heading\">What types of companies generally use&nbsp;Akismet?</h3>\n\n\n\n<p>There are over 100 million sites currently using Akismet. There is a<a href=\"https://akismet.com/features/\"> free version</a> for non-commercial blogs, reasonably priced paid versions for commercial businesses, and<a href=\"https://akismet.com/enterprise/\"> an enterprise version</a> for large&nbsp;companies.&nbsp;</p>\n\n\n\n<p>Happy Akismet customers include Microsoft, Bluehost,<a href=\"https://akismet.com/blog/convertkit-customerstory/\"> and ConvertKit</a>, whose senior engineer John Lunsford said, “With Akismet, we don’t really have to think about spam prevention, which allows us to work on other things. We moved from a place of putting out fires to now things are automated. We’re tracking stuff, we’re alerting on stuff. So now we know across our whole surface area if we have bot&nbsp;attacks.”</p>\n\n\n\n<h2 class=\"wp-block-heading\">Instantly improve your lead capture form conversion&nbsp;rates</h2>\n\n\n\n<p>You can spend hours optimizing lead generation forms, designing custom graphics, and tweaking copy. All of those things will pay off with incremental increases in conversion rates from your target&nbsp;audience.&nbsp;</p>\n\n\n\n<p>But what if you need results <em>right now</em>? The quickest way to boost results is to eliminate annoying CAPTCHAs and use Akismet instead to protect your site in the background while letting real users pass right&nbsp;by.&nbsp;</p>\n\n\n\n<p><a href=\"https://akismet.com/pricing/\">Get Akismet&nbsp;today.</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jen Swisher\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"HeroPress: My Journey as a Teacher and Engineer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=5915\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"https://heropress.com/essays/my-journey-as-a-teacher-and-engineer/#utm_source=rss&utm_medium=rss&utm_campaign=my-journey-as-a-teacher-and-engineer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13299:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2024/09/092623-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I only knew I had teaching skills, but WordPress taught me to be versatile.\" /><p>I always wanted to be a teacher from my childhood days. I have seen my mom giving tuition. My aunts, uncles, sisters-in-law, and cousins were all in the teaching field. Since I grew up observing them all teaching, I also envisioned myself as a teacher. I believed there was no better profession in the world, and I still do.</p>\n\n\n\n<p>As I grew older, my goals shifted slightly. I started to see myself as a lecturer rather than a teacher. I was the first girl in my family to become an engineer. </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>During my studies, I never thought about working in the IT field. </p>\n</blockquote>\n\n\n\n<p>I had a narrow view that IT or Computer Engineering meant only for coding. The employee has to work around the clock and move to another location. So, I had enough reasons to convince myself to pursue a career in teaching. Even today, if someone asks me in the middle of the night to explain how to debug a program using a loop, I can do so happily.</p>\n\n\n\n<p>After completing my engineering degree, I started working as a lecturer. After getting married, I moved to a new city but continued working as a lecturer. During that period, my husband went to Singapore for work, and we all moved to our native place. I could not find a lecturing job as there were no engineering colleges. And other colleges only offered positions as computer lab assistants, which I declined. I began providing private tutoring for engineering students, and my life seemed settled.</p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-discovering-passion-through-writing-my-journey-from-boredom-to-blogging-bliss\"><strong>Discovering Passion Through Writing: My Journey from Boredom to Blogging Bliss</strong></h2>\n\n\n\n<p>Then, a turning point occurred in my life. Within five months, I also moved to Singapore. I managed to find a job in marketing, which was outside my skill set. I soon realized that it did not bring me joy. And without joy, there was no fulfilment.</p>\n\n\n\n<p>I left that job after three months. I started getting bored. I did not have much to do except grocery shopping and household chores. One day, my husband suggested trying something new! It can be writing or documenting or anything that could help to stay content. I had never considered writing before! He suggested some blogging platforms like Medium, Tumblr, Blogger, and WordPress. I created accounts for each of them and started publishing articles. </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>WordPress turned out to be the most engaging platform, and I decided to continue writing a blog on WordPress. </p>\n</blockquote>\n\n\n\n<p>That was how I started <a href=\"https://krupajnanda.wordpress.com/\">my blog</a>, out of boredom, which became a passion later. I connected with hundreds of fellow bloggers. I also started participating in various blogger events and started getting recognition. And this was something I could do for hours.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Crossroads and Choices: Navigating Career Transitions from Teaching to Testing</strong></h2>\n\n\n\n<p>In 2015, we returned to India. We settled in Pune, which presented a new challenge for me in finding a lecturing job. Some institutes only offered me positions as visiting faculty. And pursuing further studies seemed impractical at that time. So, I had two options left. Either continue writing blogs full-time or join the IT sector. I enrolled in a testing crash course, which I would not recommend anyone to do. The institute focused on theory more and minimal practical knowledge. I also cleared my ISTQB certification.</p>\n\n\n\n<p>And you won&#8217;t believe what happened next&#8230;.!</p>\n\n\n\n<p>After a few months, I landed a position at rtCamp as a <em>QA Engineer</em>! It&#8217;s fascinating to think that I initially used WordPress as a consumer to publish my blogs, and now I find myself testing websites built on the WordPress platform. </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Like many others, I once considered WordPress to be exclusively a blogging platform, unaware of the efficiency and sophistication of the entire WordPress ecosystem.&nbsp;</p>\n</blockquote>\n\n\n\n<p>Back then, I had little technical knowledge about WordPress, but I became familiar with the plethora of terms specific to the WordPress environment and other technical nuances. I delved into concepts ranging from the Dashboard to slugs and post metadata, among other things. Initially, I conducted manual testing of websites, but over time, I acquired proficiency in various automation frameworks. At rtCamp, we have explored a multitude of frameworks for comprehensive automation, covering areas such as end-to-end testing, visual testing, acceptance testing, API testing, and more. If you&#8217;re interested in learning more about our QA services, you can explore them <a href=\"https://rtcamp.com/quality-assurance-services/\">here</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>COVID19 &#8211; A Journey of Career Break, Home Schooling, and Life Lessons</strong></h2>\n\n\n\n<p>Fast forward to 2020, a year we remember as a pandemic! I took a career break around June 2020 for many reasons. I decided to home school my son. Teaching a preschooler is quite different from teaching a college student. I had no idea how I would be able to make homeschooling happen. I come from a traditional school environment. </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>To understand the depth of homeschooling was also a challenge for me. I had no idea where to start! </p>\n</blockquote>\n\n\n\n<p>I started following many such accounts dedicated to homeschooling. But it did not go well initially. We took multiple breaks. I kept revisiting my failures in homeschooling strategies, what went well, what could be improved, and how can I make more engaging things like that!</p>\n\n\n\n<p>I also started reading many parenting books. My son became more comfortable with the time. It was a journey filled with various gaps and learning experiences! I started documenting <a href=\"https://musingsonparenting.com/\">my parenting and homeschool journey</a>. I also share bits of it on <a href=\"https://www.instagram.com/musingsonparenting/\">Instagram</a> too.</p>\n\n\n\n<p>During those years, we traveled to many places around India. And homeschooling became more like <em>school on the road</em>. It was not only about learning ABCs and 1, 2, 3. Homeschooling meant acquiring life skills. We traveled to different places, immersing ourselves in local cultures and food. We worked and improved on many aspects during our home school journey. Apart from academics, we learnt gardening, composting, eco-friendly practices, reading books, sharing toys/books and many more new things! My son never liked books but we ended up visiting the library twice a week!</p>\n\n\n\n<p>My husband and I considered extending homeschooling, at least for kindergarten. But there are always pros and cons to everything! Home schooling is blissful yet it comes with challenges for parents and kids. I also wanted my son to attend a real school and want him to understand the difference between homeschooling v/s going to school every day where school follows a fixed curriculum. He is too small at this age to understand what is best for him. I wanted him to experience what school life is all about! Luckily, we found a good school in town that does not follow the traditional teaching approach. They focused on teaching children <em>how to think rather than telling them what to think.&nbsp;</em></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Emerging from the Comfort Zone: Rediscovering My Career Path After an Extended Career Break</strong></h2>\n\n\n\n<p>As my son started school, I again had some free time but was unsure about resuming my career. I retreated into a cocoon of safety. Resuming work meant facing new challenges for which I wasn&#8217;t prepared. So, I took more time to adjust to the upcoming changes. I explained to my son why I wanted to work and prepared him. Today, I am proud of how well he has managed.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Overcoming Rejections and Career Break Challenges</strong></h2>\n\n\n\n<p>During the second half of the last year, I began preparing myself. The job market took a hit due to an economic downturn. Layoffs and pay cuts were happening even at major companies like Google and Microsoft. Despite the challenges, I started looking for job opportunities. My journey was marked by numerous rejections, even after successfully clearing interviews. In several instances, when multiple candidates vied for the same position, my career break seemed to be a decisive factor in being overlooked. This experience was disheartening, as many organizations fail to recognize the value of individuals who have taken career breaks!</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>My Journey Back to Work with rtCamp</strong></h2>\n\n\n\n<p>But fate had other plans. I reconnected with my former employer this year around April 2023, and they didn’t let me down. It gives me goosebumps even now as I write this. I resumed my career back at rtCamp this year in June 2023</p>\n\n\n\n<p>Rejoining the same organization after an extended break gave me the feeling of returning back to home after a vacation! rtCamp is known for its motto of &#8220;<em>Good Work and Good People&#8221; </em>and they proven to stand by it!&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>From User to Contributor in the WordPress ecosystem</strong></h2>\n\n\n\n<p>One of the remarkable aspects of rtCamp is, that we are encouraged to contribute to the WordPress ecosystem. I gradually began contributing to the WordPress Core, and it fills me with pride whenever even a modest suggestion, enhancement, or reported bug gets approved. Whether it&#8217;s a small or substantial contribution, each one enhances WordPress as a whole which millions of people use, resulting in continuous improvements. Being a part of the WordPress community brings me immense joy, and I consider myself blessed. Here are some of the tickets that opened and got fixed.</p>\n\n\n\n<ul>\n<li><a href=\"https://core.trac.wordpress.org/ticket/44714\">https://core.trac.wordpress.org/ticket/44714</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/ticket/41648\">https://core.trac.wordpress.org/ticket/41648</a></li>\n\n\n\n<li><a href=\"https://meta.trac.wordpress.org/ticket/4721\">https://meta.trac.wordpress.org/ticket/4721</a></li>\n\n\n\n<li><a href=\"https://buddypress.trac.wordpress.org/ticket/8161\">https://buddypress.trac.wordpress.org/ticket/8161</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Inspired to Speak: My experience of attending Speaker Workshop for Indian Women</strong></h2>\n\n\n\n<p>Recently, I had the privilege of attending the Speaker Workshop for Indian Women in the WordPress Community, which took place on September 23-24. This workshop not only boosted my confidence but also shattered many myths. It made me realize that no one is an absolute expert, and nobody is perfect. Sooner or later, you break the cocoon to free your wings if you want to fly!</p>\n\n\n\n<p>Regrettably, I hadn&#8217;t been able to attend any Meetups or WordCamps before. However, I am genuinely looking forward to participating in upcoming WordCamps and meetups very soon!</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>From testing exam papers to testing websites</strong></h2>\n\n\n\n<p>I only knew I had teaching skills, but WordPress taught me to be versatile. One should keep exploring various opportunities rather than waiting for destiny to knock on the door.&nbsp;</p>\n\n\n\n<p>By the way, rtCamp is always hiring. If you&#8217;re interested in working with rtCamp, visit their <a href=\"https://rtcamp.com/careers/\">career page</a>.</p>\n\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id5915_81e43c-37 alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column5915_38272e-59\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"work-environment\" class=\"kt-adv-heading5915_69c4fb-d0 wp-block-kadence-advancedheading\">Krupa&#8217;s Work Environment</h2>\n\n\n\n<p>We asked Krupa for a view into her development life and this is what she sent! </p>\n\n\n	<div class=\"hotspots-image-container\">\n		<img width=\"2346\" height=\"2560\" src=\"https://heropress.com/wp-content/uploads/2023/09/Krupa-Desktop-scaled.jpg\" alt=\"Krupa Nanda\" class=\"hotspots-image skip-lazy\" />\n	</div>\n\n\n\n\n<p class=\"kt-adv-heading5915_fdd08f-54 wp-block-kadence-advancedheading has-theme-palette-9-background-color has-background\">HeroPress would like to thank <a href=\"https://wpdrawattention.com/\">Draw Attention</a> for their donation of the plugin to make this interactive image!</p>\n</div></div>\n\n</div></div>\n\n\n<p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/my-journey-as-a-teacher-and-engineer/\">My Journey as a Teacher and Engineer</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 12:07:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Krupa Nanda\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WordPress.org blog: Help Influence the Future of WordPress by Taking the 2023 Annual Survey Today\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15982\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/news/2023/09/help-influence-the-future-of-wordpress-by-taking-the-2023-annual-survey-today/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4717:\"<p>Each year, the WordPress community (users, site builders, extenders, and contributors) provides valuable feedback through an annual survey. The results can influence the direction of the WordPress project by identifying areas that need attention. Annual surveying can also help track trends over time, with data points often finding their way into the yearly <a href=\"https://wordpress.org/news/2022/11/state-of-the-word-2022/\">State of the Word</a> address.</p>\n\n\n\n<p>This survey helps those who build WordPress understand more about how the software is used and by whom. The survey also allows WordPress open source project leaders to learn more about our contributors’ experiences.&nbsp;&nbsp;</p>\n\n\n\n<p>To ensure your WordPress experience gets represented in the 2023 survey results, take the survey now (link).</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>You may also take the survey in other languages by using the link above and switching to another language, thanks to the efforts of WordPress polyglot contributors.&nbsp;</p>\n\n\n\n<p>The survey will be open for five weeks. Results will be published on the News blog in early December.</p>\n\n\n\n<p>This year, like last year, the survey has undergone some improvements to the flow and question set. A new platform is also being piloted, offering an updated interface, enhanced multi-lingual support, expanded analysis and visualization tools for the results, and more. The new platform also has built-in accessibility and privacy controls, ensuring the survey meets the diverse needs of the WordPress community.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Spread the word</strong></h2>\n\n\n\n<p>Please help spread the word about the survey by sharing it with your network, through Slack, or within your social media accounts. The more people who complete the survey and share their experience with WordPress, the more the project will benefit.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Security and privacy</strong></h2>\n\n\n\n<p>Data security and privacy are paramount to the WordPress project and community. With this in mind, all data will be anonymized: no email addresses or IP addresses will be associated with published results. To learn more about WordPress.org’s privacy practices, view the <a href=\"https://wordpress.org/about/privacy/\">privacy policy</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Thank you</strong></h2>\n\n\n\n<p>Thank you to the following WordPress contributors for assisting with the annual survey project, including question creation, strategy, survey build-out, and translation:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/adamsilverstein/\">adamsilverstein</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">audrasjb</a>, <a href=\"https://profiles.wordpress.org/alvarogois/\">alvarogóis</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">atachibana</a>, <a href=\"https://profiles.wordpress.org/bjmcsherry/\">bjmcsherry</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">dansoschin</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">eidolonnight</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">fierevere</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbénard</a>, <a href=\"https://profiles.wordpress.org/hassantafreshi/\">hassantafreshi</a>, <a href=\"https://profiles.wordpress.org/juliagasparyan/\">juliagasparyan</a>, <a href=\"https://profiles.wordpress.org/kittmedia/\">kittmedia</a>, <a href=\"https://profiles.wordpress.org/manudavidos/\">manudavidos</a>, <a href=\"https://profiles.wordpress.org/nao/\">nao</a>, <a href=\"https://profiles.wordpress.org/nilovelez/\">nilovelez</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, and <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner</a>.</p>\n\n\n\n<p>Thanks to <a href=\"https://www.hostinger.com/\">Hostinger</a>, <a href=\"https://cloud.jetpack.com/\">Jetpack</a>, and <a href=\"http://wordpress.com\">WordPress.com</a>, for assisting with promoting the survey to their respective clients.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://survey.alchemer.com/s3/7439442/2023-WordPress-Annual-Survey?ref23=dotOrgNewsPost\">Take the 2023 Survey</a></div>\n</div>\n\n\n\n<p>The survey closes on Tuesday, October 31, 2023 at 12:00.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 10:52:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Dan Soschin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WPTavern: WordPress 6.4 Beta 1 Released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149512\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wptavern.com/wordpress-6-4-beta-1-released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3558:\"<p><a href=\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\">WordPress 6.4 Beta 1</a> was released today on schedule, led by an <a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\" target=\"_blank\">underrepresented gender release squad</a>. It includes the last five releases of the Gutenberg plugin (<a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>) along with the upcoming 16.7 release and <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=6.4&group=component&max=500&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">190 tickets for core</a>.</p>\n\n\n\n<p>If you are following Gutenberg development, many of these features have already been released in the plugin. The most notable highlights of features and improvements coming in 6.4 include the following:</p>\n\n\n\n<ul>\n<li><strong>Font Management</strong> &#8211; allows users to manage a <a href=\"https://core.trac.wordpress.org/ticket/59166\">font library</a> independent of their active theme, along with <a href=\"https://core.trac.wordpress.org/ticket/59165\">Font Face</a> support for server-side <code>@font-face</code> style generation and printing</li>\n\n\n\n<li><strong>Block Hooks</strong> &#8211; enables developers to automatically insert blocks into content relative to another block</li>\n\n\n\n<li><strong>Lightbox for Images</strong> &#8211; core support for <a href=\"https://github.com/WordPress/gutenberg/issues/51132\">lightbox</a> functionality for image blocks</li>\n\n\n\n<li><strong>Expanded Design Tools</strong> &#8211; background images for Group blocks, aspect ratios for image placeholders, alignment settings for synced patterns, and more</li>\n\n\n\n<li><strong>Command Palette updates</strong> &#8211; <a href=\"https://github.com/WordPress/gutenberg/pull/53117\">improved design</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/52509#top\">new commands</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53496\">better consistency across existing commands</a></li>\n\n\n\n<li><strong>List view enhancements</strong> &#8211; usability improvements allow for renaming Group blocks, viewing media previews for Gallery and Image blocks, and duplicating blocks with a keyboard shortcut</li>\n\n\n\n<li><strong>New Twenty Twenty-Four default theme</strong> &#8211; a multipurpose block theme that will ship with a collection of templates and patterns that lend themselves to a wide variety of use cases. See a demo at <a href=\"http://2024.wordpress.net/\">2024.wordpress.net</a>.</li>\n</ul>\n\n\n\n<p>WordPress 6.4 will also include many accessibility and performance improvements that will improve workflows and speed for all users of both Block and Classic Themes. A <a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">detailed testing guide</a> is available that covers all the key features and how to test them, with video demos for each.</p>\n\n\n\n<p>Beta 2 is expected on October 3. WordPress 6.4 will be the third major release of 2023, and is scheduled for November 7. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Sep 2023 03:04:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WordPress.org Expands Two-Factor Authentication Interface to Include Security Keys\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149493\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wordpress-org-expands-two-factor-authentication-interface-to-include-security-keys\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2442:\"<p>WordPress.org began <a href=\"https://make.wordpress.org/meta/2023/05/31/two-factor-auth-available-to-test-on-wordpress-org/\">testing two-factor authentication</a> (2FA) as an opt-in feature in May 2023. The interface and functionality are still in beta but it&#8217;s operational. This week contributors have <a href=\"https://make.wordpress.org/meta/2023/09/26/set-up-two-factor-authentication-wordpress-org/\">expanded support for 2FA</a> with a new interface for adding security keys, which are more secure than the one-time passwords.</p>\n\n\n\n<p>A logged in user can set up the keys by visiting their WordPress.org profile, scrolling down to the &#8220;Security&#8221; section, and clicking on the support forum profile link. </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1964\" height=\"644\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/Screen-Shot-2023-09-26-at-3.24.29-PM.png\" alt=\"\" class=\"wp-image-149522\" />\n\n\n\n<p>Users who have two-factor authentication set up can click on &#8220;Two-Factor Security Key&#8221; and follow the instructions to set them up. </p>\n\n\n\n<p>This update to the interface also adds Time-Based One-Time Passwords<strong> </strong>(TOTP), which are generated from the user&#8217;s chosen authentication app on their device and changed every 30 seconds. WordPress.org currently defaults to using security keys over the time-based on-time passwords, but contributors are <a href=\"https://github.com/WordPress/wporg-two-factor/issues/249\">working on making that configurable</a> in the future.</p>\n\n\n\n<p>Additions to the interface also include the ability to generate backup codes, which enable access when users don&#8217;t have their 2FA security key or app configured. The backup codes come with a note of caution from Automattic- sponsored Meta contributor Steve Dufresne, who has been working on the 2FA project:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>Regardless of whether you are using security keys or a Time-Based One-Time password, <strong>make sure you generate and print backup codes</strong>. If you lose your primary key/device and don’t have a backup code, you will lose access to your account forever.</p>\n</blockquote>\n\n\n\n<p>Dufresne encouraged WordPress.org users who haven&#8217;t set up 2FA to go ahead and do so. Any bugs can be reported to the project&#8217;s <a href=\"https://github.com/wordpress/wporg-two-factor\">GitHub repository</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Sep 2023 21:02:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WordPress.org blog: WordPress 6.4 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=15994\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2023/09/wordpress-6-4-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18853:\"<p>WordPress 6.4 Beta 1 is ready for download and testing!</p>\n\n\n\n<p><strong>This beta version of the WordPress software is under development</strong>.<strong> </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended you evaluate Beta 1 on a test server and site.</p>\n\n\n\n<p>You can test WordPress 6.4 Beta 1 in three ways:</p>\n\n\n\n<ol>\n<li><strong>Plugin:</strong> Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin on a WordPress install (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li>\n\n\n\n<li><strong>Direct download: </strong>Download the <a href=\"https://wordpress.org/wordpress-6.4-beta1.zip\">Beta 1 version (zip)</a> and install it on a WordPress website.</li>\n\n\n\n<li><strong>Command line:</strong> Use the following <a href=\"https://make.wordpress.org/cli/\">WP-CLI</a> command:<br /><code>wp core update --version=6.4-beta1</code></li>\n</ol>\n\n\n\n<p>The current target for the final release of WordPress 6.4 is <strong>November 7, 2023</strong>. Your help testing this version is key to ensuring everything in the release is the best it can be.</p>\n\n\n\n<p>The WordPress 6.4 release is brought to you by an&nbsp;<a rel=\"noreferrer noopener\" href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\" target=\"_blank\"><strong>underrepresented gender release squad</strong></a>&nbsp;to increase participation&nbsp;of and partnership with&nbsp;those who identify as gender-underrepresented in the WordPress open source project.</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p class=\"has-extra-large-font-size\">Get an overview of the <a href=\"https://make.wordpress.org/core/6-4/\">6.4 release cycle</a>, and check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/6-4/\">6.4-related posts</a> in the coming weeks for further details.</p>\n</blockquote>\n\n\n\n<p><em><strong>This post has been updated as of October 5, 2023, to reflect the latest changes.</strong></em></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">How you can help: Testing</h2>\n\n\n\n<p>Testing for issues is a critical part of developing any software, and it’s a meaningful way for anyone to contribute—whether you have experience or not. <strong><a href=\"https://make.wordpress.org/test/2023/09/26/help-test-wordpress-6-4/\">This detailed guide</a> will walk you through testing key features in WordPress 6.4.</strong></p>\n\n\n\n<p>If you encounter an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Curious about testing releases in general? Follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives in Make Core</a> and join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on <a href=\"https://wordpress.slack.com/\">Making WordPress Slack</a>.</p>\n\n\n\n<p>Learn more about Gutenberg updates that have debuted since WordPress 6.3 by reviewing prior editions of <a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s New in Gutenberg</a> posts for <a href=\"https://make.wordpress.org/core/2023/07/14/whats-new-in-gutenberg-16-2-12-july/\">16.2</a>, <a href=\"https://make.wordpress.org/core/2023/07/26/whats-new-in-gutenberg-16-3-26-july/\">16.3</a>, <a href=\"https://make.wordpress.org/core/2023/08/10/whats-new-in-gutenberg-16-4-9-august/\">16.4</a>, <a href=\"https://make.wordpress.org/core/2023/08/23/whats-new-in-gutenberg-16-5-23-august/\">16.5</a>, <a href=\"https://make.wordpress.org/core/2023/09/06/whats-new-in-gutenberg-16-6-06-september/\">16.6</a>, and <a href=\"https://make.wordpress.org/core/2023/09/28/whats-new-in-gutenberg-16-7-27-september/\">16.7</a>.</p>\n\n\n\n<p>WordPress 6.4 Beta 1 contains over 400 enhancements and 370 bug fixes for the editor, including more than <a href=\"https://core.trac.wordpress.org/query?status=closed&milestone=6.4&group=component&max=500&col=id&col=summary&col=owner&col=type&col=priority&col=component&col=version&order=priority\">190 tickets for WordPress 6.4 core</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Vulnerability bounty doubles during Beta 1</h3>\n\n\n\n<p>Between Beta 1 and the final release candidate (RC) for each new WordPress version, the <a href=\"https://make.wordpress.org/security/2023/09/26/bug-bounty-for-wordpress-6-4-beta/\">monetary reward for reporting new, unreleased security vulnerabilities is doubled</a>. Please follow responsible disclosure practices as detailed in the project’s security practices and policies outlined on the <a href=\"https://hackerone.com/wordpress\">HackerOne page</a> and in the <a href=\"https://wordpress.org/about/security/\">security white paper</a>.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">A first look at WordPress 6.4</h2>\n\n\n\n<p>WordPress 6.4 will introduce a versatile default theme, new features, and numerous updates designed to enhance your WordPress experience across multiple areas—from writing and design to workflow efficiency. All while the foundational work continues for Phase 3 of the <a href=\"https://wordpress.org/about/roadmap/\">WordPress roadmap</a>. Read on for some highlights.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Meet the Twenty Twenty-Four theme</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/08/24/introducing-twenty-twenty-four/\">Twenty Twenty-Four</a> is a new default theme that will launch with 6.4. With a versatile collection of templates and patterns, this theme covers a diverse range of use cases, from entrepreneurs to small businesses to artists and writers. Twenty Twenty-Four also emphasizes the latest design tooling and site editing features, enabling you to leverage the flexibility of blocks and unlock numerous creative possibilities with just a few tweaks. Follow the theme&#8217;s progress and report any issues on <a href=\"https://github.com/WordPress/twentytwentyfour\">this GitHub repo</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Manage fonts across your site</h3>\n\n\n\n<p>WordPress 6.4 will introduce new font management features:</p>\n\n\n\n<p>The <a href=\"https://core.trac.wordpress.org/ticket/59166\">Font Library</a> enables you to handle fonts across your site, regardless of your active theme—just like you manage assets in the Media Library. Easily install local and Google Fonts and choose which to activate for each theme. This new font manager is a powerful way to control a fundamental piece of your site&#8217;s design and branding without coding. Thanks to its <a href=\"https://github.com/WordPress/gutenberg/issues/53307\">extensibility</a>, custom typographic collections can expand your font choices.</p>\n\n\n\n<p>On the other hand, <a href=\"https://core.trac.wordpress.org/ticket/59165\">Font Face</a> provides server-side <code>@font-face</code> style generation and printing support. It introduces a new global function called <code>wp_print_font_faces()</code>, which processes font data received from styles set in the editor or by the active theme.</p>\n\n\n\n<p><em><strong>Update (October 5, 2023): </strong>The Font Library feature will not debut in WordPress 6.4. Instead, it has been postponed to the next major release, 6.5. WordPress is committed to delivering the best possible experience, meaning this feature requires more feedback and testing to shine. Thank you for your understanding!</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Add lightbox functionality to your images</h3>\n\n\n\n<p>Showcase your images in an interactive fashion with <a href=\"https://github.com/WordPress/gutenberg/issues/51132\">lightbox functionality</a>. This new core feature will be available for Image blocks, allowing visual assets to be opened and enlarged on top of the existing content.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enjoy new writing improvements</h3>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/issues/53305\">Many enhancements</a> in 6.4 will ensure that your WordPress writing experience remains smooth and enjoyable, from new keyboard shortcuts to more reliable pasting from other sources. Moreover, a fresh toolbar experience will be available for the <a href=\"https://github.com/WordPress/gutenberg/pull/53697\">Navigation</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53306\">List</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53699\">Quote</a> blocks, making working with their tooling options more efficient and intuitive.</p>\n\n\n\n<h3 class=\"wp-block-heading\">More design tools, greater creativity</h3>\n\n\n\n<p>New design tools will improve the overall creation experience with WordPress while providing greater layout control and flexibility. Some updates include:</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53934\">Background images for Group blocks</a>, allowing for creative and customized layouts.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54216\">Aspect ratios for image placeholders</a>—a new feature that’s particularly useful when creating and using patterns. After setting a placeholder’s desired aspect ratio, you can drag and drop an image, which will adjust to maintain the design consistency.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/53667\">Button and heading color customization in Group</a> and <a href=\"https://github.com/WordPress/gutenberg/pull/54104\">Columns blocks</a>, enabling you to define the appearance of these elements when placed within these container blocks. This feature takes a step towards allowing <a href=\"https://github.com/WordPress/gutenberg/issues/40318\">section-specific styling</a>, which will continue to develop in upcoming releases.</li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/54416\">Alignment settings in synced patterns</a>. When creating and converting a synced pattern with wide, full-width, left or right-aligned blocks, this improvement ensures alignment attributes remain intact for a seamless site editing and pattern creation experience.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Upgrades for smoother workflows</h3>\n\n\n\n<p>As the Site Editor continues to evolve and expand its capabilities, so do the interface and tools that support it.</p>\n\n\n\n<p>First introduced in WordPress 6.3, the <a href=\"https://wordpress.org/documentation/article/site-editor-command-palette/\">Command Palette</a> helps you perform actions, search, and quickly navigate your site&#8217;s content and settings. It will receive significant updates in 6.4, featuring an <a href=\"https://github.com/WordPress/gutenberg/pull/53117\">updated design</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/52509#top\">new commands</a> to accomplish block-specific actions, and <a href=\"https://github.com/WordPress/gutenberg/pull/53496\">better command language and action consistency</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/list-view/\">List View</a> provides a great way to browse and work with the blocks that make up your site. This release will introduce enhancements to its interface and usability, making it even more powerful. You can <a href=\"https://github.com/WordPress/gutenberg/pull/53735\">rename Group blocks</a>, <a href=\"https://github.com/WordPress/gutenberg/pull/53381\">view media previews for Gallery and Image blocks</a>, and <a href=\"https://github.com/WordPress/gutenberg/pull/53559\">duplicate blocks with a keyboard shortcut</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Pattern advancements</h3>\n\n\n\n<p><a href=\"https://wordpress.org/documentation/article/site-editor-patterns/\">Patterns</a><strong> </strong>play an essential role in site editing, and its importance remains prominent in the upcoming release.</p>\n\n\n\n<p>6.4 will allow you to better organize <a href=\"https://github.com/WordPress/gutenberg/pull/53835\">your synced and unsynced patterns with categories</a> as part of the creation process. These categories are available for sorting within the insertion flow to make discovering and adding patterns easier. In addition, you can conveniently access all your custom patterns from the same place—the Patterns section of the Block Inserter, which removes the separate tab for synced patterns.</p>\n\n\n\n<p>Other improvements include <a href=\"https://github.com/WordPress/gutenberg/pull/54337\">importing and exporting patterns as JSON files</a>, ensuring backward compatibility with Reusable blocks, and enabling pattern transfer across sites.</p>\n\n\n\n<p>Lastly, building on the groundwork laid in WordPress 6.3, this release will improve the <a href=\"https://github.com/WordPress/gutenberg/issues/52150\">pattern management experience for non-block themes</a> by adding a <a href=\"https://core.trac.wordpress.org/ticket/58827\">Patterns tab</a> under the Appearance menu, allowing access to the Pattern list page of the admin screen.</p>\n\n\n\n<p><strong><em>Update (October 2, 2023): </em></strong><em>While 6.4 will bring several exciting pattern advancements, the previously mentioned improved pattern management experience for non-block themes will regrettably not be included in the 6.4 release. Thank you for your understanding, and be on the lookout for it in WordPress 6.5.</em></p>\n\n\n\n<h3 class=\"wp-block-heading\">Introducing Block Hooks</h3>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/ticket/59313\">Block Hooks</a> is a new powerful feature that enriches the extensibility of block themes, drawing inspiration from the familiar WordPress <a href=\"https://learn.wordpress.org/tutorial/wordpress-filter-hooks/\">Hooks</a> concept. Upon activation, plugins can automatically insert blocks into content relative to another block. For example, a &#8220;Like&#8221; button block can automatically be inserted after the Post Content block.</p>\n\n\n\n<p>While developer-centric, Block Hooks enhances the user experience by making block usage more intuitive and allowing for further customization and control over where and how the auto-inserted blocks appear. A <a href=\"https://github.com/WordPress/gutenberg/pull/52969\">new block inspector panel</a> named &#8220;Plugins&#8221; is designed to respect creators&#8217; preferences, ensuring you can add, dismiss, or relocate Block Hooks as desired.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Accessibility</h3>\n\n\n\n<p>WordPress 6.4 has 70 accessibility improvements slated for inclusion, 60 of those are included in Beta 1. Notable updates focused on enhancing the user interface (UI) experience include <a href=\"https://core.trac.wordpress.org/ticket/40822\">better button placements</a>, <a href=\"https://core.trac.wordpress.org/ticket/47125\">improved context for “Add New” admin menu items</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58573\">upgraded spoken messages in Site Health</a>.</p>\n\n\n\n<p>Additionally, fixes for <a href=\"https://core.trac.wordpress.org/ticket/58756\">image editing in the Media Library</a>, <a href=\"https://core.trac.wordpress.org/ticket/30685\">error reporting on the login screen</a>, and <a href=\"https://core.trac.wordpress.org/ticket/58756\">&#8220;no motion&#8221; settings for GIFs</a> have been implemented. The cause of some <a href=\"https://core.trac.wordpress.org/ticket/58703\">false positives in automated UI tests</a> has been corrected, and users without JavaScript now see a <a href=\"https://core.trac.wordpress.org/ticket/59229\">direct link to install the Classic Editor plugin</a>. Learn more about these changes and other accessibility improvements for 6.4 on <a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&milestone=6.4&col=id&col=summary&col=status&col=milestone&col=owner&col=type&col=priority&order=priority\">WordPress Trac</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performance</h3>\n\n\n\n<p>WordPress 6.4 will include more than 100 performance-related updates, including <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&component=Themes&milestone=6.4\">improvements to template loading performance</a> for Block Themes and Classic Themes, <a href=\"https://core.trac.wordpress.org/query?focuses=~javascript+performance&milestone=6.4\">usage of the new script loading strategies “defer” and “async”</a> in core, blocks, and themes, and new functions to optimize the use of <a href=\"https://core.trac.wordpress.org/query?focuses=~performance&component=Options%2C+Meta+APIs&component=Database&milestone=6.4\">autoloaded options</a>.</p>\n\n\n\n<p><strong><em>Please note that features in this list are subject to change before final release.</em></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">A haiku for 6.4</h2>\n\n\n\n<p>Inline fonts, lightbox<br />Command blocks like CLI<br />Almost to 6-4</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\"https://profiles.wordpress.org/meher/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meher</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a>, <a href=\"https://profiles.wordpress.org/meaganhanes/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>meaganhanes</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/annezazu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>annezazu</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/flixos90/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>flixos90</a>, <a href=\"https://profiles.wordpress.org/richtabor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>richtabor</a>,&nbsp; <a href=\"https://profiles.wordpress.org/francina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>francina</a>, <a href=\"https://profiles.wordpress.org/joedolson/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joedolson</a>, <a href=\"https://profiles.wordpress.org/priethor/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>priethor</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>davidbaumwald</a></em>, <em><a href=\"https://profiles.wordpress.org/chanthaboune/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chanthaboune</a>, <a href=\"https://profiles.wordpress.org/luminuu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>luminuu</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Sep 2023 20:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Reyes Martínez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: A 3m x 3m Grid Planet Wide Geocoding System with Phoebe and Jash\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76597\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://dothewoo.io/phoebe-and-jash-what3words/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"<p>what3words, a unique geocoding system that represents any location on our planet, divided into 3 x 3 meter grid, and identified by three words.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/phoebe-and-jash-what3words/\">A 3m x 3m Grid Planet Wide Geocoding System with Phoebe and Jash</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Sep 2023 08:23:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Matthaus Klute Acquires Social Link Pages Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149460\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/matthaus-klute-acquires-social-link-pages-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7042:\"<p>WordPress developer <a href=\"https://gelform.com/\">Corey Maass</a> has sold his <a href=\"https://wordpress.org/plugins/social-link-pages/\">Social Link Pages</a> plugin to Matthaus Klute, an independent WordPress consultant and developer with Alpha Particle. It&#8217;s another story of small plugins changing hands, where developers get the opportunity to test ideas and business models. Even the most modest creations have value in a thriving marketplace where business owners are willing to invest in these types of assets to expand their own offerings.</p>\n\n\n\n<p>In 2019, Maass created Social Link Pages after taking a course on how to market himself as a musician and DJ. The course required him to sign up for <a rel=\"noreferrer noopener\" href=\"http://linktr.ee/\" target=\"_blank\">Linktr.ee</a>, a popular &#8220;link in bio&#8221; landing page service.</p>\n\n\n\n<p>&#8220;In typical developer fashion, instead of paying $8 a month, I thought &#8216;I should build this,\'&#8221; Maass said. &#8220;So I spent hundreds of hours building Social Link Pages for WordPress.&#8221;</p>\n\n\n\n<p>Initially, Maass built the free version with most of the basic bells and whistles found in other link-in-bio page builders. After getting some pushback from the Plugin Review team, who Maass said were &#8220;skeptical about why we needed a &#8216;mini WordPress inside WordPress,&#8217; the Social Link Pages plugin was approved for the directory.</p>\n\n\n\n<p>Over the next year he added features that he needed while figuring out the right extras for a Pro version. </p>\n\n\n\n<p>&#8220;Along the way, a user contacted me, asking if the plug-in could be white-labeled and used to build her own SaaS,&#8221; Maass said. &#8220;Shortly thereafter I released the Pro and Community (i.e. SaaS) versions of the plugin.</p>\n\n\n\n<p>&#8220;Then I took a day job and stopped working on it for about a year and a half. I took the commercial versions offline. I barely looked at the plugin because there were almost no support requests.&#8221;</p>\n\n\n\n<p>When Maass&#8217; day job ended 18 months later, he went back to the plugin and was pleasantly surprised to find it had 1,000 active installs. This encouraged him to make some major updates and add new features.</p>\n\n\n\n<p>The first marketing effort he made was to put Social Link Pages on AppSumo. At that time they were just opening up their marketplace.</p>\n\n\n\n<p>&#8220;In the marketplace, you don&#8217;t benefit from AppSumo&#8217;s larger email campaigns, but I think Social Link Pages got a lot of eyes from people looking for good lifetime deals,&#8221; Maass said. &#8220;I sold about 80-lifetime licenses and was surprised to find that only two or three were ever actually claimed. I&#8217;ve since heard of other plugin developers who have had the same experience. Apparently, a lot of people collect lifetime deals, but never actually use them. So in the end it was free money.&#8221;</p>\n\n\n\n<p>Over the next few years, Maass continued to add features but his interest was waning. </p>\n\n\n\n<p>&#8220;The plugin did what I needed on my own sites, so I was not inspired to keep adding features just because I could,&#8221; he said. &#8220;I also saw a lot of new link-in-bio apps come online, though none were specific to WordPress. And I wanted to move on to new ideas.&#8221;</p>\n\n\n\n<p>At the beginning of 2023, while considering all of his projects, Maass said he &#8220;could not find the willpower to market Social Link Pages as it should be.&#8221; He knew he was no longer the best owner for the plugin, so he listed it on a couple of sites dedicated to selling small software products.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Social Links Plugin Sells for $3K</h2>\n\n\n\n<p>&#8220;I&#8217;d always heard the correct pricing for a software product is 12-18 months of revenue,&#8221; Maass said. &#8220;Social Link Pages was only making about $125 per month at the time, but I was selling a complete business, already set up with e-commerce, multiple products, email automation, and more.</p>\n\n\n\n<p>&#8220;I listed it at $5000. I heard from a dozen or so potential buyers, all of whom asked for charts and spreadsheets I did not have. I&#8217;m a developer and guilty of ignoring a lot of the standard sales and &#8216;biz dev&#8217; practices. As I was asking too much based on what was &#8216;on paper,&#8217; I did not find a buyer. I unlisted Social Link Pages, figuring I&#8217;d try again in the future.&#8221;</p>\n\n\n\n<p>Maass tried again in the summer, listing the plugin in Post Status and a couple of other solopreneur-focused communities. He also dropped the price to $3,000. </p>\n\n\n\n<p>&#8220;Immediately I heard from a number of interested buyers who saw the value in what I was selling,&#8221; Maass said.&#8221; I probably could&#8217;ve brought the price back up to $5000 again, but I wanted to see the plugin go to a new, better owner.&#8221;</p>\n\n\n\n<p>Two years ago, <a href=\"https://wptavern.com/alpha-particle-and-flowspoke-acquire-kanban-for-wordpress-for-15k\">Maass sold his Kanban for WordPress plugin to Keanan Koppenhaver</a> at Alpha Particle. After discussing with Matthaus Klute, a developer who works with Koppenhaver, Maass knew he had found the right buyer. </p>\n\n\n\n<p>&#8220;He&#8217;s a thoughtful developer with WordPress experience interested in building a product business,&#8221; Maass said. &#8220;We met up in person at WordCamp US in DC in August 2023, and spent a few hours moving all accounts to his name and getting him set up. It was a fun experience to do in person.&#8221;</p>\n\n\n\n<p>Klute said Maass came to him highly recommended from others who had purchased plugins from him in the past. After he spoke with his lawyer, they proceeded to do an in-person asset transfer at WordCamp US (WCUS).</p>\n\n\n\n<p>&#8220;I wasn’t actively shopping for a plugin, however I’ve always had a passing interest in asset and/or small businesses acquisitions,&#8221; Klute said. &#8220;Corey&#8217;s plugin caught my attention for several reasons. It fit well within my budget, boasted an active user base, and generated consistent recurring revenue.  </p>\n\n\n\n<p>&#8220;With my 9 -5 spent coding, the prospect of having an existing solution that I could focus on marketing rather than building was enticing. Lastly, I wanted to gain a deeper understanding of the plugin ecosystem.&#8221;</p>\n\n\n\n<p>Klute said Maass&#8217;s experience played a crucial role in ensuring a smooth transfer. He had all the plugin&#8217;s accounts and services separated from his other entities, making it easily transferable. While at WCUS, they conducted a few Zoom sessions to explore the plugin&#8217;s codebase in-depth.</p>\n\n\n\n<p>&#8220;Despite the focus on marketing, I do have a few ideas for the plugin roadmap,&#8221; Klute said. &#8220;I&#8217;m looking at the possibility of a digital business card functionality similar to Blinq and also exploring ways to enhance the plugin’s compatibility with WooCommerce for my dynamic shop functionality for e-commerce businesses.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 25 Sep 2023 17:44:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Gutenberg Times: Hallway Hangouts Galore, Recipes in the Block Cook Book, Default Theme and much more—Weekend Edition #269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=25652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://gutenbergtimes.com/hallway-hangouts-galore-recipes-in-the-block-cook-book-default-theme-and-much-more-weekend-edition-269/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:18934:\"<p>Howdy, </p>\n\n\n\n<p>We are running towards WordPress 6.4 Beta 1! Gutenberg 16.7 RC candidate was released this week.  What are you most excited about for this major WordPress release? For me, it&#8217;s the Block Hooks that allow you to auto-insert blocks and the font library it empowers users to manage local fonts for their site that are independent of the design of the theme. </p>\n\n\n\n<p>The best way to learn how all the new features with WordPress 6.4 work is to follow along with the 26th Call for Testing coming out of the FSE Outreach program: <a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\"><strong>FSE Program Testing Call #26: Final touches</strong></a> by Anne McCarthy. </p>\n\n\n\n<p><strong>Congratulations</strong> to the <strong><a href=\"https://wordpress.org/news/2023/09/openverse-wins-the-2023-oeg-open-infrastructure-award/\">team of Openverse for winning the Open Infrastructure Award!</a> </strong>Many of our featured images originate at the directory of Creative Commons licensed assets. Did you know that you can search the directory directly from your image block? Try it out. </p>\n\n\n\n<p>And as always, there are more updates in this edition. Enjoy! </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#1-word-press-6-4\">WordPress 6.4</a></li><li><a href=\"https://gutenbergtimes.com/feed/#1-gutenberg-16-7\">Gutenberg 16.7 RC </a></li></ul></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#4-new-tutorials-on-learn-word-press\">New tutorials on Learn.WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</a><ul><li><a href=\"https://gutenbergtimes.com/feed/#5-🗓️-save-the-date\">🗓️ Save the date: Hallway Hangouts Galore</a></li></ul></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>Next week is release week! WordPress 6.4 Beta 1 will be released on Tuesday, September 26th, and Gutenberg 16.7 on September 17th, 2023. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"1-word-press-6-4\">WordPress 6.4</h3>\n\n\n\n<p>Apart from the gazillion &#8216;quality of life&#8217; improvements of site editor, writing flow, list view and blocks, there are four big features coming to 6.4:  The Font Library and Management, Block Hooks, user added categories for Patterns and the image Lightbox feature </p>\n\n\n\n<ul>\n<li><a target=\"_blank\" href=\"https://github.com/WordPress/gutenberg/issues/54169\" rel=\"noreferrer noopener\">Font Library</a></li>\n\n\n\n<li><a target=\"_blank\" href=\"https://github.com/WordPress/gutenberg/issues/51132\" rel=\"noreferrer noopener\">Image Lightbox</a></li>\n\n\n\n<li><a target=\"_blank\" href=\"https://github.com/WordPress/gutenberg/issues/53987\" rel=\"noreferrer noopener\">Block Hooks</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/53164\" target=\"_blank\" rel=\"noreferrer noopener\">Pattern categories</a></li>\n</ul>\n\n\n\n<p>As mentioned above, <strong>Anne McCarthy</strong> published <a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\"><strong>FSE Program Testing Call #26: Final touches</strong></a>. The instructions lead you through the array of new features for WordPress 6.4: You get to learn how to manage fonts, get your side organized using the Command Palette and rename Group blocks. Then you are asked to create a new Pattern and finish a Portfolio page. You also get to swap out patterns, and handle the display of a like button. It&#8217;s a fun call for testing for sure and the deadline for feedback is October 9th, 2023. </p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"1-gutenberg-16-7\">Gutenberg 16.7 RC </h3>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v16.7.0-rc.1\"><strong>Gutenberg 16.7 Release candidate </strong></a>is now available for testing. It&#8217;s the last release before WordPress 6.4 Beta 1 and all new things should be already in there, except for three features, Lightbox for image blocks, Block Hooks and Font Library. Additional refinements will be made in upcoming Gutenberg releases that will be synchronized with the WordPress 6.4 release cycle all through the Beta period. </p>\n\n\n\n<p>Gutenberg 16.7 has a whooping 290 PRs merged. When you consider that there has been an additional week to merge new code, it maybe isn&#8217;t so much. But of course, the changelog is again a mile long. <strong>Sarah Norris</strong> handled the release as part of the Editor Tech lead role on the underrepresented led WordPress 6.4 release. </p>\n\n\n\n<p><strong>Tammie Lister</strong> is Norris&#8217; co-lead and joined me again for this week&#8217;s Gutenberg Changelog recording. We discussed the most important PRs during the recording of the <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">90th episode of the Gutenberg Changelog</a> podcast on Thursday. The episode will arrive at your favorite podcast app over the weekend. We also discussed the features that will make it into WordPress 6.4 and what we are excited about. </p>\n\n\n\n<img width=\"652\" height=\"198\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/Screenshot-2023-09-21-at-13.43.00.png?resize=652%2C198&ssl=1\" alt=\"Tammie Lister and Birgit Pauli-Haack recording Gutenberg Changelog 90 \" class=\"wp-image-25710\" />\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p class=\"is-style-no-vertical-margin\"><strong>🎙️ </strong> Latest episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\">Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</a> with Tammie Lister as special guest, hosted by Birgit Pauli-Haack</p>\n</div></div>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Nick Diego</strong> announced <a href=\"https://blockvisibilitywp.com/block-visibility-3-1-0-introducing-woocommerce-and-edd-controls/\"><strong>Block Visibility 3.1.0: Introducing WooCommerce and EDD controls</strong></a>, after improving the WooCommerce and EDD integrations for  sites with large product/download catalogs. Diego mentioned a notable change to the product-based rules. &#8220;Previously, you had to select which product you wanted to target with the visibility conditions. While this is still possible, Block Visibility can now detect the current product.&#8221; he wrote. </p>\n\n\n\n<p>With this version, the migration from Pro features to the free version is complete. Once you update to 3.1.x it&#8217;s safe to deactivate and uninstall the Pro edition. The <a href=\"https://github.com/ndiego/block-visibility/releases/tag/v3.1.0\">complete changelog is available on GitHub</a></p>\n\n\n\n<p><strong>Sarah Gooding</strong> has a <a href=\"https://wptavern.com/block-visibility-3-1-0-adds-woocommerce-and-easy-digital-downloads-controls\">reported on the plugin update</a> for the WPTavern, too. </p>\n\n\n\n<img width=\"652\" height=\"341\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/detect-current-product-example-1024x535.png?resize=652%2C341&ssl=1\" alt=\"\" class=\"wp-image-25708\" />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jamie Marsland</strong> interviewed <strong>Mike McAliste</strong>r creator of the <a href=\"https://olliewp.com/\">Ollie theme</a> on <a href=\"https://www.pootlepress.com/2023/09/wordpress-block-themes-versus-classic-themes/\"><strong>Will WordPress Block Themes ever be as popular as Classic Themes?</strong></a> They discussed some reasons for a seemingly slow adoption of block themes. <br /></p>\n\n\n\n<p>Right on cue, <strong>Fränk Klein</strong> <a href=\"https://twitter.com/bph/status/1705873655782092955\">tweeted </a>about the key benefit of Block Themes and Full site editing: Interoperability. </p>\n\n\n\n<ul>\n<li>Content written with blocks is stored as HTML. So you can transfer it to another CMS. </li>\n\n\n\n<li>Plugins that use blocks work with all block themes. Without needing an extra compatibility layer. </li>\n\n\n\n<li>These plugin blocks, if written the right way, inherit theme styles. </li>\n\n\n\n<li>And in the near future patterns (previously called reusable blocks) will be portable between themes. </li>\n\n\n\n<li>There is no page builder, theme framework, or metabox plugin that can do the same.</li>\n</ul>\n\n\n\n<p class=\"has-light-background-background-color has-background\"><strong>What do you think are the biggest hurdles for you</strong>? Hit reply on the email or share in the comments here. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"4-new-tutorials-on-learn-word-press\">New tutorials on Learn.WordPress</h2>\n\n\n\n<p>The WordPress Training team released new tutorials for WordPress users: <br /></p>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/intro-to-the-site-editor-and-template-editor/\">Intro to the Site Editor</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/scheduling-posts-and-pages/\">Scheduling posts and pages</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/creating-your-own-custom-synced-or-non-synced-patterns/\">Creating your own custom synced or non-synced patterns</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p>The new default theme: <strong>Twenty-Twenty-Four</strong> is progressing fast, too. You can follow along via the demo site, the Slack channel, the GitHub repo and via the meeting notes:  </p>\n\n\n\n<ul>\n<li>Demo Site on <a href=\"https://2024.wordpress.net/\"><strong>2024.wordpress.net/</strong></a></li>\n\n\n\n<li>Meeting in <a href=\"https://wordpress.slack.com/archives/C02RP4VMP\">#core-themes </a>channel</li>\n\n\n\n<li>GitHub Repo: T<a href=\"https://github.com/WordPress/twentytwentyfour\">wentyTwentyFour</a></li>\n\n\n\n<li>Meeting notes on Make Core blog: <a href=\"https://make.wordpress.org/core/tag/twenty-twenty-four/\">#twentytwentyfour</a></li>\n</ul>\n\n\n\n<a href=\"http://2024.wordpress.net/index.php/patterns/\"><img width=\"652\" height=\"439\" src=\"https://i0.wp.com/gutenbergtimes.com/wp-content/uploads/2023/09/twenty-twenty-four-full-page-patterns.jpg?resize=652%2C439&ssl=1\" alt=\"\" class=\"wp-image-25745\" /></a>Screenshot Demo Site <a href=\"http://2024.wordpress.net/index.php/patterns/\">Full-Page Patterns</a>\n\n\n\n\n<p><strong> <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a> </strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor</h2>\n\n\n\n<p><strong>Matthias Hunt </strong>and <strong>Michelle Schlup</strong> released their VS Code <a href=\"https://marketplace.visualstudio.com/items?itemName=matthiashunt.wordpress-syntax-highlighter\"><strong>WordPress Syntax Highlighter</strong></a>. This extension provides syntax highlighting for the following WordPress syntaxes that exist inside traditional comment blocks:</p>\n\n\n\n<ul>\n<li>Plugin header fields (PHP)</li>\n\n\n\n<li>Block pattern fields (PHP)</li>\n\n\n\n<li>Theme header fields (style.css)</li>\n\n\n\n<li>Block markup (HTML + JSON)</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong> started a series of twitch streams working on <strong>Block Developer Cookbook</strong> recipes. The first few broadcasts are now available on YouTube: </p>\n\n\n\n<ul>\n<li>🧑‍🍳 <a href=\"https://www.youtube.com/watch?v=YpOIO1V0KlM\"><strong>Block Level Validation</strong></a> &#8211;  How to create block level checks to ensure that button blocks have text in them before the post can be published. </li>\n\n\n\n<li>🧑‍🍳 <a href=\"https://www.youtube.com/watch?v=MtVRifFbUaQ\"><strong>Connecting to Post Meta</strong></a> &#8211; How to create a block that can read from and write back to WordPress custom post meta. </li>\n\n\n\n<li>🧑‍🍳 <a href=\"https://www.twitch.tv/videos/1931306774\"><strong>Block Variations</strong></a> is the latest in the series, streamed last Thursday and is only available on Twitch</li>\n</ul>\n\n\n\n<p><em>Every Thursday at 10:30 ET / 14:30  UTC Ryan Welcher goes online on Twitch with live programming sessions. </em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<h3 class=\"wp-block-heading\" id=\"5-🗓️-save-the-date\">🗓️ Save the date: Hallway Hangouts Galore</h3>\n\n\n\n<p><strong>September 27th, 2023 at 14:00 UTC</strong> <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/295482707/\"><strong>Developer Hours: Building better blocks with the &#8216;create-block&#8217; package</strong></a>.  Ryan Welcher and Nick Diego will be diving deep into the functionalities of the <a href=\"https://developer.wordpress.org/block-editor/reference-guides/packages/packages-create-block/#available-commands\" target=\"_blank\" rel=\"noreferrer noopener\">create-block</a> package. Developed to simplify and accelerate the process of building custom WordPress blocks, this package has become an indispensable tool for developers of all levels.</p>\n\n\n\n<p><em><strong>WordPress Developer Hours</strong> are held regularly on the last Wednesday of each month</em> <em>(except October 2023)</em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Thursday, October 12, 2023,</strong> <strong>at 18:00 UTC</strong> <a href=\"https://make.wordpress.org/core/2023/09/14/hallway-hangout-whats-new-for-developers-in-wordpress-6-4/\"><strong>Hallway Hangout: What’s new for developers in WordPress 6.4</strong></a> Justin Tadlock, Ryan Welcher and Nick Diego  will host a casual conversation about the most important and exciting developer-related changes coming soon in WordPress 6.4. From Block Hooks and the Font Library to improved Editor flows and the new Twenty Twenty-Four theme, there is just so much to talk about.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Thursday, October 19, 2023, at 15:00 UTC <a href=\"https://make.wordpress.org/core/2023/09/18/hallway-hangout-performance-improvements-for-wordpress-6-4/\">Hallway Hangout: Performance Improvements for WordPress 6.4</a></strong> The hosts <strong>Emily Clark</strong>, <strong>Joe McGil</strong>l and <strong>Felix Arntz</strong> will go through quick intros (what each person does/focuses on) before reviewing WordPress 6.3 performance impact in the field, diving into WordPress 6.4 performance improvements and looking ahead at what can be learned for WordPress 6.5. </p>\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: &#8220;<a href=\"https://www.flickr.com/photos/8455331@N08/35088954290\" target=\"_blank\" rel=\"noreferrer noopener\">Moveable type used on Hawaii&#8217;s first printing printing press at the Hale Pa&#8217;i Printing Museum at Lahainaluna</a>&#8221; by <a href=\"https://www.flickr.com/photos/8455331@N08\" target=\"_blank\" rel=\"noreferrer noopener\">Kanalu Chock</a> is licensed under <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/?ref=openverse\" target=\"_blank\" rel=\"noreferrer noopener\">CC BY-NC-SA 2.0</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Sep 2023 11:30:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"Gutenberg Times: Gutenberg Changelog #90 – New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=25736\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-90-new-testing-call-for-the-fse-program-gutenberg-16-7-and-wordpress-6-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:62664:\"<p>Tammie Lister and Birgit Pauli-Haack discuss the New Testing Call for the FSE Program, Gutenberg 16.7 and WordPress 6.4</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\" id=\"shownotes\"><strong>Show Notes</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Announcements</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2023/09/12/core-editor-improvement-commanding-the-command-palette/\">Core Editor Improvement: Commanding the Command Palette</a></p>\n\n\n\n<p><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></p>\n\n\n\n<p><strong>Training Team</strong></p>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/intro-to-the-site-editor-and-template-editor/\">Intro to the Site Editor</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/scheduling-posts-and-pages/\">Scheduling posts and pages</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/creating-your-own-custom-synced-or-non-synced-patterns/\">Creating your own custom synced or non-synced patterns</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/the-wordpress-database/\">The WordPress Database</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contributions</h2>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2023/09/understanding-block-attributes/\">Understanding block attributes</a> by Michael Burridge</p>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/2023/09/whats-new-for-developers-september-2023/\">What’s new for developers? (September 2023)</a> by Justin Tadlock and Birgit Pauli-Haack</p>\n\n\n\n<p>Learn more how to contribute to the Developer Blog</p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/how-to-contribute/\">How to contribute</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/tips-and-guidelines-for-writers/\">Tips and guidelines for writers</a></li>\n</ul>\n\n\n\n<p><strong>What&#8217;s released: </strong></p>\n\n\n\n<p><a href=\"https://github.com/WordPress/gutenberg/releases/tag/v16.7.0-rc.1\"><strong>Gutenberg 16.7.0 RC 1</strong></a></p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/call-for-testing-of-the-new-font-library/\">Call for testing of the new Font Library</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s being worked on and discussed? </h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-4/\">Underrepresented gender led WordPress 6.4</a></p>\n\n\n\n<p><a href=\"https://github.com/orgs/WordPress/projects/127/views/1\">Project Board of Editor Tasks for WordPress 6.4</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\" id=\"transcript\"><strong>Transcript</strong></p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello and welcome to our 90th episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about the new testing call for the FSE program, Gutenberg 16.7 and WordPress 6.4 of course. And I&#8217;m your host Birgit Pauli-Haack, curator at the Gutenberg Times and full-time core contributor for the WordPress Open Source project sponsored by Automattic&#8217;s Five for the Future program. My special guest today again is Tammie Lister and she and I are working on the WordPress 6.4 underrepresented gender release team and she is the co-lead of the editor tech teams. She also works as a developer at Inpsyde and started our new writing project. You will hear about it maybe in a moment. So welcome to the show Tammie. How are you and have you recovered from the last WordCamp?</p>\n\n\n\n<p><em>Tammie Lister</em>: Yeah, I&#8217;m doing really well. Yes, I had the pleasure of going to WordCamp with Lee Bay on Monday, a couple of days ago now. It was really nice. It was a small WordCamp at a tiny little beach place up in the northeast of England and it was a real pleasure to go there and talk about Gutenberg as a product. And you mentioned my new writing project. Yes. I&#8217;m just writing about how do all the various parts and patterns, templates, it&#8217;s at presselements.com kind of come together design system with surprise thinking. So I&#8217;m doing really well. Thank you for having me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh yeah, well the WordCamp sounds lovely in the last summer days in a bay.</p>\n\n\n\n<p><em>Tammie Lister</em>: Yeah, it was lovely to just be at a single track was I think I&#8217;m correcting saying the first WordCamp since the events of the past few years for my country&#8217;s community. And it was really nice to just get together and just all be there. And there&#8217;s something about those small WordCamps that are really nice to have those conversations. At the end of it, everyone can go to the same restaurant and then kind of relax down, and it was a real pleasure to just listen to it everyone&#8217;s talks and just learn how everyone was using Gutenberg and what everyone was creating. I got to see what agencies were creating and what they were doing as well, which was really fascinating.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I like the small WordCamps too. In July, I was in Leipzig, which is also very small one-track camp and it was a very good, I felt very welcome in the German community because I had just moved to Germany and it was the first time at the German WordCamp so it was lovely and we had some great conversations.</p>\n\n\n\n<p><em>Tammie Lister</em>: You get to do those long lunches and just the pace seems, you&#8217;re not to kind of chasing to go and see everybody because there&#8217;s so many people in this space. You can actually have the conversations with everybody in the room and it was really nice.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And you don&#8217;t have to make a decision on which session you&#8217;re going to now it&#8217;s just one track.</p>\n\n\n\n<p><em>Tammie Lister</em>: No, yeah, and it was super nice being by the sea so you could look out of the window and go by the sea and yeah, that was kind of nice.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Announcements</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, nice, nice. So we have a few announcements to make. So one of the more hidden features that were part of the WordPress 6.3 release was the command palette and that can be invoked within the site editor and now also with the post editor using control or command K. And it gives you a quick access to various tasks and settings throughout the space and you don&#8217;t have to hunt down the third level menu item to get to places where you needed to go.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">FSE Program Testing Call #26: Final Touches</h3>\n\n\n\n<p>And Anne McCarthy has published a great article on the Core Editor Improvement series, Commanding the Command Palette. So if you haven&#8217;t explored that yet, you definitely want to read that. And of course we show the links in the show notes and really it&#8217;s, well first of all the post editor I think is only coming with a 6.4. 6.3 was only with a site editor. But it&#8217;s such a lovely improvement if you are a power user you can get to places very, very fast. Have you tried it?</p>\n\n\n\n<p><em>Tammie Lister</em>: Yeah, personally the command palette I think is going to be really powerful going forward, but I don&#8217;t think people are quite using it yet. So what I love is that we are creating more documentation and that we are starting to really show these articles and use cases because in the conversations I&#8217;ve had with people there, curious but don&#8217;t quite know yet how to utilize it, I absolutely have tried it but I&#8217;m also trying to find out how do I start to use this and where do I start to do it? So the more articles that we have on how to extend it, the more happy I am and I think we&#8217;re going to get to the massive docs stuff data. So I&#8217;m really excited how all these features we start having things like that as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, and if you want to really get into the what&#8217;s coming to WordPress 6.4, I really would recommend that you follow Anne McCarthy&#8217;s call for testing on the final touches because the instructions lead you all through the area of the features of 6.4. Among them, the command palette but also the group block and the new pattern. And you get to learn how to manage the fonts of course the big new feature and how to swap up patterns and templates and display like button on the portfolio page. And it&#8217;s a fun call for testing and make sure that you get your feedback in before October 8th. So all the feedback that you get in can be fixed in beta and release candidate for 6.4. So it&#8217;s kind of both. It&#8217;s a training on the 6.4 features but it&#8217;s also a kind of have more people find the bugs before we release. So I really hope you can make it and go through it.</p>\n\n\n\n<p><em>Tammie Lister</em>: And that&#8217;s been one of the biggest comments from the phone library to the command palette that I&#8217;ve heard from people is where do I go for all this information? So having these hallway Hangouts to these posts I think is really essential. The moment I show someone one of these posts, their little eyes light up and they&#8217;re like, oh, I can go to one place and I can then follow these information.</p>\n\n\n\n<p>Hallway hangouts are great for that as well for people where they can just go and then they can see a summary of links and they can just wander around without having to scour or use search, search inputs it really difficult to know to collect that information and not everybody can ask everybody and some people just want to at their own pace, discover these things. So again, that kind of goes back to finding that information. If you are in a release, you&#8217;re going to know I&#8217;m trying fonts because I&#8217;m in the release and it&#8217;s going to come up. I&#8217;m trying this because it&#8217;s in a release and it&#8217;s going to come out, but I&#8217;m not trying the things that aren&#8217;t in the release because I&#8217;m focusing on the release.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, we will share. Anne McCarthy also did a hallway hangout and going through the roadmap and just briefly said, &#8220;Okay, this made it, this didn&#8217;t make it, this made it.&#8221; And demo some of that as well if you don&#8217;t want to go through the call of testing. So I&#8217;m going to share that as well in the share notes. No show notes. Well share notes could be too. Right. And then a big shout-out also to the WordPress training team. They&#8217;re quite a productive bunch and their newest tutorials were, they&#8217;re not yet for the release of course because they don&#8217;t have all the information yet, but there&#8217;s an intro into the site editor. So if you haven&#8217;t gone and used those features, there&#8217;s a short intro. There&#8217;s also for those new to WordPress and how to schedule posts or pages. And one is also how to create your own synced or non-synced patterns.</p>\n\n\n\n<p>Now that you can do it on WordPress patterns are really a great way to streamline your processes but also to help standardize your site production when you work within a team. And then last but not least, for this round of shout-outs, the WordPress database. And that&#8217;s a dive into, if you ever want to customize some of the WordPress, you need to know how the database is structured, how you can access it, how you can do all the edits, updates and deletes and what the actions and filters are. So this is, it&#8217;s a short intro but it&#8217;s really powerful so don&#8217;t forget to go to the <a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a> site to pick out all the tutorials that you need. But these are the four new ones from September, no, August. Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: I think those are great. Someone could just be joining today and they turn up and they&#8217;re like what synced or non-synced? And we use language that we presume people know what they mean. I do all the time. So always. Yeah, it&#8217;s so good that we are actually correcting that by having these information resources.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And they mix the production of those resources between someone who has been in the community for a long time and just needs a new feature. And those who came in yesterday and need to know, okay, how to create your website, what&#8217;s the site? So it&#8217;s so important to have these resources.</p>\n\n\n\n<p><em>Tammie Lister</em>: And there&#8217;s a lot of people who have a lot of knowledge on creating, if you are talking either not just an end user, but you&#8217;re also talking about someone who&#8217;s a developer. They may have used different systems and they may use the terminology synced or non-synced, completely different to how we use synced or non synced. So coming into our space and then we, because do use, we are adorable, but we do use terms in a very specific WordPress way for certain things. So having some clarity I think is great, because you never know what is your source of truth for a lot of these things. So I am so pleased to find this information.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Community Contributions</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And we just talked about this, that the new WordPress Developer Blog, which has only been happening for the last nine months is not so known in the community. And I just want to give a shout-out to Michael Burridge. He posted a great tutorial for beginners on understanding block attributes, beginners being block development beginners, and there is more to block attributes that meets the eye and attributes contain data needed for your block or the data can be retrieved in multiple ways. And in this he walks you through a progressive kind of complexity way from the anatomy of a simple block to sources and selectors and HTML attributes and also how to use a query as the source of those attributes. And there were actually some great comments from block developers. One was, &#8220;I&#8217;ve been creating blocks since 5.0 and this is the first time that I actually understood how the query works. Thanks, man.&#8221; And then another one, &#8220;I always struggled with using HTML attributes as a source and this makes it so clear.&#8221; So it&#8217;s definitely a post to look through even if you&#8217;re an experienced block developer.</p>\n\n\n\n<p><em>Tammie Lister</em>: I just adore this because really to me it does come back down to the visibility and in the olden days it was go to Make Core. It really, Make Core is not, it&#8217;s great, but it&#8217;s an information resource, and the Developer Blog is really where you are safe to, maybe it&#8217;s me, but I don&#8217;t think it is. You&#8217;re safe to Instapaper, you get your highlighter, your digital highlighter pen out and you sit down and you learn. And that&#8217;s what this is becoming. So when I&#8217;m talking to someone at a WordCamp, when I&#8217;m talking to somewhere, one of my first conversations with a developer is going to be, Hey, are you following this blog? Because this is just as if you&#8217;re following React or you&#8217;re following whatever your flavor of awesome that you&#8217;re creating with because everybody has their own pet scripts that they create with.</p>\n\n\n\n<p>It&#8217;s like sports teams, are you following this? Because we always used to say, are you following Make Core if you are a developer, are you following Make Design? If you&#8217;re a designer. This should be on those lists of are you following this? I don&#8217;t actually just think developers. I think even if you are slightly interested in what&#8217;s going on because, and I think this is worth saying the scale of what has been put there, and this might be something to look at in the future is having a, you need to know because I think sometimes knowing what you need to know is curious on here and a lot of people are presumed knowledge. So that&#8217;s something as we&#8217;re kind of doing this, some people have incredible knowledge in PHP, but not the knowledge in JavaScript quite yet. And that&#8217;s great because this blog can give them that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: In multiple ways and also to keep up with what&#8217;s changing because Core and Gutenberg reapers are changing so much.</p>\n\n\n\n<p><em>Tammie Lister</em>: Theme Jsons, block Jsons, if you were making blocks before and then you went for two years to do something like life and then you came back the way the blocks are done now or the way that themes are done now, completely different from the way that they were being done.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, that&#8217;s true. And there&#8217;s one roundup post on the Developer Blog that&#8217;s come out every month and Justin Tadlock just posted the one from September and it&#8217;s a monthly roundup post for WordPress developers working on plugins, themes, and agencies. And this edition has about 20-plus short updates that gives you an overview what&#8217;s released, what&#8217;s about to come out in future releases. And also for both the front end as well as backend, sometimes I use that distinction between Gutenberg and Core to make it more one thing.</p>\n\n\n\n<p>And the monthly publishing frequency is actually more digestible, even if it&#8217;s 20 plus items. But you can decide, they are divided up into highlights and plugin and theme developers. So you only have to, if you&#8217;re a plugin developer, just do the 10 items from the plugin section, but it&#8217;s more or less digestible than the three times a year field guide that comes with, I don&#8217;t know, tons of updates that are, you never know from the one-liners if it&#8217;s really important to you personally or is it just something you can ignore and it&#8217;s really hard to keep track of it. So it&#8217;d always be published on the 10th of the month and we are working on the October edition. And it comes out October 10th.</p>\n\n\n\n<p><em>Tammie Lister</em>: It&#8217;s a random suggestion, but this is not, I would love to see behind the scenes of the default being there or behind the scenes of releases, I don&#8217;t know, but I would love to see more community developer stuff there. But that happens with eyeballs on the blog. So I think that that happens as it grows. So more people pay attention to the blog and then more people can be there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Right. And if you are a developer and you want to share your journey…</p>\n\n\n\n<p><em>Tammie Lister</em>: There you go.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: &#8230; on certain things, if you go on the WordPress, so it&#8217;s <a href=\"https://developer.wordpress.org/news/\">developer.wordpress.org/news</a> is the address of it. There are two things to contribute to. One is the tips and guidelines for the writers and the reviewers and the other one is how to contribute because it&#8217;s not only the writing part, it&#8217;s also, yeah, we need to organize it. We have editorial group meetings and all that. So this is all kind of laid out in two pages, well pages, they&#8217;re very long pages.</p>\n\n\n\n<p><em>Tammie Lister</em>: I would love to hear more because there&#8217;s so many good stories and so many problems people are solving that they don&#8217;t keep to themselves in a bad way, but they keep themselves, they don&#8217;t have a place to put it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: To put it. Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: And Make Core isn&#8217;t the place. This is the place. So I am so excited we&#8217;re talking about this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Even if your personal blog is not the place because you&#8217;re talking to clients on your personal blog or the agency blog. Yeah, it&#8217;s a place.</p>\n\n\n\n<p><em>Tammie Lister</em>: The personal blog is also sometimes one space and sometimes you might have like, Hey, I did this, I&#8217;d love other opinions about what I did, which is hard to do, but it&#8217;s also good to collaborate and share as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. But it&#8217;s more the exploration on the personal blog where you can collaborate with people, but then the outcome of it could be on the Developer Blog, on the official WordPress Developer Blog. So we have a discussion board on the Gutenberg, I share all those links of course in the show notes in the Developer Blog content repo on GitHub where we have discussions and we talk about those in the monthly meetings. So yeah, kind of hit me up either on Slack, WordPress or there in the meeting or in the channel we have actually a 4-dev-blog blog is the channel for all things Developer Blog. So yeah, come join us.</p>\n\n\n\n<p>Excellent. Well, thanks for the ping here.</p>\n\n\n\n<h3 class=\"wp-block-heading\">What’s Released &#8211; Gutenberg 16.7</h3>\n\n\n\n<p>Yeah, that brings us to our section, what&#8217;s released. And Gutenberg 16.7 had a three-week release cycle. And the change on is again about one and a half miles long with 290 PRs merged. Whoa. So Tammie and I, we have our work cut out today going over the most relevant parts. So Sarah Norris, your co-editor, tech lead, managed the release in preparation on the WordPress beta release that comes on Tuesday, September 26th, 2023. And 290 PRS, 72 of those are bug fixes, so it&#8217;s a really great release with some fixes as well.</p>\n\n\n\n<p><em>Tammie Lister</em>: Yeah, I think it&#8217;s worth saying that this is 6.4, it&#8217;s coming. We have the beta Tuesday? Always like to check. Calendars are hard and tricky and they see they&#8217;re popping up on my computer. With that, that&#8217;s why it took a little bit of a longer time. But those 72 bug fixes I think are incredibly important. We kind of get into that as well. Often we focus on the things we release, but the things we fixed and made even better and even more stable are incredibly important and this release has been a lot about that. So yeah, getting into that and getting into was Gutenberg for 6.4 is there, what now from Gutenberg? So I&#8217;m excited to dive into this and one day I&#8217;ll turn up and it&#8217;ll be a really short changelog for you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I don&#8217;t know, maybe 16.8 or so. Well let&#8217;s look at the November one because there&#8217;s not a whole lot of people, they&#8217;re all on vacation holiday.</p>\n\n\n\n<p><em>Tammie Lister</em>: But then it opens up again and then everyone&#8217;s like, oh, put all the things in there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Absolutely. Yeah. So tell me, what features are you most excited about for WordPress 6.4 to just derail us a little bit more?</p>\n\n\n\n<p><em>Tammie Lister</em>: I really, it&#8217;s not features, well default theme. I&#8217;ve always loved default themes, which is like, yes, it&#8217;s a Gutenberg, but it&#8217;s a tangent because I think now it showcases what can be done with the editing experience in its current incarnation, if that makes sense. Incarnation is a weird word, but that&#8217;s true. What it should do is showcase, oh goodness, if no one&#8217;s been following along, I&#8217;m very excited to deliver that Christmas present. It shows what you can do and empowers. So that to me is always powerful because you click it and it works for so many people and so many people turn it on from day one. So that and then just the fixing, it&#8217;s not a feature. And then I do absolutely have to say font library mainly because maturity of product, I feel that I always say there&#8217;s a checklist of modern editing experiences like yes, block editor, yes, collaboration, but honestly font management feels pretty standard, font management design, so that is really big. What about you?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I&#8217;m definitely font management, but I&#8217;m excited of all of it, but it&#8217;s the font library, it kind of empowers the user first time that you are not having to rely on a theme to get you the fonts that you want. So you can do a theme selection outside of your favorite fonts and you can find fonts that can be decorative, and you can do a lot more with it as a designer with the site editor now than you could before because you don&#8217;t have to bundle all this, you can just kind of have it in there.</p>\n\n\n\n<p><em>Tammie Lister</em>: We&#8217;re saying it&#8217;s not just that you have to rely on a theme, you also don&#8217;t have to rely on tutorials or plugins or something you might be trusting and it could not be great code. And I don&#8217;t mean to scare people, but the way that sometimes people have implemented fonts have at best not being performant and at worse, not being secure and not being performant and having these ways just helps everything from those angles. And I&#8217;m not going to be super scary, but the more holes we block from a performance and security angle, the better in that. And it just happens that it&#8217;s just better from a user journey perspective as well. Spoiler alert. It&#8217;s always better that someone doesn&#8217;t have to Google how to add a font and then put code. Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And I also like that you can have the fonts stored locally on your site so you don&#8217;t have to go out to third parties and share your YouTube.</p>\n\n\n\n<p><em>Tammie Lister</em>: It encourages good behavior, which I think is really, we kind of started that with the accessibility with the little nudge of like, hey, that&#8217;s not an accessible color combination. Do you really want to do that? And it&#8217;s doing that. It&#8217;s encouraging the best practices and I think the more that we do that, the better. It makes gentle, happy nudges to best practices is the best way.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right, let&#8217;s get into the changelog. So the first feature that I see on the changelog, but it&#8217;s not, is rename root blocks in the editor via a modal. And this is so powerful because it helps you as a site developer or even as a template developer to actually name the things, the sections that your template is for or if you have a long post you can easily see it&#8217;s not only just heading, heading, heading, heading. So you can actually name these things and find your way around much better. It also keeps the name, if you give it a name in the pattern, it keeps the name also there. So I really love that new feature. Yeah, I&#8217;m glad it&#8217;s coming to 6.4.</p>\n\n\n\n<p><em>Tammie Lister</em>: So next we have font library, which you&#8217;ve already discussed I think, but really it&#8217;s a font collection backend and the front end. It seems a small feature but really I think in the importance of this is to do the call for testing again and say that because yes, something getting in but something getting in that has a really thorough call for testing and everybody has got their sticks and gone and tested it with everything and tested it with their existing implementations of fonts. I think is something worth calling because or tested, turning it off because quite a lot of people may have pretty established settings at the moment, so we need to know can you turn it off and particularly an agency setting, can you turn it off? All these kinds of things.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: So knowing how it works in your situation and being empowered to do that is really important.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, absolutely. Every new feature in WordPress comes with an off switch because that&#8217;s some people want…</p>\n\n\n\n<p><em>Tammie Lister</em>: But knowing how to do that now will super educate you for when 6.4 comes out and I think that&#8217;s my biggest reflection from working in that space is learn now at beta what you are going to be turning off going forward. Yes, it&#8217;s going to take you a little while to roll out those new features but it&#8217;s being able to know, and then pivot is really important.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And so for the user that are using the site editor to build themes, so you can upload the font management thing is you upload a font that you first have downloaded and then upload it to a site and then you can select the variance of it and then it will fill up the dropdown boxes for font management for blocks, elements and for even patterns and templates and all that. So it&#8217;s so powerful. It also lets you delete fonts that are already enabled, just delete them and not have your user use them. So it&#8217;s quite a big new environment.&nbsp;</p>\n\n\n\n<p><em>Tammie Lister</em>: Almost want to plug in where someone says, hey, you haven&#8217;t used that for, someone sits with fonts for a certain time, Hey you haven&#8217;t used it for a while. I&#8217;m sure someone&#8217;s going to create that. Would you like to remove it? Because you know humans, I&#8217;m going to try a lot of fonts.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah. Yeah, I like the gamification kind of thing. So after six months if you haven&#8217;t used it, I need to use it in my closet as well, to have a person point out to me, okay, you haven&#8217;t worn that T-shirt for two or three years.</p>\n\n\n\n<p><em>Tammie Lister</em>: But I think that&#8217;s something that we maybe can, totally going off track, but that&#8217;s something to look at as improvements to all of these kind of things is and that&#8217;s the evolution, that&#8217;s part of it. We&#8217;re putting these features in and then how do we build then giving the feedback. So part of this is also giving your feedback to all these features, so test it and then give feedback. This is the first pancake at font library and the best guess at what people are going to need, but it&#8217;s not going to be the ultimate, it&#8217;s going to be the first start of it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right, yeah.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Enhancements</h3>\n\n\n\n<p><em>Tammie Lister:</em> Next we move on to enhancements I think. Is that correct?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: There are lots of enhancements and one I would particularly like to call out is improving error messages and codes and not because I am fixated on errors but mainly because I think it&#8217;s really important to call out anytime the errors messaging is really improved. Sometimes like copy errors and different things, just hard to improve. But that has happened with the desk console and match JS, along with there&#8217;s also been visual tweaks to specific block commands. So all of these things they really add up to just a better experience for everybody no matter what type of user you are experiencing the editor.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Awesome. Yeah, definitely. Yeah, there have been some component updates and if you are using many core components, you probably want to go through a whole list. We have about three to shout-out. One is the support controlling open and closed state for dropdowns and dropdown menu. This definitely helps with a standardized way on how to manage that state. And then there&#8217;s a popover update. You can update the position types now for popover component and make them more flexible in using, so it could be an overlay or floating or it could be anything that you want. And the documentation for that is definitely is in the PR. So if you go through the changelog and you&#8217;ll see the PR for that. Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: Another one I&#8217;d like to call out in there, to finally finish components is tooltip. So there actually has been a refactor using, I&#8217;m going to try and say this and see if it works, Ariakit and I think that&#8217;s it. Tooltip was kind of there, it kind of had bugs and it kind of was fixed but it was there. So this is quite a big one to do it. It means a lot of things, the biggest of those is it&#8217;s easier to create from and easier to extend from I think as well as you just get all the benefits of it being using that as well. So I think that&#8217;s really worth calling out.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, definitely. You don&#8217;t have to run your own tooltip kind of system, you can just tap into the WordPress one. Yeah, absolutely.</p>\n\n\n\n<p><em>Tammie Lister</em>: And if you think about how many different tooltips have you seen over time. To me that is a strong thread leading into a lot of the phase three site admin, stroke design system stuff going forward is just how can we have lots of awesome things in our Lego Kit, going back to Legos, that we can start using foundationally. So if we have one tooltip system, we have one modal, we have one and then you can extend it, then you can bring your designs to it. I think that that&#8217;s really powerful. So I am delighted to see this. Shall we move on to block library? So block library has quite a few in, I want to call out first of all buttons. Buttons are a really powerful part of the block library and there&#8217;s two particular things I want to call out which is allow using a button element for button blocks and show inserter, if button has variations. Again, these are small but real quality of life fixes as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And what I learned, I don&#8217;t know if I learned it by reading through the PRs or by reading Nick Diego&#8217;s post on block variations on the Developer Blog. Sometimes you just don&#8217;t remember where you read things, but do you have it in your knowledge.</p>\n\n\n\n<p>And is that you actually can replace a core block with your variation if you just use the is default and then the core block wouldn&#8217;t show up in the inserter but yours will replace that. So if you have a certain separator that you use throughout the whole site and you never want to see a different separator and whoever uses the separator has the right one, use that tool. Create a separator variation and set it is default and then it will automatically be the one that&#8217;s in the inserter for people to pick. And I think that&#8217;s so powerful and an easy way to extend the block editor for your client sites without having to do a whole lot of custom block development.</p>\n\n\n\n<p><em>Tammie Lister</em>: We need that article linked in the show notes I think.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And speaking of buttons, what was missing terribly from the navigation block or the navigation menu item was that you could actually use a button in header in the navigation to call out a certain feature. If you look around and I saw that in the PR, how many sites actually are using having a button on the top in the header for navigating to a certain specific place on the site that everybody always wants to use like the login or the access your or Pay Now or these kinds of things. Now you can use it in the navigation block just as a block and add a button to it and style it of course. There&#8217;s a button, so I&#8217;m really happy about that.</p>\n\n\n\n<p><em>Tammie Lister</em>: So moving on, we have one of my favorite sections, the design tool sections. This is a small but mighty section in the changelog. And the ones that I would like to call out is add a blockGap to post content block, that is really useful. It&#8217;s one of those small things that you&#8217;re just like, oh yeah, blockGap is an unsung part that really in design tours you don&#8217;t know you need it until you need it. I think whenever you&#8217;re creating something and add block, instant element support for buttons and headings. And block supports, add background image supports to group block, really interesting for that one. And columns adopt block and heading element colors.</p>\n\n\n\n<p>Again, what this says to me and what it is really is just refinement and knowing where these blocks and where things are getting used and that will be from feedback and that will be from people using them. Probably in this context a lot of it, and I&#8217;m going back to what you&#8217;re getting for Christmas, which is a default theme. So default themes are great because what they do is they push the editing experience and that&#8217;s probably where a lot of this has come from in a beautiful way of, oh we can&#8217;t do that pattern or oh this agency has given this feedback. So keep the feedback coming and really keep trying to make patterns and breaking the editor because as you do, you&#8217;re going to get the design tools and the experience that you want from it. Is my best message around design tools.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Absolutely.</p>\n\n\n\n<p><em>Tammie Lister</em>: And that leads on to patterns I guess.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, that&#8217;s another big feature, but I really happy about the background image for group block. Yeah, I just not always want to use a cover block for the whole thing.&nbsp;</p>\n\n\n\n<p><em>Tammie Lister</em>: Oh, I have so many sites where I just put cover block as the background before everything. It&#8217;s a horrible way, just so I can do that. So now I know I don&#8217;t have to be evil on my site.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And you just upload it, check it from the, and you have a little at a sidebar, you get a little note which…</p>\n\n\n\n<p><em>Tammie Lister</em>: Don&#8217;t have to hack around it. We can actually use the editor how we wanted to use it, not how we were hacking.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And the pattern changes in this Gutenberg release is also something to now the developers edit categories to your user patterns, to the patterns that you all create. You also can create categories to it so you can cluster them, you can make them available, you have a little taxonomy to them and you can also filter by that when you look in inserter as well as on the pattern site editor section. So that&#8217;s so powerful. It also when you create a sync pattern, it offers you the category and I&#8217;ve been testing this and I really love how that works. And you can also have it when you edit it, you can add categories in the sidebar. So it&#8217;s a very thought through process in multiple ways. So I really, really appreciate that and you can use them for sync patterns as well as the unsync patterns or the sync patterns are what we call five years the reusable blocks. So it&#8217;s a new term for the same thing. So I really love it.</p>\n\n\n\n<p><em>Tammie Lister</em>: So moving on, do you want to talk about custom pattern category management?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You can change the categories of course. Actually using the WordPress native taxonomy management for the pattern category. So you can access it through plugins, your themes to anywhere where you use custom categories anywhere because it&#8217;s just a custom post type and then you have a custom taxonomy with it. That&#8217;s all what that was…</p>\n\n\n\n<p><em>Tammie Lister</em>: Or you can just leave that out then confused.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And I&#8217;ll just leave it there.</p>\n\n\n\n<p><em>Tammie Lister:</em> So moving on, I think we should be talking about the interactivity API and we have one particular bit that might seem a little bit unexpected, which we have with the image block and we have two. Which one is revise lightbox UI to remove behaviors and image block UI updates for the image lightbox. This shows just some thinking. Anyone that has experienced what the lightbox would say, one, lightbox is needed. Nobody is in doubt with we need it, but is it needed where it was? Is it needed to be called behaviors? Probably not. Was that the right place? Maybe. No, maybe not. So this shows reflection and what this shows is consideration and people taking feedback and something doing that. So I don&#8217;t know what you feel, but that&#8217;s what this shows to me is things should be released when they&#8217;re ready and when they&#8217;re in a place. One of the really key things is that this functionality is really wanted, but if we put it somewhere, everybody is going to learn that it is there. So where we put it better be the place we want it to be.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Yeah. I think there were too many abstractions about the behavior thing, thinking about it, this would be an example, but at the end of the day it&#8217;s a feature for an image and that&#8217;s where you find it. You find it in your image settings, image box settings and in the sidebar and you can turn it on and off. What it does is actually, but it&#8217;s enabling that you can expand it on click the image that you&#8217;re looking at. So it fills up the full screen content if you want to and any user can, with the image decide if they want to enable it or not. So this is bringing something very complex to a very simple user interface and I really love that sometimes you take big detours.</p>\n\n\n\n<p><em>Tammie Lister</em>: And the first version was quite complex and I think it&#8217;s really good because it&#8217;s basic saying, hey, what we put in, what&#8217;s not what we, and again it shows putting something in the plugin gets the feedback that then oh nope, reverse the car and that&#8217;s good. So now what we have is lightbox is going to be there and lightbox is going to just be a lot more minimal and it&#8217;s going to be exactly what it should be. Actually what it&#8217;s coming down to is exactly what most plugins have for it more or less, which I think is going to be a lot easier from a pitch perspective and easier from a user perspective of understanding and easier to onboard users into the native from the non-native, which is always what I think because there&#8217;s so many sites that I know that they already have lightboxes, but I so want to put them onto the new lightbox the moment it&#8217;s there.</p>\n\n\n\n<p>So the closer it is to their current experience, the easier that&#8217;s going to be as soon. As it&#8217;s in a completely different postcode or zip code, depending on your own adventure, it&#8217;s going to be really difficult for that kind of adventure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. But it also has the danger that a lot of people have used lightboxes before and have a lot of expectations to it. So this is…</p>\n\n\n\n<p><em>Tammie Lister</em>: Lots of feelings when you talk about lightbox. Lightbox is one of those words that one, people will always visually see something. Two, people always have a favorite plugin and then three, people always have feelings.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We have big feelings, yeah. And right now it&#8217;s the basic implementation of a lightbox for an image block. So if you expect in the gallery block that you all of a sudden can use it as a carousel, that&#8217;s an expectation that will not be met.</p>\n\n\n\n<p><em>Tammie Lister</em>: It&#8217;s a great call out, because I think people are going to want that. In fact, I encountered that recently of that&#8217;s actually a common use case patterns. So where you&#8217;re going to have something, I think that that&#8217;s going to be a real expectation and until that that happens, spoiler, it probably will, because it&#8217;s a…</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Sooner or later.</p>\n\n\n\n<p><em>Tammie Lister</em>: &#8230; natural progression. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Sooner or later it&#8217;ll happen.</p>\n\n\n\n<p><em>Tammie Lister</em>: It&#8217;s a natural, but we need to get these things in. We&#8217;ve kind of spoken about that with the font library and everything. We need to get things in a simple form and then we can complicate, but sometimes it&#8217;s still tempting to be complicated to start.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: Because we&#8217;re all human.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We want all of it and sometimes…</p>\n\n\n\n<p><em>Tammie Lister</em>: We want all…</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All of it.</p>\n\n\n\n<p><em>Tammie Lister</em>: &#8230; the cake&#8230; all the time.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So then another thing that&#8217;s in the plugin is in the page inspector, the ability to switch templates for pages. So right now in WordPress we have two places where you can edit pages. That&#8217;s the old way, the WP admin pages kind of section and add or edit. But the other one is that you can, through the site editor, you have a pages menu there and there you can also now swap out templates for that particular page. So you have multiple templates for maybe a service or maybe a portfolio or something like that. You can now switch in the page editing section of the site editor, the template. I&#8217;ve seen some implementation where you actually can preview the template in the sidebar, but I don&#8217;t think that made it yet. I was briefly testing it, so if you find it kudos to you, but I only saw it in a demo on the PR but in a discussion, but I don&#8217;t think that part made it yet into the plugin.</p>\n\n\n\n<p><em>Tammie Lister</em>: Moving on, I think we&#8217;re at block API, is that correct?</p>\n\n\n\n<h3 class=\"wp-block-heading\">APIs</h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh yeah. We&#8217;re moving on to new APIs for the block editor and two of them are for the use case of Gutenberg as a framework. So using it outside the WordPress context and Riad Benguella has been looking into certain packages to decouple it for the WordPress backend and one of them is to extract the undo redo into methods and storage and all that into a separate package so it can be used outside the WordPress context and also introduce something like a block canvas to have the iframe, the block list and the writing flow kind of also in the framework rather than just in WordPress.</p>\n\n\n\n<p>That&#8217;s pretty much all I wanted to shout out that that is coming. Somebody is taking a look at that. I got quite a few, when I&#8217;m at WordCamp Europe, I had some conversations on how that actually is more developed and there is a plugin by Automattic, like Gutenberg-everywhere or block editor everywhere, but it&#8217;s not yet fully developed. And I think having that in core would definitely be a better way to work with that. So if things are coming, please test it because as Tammie said, feedback is everything in this kind of line of work.</p>\n\n\n\n<p><em>Tammie Lister</em>: I think something like that is also going to be curious as someone to test and think does it fit a use case from a pitch perspective? Is it something that you felt you were working around WordPress before? Would it fit into it, would it not? All these kind of things, because starting to see WordPress as that framework and WordPress as that foundation and Gutenberg as that kind of kit that you can build out from is a hundred percent what I&#8217;m kind of curious about. I mean it&#8217;s WordPress but the kit of WordPress is where all of this is going and it&#8217;s very, very exciting to me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: For me too, we talked about it before on this changelog, but not very recently. So Gutenberg is used in Drupal. Gutenberg is used in Tumblr and Gutenberg is used in Day One, the journaling app.</p>\n\n\n\n<p><em>Tammie Lister</em>: Using it to build products, using it from, it&#8217;s such a hipster kind of word, but headless. And I mean that in an adorable way, but honestly choosing the right tool and the right foundation means being able to pick. And to do that we need things like having it as a framework. And we also need the other thing, curiously leading into the stabilizing block hooks feature, which is just having the right things in the right place at the right time, that&#8217;s kind of what it is. And marking things as experimental that should be and just being clean about a lot of what we do. A lot of the time we are just pushing to do stuff. So that is coming in here as well. It is going to be part of 6.4. There&#8217;s a lot of iceberg features that kind of go through, which is a stabilizing, block hooks feature is part of that. It&#8217;s where you are looking at a cross between core and also Gutenberg as well. I don&#8217;t know what you think about that?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well the block hooks feature was actually released in an earlier plugin version, but it was always hidden in the experiment section. And so if people don&#8217;t explore the experiment sections, they don&#8217;t even know if that&#8217;s what it is. And now for 6.4 there was the decision that, oh, we need this in 6.4. So before it can go into core, it needs to be stabilized, it needs to, all the experimentation code needs to be looked at. Is it something we want to support backwards compatibility for the next, I don&#8217;t know five years or 10 years or so. Yeah, so those are very…</p>\n\n\n\n<p><em>Tammie Lister</em>: And having that consideration, but I think it&#8217;s really important to have that consideration and go through as well. I haven&#8217;t explored too much really this, I think this feature is really about trying to get something in that also is going to be really powerful for the foundation.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Absolutely, absolutely. Yeah. So the block hooks features is actually the one that was previously announced on the auto inserting blocks. So you could add a like button to a comment block without having a user needing to put it in. They just can take it out from the plugin version. So it&#8217;s an extensibility feature that people have been waiting for quite a bit. Just to reiterate, what are block hooks? Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: It&#8217;s worth calling it out separately. I think sometimes a lot of this, again the iceberg, a lot of this stuff as you were saying, it didn&#8217;t kind of get seen because it&#8217;s in there. The experimental flag is amazing because there&#8217;s so much good stuff hidden under there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And I&#8217;m calling out some of the bug fixes for the widget editor. Well that&#8217;s a blast from the past. We haven&#8217;t talked about widgets for quite a while, but it&#8217;s still very, very prominent in classic themes. And there were some broken layouts that had been fixed. The invisible area on the top toolbar, there was kind of a lot of white space there that had been fixed. And also the toolbar actually showing in the customizer, in the widget sidebar control, it has also been fixed. So if you are kind of waiting for those, it&#8217;s here now in the Gutenberg plugin and it will come to WordPress 6.4.</p>\n\n\n\n<p><em>Tammie Lister</em>: That&#8217;s really important. A lot of people still use widgets.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Absolutely.</p>\n\n\n\n<p><em>Tammie Lister</em>: So we have to a hundred percent still support that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And kudos to Aki Hamano who took those three fixes on and to push some over the finish line.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Documentation</h3>\n\n\n\n<p>So now we come to a huge section in this release and that&#8217;s documentation. And there are multiple documentation updates, but I think we can cluster them into three kinds of categories or three sections. One is Gutenberg as a framework. So Riad Benguella has done Bootstrap, the documentation website that is geared towards the usage of Gutenberg outside of WordPress. Of course he hasn&#8217;t filled in the pages yet, but he did the architecture of it and also has one page in there to explain how to implement the undo and redo in a third-party editor.</p>\n\n\n\n<p>And then Nick Diego and JuanMa Garrido and Ryan Welcher and some others have worked on the overhaul of the Block Editor Handbook to bring it up to date and rearrange some pages and also to delete pages like the outreach page, which was actually put in because there was the documentation missing, which is now in there. Or remove unneeded block theme documentation that is coming to the theme handbook very soon. So there&#8217;s some, so move the glossary and into a get it started, the FAQ and get the get it started section really robust. And also update how to set up a block development environment with some of the instructions that are much more geared towards and successful into implementation of a local development than before. Do you have any thoughts on that, Tammie?</p>\n\n\n\n<p><em>Tammie Lister</em>: I absolutely adore that we&#8217;re adding to our documentation. I think we don&#8217;t know what we don&#8217;t know about the weird statement, but the gaps. So if anyone is like, wow, I wish we had this resource. I think saying that, this is so great because many times you are even repeating the same information. I would love to have these resources to point to. So I am over the moon that we have these resources. So thank you everyone that&#8217;s doing them.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And then the third section that I mentioned was about documenting, the comment palette, which Riad Benguella has in these dev notes from 6.3, quite a few examples in there, but on the Make Core block buried under, I don&#8217;t know, 450 posts and they are brought now, those examples are now brought into the commands documentation to add more context and to help people to create new…</p>\n\n\n\n<p><em>Tammie Lister</em>: That&#8217;s really important.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: New comments.</p>\n\n\n\n<p><em>Tammie Lister:</em> People are not using that enough quite yet. And that kind of goes back to the beginning when I was just, we were talking about testing and everything, but really it&#8217;s the chicken egg, whatever analogy that we used in your culture. Really having that, the people that create it really saying, hey, this is how you can do this. And then people exploring for themselves how to do it. So I personally am going to be checking out that documentation to see how to, because that&#8217;s not something that I&#8217;ve played with and I really want to play with, I really want to play with it, Clippy and all that, but just really trying to, but now we have these documentations and now we&#8217;re starting to have the Developer Blog. We can start going in and just having better resources to do it. So I&#8217;m very excited to see that.&nbsp;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Me, too. Me, too. And I just wanted to call out one update on the component changelog to mark the popover slot removal as a breaking change. So we mentioned that the had an additional placement there, but there&#8217;s also probably a little breaking change there. It&#8217;s documented in a component changelog, but I don&#8217;t think it made it into Block Editor Handbook yet. So I&#8217;m going to call that out in the show notes as well, just for those who use that popover component in their own apps. It&#8217;s a small thing, but it might trip up some people. So did we actually get through it?</p>\n\n\n\n<p><em>Tammie Lister</em>: We survived.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: We survived.</p>\n\n\n\n<p><em>Tammie Lister</em>: Go team.</p>\n\n\n\n<h3 class=\"wp-block-heading\">WordPress 6.4 Beta Release</h3>\n\n\n\n<p>Birgit Pauli-Haack: All right. Tammie, it was wonderful to have you here and go through this. So what&#8217;s next for us? Of course, it&#8217;s the WordPress 6.4 beta release on Tuesday, September the 26th. And the release party is at 18:00 pm UT? No, it&#8217;s on 4:00 PM UTC. Join us in the core channel and have a party.</p>\n\n\n\n<p><em>Tammie Lister</em>: I was meant to try to work out what time that was me for tea time. That&#8217;s just tea time for me, to bring tea and cake. And I think that&#8217;s really important to say, that for those working on 6.4, now we step, we&#8217;ve been doing stuff all along, but from beta choose own adventure. It really is where we start. Yes, we have been doing stuff. We have not been absent. We have absolutely been doing stuff, but really this is the hard end of the release where everything gets really like, ooh, and everybody starts doing lots of things.</p>\n\n\n\n<p>It is a shorter release or the end of the year releases are always shorter. You always try and put everything in Santa’s stocking or whoever you&#8217;re going to believe in and it never fits. But from a Gutenberg perspective, that means that it&#8217;s kind of shipped for 6.4 and a plugin will be open for your happy things to go into 6.5, because Gutenberg time travels in the best possible way. So you will start seeing people starting to talk about wider projects and because of the gap, you&#8217;ll probably see people starting to talk about some of the wider projects around collaboration and some of those kinds of things. I don&#8217;t know what you think, but that&#8217;s kind of what the end of the year vibe is always. People take breaks, please people take breaks because you are human. But also people start thinking about some of the bigger projects. So I expect to see probably…</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: &#8230; some lovely in-depth project, make posts, Developer Blog posts and just follow, always the tickets I love on the GitHub are the tracking ones. Once they tracking, if you search for tracking in the GitHub repo, that&#8217;s one of my favorite things to search for.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah. Tracking an overview. Yeah, those are the big items. Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: Tracking is like the new hotness over overview at the moment. It feels.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Tammie Lister</em>: We should unify that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I&#8217;m really looking forward to the next three, four weeks just because we&#8217;re going to see a lot of bug fixes coming into 6.4 from the beta release, and then the release candidate. Well release candidate one is the deadline for developer notes to come out and the field guide to come together. So have an eye out for that.</p>\n\n\n\n<p><em>Tammie Lister</em>: Yeah, you&#8217;ll start to see sources of truth posts come out, which would be like, here&#8217;s actually what was in, we&#8217;ve been talking a lot about here&#8217;s what&#8217;s going on, but say, I don&#8217;t know, the top toolbar focused outline. I&#8217;m literally looking at something in the changelog, turns out to hurt bunnies. I don&#8217;t know. Then that will be pulled because hurting bunnies is bad. So all those kinds of things is what will happen when it actually goes in and has more people testing it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So the final release, 6.4 is in November 7th, so it&#8217;s early Christmas this year to follow your metaphor there.</p>\n\n\n\n<p><em>Tammie Lister</em>: This is early, everybody.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s early there.</p>\n\n\n\n<p><em>Tammie Lister</em>: &#8230; take a long, long break.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, after that a lot of people are going to take off because in America it&#8217;s going to be Thanksgiving, Christmas is bigger in Europe, Christmas holidays and all that. So in January…</p>\n\n\n\n<p><em>Tammie Lister</em>: But people also talk about, I think the other thing that people do over this time is think about a lot of the longer term projects. You&#8217;ll see a lot of housekeeping, a lot of tests, a lot of just general thinking about the bigger projects. So there&#8217;ll probably be, as I&#8217;ve mentioned, that the collaboration posts and things, which I think is always, you end on that and then you start afresh thinking about the roadmap. I love this time of year because, and this is one of my favorite releases because, and then you also get the default theme to play with. So you can start thinking about what you want to do and what you want to create with the editor. What tickets do you want in next year? What do you want to create? Sounds fun.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right. Well, we always love to hear from you. So if you have things that you want us to know about, send us your questions or suggestions or the news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>, the <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. And as always, the show notes will be published on gutenbergtimes.com/podcast. This is episode 90. Wow. 90 episodes. Well, 10 more episodes we&#8217;re at 100.</p>\n\n\n\n<p><em>Tammie Lister</em>: Yay. You need cake for 100.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: I need Cake. Yes. Okay. So thank you so much, Tammie, to be on the show and make this a fun show again. And wishing everybody a nice start into the fall. And I hear you all in three weeks because 6.7 had a three-week week cycle. So 16.8 is not coming out until beginning of October. You all take care and I&#8217;ll be out of here. Bye, Tammie.</p>\n\n\n\n<p><em>Tammie Lister</em>: Bye.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: All right, thank you.</p>\n\n\n\n<p> </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Sep 2023 09:51:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Gutenberg Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"BuddyPress: BP Attachments 1.2.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=331360\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://buddypress.org/2023/09/bp-attachments-1-2-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1290:\"<p>Immediately available is <a rel=\"noreferrer noopener\" href=\"https://downloads.wordpress.org/plugin/bp-attachments.1.2.0.zip\" target=\"_blank\">BP Attachments 1.2.0</a>. This BuddyPress Add-on maintenance release main goal is to fix two annoying issues (one of them is a regression introduced in previous minor release). Please make sure to upgrade asap.</p>\n\n\n\n<span id=\"more-331360\"></span>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Changes</h2>\n\n\n\n<ul>\n<li>Make sure to only override the WP queried object if it is an Attachment one.</li>\n\n\n\n<li>Only list the BP Attachments Add-on in optional components into the BP Components Administration screen.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Please upgrade to 1.2.0 asap !</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-7 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/bp-attachments/\">BP Attachments</a></blockquote>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Sep 2023 04:34:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"BuddyPress: BP Classic 1.1.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=331344\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://buddypress.org/2023/09/bp-classic-1-1-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2331:\"<p>Dear end users &amp; site owners,</p>\n\n\n\n<p>If you don&#8217;t know yet what&#8217;s the purpose of BP Classic, we advise you to read the <a href=\"https://buddypress.org/2023/07/bp-classic-1-0-0/\">Add-on&#8217;s first version announcement post</a>. In short: BP Classic is a BuddyPress Add-on that is being developed and maintained by the official <a href=\"https://buddypress.org/about/\">BuddyPress development team</a>. It mainly provides backwards compatibility for BuddyPress 12.0.0 &amp; up in case your active BuddyPress plugins or theme are not ready yet for the great BP Rewrites API introduced in BuddyPress 12.0.0. It basically brings back the BP Legacy URL parser.</p>\n\n\n\n<span id=\"more-331344\"></span>\n\n\n\n<p>NB: BuddyPress <strong>12.0.0</strong> is still under development and you can contribute to BP Classic as well as BuddyPress 12.0.0 improvements using the <a href=\"https://buddypress.org/2023/09/buddypress-12-0-0-beta2/\">12.0.0-beta2</a> (or up) pre-version.</p>\n\n\n\n<p>1.1.0 is fixing 2 issues:</p>\n\n\n\n<ul>\n<li>It makes sure BP Classic is activated at the same network level than BuddyPress (See&nbsp;<a href=\"https://github.com/buddypress/bp-classic/issues/21\" target=\"_blank\" rel=\"noreferrer noopener\">#21</a>).</li>\n\n\n\n<li>it improves the way the themes directory is registered (See&nbsp;<a href=\"https://github.com/buddypress/bp-classic/issues/23\" target=\"_blank\" rel=\"noreferrer noopener\">#23</a>).</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Props</h2>\n\n\n\n<p><a class=\"bp-suggestions-mention\" href=\"https://buddypress.org/members/imath/\" rel=\"nofollow\">@imath</a> <a class=\"bp-suggestions-mention\" href=\"https://buddypress.org/members/dd32/\" rel=\"nofollow\">@dd32</a></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Please upgrade to BP Classic 1.1.0</h2>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-13 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/bp-classic/\">BP Classic</a></blockquote>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\"></div>\n</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Sep 2023 08:05:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Block Visibility 3.1.0 Adds WooCommerce and Easy Digital Downloads Controls\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149369\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/block-visibility-3-1-0-adds-woocommerce-and-easy-digital-downloads-controls\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3307:\"<p>When WordPress contributor and developer Nick Diego released version 3.0 of his <a href=\"https://wordpress.org/plugins/block-visibility/\">Block Visibility</a> plugin earlier this year in March, he <a href=\"https://wptavern.com/block-visibility-3-0-0-makes-pro-version-free-adds-browser-and-device-control-visibility-presets-and-more\">made all the Pro features available in the free version</a>, with the exception of a few that would take more time. The plugin, which is used on more than 10,000 WordPress sites, allows users to conditionally display blocks based on specific user roles, logged in/out, specific users, screen sizes, query strings, ACF fields, and more. </p>\n\n\n\n<p>In the latest <a href=\"https://blockvisibilitywp.com/block-visibility-3-1-0-introducing-woocommerce-and-edd-controls/\">3.1.0 update</a> Block Visibility has added the missing WooCommerce and Easy Digital Downloads (EDD) controls. These features were originally planned to be merged into the free version in April but required more development to improve how they work on sites with large product/download catalogs.</p>\n\n\n\n<p>The WooCommerce controls include 18 conditional visibility rules with full support for products with variable pricing. It allows users to show or hide blocks based on products, cart contents, customer purchase history, and more.</p>\n\n\n\n<p>&#8220;There is one notable change to the product-based rules,&#8221; Diego said. &#8220;Previously, you had to select which product you wanted to target with the visibility conditions. While this is still possible, Block Visibility can now detect the current product.</p>\n\n\n\n<p>&#8220;This functionality is extremely useful on product pages, single product templates, and product grids (Query blocks).&#8221;</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"500\" height=\"425\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/detect-current-product.gif\" alt=\"\" class=\"wp-image-149400\" />\n\n\n\n<p>The EDD controls allow users to show or hide blocks based on downloads, cart contents, customer purchase history, and more. Since EDD doesn&#8217;t have as many block-powered layouts as WooCommerce, Diego did not include the &#8220;Detect current product&#8221; feature.</p>\n\n\n\n<p>&#8220;The EDD visibility control currently has no product-based rules,&#8221; he said. &#8220;If greater block support is added to EDD in the future, such as an EDD Products block that supports inner blocks, expect more functionality.&#8221;</p>\n\n\n\n<p>Block Visibility 3.1.0 also adds a new Command Palette command to &#8220;Manage Visibility Presets,&#8221; which requires WordPress 6.3+.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<img width=\"1372\" height=\"985\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/command-palette-manage-visibility-presets.gif\" alt=\"\" class=\"wp-image-149403\" />image credit: Block Visibility repository &#8211; <a href=\"https://github.com/ndiego/block-visibility/pull/84\">PR #84</a>\n\n\n\n<p>Diego said he doesn&#8217;t plan on adding any new integrations to the plugin but will continue improving existing controls. Now that all the features from the Pro version have been merged into the free plugin, users who have the Pro version installed can deactivate it after upgrading to version 3.1.0.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Sep 2023 02:07:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: WordPress Plugin Review Team Onboards New Members, Releases Plugin to Flag Common Errors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149346\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://wptavern.com/wordpress-plugin-review-team-onboards-new-members-releases-plugin-to-flag-common-errors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3371:\"<p>WordPress&#8217; Plugin Review Team continues to dig out from under a massive backlog that has grown to 1,260 <a href=\"https://wordpress.org/plugins/developers/add/\">plugins awaiting review</a>.  Developers submitting new plugins can expect to wait at least 91 days, according to the notice on the queue today. </p>\n\n\n\n<p>&#8220;<em>Currently there are 1,241 plugins awaiting review</em>,&#8221; Automattic-sponsored Plugin Review team member Alvaro Gómez said earlier this week.</p>\n\n\n\n<p>&#8220;We are painstakingly aware of this. We check that number every day and realize how this delay is affecting plugin authors.&#8221; </p>\n\n\n\n<p>Although the backlog seems to be getting worse, Gómez published an <a href=\"https://make.wordpress.org/plugins/2023/09/19/update-turning-the-tide/\">update</a> outlining new systems the team is putting in place to get the situation under control. He likened it to patching a hole in a boat, as opposed to simply prioritizing bailing out the water.</p>\n\n\n\n<p>&#8220;During the last six months, the Plugin review team has worked on documenting its processes, training new members, and improving its tools,&#8221; he said. &#8220;Now, thanks to your patience and support, the tide is about to turn.&#8221;</p>\n\n\n\n<p>The team has now onboarded two rounds of new members, with three more reviewers added recently, and has a system in place to make this easier in the future. After receiving more than 40 <a href=\"https://make.wordpress.org/plugins/handbook/apply/\">applications</a> to join the team, the form will be closing at the end of September.</p>\n\n\n\n<p>They also sent plugin authors still waiting in the queue an email asking them to self-check their plugins to meet basic security standards, as another effort to mitigate the growing backlog.</p>\n\n\n\n<p>&#8220;We find ourselves correcting the same three or four errors on +95% of plugins and this is not a good use of our time,&#8221; Gómez said. &#8220;Once authors confirm that their plugins meet these basic requirements, we will proceed with the review.&#8221;</p>\n\n\n\n<p>A new plugin called <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check</a> has just been published to WordPress.org for plugin authors to self-review for common errors, which will eventually be integrated into the plugin submission process.</p>\n\n\n\n<p>&#8220;Once the PCP is merged with <a href=\"https://github.com/10up/plugin-check\">this other plugin that the Performance team has been working on</a>, it will provide <a href=\"https://make.wordpress.org/plugins/2022/07/05/proposal-for-a-wordpress-plugin-checker/\">checks for a lot of other things</a>,&#8221; Gómez  said. &#8220;When this is completed, we will be in a better spot to take in feedback and make improvements.</p>\n\n\n\n<p>&#8220;In the short term, we are going to ask authors to test their plugins using the PCP before submitting them, but our goal is to integrate the plugin as <strong>part of the submission process</strong> and run automated checks.&#8221;</p>\n\n\n\n<p>So far plugin authors have reported a few bugs and issues with the plugin not recognizing files or giving unintelligible errors. These issues can be reported on the <a href=\"https://github.com/10up/plugin-check/\">GitHub repo</a>, which is temporarily hosted on the 10up GitHub account but will be moving to WordPress.org in the near future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Sep 2023 17:51:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Do The Woo Community: WooBits: Accessibility, Diversity, Community, WooSesh and More\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=76579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://dothewoo.io/woobits-accessibility-diversity-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:426:\"<p>This week, diversity at WP Accessibility Day, WooSesh, Cart and Checkout Blocks and more WordPress and WooCommerce community.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woobits-accessibility-diversity-community/\">WooBits: Accessibility, Diversity, Community, WooSesh and More</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Sep 2023 13:04:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"WPTavern: WordPress Accessibility Day 2023 Announces Diverse Speaker Lineup, Doubles Sponsors from Previous Year\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149315\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://wptavern.com/wordpress-accessibility-day-2023-announces-diverse-speaker-lineup-doubles-sponsors-from-previous-year\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6744:\"<p><a href=\"https://2023.wpaccessibility.day/\">WP Accessibility Day</a> (WPAD), an independent 24-hour virtual conference, has published its <a href=\"https://2023.wpaccessibility.day/schedule/\">schedule</a> for the upcoming event on September 27, 2023. Co-lead organizer Amber Hinds reports that more than 1,248 people have registered for the event so far with attendees across 30 different countries. Approximately 50% of attendees are from the U.S. </p>\n\n\n\n<p>WPAD has attracted an influx of new voices this year. All speakers, excluding sponsored sessions, are first-time speakers at the event.</p>\n\n\n\n<p>&#8220;We were nervous initially about speaker applicants, but we actually received a lot more speaker applications than last year and also more applications that were higher quality than in previous years,&#8221; Hinds said. &#8220;It was hard to decide!&#8221;</p>\n\n\n\n<p>The keynote address will feature a conversation between Jennison Asuncion, co-founder of Global Accessibility Awareness Day (GAAD), and Joe Dolson, an accessibility consultant and co-founder of WordPress Accessibility Day. Attendees will learn how to perform usability and accessibility tests on their websites, how to build an accessible WordPress pages and posts using the block editor, simple ways to make email more accessible, how to understand color and contrast requirements in WCAG 2, and more. </p>\n\n\n\n<p>Based on the stats for speakers (of people who opted to give the info), WPAD&#8217;s organizers have succeeded at recruiting a diverse lineup for the event:</p>\n\n\n\n<ul>\n<li>10 countries</li>\n\n\n\n<li>67% female, 30% male, 3% Nonbinary</li>\n\n\n\n<li>14% LGBTQ</li>\n\n\n\n<li>41% non-white identifying</li>\n\n\n\n<li>2 first time speakers who have never spoken at any event.</li>\n\n\n\n<li>11 of the 27 speakers identify as having a disability. (41%) &#8211; There are speakers who identify as blind/low vision, deaf or hard of hearing, have limited mobility, and learning disabilities.</li>\n</ul>\n\n\n\n<p>&#8220;These were the hardest decisions we&#8217;ve had to make yet in selecting the WordPress Accessibility Day speakers,&#8221; Speaker Team lead Joe Dolson said. &#8220;There were so many truly excellent ideas proposed. As a result, our speakers include people who work across many different aspects of the web &#8211; inside and outside the WordPress community. I feel like we&#8217;ve ended up with an excellent cross section of topics, so we have something to offer for developers, policy makers, content creators, or community organizers.&#8221;</p>\n\n\n\n<p>WPAD <a href=\"https://wptavern.com/wp-accessibility-day-secures-nonprofit-status-for-annual-event-calls-for-speakers-and-sponsors\">secured non-profit status</a> earlier this year through a fiscal sponsorship partnership with <a href=\"https://knowbility.org/\">Knowbility</a>, an Austin-based digital accessibility advocate and services provider. One of the reasons the organizers wanted to manage it independently of the WordPress Foundation was to reserve the option to do things like pay speakers for their time and expertise. Speaker pay is one expenditure for the event, which is supported by corporate and community sponsors.</p>\n\n\n\n<p>Hinds said it was easier to attract sponsors this year and that the sponsors team received positive responses fairly quickly. They also added a microsponsorship option earlier this year (previously it was only on the registration form) and were able to recruit more businesses as microsponsors.</p>\n\n\n\n<p>The team&#8217;s goal this year was to get enough sponsorships to cover the cost of the event itself, make a donation to Knowbility (part of the event&#8217;s fiscal sponsorship agreement with them), and have enough leftover to cover year-round expenses, such as Google workspace, Buffer, domain registration, and hosting.</p>\n\n\n\n<p>Hinds said the organization met its sponsorship goals at most tiers, due to the hard work of the Sponsors team leads Bet Hannon and Joe Hall, along with the generosity of the community in supporting the event.</p>\n\n\n\n<p>&#8220;We are thrilled to have doubled the number of sponsors this year over last year,&#8221; Hannon said. &#8220;I think this reflects the increasing awareness about accessibility as an issue to be addressed, as well as the wider WordPress community coming together to sponsor an event providing high quality accessibility education.&#8221;</p>\n\n\n\n<h3 class=\"wp-block-heading\">New in 2023: WPAD to Broadcast via Zoom</h3>\n\n\n\n<p>In addition to a whole new crop of speakers this year, WPAD is offering t-shirts for the first time as a thank you gift to attendees who want to make a donation when they register. </p>\n\n\n\n<p>&#8220;We had a lot of people ask us last year how they could get a t-shirt, but they were only available to organizers, speakers, and volunteers,&#8221; Hinds said. &#8220;This year they’re available during registration so anyone can get one.&#8221;</p>\n\n\n\n<p>Last year the event was broadcast via an embedded YouTube video on the WPAD website with third-party embeds for chat/Q&amp;A and the live transcript. </p>\n\n\n\n<p>&#8220;We got feedback from attendees that this did not work well because they didn’t have control of the layout of the video,&#8221; Hinds said. &#8220;It was particularly limiting for attendees who rely on the sign language interpreters; they needed the interpreter video to be larger. Other people said that they found the interpretation to be distracting or they needed the slides to be bigger so they would be easier to read.&#8221;</p>\n\n\n\n<p>The 2023 event will be live streamed using Zoom, which recently introduced a sign language interpretation view that allows hosts to assign interpreters. </p>\n\n\n\n<p>&#8220;Attendees can choose to view the sign language interpretation in a separate window,&#8221; Hinds said.  &#8220;With this new feature available, we decided to change to Zoom webinars. We have one long 24-hour webinar that people can jump in and out of as they see fit, and each attendee can set a view for speakers, slides, signers, and captions that works best for them.&#8221;</p>\n\n\n\n<p><a href=\"https://2023.wpaccessibility.day/attendee-registration/\">Registration</a> for the event is free and it&#8217;s still open. Attendees have the opportunity to receive virtual swag and win prizes from the sponsors. Organizers have also gotten the conference pre-approved for continuing education credits for the International Association of Accessibility Professionals <a href=\"https://www.accessibilityassociation.org/s/wascertification\">Web Accessibility Specialist (WAS)</a> and <a href=\"https://www.accessibilityassociation.org/s/certified-professional\">Certified Professional in Core Competencies (CPACC)</a> certifications.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Sep 2023 03:49:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Community Team Invites Organizers to Apply for Hosting Next Generation WordPress Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=149225\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://wptavern.com/community-team-invites-organizers-to-apply-for-hosting-next-generation-wordpress-events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3017:\"<img width=\"1600\" height=\"792\" src=\"https://149611589.v2.pressablecdn.com/wp-content/uploads/2023/09/wordcamp-bengalaru.png\" alt=\"\" class=\"wp-image-149298\" />Attendees of NextGen WordCamp Bengaluru &#8211; image credit: <a href=\"https://make.wordpress.org/community/2023/09/19/from-japan-to-rome-recent-and-upcoming-next-generation-wordpress-events/\">WordPress.org</a>\n\n\n\n<p>WordPress&#8217; Community team is evolving the WordCamp format to  promote adoption, training, and networking for professionals, leaving the flagship events to focus more on connection and inspiration. This change opens the door for more creative concepts around  the events&#8217; new mission:</p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p><em>WordPress events spark innovation and adoption by way of accessible training and networking for users, builders, designers, and extenders. We celebrate community by accelerating 21st-century skills, professional opportunities, and partnerships for WordPressers of today and tomorrow.</em></p>\n</blockquote>\n\n\n\n<p>A group of <a href=\"https://wptavern.com/wordpress-confirms-8-pilot-events-to-launch-the-next-generation-of-wordcamps-in-2023\">eight pilot events were confirmed in June</a>, and two recent &#8220;NextGen&#8221; WordPress events have already happened, including a community-building workshop in Japan, and WordCamp Bengaluru, a one-day event featuring the local culture and a walking tour of the city.</p>\n\n\n\n<p>The Community team has compiled a list of more than three dozen <a href=\"https://make.wordpress.org/community/2023/08/30/the-nextgen-event-project-your-ideas-your-wordpress-community/\">concepts to inspire NextGen event organizers</a>. The list spans a wide range of ideas, such as college campus based groups, sponsor networking days, show and tell night, job fairs, events for agencies, WordPress retreats, and many more. </p>\n\n\n\n<p>Anyone who is interested to host one of these new event types is invited to <a href=\"https://wordpressdotorg.survey.fm/next-generation-of-wordpress-events\">fill out a form</a> that the Community team has created to capture ideas for future events &#8211; either before the end of 2023, or during the first half of 2024. Organizers will be asked to identify a category for their proposed event from among the following:</p>\n\n\n\n<ul>\n<li>WP expertise level (beginners, intermediate, advanced)</li>\n\n\n\n<li>Focused activity (training, recruiting, networking, contributing, conferencing, etc)</li>\n\n\n\n<li>Job status (students, fresh graduates, job seekers, freelancers, business owners, etc)</li>\n\n\n\n<li>Identity-based (women, castes, BIPOC, Latinx, LGBTQI+, tribes, age, etc)</li>\n\n\n\n<li>Content topic focused (designers, block development, SEO, etc)</li>\n</ul>\n\n\n\n<p>Although the form is presented as a survey, it&#8217;s more of an interest form, which is why it collects the respondent&#8217;s contact information. Respondents who indicate they are willing to have a discussion about their ideas may be contacted by the Community team.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Sep 2023 01:26:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"Post Status: Plugin Team Sees a Shift Starting • Browser Interoperability Issues • WCUS Q&amp;A • Enterprise WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=155074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://poststatus.com/plugin-team-sees-a-shift-starting/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15209:\"<h2 class=\"wp-block-heading alignfull\" id=\"h-this-week-at-wordpress-org-september-18-2023\">This Week at WordPress.org (September 18, 2023)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f50c.png\" alt=\"🔌\" class=\"wp-smiley\" /> Plugin Check plugin is now available🛜 Browser Compatibility Issues<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2753.png\" alt=\"❓\" class=\"wp-smiley\" />#WCUS Q&amp;A Continued<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /> Enterprise Clients and the Business of WordPress </p></div>\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n<div class=\"gb-container gb-container-5e804289\">\n\n<h2 class=\"wp-block-heading\" id=\"h-news\"><a href=\"https://wordpress.org/news\">News</a></h2>\n\n</div>\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/09/episode-62-enterprise-clients-and-the-business-of-wordpress/\">WP Briefing: Episode 62: Enterprise Clients and the Business of WordPress</a></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-community-summit-notes\"><a href=\"https://make.wordpress.org/summit\">Community Summit Notes</a></h2>\n\n\n\n<ul>\n<li><strong><a href=\"https://make.wordpress.org/summit/2023/09/21/community-summit-discussion-notes-creating-wordpress-curriculum-and-educational-experiences/\" target=\"_blank\" rel=\"noreferrer noopener\">Creating WordPress Curriculum and Educational Experiences</a></strong></li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-9 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\">WordPress 6.4</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/07/18/wordpress-6-4-whats-on-your-wishlist/\">WordPress 6.4: What’s on your wishlist?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/06/05/wordpress-6-4-development-cycle/\">WordPress 6.4 Development Cycle</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/14/hallway-hangout-whats-new-for-developers-in-wordpress-6-4/\">Hallway Hangout: What’s new for developers in WordPress 6.4</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\"><a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check</a></blockquote>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-14 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-columns is-layout-flex wp-container-12 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/community\">Community</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2023/09/20/attention-wordpress-women-in-india-and-your-event-organizers-this-important-workshop-this-weekend-is-for-you/\">Attention WordPress women in India and those who support you: This important workshop this weekend is for you!</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/09/19/from-japan-to-rome-recent-and-upcoming-next-generation-wordpress-events/\">From Japan to Rome: Recent and Upcoming Next Generation WordPress Events</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/09/19/contributor-working-group-mentorship-chat-agenda-september-21st-0700-utc-apac-emea-and-1600-utc-amer/\">Contributor Working Group: Mentorship Chat Agenda | September 21st 07:00 UTC (APAC/EMEA) and 16:00 UTC (AMER)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/20/seeking-proposals-for-interop-2024/\">Seeking proposals for Interop 2024</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/19/analyzing-the-core-web-vitals-performance-impact-of-wordpress-6-3-in-the-field/\">Analyzing the Core Web Vitals performance impact of WordPress 6.3 in the field</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-developer-blog\"><a href=\"https://developer.wordpress.org/news/\">Developer Blog</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2023/09/understanding-block-attributes/\">Understanding block attributes</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/09/whats-new-for-developers-september-2023/\">What’s new for developers? (September 2023)</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/20/default-theme-chat-agenda-september-20th-2023/\">Default Theme Chat Agenda: September 20th, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/20/dev-chat-agenda-september-13-2023-2/\">Dev Chat agenda, September 20, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/09/19/performance-chat-summary-19-september-2023/\">Performance Chat Summary: 19 September 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2023/09/11/design-share-aug-28-sep8/\">Design Share: Aug 28-Sep8</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2023/09/18/agenda-for-docs-team-biweekly-meeting-september-19-2023/\">Agenda for Docs Team Biweekly Meeting (September 19, 2023)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2023/09/06/summary-of-docs-team-biweekly-meeting-september-05-2023/\">Summary of Docs Team Biweekly Meeting (September 05, 2023)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/18/documentation-team-update-september-18-2023/\">Documentation Team Update – September 18, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2023/09/21/meeting-recap-for-september-20-2023/\">Meeting Recap for September 20, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2023/09/18/last-week-openverse-2023-09-11-2023-09-18/\">A week in Openverse: 2023-09-11 – 2023-09-18</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/09/19/performance-chat-agenda-19-september-2023/\">Performance Chat Agenda: 19 September 2023</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/five-for-the-future/issues/230\">Core Performance Team badge missing from org pages</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/09/19/update-turning-the-tide/\">Update: Turning the Tide</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/plugins/2023/08/21/xpost-wordpresscs-3-0-0-is-now-available/\">WordPressCS 3.0.0 is now available</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/18/plugin-review-team-18-september-2023/\">Plugin Review Team: 18 September 2023</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h2 class=\"wp-block-heading\" id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2023/09/20/previewing-patterns-during-translation/\">Previewing patterns during translation</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2023/09/20/agenda-weekly-polyglots-chat-september-20-2023-0700-utc/\">Agenda: Weekly Polyglots Chat- September 20, 2023 (07:00 UTC)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-project\"><a href=\"https://make.wordpress.org/project\">Project</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2023/09/15/wordcamp-us-2023-qa/\">WordCamp US 2023 Q&amp;A</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/support/2023/09/agenda-for-september-21st-support-meeting-2/\">Agenda for September 21st Support Meeting</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><a href=\"https://make.wordpress.org/sustainability\">Sustainability</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/sustainability/2023/09/20/sustainability-chat-agenda-september-22-2023/\">Sustainability Chat Agenda, September 22, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/sustainability/2023/09/15/call-for-wordpress-sustainability-team-representatives/\">Call for WordPress Sustainability Team Representatives</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/09/18/fse-program-testing-call-26-final-touches/\">FSE Program Testing Call #26: Final touches</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/18/test-team-update-18-september-2023/\">Test Team Update: 18 September 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-theme\"><a href=\"https://make.wordpress.org/theme\">Theme</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2023/09/15/theme-handbook-overhaul-phase-3-publishing-content/\">Theme Handbook Overhaul: Phase 3 (Publishing Content)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/19/themes-team-update-september-19-2023/\">Themes team update September 19, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/09/13/themes-team-update-september-13-2023/\">Themes team update September 13, 2023</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/training/2023/09/21/proposal-updating-the-contributor-ladder-to-a-five-path-model/\">Proposal: Updating the Contributor Ladder to a five-path model</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/09/19/training-team-meeting-recap-12th-september-2023/\">Training Team Meeting Recap – 12th September 2023</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=gpl-in-the-wordpress-training-teams-vetting-processes\">GPL in the WordPress Training Team’s Vetting Processes</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://blog.jquery.com/2023/08/28/jquery-3-7-1-released-reliable-table-row-dimensions/\">jQuery 3.7.1 Released: Reliable Table Row Dimensions</a></li>\n\n\n\n<li><a href=\"https://github.com/nodejs/node/blob/main/doc/changelogs/CHANGELOG_V20.md#20.6.1\">Node v20.6.1released</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-09-14-1\">PHP 8.3.0 RC 2 available for testing</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-08-31-2\">PHP 8.2.10 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-08-31-3\">PHP 8.1.23 Released!</a></li>\n\n\n\n<li><a href=\"https://github.com/PHPMailer/PHPMailer/releases/tag/v6.8.1\">PHPMailer 6.8.1</a></li>\n\n\n\n<li><a href=\"https://dev.mysql.com/doc/relnotes/mysql/8.0/en/news-8-0-35.html\">Changes in MySQL 8.0.35 (Not yet released, General Availability)</a></li>\n\n\n\n<li><a href=\"https://262.ecma-international.org/\">TC39</a></li>\n\n\n\n<li><a href=\"https://github.com/composer/composer/releases\">Composer </a><a href=\"https://github.com/composer/composer/releases/tag/2.6.3\">2.6.3</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong>   <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status&#8217; <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It&#8217;s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>.  </p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and your whole team can <a href=\"https://poststatus.com/join/\">join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 21 Sep 2023 18:30:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 12 Oct 2023 12:48:40 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:13:\"last-modified\";s:29:\"Thu, 12 Oct 2023 12:45:30 GMT\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20211220193300\";}","no");
INSERT INTO ceba_options VALUES("159","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1697158120","no");
INSERT INTO ceba_options VALUES("160","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1697114920","no");
INSERT INTO ceba_options VALUES("161","_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b","1697158120","no");
INSERT INTO ceba_options VALUES("162","_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/10/wordpress-6-4-beta-3/\'>WordPress 6.4 Beta 3</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2023/10/wordpress-6-4-beta-2/\'>WordPress 6.4 Beta 2</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-com-enters-the-fediverse-with-activitypub-support\'>WPTavern: WordPress.com Enters the Fediverse with ActivityPub Support</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-contributors-speed-up-twenty-twenty-four-default-theme-performance-by-40\'>WPTavern: WordPress Contributors Speed Up Twenty Twenty-Four Default Theme Performance by 40%</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/podcast/94-birgit-olzem-and-jill-binder-on-creating-a-diverse-and-sustainable-wordpress-community\'>WPTavern: #94 – Birgit Olzem and Jill Binder on Creating a Diverse and Sustainable WordPress Community</a></li></ul></div>","no");
INSERT INTO ceba_options VALUES("163","can_compress_scripts","0","yes");
INSERT INTO ceba_options VALUES("166","finished_updating_comment_type","1","yes");
INSERT INTO ceba_options VALUES("168","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1697157046;s:7:\"checked\";a:4:{s:8:\"jupiterx\";s:5:\"3.5.6\";s:15:\"twentytwentyone\";s:3:\"1.9\";s:17:\"twentytwentythree\";s:3:\"1.2\";s:15:\"twentytwentytwo\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.8.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.2.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.4.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","no");
INSERT INTO ceba_options VALUES("169","current_theme","JupiterX","yes");
INSERT INTO ceba_options VALUES("170","theme_mods_jupiterx","a:1:{s:18:\"custom_css_post_id\";i:-1;}","yes");
INSERT INTO ceba_options VALUES("171","theme_switched","","yes");
INSERT INTO ceba_options VALUES("172","jupiterx","a:11:{s:13:\"theme_version\";s:5:\"3.5.6\";s:21:\"theme_current_version\";s:5:\"3.5.6\";s:23:\"mods_migrated_from_lite\";b:1;s:28:\"first_installation_after_250\";b:1;s:28:\"envato_purchase_code_5177775\";s:36:\"341984d3-46f4-4074-986e-1dec7c2f6b90\";s:7:\"api_key\";s:64:\"02d13c83587138f6b8e28a4e0ff652cb1220442c28f6e44de1df8e672e96a752\";s:16:\"api_access_token\";s:32:\"8ee5c3c2f694ab2d525f83c6302fc520\";s:9:\"api_email\";s:22:\"colmandeocar@gmail.com\";s:10:\"api_expiry\";s:19:\"2019-06-02 18:52:53\";s:30:\"jupiterx_selected_google_fonts\";a:0:{}s:11:\"svg_support\";i:1;}","yes");
INSERT INTO ceba_options VALUES("175","jupiterx_tgmpa_plugins","a:25:{i:0;a:14:{s:2:\"id\";i:37690;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:8:\"basename\";s:31:\"jupiterx-core/jupiterx-core.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiterx-core-icon.png\";s:4:\"desc\";s:107:\"Enables the customizer settings in Jupiter X. Also, some other theme functionalities depend on this plugin.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx-core-v3.5.6.zip\";s:7:\"version\";s:5:\"3.5.6\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:63:\"https://themes.artbees.net/docs/jupiter-x-core-plugin-overview/\";s:11:\"is_callable\";s:13:\"JupiterX_Core\";}i:1;a:12:{s:2:\"id\";i:37695;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:8:\"basename\";s:30:\"advanced-custom-fields/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:11:\"is_callable\";s:3:\"ACF\";}i:2;a:12:{s:2:\"id\";i:37698;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:8:\"basename\";s:23:\"elementor/elementor.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-elementor-icon.png\";s:4:\"desc\";s:162:\"The default page builder with Jupiter X. It allows you to edit the pages in a real WYSIWYG editor. Currently known as the most advanced page builder in the world.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:74:\"https://help.artbees.net/getting-started/plugins/elementor-plugin-overview\";s:11:\"is_callable\";s:16:\"Elementor\\Plugin\";}i:3;a:15:{s:2:\"id\";i:37586;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:8:\"basename\";s:15:\"raven/raven.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-raven-icon.png\";s:4:\"desc\";s:189:\"20+ new elements exclusively developed by Artbees for Elementor. Also, Header, Footer and custom post type templates in the Free version of Elementor will be available by using this plugin.\";s:6:\"source\";s:94:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2020/09/raven-v1.11.0.zip\";s:7:\"version\";s:6:\"1.11.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:70:\"https://help.artbees.net/getting-started/plugins/raven-plugin-overview\";s:11:\"is_callable\";s:12:\"Raven\\Plugin\";s:8:\"releases\";O:8:\"stdClass\":2:{s:6:\"item-0\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:1:\"I\";s:15:\"_version_number\";s:5:\"1.3.0\";}s:6:\"item-1\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:2:\"II\";s:15:\"_version_number\";s:5:\"1.3.1\";}}}i:4;a:18:{s:2:\"id\";i:37701;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:12:\"Jet Elements\";s:8:\"headline\";s:26:\"Get More Elementor Widgets\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/edflWQvInNc\";s:15:\"large_thumbnail\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-elements-2.jpg\";s:4:\"slug\";s:12:\"jet-elements\";s:8:\"basename\";s:29:\"jet-elements/jet-elements.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-elements-icon.png\";s:4:\"desc\";s:62:\"Adds different Elements and widgets to Elementor page builder.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-elements-v2.6.13.zip\";s:7:\"version\";s:6:\"2.6.13\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/jetelements-plugin-overview/\";s:11:\"is_callable\";s:12:\"Jet_Elements\";s:10:\"label_type\";s:8:\"Optional\";}i:5;a:18:{s:2:\"id\";i:37706;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Blog\";s:8:\"headline\";s:18:\"Create Better Blog\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/80LaNrv9fZ8\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Blog-2.jpg\";s:4:\"slug\";s:8:\"jet-blog\";s:8:\"basename\";s:21:\"jet-blog/jet-blog.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-blog-icon.png\";s:4:\"desc\";s:90:\"Adds advanced widgets to Elementor and let you build a powerful blog and magazine website.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-blog-v2.3.5.zip\";s:7:\"version\";s:5:\"2.3.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetblog-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Blog\";s:10:\"label_type\";s:8:\"Optional\";}i:6;a:18:{s:2:\"id\";i:37711;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Menu\";s:8:\"headline\";s:21:\"Create Advanced Menus\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/Pndy-eEgGsY\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Menu-2.jpg\";s:4:\"slug\";s:8:\"jet-menu\";s:8:\"basename\";s:21:\"jet-menu/jet-menu.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-menu-icon.png\";s:4:\"desc\";s:52:\"Advanced mega menu addon for Elementor page builder.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-menu-v2.4.1.zip\";s:7:\"version\";s:5:\"2.4.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetmenu-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Menu\";s:10:\"label_type\";s:8:\"Optional\";}i:7;a:18:{s:2:\"id\";i:37716;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Jet Popup\";s:8:\"headline\";s:25:\"Create Pop-ups and Modals\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/pgINfIT8hKk\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Popup.jpg\";s:4:\"slug\";s:9:\"jet-popup\";s:8:\"basename\";s:23:\"jet-popup/jet-popup.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-popup-icon.png\";s:4:\"desc\";s:55:\"The advanced plugin for creating popups with Elementor.\";s:6:\"source\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-popup-v2.0.2.1.zip\";s:7:\"version\";s:7:\"2.0.2.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:57:\"https://themes.artbees.net/docs/jetpopup-plugin-overview/\";s:11:\"is_callable\";s:9:\"Jet_Popup\";s:10:\"label_type\";s:8:\"Optional\";}i:8;a:18:{s:2:\"id\";i:37721;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Tabs\";s:8:\"headline\";s:41:\"Create Tabs with Extended Functionalities\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/WgOJEQrMEFg\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tabs-2.jpg\";s:4:\"slug\";s:8:\"jet-tabs\";s:8:\"basename\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tabs-icon.png\";s:4:\"desc\";s:56:\"Advanced Tabs and Accordions for Elementor Page Builder.\";s:6:\"source\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-tabs-v2.1.25.1.zip\";s:7:\"version\";s:8:\"2.1.25.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jettabs-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Tabs\";s:10:\"label_type\";s:8:\"Optional\";}i:9;a:18:{s:2:\"id\";i:37726;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jet WooBuilder\";s:8:\"headline\";s:23:\"Customize Product Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vvMrjACSnzo\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-woobuilder-2.jpg\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:8:\"basename\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"img_url\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-woobuilder-icon.png\";s:4:\"desc\";s:131:\"Custom shop templates for WooCommerce. Adds some widgets to Elementor that can be used inside and outside of WooCommerce templates.\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-woo-builder-v2.1.7.2.zip\";s:7:\"version\";s:7:\"2.1.7.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/jetwoobuilder-plugin-overview/\";s:11:\"is_callable\";s:15:\"Jet_Woo_Builder\";s:10:\"label_type\";s:8:\"Optional\";}i:10;a:18:{s:2:\"id\";i:37731;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Tricks\";s:8:\"headline\";s:21:\"Create Visual Effects\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/mfGuDEsixFs\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tricks-2.jpg\";s:4:\"slug\";s:10:\"jet-tricks\";s:8:\"basename\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tricks-icon.png\";s:4:\"desc\";s:124:\"Use different eye-catching stylish animation effects and let your content become truly alive with outstanding visual tricks.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-tricks-v1.4.6.2.zip\";s:7:\"version\";s:7:\"1.4.6.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jettricks-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Tricks\";s:10:\"label_type\";s:8:\"Optional\";}i:11;a:18:{s:2:\"id\";i:37736;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Engine\";s:8:\"headline\";s:31:\"Create Dynamic Fields and Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/aP_jHmX9hd4\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Engine-2.jpg\";s:4:\"slug\";s:10:\"jet-engine\";s:8:\"basename\";s:25:\"jet-engine/jet-engine.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-engine-icon.png\";s:4:\"desc\";s:146:\"Create and manage custom post types, listings and booking forms for them. Completely compatible with Jupiter X Custom Post Type templates feature.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-engine-v3.2.5.1.zip\";s:7:\"version\";s:7:\"3.2.5.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jetengine-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Engine\";s:10:\"label_type\";s:8:\"Optional\";}i:12;a:18:{s:2:\"id\";i:37741;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Jet SmartFilters\";s:8:\"headline\";s:32:\"Create Filters For Any Post Type\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/uJ2efTTaxD8\";s:15:\"large_thumbnail\";s:87:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-SmartFilters-2.jpg\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:8:\"basename\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-smartfilters-icon.png\";s:4:\"desc\";s:107:\"Adds easy-to-use AJAX filters and widgets to Elementor so you can easily manage your listings and products.\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/10/jet-smart-filters-v3.2.2.zip\";s:7:\"version\";s:5:\"3.2.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:64:\"https://themes.artbees.net/docs/jetsmartfilters-plugin-overview/\";s:11:\"is_callable\";s:17:\"Jet_Smart_Filters\";s:10:\"label_type\";s:8:\"Optional\";}i:13;a:16:{s:2:\"id\";i:37746;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:8:\"headline\";s:61:\"Use Another Page Builder to Migrate from Jupiter to Jupiter X\";s:15:\"large_thumbnail\";s:77:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/wpbakery.jpg\";s:4:\"slug\";s:17:\"js_composer_theme\";s:8:\"basename\";s:33:\"js_composer_theme/js_composer.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-js_composer_theme.svg\";s:4:\"desc\";s:140:\"Another page builder with Jupiter X. It can work along side Elementor. Best for the websites that want to migrate from Jupiter to Jupiter X.\";s:6:\"source\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx_js_composer_theme.7.0.zip\";s:7:\"version\";s:3:\"7.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:10:\"Vc_Manager\";s:10:\"label_type\";s:8:\"Optional\";}i:14;a:16:{s:2:\"id\";i:37751;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Jupiter Donut\";s:8:\"headline\";s:48:\"Add Jupiter Shortcodes For WPBakery Page Builder\";s:15:\"large_thumbnail\";s:75:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/donut2.jpg\";s:4:\"slug\";s:13:\"jupiter-donut\";s:8:\"basename\";s:31:\"jupiter-donut/jupiter-donut.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiter-donut.png\";s:4:\"desc\";s:205:\"80+ shortcodes for WPBakery Page Builder. These shortcodes were available in Jupiter and are necessary if you are migrating your theme from Jupiter to Jupiter X and still want to use WPBakery Page Builder.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jupiter-donut-v1.4.4.zip\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:13:\"Jupiter_Donut\";s:10:\"label_type\";s:8:\"Optional\";}i:15;a:17:{s:2:\"id\";i:37755;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:8:\"headline\";s:19:\"Create Field Groups\";s:15:\"large_thumbnail\";s:76:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/acf-pro.jpg\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"basename\";s:34:\"advanced-custom-fields-pro/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:6:\"source\";s:114:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/advanced-custom-fields-pro-v6.2.0.zip\";s:7:\"version\";s:5:\"6.2.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:91:\"https://help.artbees.net/getting-started/plugins/advanced-custom-fields-pro-plugin-overview\";s:11:\"is_callable\";s:7:\"acf_pro\";s:10:\"label_type\";s:8:\"Optional\";}i:16;a:15:{s:2:\"id\";i:37759;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:8:\"headline\";s:17:\"Add Icons to Menu\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Menu-Icons.jpg\";s:4:\"slug\";s:10:\"menu-icons\";s:8:\"basename\";s:25:\"menu-icons/menu-icons.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-menu-icons.png\";s:4:\"desc\";s:30:\"Adds icons to your menu items.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:59:\"https://themes.artbees.net/docs/menu-icons-plugin-overview/\";s:11:\"is_callable\";s:10:\"Menu_Icons\";s:10:\"label_type\";s:8:\"Optional\";}i:17;a:18:{s:2:\"id\";i:37762;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:17:\"Slider Revolution\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:43:\"https://www.youtube.com/watch?v=mn5hC07aGvE\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/sliderrev-2.jpg\";s:4:\"slug\";s:9:\"revslider\";s:8:\"basename\";s:23:\"revslider/revslider.php\";s:7:\"img_url\";s:91:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/slider-revolution-icon.png\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/revslider.v6.6.16.zip\";s:7:\"version\";s:6:\"6.6.16\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:66:\"https://themes.artbees.net/docs/slider-revolution-plugin-overview/\";s:11:\"is_callable\";s:14:\"RevSliderFront\";s:10:\"label_type\";s:8:\"Optional\";}i:18;a:17:{s:2:\"id\";i:37767;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Master Slider\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:82:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Master-Slider.jpg\";s:4:\"slug\";s:12:\"masterslider\";s:8:\"basename\";s:29:\"masterslider/masterslider.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-master-slider-icon.jpg\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/masterslider-v3.6.5.zip\";s:7:\"version\";s:5:\"3.6.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/master-slider-plugin-overview/\";s:11:\"is_callable\";s:13:\"Master_Slider\";s:10:\"label_type\";s:8:\"Optional\";}i:19;a:17:{s:2:\"id\";i:37769;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/LayerSlider-WP-2.jpg\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"basename\";s:27:\"LayerSlider/layerslider.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-layer-slider-icon.png\";s:4:\"desc\";s:108:\"Popular advanced Slider plugin. Build and publish your sliders on your website. License is \"In-Stock Usage\".\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/layersliderwp-v7.8.0.zip\";s:7:\"version\";s:5:\"7.8.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:61:\"https://themes.artbees.net/docs/layer-slider-plugin-overview/\";s:11:\"is_callable\";s:9:\"LS_Config\";s:10:\"label_type\";s:8:\"Optional\";}i:20;a:15:{s:2:\"id\";i:37772;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"WooCommerce\";s:8:\"headline\";s:23:\"Build eCommerce Website\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/WooCommerce.jpg\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"basename\";s:27:\"woocommerce/woocommerce.php\";s:7:\"img_url\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-woocommerce-icon.png\";s:4:\"desc\";s:131:\"Create and manage your e-commerce website with this plugin. After activating, the Shop section in the Customizer will be available.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/woocommerce-plugin-overview/\";s:11:\"is_callable\";s:11:\"WooCommerce\";s:10:\"label_type\";s:8:\"Optional\";}i:21;a:15:{s:2:\"id\";i:37774;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:24:\"Customizer Export/Import\";s:8:\"headline\";s:42:\"Add Export and Import Option to Customizer\";s:15:\"large_thumbnail\";s:93:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-import-export.jpg\";s:4:\"slug\";s:24:\"customizer-export-import\";s:8:\"basename\";s:53:\"customizer-export-import/customizer-export-import.php\";s:7:\"img_url\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-export-import-icon.png\";s:4:\"desc\";s:112:\"Adds the Export and import option to the Customizer. Useful for theme migrations and moving to the child themes.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:73:\"https://themes.artbees.net/docs/customizer-export-import-plugin-overview/\";s:11:\"is_callable\";s:8:\"CEI_Core\";s:10:\"label_type\";s:8:\"Optional\";}i:22;a:15:{s:2:\"id\";i:37776;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Customizer Reset\";s:8:\"headline\";s:26:\"Reset Theme Customizations\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-reset.jpg\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:8:\"basename\";s:47:\"customizer-reset-by-wpzoom/customizer-reset.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-reset-icon.png\";s:4:\"desc\";s:107:\"Reset theme customizations made via WordPress Customizer. Useful for troubleshooting the customizer issues.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:65:\"https://themes.artbees.net/docs/customizer-reset-plugin-overview/\";s:11:\"is_callable\";s:21:\"ZOOM_Customizer_Reset\";s:10:\"label_type\";s:8:\"Optional\";}i:23;a:16:{s:2:\"id\";i:45885;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"WunderWP\";s:8:\"headline\";s:65:\"Build Pages Quickly With Presets and Reusable Styles or Templates\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/nW4vduTqD64\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp-2.jpg\";s:4:\"slug\";s:8:\"wunderwp\";s:8:\"basename\";s:21:\"wunderwp/wunderwp.php\";s:7:\"img_url\";s:89:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp_plugin_icon.png\";s:4:\"desc\";s:151:\"Save and reuse your Elementor styles or templates in the WunderWP Cloud or use readymade styles to quickly beautify your Elementor pages. All for free!\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:21:\"https://wunderwp.com/\";s:11:\"is_callable\";s:8:\"WunderWP\";s:10:\"label_type\";s:8:\"Optional\";}i:24;a:16:{s:2:\"id\";i:74379;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Growmatik\";s:8:\"headline\";s:44:\"All-in-one Personalized Marketing Automation\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vdk09PMWit4\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik.jpg\";s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:8:\"basename\";s:54:\"marketing-automation-and-personalization/growmatik.php\";s:7:\"img_url\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik-logo.png\";s:4:\"desc\";s:150:\"Growmatik automates your marketing and personalizes your customer experience across their journey by highly-personalized web pages, emails and popups.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:93:\"https://app.growmatik.ai/start/?utm_source=JupiterXSuggestedPlugin&utm_campaign=JupiterXAdmin\";s:11:\"is_callable\";s:9:\"Growmatik\";s:10:\"label_type\";s:8:\"Optional\";}}","no");
INSERT INTO ceba_options VALUES("182","elementor_active_kit","7","yes");
INSERT INTO ceba_options VALUES("183","elementor_font_display","swap","yes");
INSERT INTO ceba_options VALUES("186","wp_sellkit-pro-database-updater_batch_b24663b9d2045c591cad13ec43","a:1:{i:0;a:2:{s:17:\"callback_function\";s:27:\"check_database_tables_1_0_0\";s:10:\"db_version\";s:5:\"1.0.0\";}}","no");
INSERT INTO ceba_options VALUES("187","elementor_version","3.16.5","yes");
INSERT INTO ceba_options VALUES("188","elementor_install_history","a:1:{s:6:\"3.16.5\";i:1697115371;}","yes");
INSERT INTO ceba_options VALUES("189","elementor_events_db_version","1.0.0","no");
INSERT INTO ceba_options VALUES("190","_elementor_editor_upgrade_notice_dismissed","1728701462","yes");
INSERT INTO ceba_options VALUES("191","widget_jupiterx_social","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("192","widget_jupiterx_posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO ceba_options VALUES("194","elementor_onboarded","1","yes");
INSERT INTO ceba_options VALUES("195","elementor_tracker_notice","1","yes");
INSERT INTO ceba_options VALUES("196","jet_engine_modules","a:3:{i:0;s:13:\"booking-forms\";i:1;s:18:\"listing-injections\";i:2;s:8:\"calendar\";}","yes");
INSERT INTO ceba_options VALUES("197","sellkit","a:4:{s:22:\"pro_current_db_version\";s:5:\"1.0.0\";s:18:\"current_db_version\";s:5:\"1.2.7\";s:43:\"contact_segmentation_users_updating_started\";b:0;s:39:\"contact_segmentation_users_are_imported\";b:1;}","yes");
INSERT INTO ceba_options VALUES("198","wp_sellkit-database-updater_batch_a6363b13f0c0950544e591113ba577","a:4:{i:0;a:2:{s:17:\"callback_function\";s:21:\"check_database_tables\";s:10:\"db_version\";s:5:\"1.0.0\";}i:1;a:2:{s:17:\"callback_function\";s:37:\"add_ip_column_to_contact_segmentation\";s:10:\"db_version\";s:5:\"1.2.1\";}i:2;a:2:{s:17:\"callback_function\";s:51:\"add_url_query_string_column_to_contact_segmentation\";s:10:\"db_version\";s:5:\"1.2.3\";}i:3;a:2:{s:17:\"callback_function\";s:24:\"add_funnel_contact_table\";s:10:\"db_version\";s:5:\"1.2.7\";}}","no");
INSERT INTO ceba_options VALUES("199","sellkit-installed-time","1697115372","yes");
INSERT INTO ceba_options VALUES("200","recently_activated","a:0:{}","yes");
INSERT INTO ceba_options VALUES("206","acf_version","6.2.1","yes");
INSERT INTO ceba_options VALUES("207","googlesitekit_has_connected_admins","0","yes");
INSERT INTO ceba_options VALUES("209","_elementor_installed_time","1697115376","yes");
INSERT INTO ceba_options VALUES("214","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:18:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:18:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:18:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:18:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:18:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:18:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:18:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:18:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:18:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:18:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:18:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:18:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:18:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:18:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:18:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:18:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:18:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:18:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:18:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:18:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:18:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:18:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:18:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:18:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:18:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:18:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:18:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:18:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:18:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:18:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:18:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:18:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:18:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:18:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:18:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:18:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:18:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\